<?php
//友情链接验证类
class LinkCheck extends Check {
	
	public function addCheck(Model &$_model, $_param) {
		if (self::isNullString($_POST['webname'])) {
			$this->_message[] = '友情链接名称不得为空！';
			$this->_flag = false;
		}
		if (self::checkStrLength($_POST['webname'], 2, 'min')) {
			$this->_message[] = '友情链接名称不得小于2位！';
			$this->_flag = false;
		}
		if (self::checkStrLength($_POST['webname'], 100, 'max')) {
			$this->_message[] = '友情链接名称不得大于100位！';
			$this->_flag = false;
		}		
		
		if (self::isNullString($_POST['weburl'])) {
			$this->_message[] = '友情链接URl不得为空！';
			$this->_flag = false;
		}
		if (self::checkStrLength($_POST['weburl'], 2, 'min')) {
			$this->_message[] = '友情链接URL不得小于2位！';
			$this->_flag = false;
		}
		if (self::checkStrLength($_POST['weburl'], 100, 'max')) {
			$this->_message[] = '友情链接URL不得大于100位！';
			$this->_flag = false;
		}
		if ($_model->isOne($_param)) {
			$this->_message[] = '友情链接名称被占用！';
			$this->_flag = false;
		}
		return $this->_flag;
	}
	
	public function updateCheck(Model &$_model) {
			if (self::isNullString($_POST['webname'])) {
			$this->_message[] = '友情链接名称不得为空！';
			$this->_flag = false;
		}
		if (self::checkStrLength($_POST['webname'], 2, 'min')) {
			$this->_message[] = '友情链接名称不得小于2位！';
			$this->_flag = false;
		}
		if (self::checkStrLength($_POST['webname'], 100, 'max')) {
			$this->_message[] = '友情链接名称不得大于100位！';
			$this->_flag = false;
		}		
		
		if (self::isNullString($_POST['weburl'])) {
			$this->_message[] = '友情链接URl不得为空！';
			$this->_flag = false;
		}
		if (self::checkStrLength($_POST['weburl'], 2, 'min')) {
			$this->_message[] = '友情链接URL不得小于2位！';
			$this->_flag = false;
		}
		if (self::checkStrLength($_POST['weburl'], 100, 'max')) {
			$this->_message[] = '友情链接URL不得大于100位！';
			$this->_flag = false;
		}		
		return $this->_flag;
	}
}
?>