<?php
if (!defined('IN_59MIAO'))
{
	exit('Access Defined');
}
//后台控制器
class AdminAction extends Action {
	private $_manage = null;
	
	public function __construct() {
		parent::__construct();
		$this->_manage = new ManageModel();
	}
	
	//后台初始页面
	public function index() {		
		if (isset($_SESSION['admin'])) {
			$this->_tpl->assign('admin', $_SESSION['admin']);
			$this->_tpl->display(SMARTY_ADMIN.'public/admin.tpl');
		} else {
			$this->_redirect->succ('?a=admin&m=login');	
		}
	}
	
	//起始页
	public function main() {		
		if(file_exists(ROOT_PATH.'/install')){
			$this->_tpl->assign('install',true);
		}
		if(file_exists(ROOT_PATH.'/admin.php')){
			$this->_tpl->assign('admin',true);
		}
		$this->_tpl->assign('tao_pid',TAO_PID);
		$this->_tpl->assign('miao_appkey',APPKEY);
		$this->_tpl->assign('miao_appsecret',APPSECRET);
		
		//版本
		$this->_tpl->assign('version','59秒b2c网上商城系统v1');
		
		$this->_tpl->assign('php_version',PHP_VERSION);
		//是否支持函数
		if(function_exists('sqlite_popen')){
			$this->_tpl->assign('sqlite_popen','<span class="onCorrect">支持sqlite数据库</span>');
		}
		else{
			$this->_tpl->assign('sqlite_popen','<span class="onError">不支持sqlite数据库</span>');
		}
		if(function_exists('file_get_contents')){
			$this->_tpl->assign('file_get_contents','<span class="onCorrect">远程获取数据</span>');
		}
		else{
			$this->_tpl->assign('file_get_contents','<span class="onError">远程获取数据</span>');
		}
		if(function_exists('mb_convert_encoding')){
			$this->_tpl->assign('mb_convert_encoding','<span class="onCorrect">编码转换</span>');
		}
		else{
			$this->_tpl->assign('mb_convert_encoding','<span class="onError">编码转换</span>');
		}	
		
		
		$this->_tpl->assign('admin', $_SESSION['admin']);
		$this->_tpl->display(SMARTY_ADMIN.'public/main.tpl');
	}	
	//后台登录
	public function login() {
		if (isset($_POST['send'])) {
			if ($this->_manage->login()) {
				$_login = $this->_manage->findLogin();			
				$_SESSION['admin']['user'] = $_login[0]->user;
				$_SESSION['admin']['level'] = $_login[0]->level_name;			
				//兼容sqlite 传过去登录次数				
				$this->_manage->countLogin($_login[0]->login_count);
				$this->_redirect->succ('?a=admin', '后台登录成功！');
			}
		}
		$this->_tpl->display(SMARTY_ADMIN.'public/login.tpl');
	}
	
	//后台退出
	public function logout() {
		if (isset($_SESSION['admin'])) session_destroy();
		$this->_redirect->succ('?a=admin&m=login');	
	}
	
	//ajaxlogin
	public function ajaxLogin() {
		$this->_manage->ajaxLogin();
	}
	
	//ajaxcode
	public function ajaxCode() {
		$this->_manage->ajaxCode();
	}
}
?>