<?php
if (!defined('IN_59MIAO'))
{
	exit('Access Defined');
}
//文章列表条控制器
class ArtilelistAction extends Action {	
	private $_artilenav;
	private $_artile;
	private $_nav;
	private $_SeoArtileNav='';   //用于seo
	private $_content='';  //用于内容页面
	private $_keywords='';//关键字
	
	private $AllArtileNav=null;
		
	public function __construct() {
		parent::__construct();	
		//引入分页类
		require_once 'public/PageClass.php';
		
		$this->_artilenav=new ArtilenavModel();	
		$this->_artile=new ArtileModel();
		$this->_nav = new NavModel();	
		$this->_keywords=new KeywordsModel();
		$AllKeywords=$this->_keywords->findAllFront();		
		$this->_tpl->assign('KeyWords',$AllKeywords);
	}
	
	public function index() {
		
		if (!$this->_tpl->is_cached(SMARTY_FRONT.'/artile.tpl',$_SERVER["REQUEST_URI"])) {
			$this->common();
			$this->setSeo();
			$AllArtile=array();
			foreach ($this->AllArtileNav as $value){
				$Navtitle=$value->name;
				$FronTenArtile=$this->_artile->FindAllFrontTen($value->id);
				$AllArtile[]=array(
					'navtitle'=>$Navtitle,
					'FrontTenArtile'=>$FronTenArtile
				);
			}
			$this->_tpl->assign('AllArtile',$AllArtile);
		}
		//FindAllFrontTen
		$this->_tpl->display(SMARTY_FRONT.'/artile.tpl',$_SERVER["REQUEST_URI"]);
	}
	public function artilelist(){
		if (!$this->_tpl->is_cached(SMARTY_FRONT.'/artile_list.tpl',$_SERVER["REQUEST_URI"])) {
			parent::page(10);
			$this->common();
			
			$artilelist=$this->_model->artilelist();	
			$listpage='';
			$size=FRONT_PAGE_SIZE;
			if(REWRITE){
				$pages = new PageClass($this->_model->total(),$size,$_GET['page'],'artilelist-artilelist-'.$_GET['pid'].'-{page}.html');
				$listpage=$pages -> myde_write();
			}
			else{
				$pages = new PageClass($this->_model->total(),$size,$_GET['page'],'index.php?a=artilelist&m=artilelist&pid='.$_GET['pid'].'&page={page}');
				$listpage=$pages -> myde_write();
			}	
			$this->_tpl->assign('pagetext',$listpage);
			$this->_SeoArtileNav=$this->_model->findOneArtileNav();	
			
			//seo
			$this->setListSeo();
			$this->_tpl->assign('artilelist',$artilelist);		
		}
		$this->_tpl->display(SMARTY_FRONT.'/artile_list.tpl',$_SERVER["REQUEST_URI"]);
	}
	
	public function artile_content(){
		if (!$this->_tpl->is_cached(SMARTY_FRONT.'/artile_content.tpl',$_SERVER["REQUEST_URI"])) {
			$this->common();
			$this->_content=$this->_model->FindFrontContent();
			//把过滤的内容再过滤回来
			$this->_content[0]->content=htmlspecialchars_decode($this->_content[0]->content);
			$this->_tpl->assign('artile_content',$this->_content[0]);		
			$this->Content_setSeo();			
		}
		$this->_tpl->display(SMARTY_FRONT.'/artile_content.tpl',$_SERVER["REQUEST_URI"]);
	}
	//用于上面调取
	private function common(){
		$AllNav=$this->_nav->findAllFront();
		$this->_tpl->assign('AllNav',$AllNav['allnav']);
		//获取文章
		$this->AllArtileNav=$this->_artilenav->findAllFront();	
		
		$this->_tpl->assign('AllArtileNav',$this->AllArtileNav);
		
		$AllHotArtile=$this->_artile->FindHot();
		
		$this->_tpl->assign('hotartile',$AllHotArtile);
	}
	//购物资讯页面
	private function setSeo(){	
		error_reporting(0);	
		//获取当前的分类信息		
		$site_title=$this->_site_title;
		$site_titleb=$this->_site_titleb;
		$site_keywords=$this->_site_keywords;		
		if(file_exists('./configs/seo_config.inc.php')){
			require_once './configs/seo_config.inc.php';	
		}				
		$this->_tpl->assign('title',$artiletitle);
		$this->_tpl->assign('keywords',$artilekeywords);
		$this->_tpl->assign('description',$artileinfo);
	}	

	//文章列表页面seo设置
	private function setListSeo(){	
		error_reporting(0);	
		
		if($this->_SeoArtileNav!=null){
			$artilelist_title=$this->_SeoArtileNav[0]->name;
			$artilelist_description=$this->_SeoArtileNav[0]->info;
		}	
		//获取当前的分类信息		
		$site_title=$this->_site_title;
		$site_titleb=$this->_site_titleb;
		$site_keywords=$this->_site_keywords;
		$site_description=$this->_site_description;	
		
		if(file_exists('./configs/seo_config.inc.php')){
			require_once './configs/seo_config.inc.php';	
		}				
		$this->_tpl->assign('title',$artile_list_title);
		$this->_tpl->assign('keywords',$artile_list_keywords);
		$this->_tpl->assign('description',$artile_list_info);
	}
	
	//用于文章列表页面
    private function Content_setSeo(){	
		error_reporting(0);			
		$artile_title=$this->_content[0]->title;
		$artile_description=$this->_content[0]->info;
		//获取当前的分类信息		
		$site_title=$this->_site_title;
		$site_titleb=$this->_site_titleb;
		$site_keywords=$this->_site_keywords;
		$site_description=$this->_site_description;	
		
		if(file_exists('./configs/seo_config.inc.php')){
			require_once './configs/seo_config.inc.php';	
		}				
		$this->_tpl->assign('title',$artile_content_title);
		$this->_tpl->assign('keywords',$artile_content_keywords);
		$this->_tpl->assign('description',$artile_content_info);
	}
}
?>