<?php
if (!defined('IN_59MIAO'))
{
	exit('Access Defined');
}
class CategoryAction extends Action {
	private $_nav=null;	
	private $_apiaction=null;
	private $_notab=true; //是否显示b2c与淘宝切换
	private $_keywords='';	
	private $_current_itemcat; //当前分类
	private $_parent_itemcat; //父分类
	public function __construct() {
		parent::__construct();
		$this->_nav = new NavModel();
		if(isset($_GET['notab']) && $_GET['notab']=='true')
		{
			$this->_notab=false;  //不显示
		}	
		$this->_keywords=new KeywordsModel();	
	}
	
	//实现初始页面
	public function index() {
		//seo
		$this->setSeo();
		//其他信息
		$AllNav=$this->_nav->findAllFront();
		$this->_tpl->assign('AllNav',$AllNav['allnav']);
		$AllKeywords=$this->_keywords->findAllFront();		
		$this->_tpl->assign('KeyWords',$AllKeywords);
		if(count($AllNav['onenav'])>0){
			$OneNav=$AllNav['onenav'][0];
		}
		else{
			$OneNav='';
		}		
		$this->_tpl->assign('OneNav',$OneNav);
		//用于选中不选中的判断
		if(isset($_GET['sort'])){
			$this->_tpl->assign('sort',$_GET['sort']);	
		}
		if(isset($_GET['star'])&& isset($_GET['end'])){
			$this->_tpl->assign('star',$_GET['star']);
			$this->_tpl->assign('end',$_GET['end']);
		}
		else{
			$this->_tpl->assign('star',0);
			$this->_tpl->assign('end',1000);
		}
		
		$tab=isset($_GET['tab'])?$_GET['tab']:null;
		switch ($tab){
			case 'b2c':
				$this->b2cData();
				break;
			case 'tao':
				$this->taoData();
				break;
			default:$this->b2cData();
		}		
	}	
	private function b2cData(){
		if (!$this->_tpl->is_cached(SMARTY_FRONT.'/b2c_category.tpl',$_SERVER["REQUEST_URI"])) {
			$data=$this->_model->getItemList();	
			$this->_tpl->assign('cid',$data['cid']);
			$this->_tpl->assign('sid',$data['sid']);				
			$this->_tpl->assign('pagetext',$data['page']);
			$this->_tpl->assign('itemcart',$data['categories']);
			$this->_tpl->assign('sellercart',$data['item_sellers']);		
			$this->_tpl->assign('items',$data['items']);
			$this->_tpl->assign('notab',$this->_notab);	
		}
		$this->_tpl->display(SMARTY_FRONT.'/b2c_category.tpl',$_SERVER["REQUEST_URI"]);
	}
	private function taoData(){
		if (!$this->_tpl->is_cached(SMARTY_FRONT.'/tao_category.tpl',$_SERVER["REQUEST_URI"])) {	
			$data=$this->_model->getItemListTao();		
			$this->_tpl->assign('cid',$_GET['cid']);
			$this->_tpl->assign('itemcats',$data['itemcats']);	
			$this->_tpl->assign('items',$data['items']);
			$this->_tpl->assign('notab',$this->_notab);	
			$this->_tpl->assign('pagetext',$data['page']);
			
		}
		$this->_tpl->display(SMARTY_FRONT.'/tao_category.tpl',$_SERVER["REQUEST_URI"]);
	}
	//seo 设置
	private function setSeo(){
		error_reporting(0);
		if($_GET['tab']!='tao'){
			//分类信息
			$CatParent=$this->_model->GetItemCatParent();	
			$this->_current_itemcat=$CatParent['current_itemcat']['name'];
			$this->_parent_itemcat=$CatParent['parent_itemcat']['name'];
			$this->_tpl->assign('itemcat',$this->_current_itemcat);
			$this->_tpl->assign('parent_itemcat',$this->_parent_itemcat);		
		}
		else if($_GET['tab']=='tao'){
			$CatParent=$this->_model->GetTaoItemCatParent();
			$this->_current_itemcat=$CatParent;
			$this->_tpl->assign('itemcat',$CatParent);
		}	
		
		$category=$this->_parent_itemcat.','.$this->_current_itemcat;  //所属分类			
		$site_title=$this->_site_title;
		$site_titleb=$this->_site_titleb;
		$site_keywords=$this->_site_keywords;
		$site_description=$this->_site_description;
		if(file_exists('./configs/seo_config.inc.php')){
			require_once './configs/seo_config.inc.php';	
		}				
		$this->_tpl->assign('title',$product_list_title);
		$this->_tpl->assign('keywords',$product_list_keywords);
		$this->_tpl->assign('description',$product_list_info);
	}	
	

}

?>