<?php
if (!defined('IN_59MIAO'))
{
	exit('Access Defined');
}
class IndexAction extends Action {
	private $_apiaction="";
	private $_link="";
	private $_artile="";
	private $_nav="";
	private $_keywords='';
	private $_seo='';
	private $_imgsider='';
	private $_sellerlist='';	
	public function __construct() {
		parent::__construct();		
		if (!$this->_tpl->is_cached(SMARTY_FRONT.'/index.tpl',$_SERVER["REQUEST_URI"])) {
			$this->_apiaction=new ApiModel();
			$this->_link=new LinkModel();	
			$this->_artile=new ArtileModel();
			$this->_nav=new NavModel();	
			$this->_keywords=new KeywordsModel();
			$this->_imgsider=new ImgsiderModel();
			$this->_sellerlist=new SellerlistModel();	
		}			
	}	
	//实现初始页面
	public function index() {
		if (!$this->_tpl->is_cached(SMARTY_FRONT.'/index.tpl',$_SERVER["REQUEST_URI"])) {
			$this->_tpl->assign('name', '首页');
			$this->setSeo();			
			$AllNav=$this->_nav->findAllFront();		
			$AllKeywords=$this->_keywords->findAllFront();		
			$this->_tpl->assign('KeyWords',$AllKeywords);		
			$this->_tpl->assign('AllNav',$AllNav['allnav']);	
			$this->_tpl->assign('promo_cat',$this->_apiaction->getPromo());
			$this->_tpl->assign('Alldata',$this->_apiaction->getHomedata());		
			$this->_tpl->assign('AllImgLink',$this->_link->findAllImg());
			$this->_tpl->assign('AllTextLink',$this->_link->findAllText());
			$this->_tpl->assign('Artile',$this->_artile->FindHot());
			//推荐商家
			$rec_seller=$this->_sellerlist->GetRecSeller();		
			foreach ($rec_seller as $key=>$value){
					$site_logo = $value->site_logo;
					$net_logo=$value->net_logo;
					if(file_exists($site_logo)){
						$value->logo=$site_logo;
					}
					else{
						$value->logo=$net_logo;
					}					
			}	
			$this->_tpl->assign('rec_seller',$rec_seller);
			//轮播图片
			$imgsider=$this->_imgsider->findAllFront();	
			$this->_tpl->assign('imgsider',$imgsider);				
		}
		$this->_tpl->display(SMARTY_FRONT.'/index.tpl',$_SERVER["REQUEST_URI"]);
	}
	
	//验证码
	public function validateCode() {
		$_vc = new ValidateCode();
		$_vc->doimg();
		$_SESSION['code'] = $_vc->getCode();
	}
	//seo 设置
	private function setSeo(){
		error_reporting(0);		
		$site_title=$this->_site_title;
		$site_titleb=$this->_site_titleb;
		$site_keywords=$this->_site_keywords;
		$site_description=$this->_site_description;
		if(file_exists('./configs/seo_config.inc.php')){
			require_once './configs/seo_config.inc.php';	
		}				
		$this->_tpl->assign('title',$index_title);
		$this->_tpl->assign('keywords',$index_keywords);
		$this->_tpl->assign('description',$index_info);
	}

}
?>