<?php
if (!defined('IN_59MIAO'))
{
	exit('Access Defined');
}
//搜索控制器
class SearchAction extends Action {
	private $_nav=null;	
	private $_keywords='';
	private $_q=null;	
	
	public function __construct() {		
		parent::__construct();
		$this->_nav = new NavModel();		
		$this->_keywords=new KeywordsModel();
		$this->_q=isset($_GET['q'])&&$_GET['q']!=null?$_GET['q']:'女装';
		$this->_tpl->assign('q',$this->_q);		
	}
	
	//实现初始页面
	public function index() {
		$AllNav=$this->_nav->findAllFront();
		$this->_tpl->assign('AllNav',$AllNav['allnav']);
		$AllKeywords=$this->_keywords->findAllFront();		
		$this->_tpl->assign('KeyWords',$AllKeywords);
		//加密url
		$this->_tpl->assign('encode_keywords',urlencode($this->_q));		
		//用于选中不选中的判断
		if(isset($_GET['sort'])){
			$this->_tpl->assign('sort',$_GET['sort']);	
		}
		if(isset($_GET['star'])&& isset($_GET['end'])){
			$this->_tpl->assign('star',$_GET['star']);
			$this->_tpl->assign('end',$_GET['end']);
		}
		else{
			$this->_tpl->assign('star',0);
			$this->_tpl->assign('end',1000);
		}
		
		$this->setSeo();
		$tab=isset($_GET['tab'])?$_GET['tab']:null;
		switch ($tab){
			case 'b2c':
				$this->b2cData();
				break;
			case 'tao':
				$this->taoData();
				break;
			default:$this->b2cData();
		}				
	}	
	private function b2cData(){
		if (!$this->_tpl->is_cached(SMARTY_FRONT.'/b2c_search.tpl',$_SERVER["REQUEST_URI"])) {
			$data=$this->_model->getB2CSearch();	
			//如果没有数据，读取没有数据的页面
			if(empty($data)){
				$this->_tpl->assign('b2c','网上商城');
			    $this->_tpl->assign('tao','淘宝');
			    $this->_tpl->assign('tab','tao');  //可以淘宝看看
				$this->_tpl->display(SMARTY_FRONT.'/nodata.tpl');
				exit;
			}
			if($data['cid']==''){
				$data['cid']=0;
			}
			if($data['sid']==''){
				$data['sid']=0;
			}
			$this->_tpl->assign('cid',$data['cid']);
			$this->_tpl->assign('sid',$data['sid']);		
			$this->_tpl->assign('itemcart',$data['categories']);
			$this->_tpl->assign('sellercart',$data['item_sellers']);
			$this->_tpl->assign('pagetext',$data['page']);		
			$this->_tpl->assign('items',$data['items']);
		}		
		$this->_tpl->display(SMARTY_FRONT.'/b2c_search.tpl',$_SERVER["REQUEST_URI"]);
	}
	private function taoData(){
		if (!$this->_tpl->is_cached(SMARTY_FRONT.'/tao_search.tpl',$_SERVER["REQUEST_URI"])) {
			$data=$this->_model->getTaoSearch();	
			if(empty($data)){
				$this->_tpl->assign('b2c','网上商城');
			    $this->_tpl->assign('tao','淘宝');
			    $this->_tpl->assign('tab','b2c');  //可以b2c看看
				$this->_tpl->display(SMARTY_FRONT.'/nodata.tpl');
				exit;
			}				
			$this->_tpl->assign('items',$data['items']);
			$this->_tpl->assign('pagetext',$data['page']);
		}		
		$this->_tpl->display(SMARTY_FRONT.'/tao_search.tpl',$_SERVER["REQUEST_URI"]);
		
	}
	//seo 设置
	private function setSeo(){
		error_reporting(0);		
		if(file_exists('./configs/seo_config.inc.php')){
			require_once './configs/seo_config.inc.php';	
		}				
		$this->_tpl->assign('title',$this->_q.','.$this->_site_titleb);
		$this->_tpl->assign('keywords',$this->_q.','.$this->_site_keywords);
		$this->_tpl->assign('description',$this->_q.','.$this->_site_description);
	}	
	

}

?>