<?php
class SellerinfoAction extends Action{
	private $_api='';
	private $_sellerlist='';
	private $_nav=null;	
	private $_keywords='';
	public function __construct(){
		parent::__construct();
		$this->_api=new ApiModel();
		$this->_sellerlist=new SellerlistModel();
		$this->_nav = new NavModel();	
		$this->_keywords=new KeywordsModel();
	}
	public function index(){
		if (!$this->_tpl->is_cached(SMARTY_FRONT.'/sellerinfo.tpl',$_SERVER["REQUEST_URI"])) {
			$AllNav=$this->_nav->findAllFront();
			$this->_tpl->assign('AllNav',$AllNav['allnav']);	
			$AllKeywords=$this->_keywords->findAllFront();			
			$this->_tpl->assign('KeyWords',$AllKeywords);			
			$sellerinfo=$this->_sellerlist->findOne();
			$site_logo = $sellerinfo[0]->site_logo;
			$net_logo=$sellerinfo[0]->net_logo;
			if(file_exists($site_logo)){
				$sellerinfo[0]->logo=$site_logo;
			}
			else{
				$sellerinfo[0]->logo=$net_logo;
			}									
			$this->_tpl->assign('sel_info',$sellerinfo[0]);
			$cid=is_numeric($_GET['cid'])?$_GET['cid']:$sellerinfo[0]->category_id;
			$sid=is_numeric($_GET['sid'])?$_GET['sid']:$sellerinfo[0]->sid;			
			//相关商品信息
			$data=$this->_model->getSellerItemList($cid,$sid);
			$this->_tpl->assign('id',$sellerinfo[0]->id);
			$this->_tpl->assign('cid',$data['cid']);
			$this->_tpl->assign('sid',$sellerinfo[0]->sid);				
			$this->_tpl->assign('pagetext',$data['page']);
			$this->_tpl->assign('itemcart',$data['categories']);
			$this->_tpl->assign('sellercart',$data['item_sellers']);			
			if($data['categories'][0]['category_id']!=''){
				$this->_tpl->assign('hascategory',true);
			}	
			$this->_tpl->assign('items',$data['items']);
			if($data['items'][0]!='')
			{
				$this->_tpl->assign('hasdata',true);
			}	
			$this->setSeo($sellerinfo['0']->name, $sellerinfo['0']->description);
		}
		$this->_tpl->display(SMARTY_FRONT.'/sellerinfo.tpl',$_SERVER["REQUEST_URI"]);
	}
	//seo 设置
	private function setSeo($sel_name,$sel_desc){
		error_reporting(0);		
		$site_title=$this->_site_title;
		$site_titleb=$this->_site_titleb;
		$site_keywords=$this->_site_keywords;
		$site_description=$this->_site_description;
		$seller_name=$sel_name;
		$seller_desc=$sel_desc;
		
		if(file_exists('./configs/seo_config.inc.php')){
			require_once './configs/seo_config.inc.php';	
		}				
		$this->_tpl->assign('title',$seller_list_title);
		$this->_tpl->assign('keywords',$seller_list_keywords);
		$this->_tpl->assign('description',$seller_list_info);
	}
	
}
?>