<?php
/**
 * 五十九秒网络购物cms APi设置实体类
 * ============================================================================
 * 版权所有 2009-2012 五十九秒网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.59miao.com；
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！您只能在不用于商业目的的前提下对程序代码进行修改和
 * 使用；不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * $Author: longzhang
 * 
*/
if (!defined('IN_59MIAO'))
{
	exit('Access Defined');
}
class ApiModel extends Model {
	private $_api59miao='';
	private $_taoapi='';	
	private $_taoConfig='';
	private $cid=''; //用于获取商品详情里面的相关商品
	private $shop_cats='';  //商家信息
	
	public function __construct(){
		parent::__construct();
		//59miao Api
		include_once ROOT_PATH.'/api/api59miao/init.inc.php';		
		$this->_api59miao=new Api59miao($AppKeySecret);
		//Taobao APi
		include_once ROOT_PATH.'/api/taoapi/Taoapi.php';
		$this->_taoConfig = Taoapi_Config::Init();
		$this->_taoConfig->setCharset('UTF-8');		
		$this->_taoapi = new Taoapi;	

		//分页类
		include_once ROOT_PATH.'/public/PageClass.php';
		
		
		$this->_fields = array('id','tao_pid','tao_appkey','tao_secret','tao_cachetime','tao_cachepath','our_appkey','our_appsecret','our_cachetime','our_cachepath');
		$this->_tables = array(DB_FREFIX.'apisetting');	
		$this->_check=new ApiCheck();
		list(
				$this->_R['id'],
				$this->_R['cid'],
				$this->_R['page'],
				$this->_R['sid'],
				$this->_R['iid'],
				$this->_R['q']			
		) = $this->getRequest()->getParam(array(
				isset($_GET['id']) ? $_GET['id'] : null,
				isset($_GET['cid']) ? $_GET['cid'] : null,				
				isset($_GET['page'])?$_GET['page']:'1',
				isset($_GET['sid'])?$_GET['sid']:'0',
				isset($_GET['iid'])?$_GET['iid']:null,
				isset($_GET['q'])&&$_GET['q']!=null?urldecode($_GET['q']):'女装'
		));		
		
	}
	//获取一条数据
	public function findOne() {
		$_where = array("id='1'");
		if (!$this->_check->oneCheck($this, $_where)) $this->_check->error();
		return parent::select(array('id','tao_pid','tao_appkey','tao_secret','tao_cachetime','tao_cachepath','our_appkey','our_appsecret','our_cachetime','our_cachepath'),
											array('where'=>$_where, 'limit'=>'1'));
	}	
	//修改Api设置
	public function update(){
		$_where=array("id='1'");		
		if (!$this->_check->oneCheck($this, $_where)) $this->_check->error();
		if (!$this->_check->updateCheck($this)) $this->_check->error();		
		$_updateData = $this->getRequest()->update($this->_fields);
		return parent::update($_where, $_updateData);
	}
	//调取59秒分类信息
	public function api59miao(){
		$fileds="cid,name,count,status,sort_order";
		$Api59miaoData=$this->_api59miao->ListItemCatsGet($fileds);
		$Category=$Api59miaoData['itemcats']['itemcat'];
		return $Category;
	}
	//调取淘宝分类信息
	public function taoapicategory(){		
		$this->_taoapi->method = 'taobao.itemcats.get';
		$this->_taoapi->parent_cid = '0';
		$this->_taoapi->fields = 'cid,parent_cid,name,is_parent,status,sort_order';	
		//需要更多的字段可以登陆 taoapi.com 进行配置生成
		$TaobaokeData = $this->_taoapi->Send('get','xml')->getArrayData();	
		$data=$TaobaokeData['item_cats']['item_cat'];				
		//打印获取到的API数据结果				
		return $data;
	}
	//获取首页调取的商品信息
	public function getHomedata(){	
		$AllData=array();		
		$this->homenav=new HomenavModel();  //获取nav信息
		$homenav=$this->homenav->findAllHomeNav();			
		foreach ($homenav as $value){
			$data=$this->_api59miao->ListItemsSearch('','',$value->category,null, 1, 10);			
			$AllData[]=array(
			'cat_name'=>$value->name,
			'category'=>$value->category,
			'total'=>$data['total_results'],
			'sonnav'=>$this->homenav->findAllSonNav($value->id),
			'product'=>$data['items_search']['items']
			);	
		}
	
		return $AllData;
	}
	//获取促销信息
	public function getPromo(){
		$_filed='title,click_url,seller_url';
		$promoData=$this->_api59miao->ListPromosListGet($_filed,'','','1','10');
		$data=$promoData['promos']['promo'];
		return $data;
	}
	//获取c2c商品的父分类和和当前分类	
	public function GetItemCatParent(){
			$CatParent=array();
			$data = $this->_api59miao->getItemCatParent($this->_R['cid']);	
			$itemcat = $data['itemcats']['itemcat'];	
			$parent_cid =$itemcat['parent_cid'];		
			if($parent_cid)
			{
				$data = $this->_api59miao->getItemCatParent($parent_cid);
				$parent_itemcat = $data['itemcats']['itemcat'];   
			}
			else{
				$parent_itemcat=' ';
			}
			
			$CatParent=array(
				'current_itemcat'=>$itemcat,
				'parent_itemcat'=>$parent_itemcat
			);			
			return $CatParent;

		
	}
	//获取淘宝的父分类和当前分类
	public function GetTaoItemCatParent(){
		$this->_taoapi->method = 'taobao.itemcats.get';	
		$this->_taoapi->cids =$this->_R['cid'];
		$this->_taoapi->fields = 'cid,parent_cid,name,is_parent,status,sort_order';	
		//需要更多的字段可以登陆 taoapi.com 进行配置生成
		$TaobaokeData = $this->_taoapi->Send('get','xml')->getArrayData();	
		$data=$TaobaokeData['item_cats']['item_cat']['name'];		
		//打印获取到的API数据结果			
		return $data;
		//print_r($data);	
		//return $data;
	}	
	
	//获取B2C相关商品相关数据
	public function getItemList(){
			if(isset($_GET['sort']) && isset($_GET['star']) && isset($_GET['end']) && $_GET['end']>=$_GET['star']){
				$star=$_GET['star'];
				$end=$_GET['end'];
				$sort=null;
				if($_GET['sort']==0){
					$sort=null;
				}
				else if($_GET['sort']==1){
					$sort='price_desc';
				}
				else if($_GET['sort']==2){
					$sort='price_asc';
				}
				else if($_GET['sort']==3){
					$sort='modified_desc';
				}
				else if($_GET['sort']==4){
					$sort='modified_asc';
				}
				//price_desc,price_asc,modified_desc,modified_asc
				$list = $this->_api59miao->ListItemsSearch('','', $this->_R['cid'], $this->_R['sid'], $this->_R['page'], 40,$star,$end,$sort);				
			}
			else{
				$list = $this->_api59miao->ListItemsSearch('','', $this->_R['cid'], $this->_R['sid'], $this->_R['page'], 40);	
			}		
			$item_categories = $list['items_search']['item_categories']['item_category'];
			if(Tool::IsTwoArray($item_categories)){
				$item_categories=array($item_categories);
			}		
			$item_seller = $list['items_search']['item_sellers']['item_seller'];	
			if(Tool::IsTwoArray($item_seller)){
				$item_seller=array($item_seller);
			}		
			if(!empty($list['items_search']['items']))
			{
				$items=$list['items_search']['items']['item'];		
			}
			else{
				$items=null;
			}

			
			if(Tool::IsTwoArray($items)){
				$items=array($items);
			}
			$apipage='';
			if($list['total_results']>=3920){
				$list['total_results']=3920;
			}
			if(isset($_GET['sort']) && isset($_GET['star']) && isset($_GET['end']) && $_GET['end']>=$_GET['star']){
				if(REWRITE){
					$pages = new PageClass($list['total_results'],40,$_GET['page'],''.DOMAIN.'/'.B2C_CATEGORY.'-'.$this->_R['cid'].'-'.$this->_R['sid'].'-'.$_GET['sort'].'-'.$_GET['star'].'-'.$_GET['end'].'-{page}'.REWRITE_SUFFIX.'');
					$apipage=$pages -> myde_write();
				}
				else{
					$pages = new PageClass($list['total_results'],40,$_GET['page'],'index.php?a=category&cid='.$this->_R['cid'].'&sid='.$this->_R['sid'].'&sort='.$_GET['sort'].'&star='.$_GET['star'].'&end='.$_GET['end'].'&page={page}');
					$apipage=$pages -> myde_write();
				}	
			}
			else{
				if(REWRITE){
					$pages = new PageClass($list['total_results'],40,$_GET['page'],''.DOMAIN.'/'.B2C_CATEGORY.'-'.$this->_R['cid'].'-'.$this->_R['sid'].'-{page}'.REWRITE_SUFFIX.'');
					$apipage=$pages -> myde_write();
				}
				else{
					$pages = new PageClass($list['total_results'],40,$_GET['page'],'index.php?a=category&cid='.$this->_R['cid'].'&sid='.$this->_R['sid'].'&page={page}');
					$apipage=$pages -> myde_write();
				}	
			}		
		
			$data=array(
				'categories'=>$item_categories,
				'item_sellers'=>$item_seller,
				'items'=>$items,
				'total'=>$list['total_results'],
				'cid'=>$this->_R['cid'],
				'sid'=>$this->_R['sid'],
				'page'=>$apipage
			);			
			return $data;
	}	
	
	
	//获取商家信息下面的相关商品
	public function getSellerItemList($cid,$sid){
			$list = $this->_api59miao->ListItemsSearch('','', $cid, $sid, $this->_R['page'], 40);						
			$item_categories = $list['items_search']['item_categories']['item_category'];
			if(Tool::IsTwoArray($item_categories)){
				$item_categories=array($item_categories);
			}		
			//给item_categorie 增加sid
			$categories=array();
			foreach ($item_categories as $value){
				$categories[]=array(
					'category_id'=>$value['category_id'],
					'category_name'=>$value['category_name'],
					'count'=>$value['count'],
					'sid'=>$sid
				);
			}
			$item_categories=$categories;
			//$item_categories['sid']=$sid;	
			$item_seller = $list['items_search']['item_sellers']['item_seller'];	
			if(Tool::IsTwoArray($item_seller)){
				$item_seller=array($item_seller);
			}		
			if(!empty($list['items_search']['items']))
			{
				$items=$list['items_search']['items']['item'];		
			}
			else{
				$items=null;
			}

			
			if(Tool::IsTwoArray($items)){
				$items=array($items);
			}
			$apipage='';
			if($list['total_results']>=3920){
				$list['total_results']=3920;
			}
			if(REWRITE){
				$pages = new PageClass($list['total_results'],40,$_GET['page'],''.DOMAIN.'/'.SELLERINFO.'-'.$this->_R['id'].'-'.$cid.'-'.$sid.'-{page}'.REWRITE_SUFFIX.'');
				$apipage=$pages -> myde_write();
			}
			else{
				$pages = new PageClass($list['total_results'],40,$_GET['page'],'index.php?a=sellerinfo&id='.$this->_R['id'].'&cid='.$cid.'&sid='.$sid.'&page={page}');
				$apipage=$pages -> myde_write();
			}			
		
			$data=array(
				'categories'=>$item_categories,
				'item_sellers'=>$item_seller,
				'items'=>$items,
				'total'=>$list['total_results'],
				'cid'=>$cid,
				'sid'=>$sid,
				'page'=>$apipage
			);	

		//	print_r($data);
			return $data;
	}	
	
	
	//获取淘宝相关商品数据
	public function getItemListTao(){
		//获取商品数据
		$this->_taoapi->method = 'taobao.items.get'; //50018264
		$this->_taoapi->fields = 'iid,detail_url,num_iid,title,nick,cid,pic_url,location,price,location,volume,parent_cid,total_results';
		$this->_taoapi->parent_cid = '0';
		$this->_taoapi->cid =$this->_R['cid'];  //50020808
		//格式为column:asc/desc,column可选值为: price（价格）, delist_time（下架时间）, seller_credit（卖家信用）,popularity(人气)。如按价格升序排列表示为：price:asc。新增排序字段：volume（最近成交量）
//		 	<option>默认排序</option>
//		    <option>价格降序</option>
//		    <option>价格升序</option>
//		    <option>成交量</option>
//		    <option>卖家信用</option>
//		    <option>人气</option>
//		    <option>时间降序</option>
//		    <option>时间升序</option>
		if(isset($_GET['sort']) && isset($_GET['star']) && isset($_GET['end']) && $_GET['end']>=$_GET['star']){
			if($_GET['sort']==0){
				$sort='volume';
			}
			else if($_GET['sort']==1){
				$sort='price:desc';
			}
			else if($_GET['sort']==2){
				$sort='price:asc';
			}
			else if($_GET['sort']==3){
				$sort='volume';
			}
			else if($_GET['sort']==4){
				$sort='popularity';
			}
			else if($_GET['sort']==5){
				$sort='seller_credit';
			}
			else if($_GET['sort']==6){
				$sort='delist_time:desc';
			}
			else if($_GET['sort']==7){
				$sort='delist_time:asc';
			}
			$this->_taoapi->start_price=$_GET['star'];
			$this->_taoapi->end_price=$_GET['end'];
			$this->_taoapi->order_by = $sort;  //按照成交量排序
		}else{
			$this->_taoapi->order_by = 'volume';  //按照成交量排序
		}
		
		$this->_taoapi->page_size = 40;
		$this->_taoapi->page_no = $this->_R['page'];		
		$items = $this->_taoapi->Send('get','xml')->getArrayData();
		
		
		//获取分类数据		
		//获取后台供卖家发布商品的标准商品类目(taobao.itemcats.get)
		$this->_taoapi->method = 'taobao.itemcats.get';
		$this->_taoapi->parent_cid = $this->_R['cid'];
		$this->_taoapi->cids='';
		$this->_taoapi->fields = 'cid,parent_cid,name,is_parent,status,sort_order';		
		
		$itemcats = $this->_taoapi->Send('get','xml')->getArrayData();
		//分类信息
		if(count($itemcats)>0){
			$itemcatsdata=$itemcats['item_cats']['item_cat'];
		}
		else{			
			$this->_taoapi->method = 'taobao.itemcats.get';
			$this->_taoapi->parent_cid = '';
			$this->_taoapi->cids=$this->_R['cid'];
			$this->_taoapi->fields = 'cid,parent_cid,name,is_parent,status,sort_order';		
			
			$itemcats = $this->_taoapi->Send('get','xml')->getArrayData();
			
			//print_r($itemcats['item_cats']['item_cat']);
			$parent_item_id=$itemcats['item_cats']['item_cat']['parent_cid'];	
			
			if(is_numeric($parent_item_id)){				
				$this->_taoapi->method = 'taobao.itemcats.get';
				$this->_taoapi->parent_cid =$parent_item_id;
				$this->_taoapi->cids='';
				$this->_taoapi->fields = 'cid,parent_cid,name,is_parent,status,sort_order';		
				
				$itemcats = $this->_taoapi->Send('get','xml')->getArrayData();
			}
			
			$itemcatsdata=$itemcats['item_cats']['item_cat'];
		}			
		$itemsdate=$items['items']['item'];
		$total=$items['total_results'];	
		if($total>=3920){
			$total=3920;
		}		
		$apipage='';
		if(isset($_GET['sort']) && isset($_GET['star']) && isset($_GET['end']) && $_GET['end']>=$_GET['star']){
			if(REWRITE){
				$pages = new PageClass($total,40,$_GET['page'],''.DOMAIN.'/'.TAO_CATEGORY.'-'.$this->_R['cid'].'-'.$_GET['sort'].'-'.$_GET['star'].'-'.$_GET['end'].'-{page}'.REWRITE_SUFFIX.'');
				$apipage=$pages -> myde_write();
			}
			else{
				$pages = new PageClass($total,40,$_GET['page'],'index.php?a=category&cid='.$this->_R['cid'].'&tab=tao&sort='.$_GET['sort'].'&star='.$_GET['star'].'&end='.$_GET['end'].'&page={page}');
				$apipage=$pages -> myde_write();
			}	
		}
		else{
			if(REWRITE){
				$pages = new PageClass($total,40,$_GET['page'],''.DOMAIN.'/'.TAO_CATEGORY.'-'.$this->_R['cid'].'-tao-{page}'.REWRITE_SUFFIX.'');
				$apipage=$pages -> myde_write();
			}
			else{
				$pages = new PageClass($total,40,$_GET['page'],'index.php?a=category&cid='.$this->_R['cid'].'&tab=tao&page={page}');
				$apipage=$pages -> myde_write();
			}	
		}		
		$ItemArray=array(
			'items'=>$itemsdate,
			'itemcats'=>$itemcatsdata,
			'total'=>$total,
			'page'=>$apipage
		);		
		return $ItemArray;

	}
    //搜索B2C相关商品相关数据
	public function getB2CSearch(){
			//排序搜索功能
			if(isset($_GET['sort']) && isset($_GET['star']) && isset($_GET['end']) && $_GET['end']>=$_GET['star']){
				$star=$_GET['star'];
				$end=$_GET['end'];
				$sort=null;
				if($_GET['sort']==0){
					$sort=null;
				}
				else if($_GET['sort']==1){
					$sort='price_desc';
				}
				else if($_GET['sort']==2){
					$sort='price_asc';
				}
				else if($_GET['sort']==3){
					$sort='modified_desc';
				}
				else if($_GET['sort']==4){
					$sort='modified_asc';
				}
				//price_desc,price_asc,modified_desc,modified_asc
				$list = $this->_api59miao->ListItemsSearch('',$this->_R['q'], $this->_R['cid'], $this->_R['sid'], $this->_R['page'], 40,$star,$end,$sort);				
			}
			else{
				$list = $this->_api59miao->ListItemsSearch('',$this->_R['q'], $this->_R['cid'], $this->_R['sid'], $this->_R['page'], 40);	
			}			
			if(count($list['items_search']['items'])<=0){  //没有数据
				$data=null; 
				return $data;
			}			
		
						
			$item_categories = $list['items_search']['item_categories']['item_category'];
			if(Tool::IsTwoArray($item_categories)){
				$item_categories=array($item_categories);
			}
			
		
			$item_seller = $list['items_search']['item_sellers']['item_seller'];	
			if(Tool::IsTwoArray($item_seller)){
				$item_seller=array($item_seller);
			}		
			if(!empty($list['items_search']['items']))
			{
				$items=$list['items_search']['items']['item'];		
			}
			else{
				$items=null;
			}			
			
			if(Tool::IsTwoArray($items)){
				$items=array($items);
			}
			if($list['total_results']>=3920){
				$list['total_results']=3920;
			}
			$apipage='';
			if(isset($_GET['sort']) && isset($_GET['star']) && isset($_GET['end']) && $_GET['end']>=$_GET['star']){
				if(REWRITE){
					$pages = new PageClass($list['total_results'],40,$_GET['page'],''.DOMAIN.'/'.SEARCH.'-'.$this->_R['q'].'-'.$this->_R['cid'].'-'.$this->_R['sid'].'-'.$_GET['sort'].'-'.$_GET['star'].'-'.$_GET['end'].'-{page}'.REWRITE_SUFFIX.'');
					$apipage=$pages -> myde_write();
				}
				else{
					$pages = new PageClass($list['total_results'],40,$_GET['page'],'index.php?a=search&q='.$this->_R['q'].'&cid='.$this->_R['cid'].'&sid='.$this->_R['sid'].'&sort='.$_GET['sort'].'&star='.$_GET['star'].'&end='.$_GET['end'].'&page={page}');
					$apipage=$pages -> myde_write();
				}
			}else{
				if(REWRITE){
					$pages = new PageClass($list['total_results'],40,$_GET['page'],''.DOMAIN.'/'.SEARCH.'-'.$this->_R['q'].'-{page}'.REWRITE_SUFFIX.'');
					$apipage=$pages -> myde_write();
				}
				else{
					$pages = new PageClass($list['total_results'],40,$_GET['page'],'index.php?a=search&q='.$this->_R['q'].'&page={page}');
					$apipage=$pages -> myde_write();
				}
			}
			
			$data=array(
				'categories'=>$item_categories,
				'item_sellers'=>$item_seller,
				'items'=>$items,
				'total'=>$list['total_results'],
				'cid'=>$this->_R['cid'],
				'sid'=>$this->_R['sid'],
				'page'=>$apipage
			);			
			return $data;
	}	
	
	//搜索淘宝相关商品数据
	public function getTaoSearch(){
		//获取商品数据	
		//搜索商品信息(taobao.items.search)
		$this->_taoapi->method = 'taobao.items.search';		
		$this->_taoapi->fields = 'num_iid,title,nick,pic_url,cid,price,type,delist_time,post_fee,volume';
		$this->_taoapi->q = $this->_R['q'];			
		$this->_taoapi->order_by = 'seller_credit';
		$this->_taoapi->is_mall = 'true';
		$this->_taoapi->order_by = 'volume';  //按照成交量排序
		$this->_taoapi->page_no = $this->_R['page'];
		$this->_taoapi->page_size = 40;
		//需要更多的字段可以登陆 taoapi.com 进行配置生成
		$items = $this->_taoapi->Send('get','xml')->getArrayData();
		if(empty($items['total_results'])){
			$ItemArray=null;
			return $ItemArray;
		}
		$itemsdate=$items['item_search']['items']['item'];
		$total=$items['total_results'];		
		if($total>=3920){
			$total=3920;
		}
		if(REWRITE){
				$pages = new PageClass($total,40,$_GET['page'],''.DOMAIN.'/'.SEARCH.'-'.$this->_R['q'].'-tao-{page}'.REWRITE_SUFFIX.'');
				$apipage=$pages -> myde_write();
			}
			else{
				$pages = new PageClass($total,40,$_GET['page'],'index.php?a=search&q='.$this->_R['q'].'&tab=tao&page={page}');
				$apipage=$pages -> myde_write();
			}		
		
		$ItemArray=array(
			'items'=>$itemsdate,			
			'total'=>$total,
			'page'=>$apipage
		);	
		return $ItemArray;

	}
	//获取分类信息
	public function GetItemCats(){
		$data = $this->_api59miao->ListItemCatsGet();
		$item_cats = $data['itemcats']['itemcat'];		
		$CatsData=array();	
		foreach ($item_cats as $cats){
			$ChildData=$this->GetItemCatsChild($cats['cid']);			
			$CatsData[]=array(
			  'cats'=>array(
					'cats_name'=>$cats['name'],
					'cats_cid'=>$cats['cid']
				),
			  'childcats'=>$ChildData		
			);
			
		}		
		//print_r($CatsData);
		return $CatsData;		
	}
	//获取子类信息
	public function GetItemCatsChild($cid){
		$cat=$this->_api59miao->getItemCat($cid);		
		if(Tool::IsTwoArray($cat)){
			$cat=array($cat);
		}		
			
		@$data = $cat['itemcats']['itemcat'];
					
		return $data;		
	}
	
	//获取商家分类信息	
	public function GetShopCats(){	
		
		$fields = 'cid,name,count';		
		$data = $this->_api59miao->ListShopCatsGet($fields);
		$this->shop_cats = $data['shop_cats']['shop_cat'];		
		return $this->shop_cats;
		
		
	}
	//获取商品详情信息
	//获取商家分类信息	
	public function getShopsDetail(){			
		$sid = IntVal($_REQUEST['s']);
		$detail = $this->_api59miao->ListShopsDetail($sid);
		
		$shop = $detail['shops']['shop'];
		$shop_url = $shop['click_url'];		
		return $shop_url;
	}
	//获取自定分类下面的商家
	public function ShopListGet($page_no,$page_size){
		$data = $this->_api59miao->ListShopListGet('',Array('page_no' =>$page_no, 'page_size' =>$page_size));
		return $data;
	}
	
	//获取左侧促销分类信息
	public function GetPromoCats(){
		$left_promo=$this->_api59miao->ListPromoCats();
		$left_promo_cats=$left_promo['promo_cats']['promo_cat'];	
		$PromoArray=array();		
		foreach ($left_promo_cats as $value){
			$category_name=$value['name'];
						
			$category_child=$this->_api59miao->ListPromoCats('',$value['cid']);
			
			$child_data=$category_child['promo_cats']['promo_cat'];
			$PromoArray[]=array(
				'cat_name'=>$category_name,
				'cat_child'=>$child_data
			);
		}		
		return $PromoArray;
	}	
	
	//获取促销
	public function GetPromoList(){
			$cid=isset($_GET['cid'])?$_GET['cid']:0;		
			$page_size = 18;			
			if(isset($_GET['page'])){
				$page=$_GET['page'];
			}			
			if(!$page || is_null($page))
			{
				$page =1;
			}			
			$data = $this->_api59miao->ListPromosListGet(null,null, $cid, $page, $page_size);		
			$total_results = $data['total_results'];  //总记录
			$promos = $data['promos']['promo'];
			if(isset($promos['pid']))
			{
				$promos = Array($promos);
			}	
			$page='';
			if(REWRITE){
				$pages = new PageClass($total_results,10,$_GET['page'],''.DOMAIN.'/'.PROMO.'-'.$cid.'-{page}'.REWRITE_SUFFIX.'');
				$page=$pages -> myde_write();
			}
			else{
				$pages = new PageClass($total_results,10,$_GET['page'],'index.php?a=promo&cid='.$cid.'&page={page}');
				$page=$pages -> myde_write();
			}
			
			$PromoList=array(
				'page'=>$page,
				'promo'=>$promos
			);		
			return $PromoList;
	}
	
	//获取内容详情
	
	public function getItemsDetail(){		
			$data = $this->_api59miao->ListItemsDetail($this->_R['iid']);
			$item = $data['items']['item'];
			if(!$item['iid'])
			{
				Header("Location: index.php");
				exit();
			}
			$this->cid=$item['cid'];
			return $item;	
	}
	
	//获取淘宝的内容详情
	public function getTaoItemDetail(){		
		//得到单个商品信息(taobao.item.get)
		$this->_taoapi->method = 'taobao.item.get';
		$this->_taoapi->fields = 'iid,detail_url,pic_url,num_iid,title,nick,type,cid,seller_cids,props,input_pids,input_str,desc,pic_path,num,valid_thru,list_time,delist_time,stuff_status,location,price,post_fee,express_fee,ems_fee,has_discount,freight_payer,has_invoice,has_warranty,has_showcase,modified,increment,auto_repost,approve_status,postage_id,product_id,auction_point,property_alias,itemimg,propimg,sku,outer_id,is_virtural,is_taobao,is_ex,video';		
		$this->_taoapi->num_iid = $this->_R['iid'];
		//需要更多的字段可以登陆 taoapi.com 进行配置生成
		$TaobaokeData = $this->_taoapi->Send('get','xml')->getArrayData();
		return $TaobaokeData;
	}
	//获取淘宝右侧商品
	public function GetTaoRightItem($cid,$page_size){
		//获取商品数据
		$this->_taoapi->method = 'taobao.items.get'; //50018264
		$this->_taoapi->fields = 'iid,detail_url,num_iid,title,nick,cid,pic_url,location,price,location,volume,parent_cid,total_results';
		$this->_taoapi->parent_cid = '0';
		$this->_taoapi->cid =$cid;  //50020808
		$this->_taoapi->order_by = 'volume';  //按照成交量排序
		$this->_taoapi->page_size = $page_size;
		$this->_taoapi->page_no = 1;		
		$items = $this->_taoapi->Send('get','xml')->getArrayData();		
		return $items['items']['item'];
	}	
	//获取商品详情右侧的相关商品
	public function GetRightItem(){	
			$list = $this->_api59miao->ListItemsSearch('','', $this->cid, null, 1, 10);
			$right_items = $list['items_search']['items']['item'];			
			if(isset($right_items['iid']))
			{
				$right_items = Array($right_items);
			}
			if(!$right_items)
			{
				$right_items = Array();
			}
			return $right_items;
	}
	//获取皇冠店铺信息
	public function GetShop(){
		//获取卖家店铺的基本信息(taobao.shop.get)
		
		$shopcategory=new ShopcategoryModel();
		
		$categoryData=$shopcategory->findAllFront();		
		$AllData=array();	
		foreach ($categoryData as $value){
			$this->_taoapi->method = 'taobao.taobaoke.shops.get';
			$this->_taoapi->fields = 'user_id,click_url,shop_title,commission_rate,seller_credit,shop_type,auction_count,total_auction';
			$this->_taoapi->cid=$value->category;
			$this->_taoapi->page_no=1;
			$this->_taoapi->page_size=10;
			
			$this->_taoapi->start_credit="1heart";
			
			$this->_taoapi->end_credit='1crown';
			
			$this->_taoapi->start_commissionrate='50';
			
			$this->_taoapi->end_commissionrate ='150';		
			
			$this->_taoapi->start_auctioncount='10';	
			
			$this->_taoapi->nick=TAO_PID;			
			//需要更多的字段可以登陆 taoapi.com 进行配置生成
			$ShopData = $this->_taoapi->Send('get','xml')->getArrayData();	
			if(count($ShopData)>0){
				$cat_data=$ShopData['taobaoke_shops']['taobaoke_shop'];			
			}
			else{
				$cat_data=null;
			}			
			$AllData[]=array(
			'cat_name'=>$value->name,			
			'Category'=>$cat_data
			);
		}
		return $AllData;
		
		
		
		
		
	}
	
}
?>