<?php
/**
 * 五十九秒网络购物cms 
 * ============================================================================
 * 版权所有 2009-2012 五十九秒网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.59miao.com；
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！您只能在不用于商业目的的前提下对程序代码进行修改和
 * 使用；不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * $Author: longzhang
 * 
*/
if (!defined('IN_59MIAO'))
{
	exit('Access Defined');
}
class BanspiderModel extends Model {	
	public function __construct(){
		parent::__construct();
		$this->_fields = array('id','mark','ban_content','is_ban');
		$this->_tables = array(DB_FREFIX.'banconfig');	
		$this->_check=new Check();	
	}
	//获取一条数据
	public function findOne() {
		$_where = array("mark='spider'");
		if (!$this->_check->oneCheck($this, $_where)) $this->_check->error();
		return parent::select(array('id','mark','ban_content','is_ban'),
											array('where'=>$_where, 'limit'=>'1'));
	}		
	public function update(){		
		$_where=array("mark='spider'");		
		if (!$this->_check->oneCheck($this, $_where)) $this->_check->error();			
		$_updateData = $this->getRequest()->update($this->_fields);		
		//屏蔽蜘蛛
		$data=$_updateData['ban_content'];		
		$is_ban=$_updateData['is_ban'];
		if(Validate::isNullArray($data) || $is_ban==0)		{
			
			if(file_exists('./configs/banspider_config_inc.php')){
				unlink('./configs/banspider_config_inc.php');
			}
		}
		else{
			$_data = $data;		
			$ban_data = '';
			foreach($_data as $key=>$val){
				if(!$val)
					unset($_data[$key]);
				else
					$ban_data .= trim($val).'|';
			}
			$ban_data=substr($ban_data, 0,-1);			
			if(!@file_put_contents('./configs/banspider_config_inc.php', $ban_data)){
				return false;
			}		
		}
		$_updateData['ban_content']=$ban_data;
		return parent::update($_where, $_updateData);
	}
}
?>