<?php
/**
 * 五十九秒网络购物cms 管理员实体类
 * ============================================================================
 * 版权所有 2009-2012 五十九秒网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.59miao.com；
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！您只能在不用于商业目的的前提下对程序代码进行修改和
 * 使用；不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * $Author: longzhang
 * 
*/
if (!defined('IN_59MIAO'))
{
	exit('Access Defined');
}
class ManageModel extends Model {
	public function __construct() {
		parent::__construct();
		$this->_fields = array('id','user','pass','level','is_super','login_count','last_ip','last_time','reg_time');
		$this->_tables = array(DB_FREFIX.'manage');
		$this->_check = new ManageCheck();
		list(
				$this->_R['id'], 
				$this->_R['user'], 
				$this->_R['pass'], 
				$this->_R['code']
		) = $this->getRequest()->getParam(array(
				isset($_GET['id']) ? $_GET['id'] : null,
				isset($_POST['user']) ? $_POST['user'] : null,
				isset($_POST['pass']) ? $_POST['pass'] : null,
				isset($_POST['code']) ? $_POST['code'] : null
		));
	}
	
	public function findAll() {
		$this->_tables = array(DB_FREFIX.'manage as a', DB_FREFIX.'level b');
		return parent::select(array('a.id as id','a.user as user','a.level as level','a.login_count as login_count','a.last_ip as last_ip','a.last_time as last_time', 'b.level_name as level_name'), 
											array('where'=>array('a.level=b.id'),'limit'=>$this->_limit, 'order'=>'a.reg_time DESC'));
	}
	
	public function findOne() {
		$_where = array("id='{$this->_R['id']}'");
		if (!$this->_check->oneCheck($this, $_where)) $this->_check->error();
		return parent::select(array('id','user','level','is_super'),
											array('where'=>$_where, 'limit'=>'1'));
	}	
	
	public function findLogin() {
		$this->_tables = array(DB_FREFIX.'manage as a', DB_FREFIX.'level as b');
		return parent::select(array('a.user as user,a.login_count as login_count', 'b.level_name as level_name'),
											array('where'=>array('a.level=b.id', "user='{$this->_R['user']}'"), 'limit'=>'1'));
	}
	//注意上面执行了findLogin 改变了_tables得值，所以登录会报错
	public function countLogin($loginCount) {		
		$Count=$loginCount+1;		
		$this->_tables = array(DB_FREFIX.'manage');
		$_where = array("user='{$this->_R['user']}'");
		$_updateData['login_count'] = array($Count);
		$_updateData['last_ip'] = Tool::getIP();
		$_updateData['last_time'] = Tool::getDate();	
		parent::update($_where, $_updateData);
	}
	
	public function total() {
		return parent::total();
	}
	
	public function add() {
		$_where = array("user='{$this->_R['user']}'");
		if (!$this->_check->addCheck($this, $_where)) $this->_check->error();
		$_addData = $this->getRequest()->add($this->_fields);
		$_addData['pass'] = sha1($_addData['pass']);
		$_addData['last_ip'] = Tool::getIP();
		$_addData['reg_time'] = Tool::getDate();
		return parent::add($_addData);
	}
	
	public function update() {
		$_where = array("id='{$this->_R['id']}'");
		if (!$this->_check->oneCheck($this, $_where)) $this->_check->error();
		if (!$this->_check->updateCheck($this)) $this->_check->error();
		$_updateData = $this->getRequest()->update($this->_fields);
		$_updateData['pass'] = sha1($_updateData['pass']);
		return parent::update($_where, $_updateData);
	}
	
	public function delete() {
		$_where = array("id='{$this->_R['id']}'");
		return parent::delete($_where);
	}
	
	public function isUser() {
		$_where = array("user='{$this->_R['user']}'");
		$this->_check->ajax($this, $_where);
	}
	
	public function login() {
		$_where = array("user='{$this->_R['user']}'", "pass='".sha1($this->_R['pass'])."'");
		if (!$this->_check->loginCheck($this, $_where)) {
			$this->_check->error();
		} else {
			return true;
		}
	}
	
	public function ajaxLogin() {
		$_where = array("user='{$this->_R['user']}'", "pass='".sha1($this->_R['pass'])."'");
		$this->_check->ajaxLogin($this, $_where);
	}
	
	public function ajaxCode() {
		$this->_check->ajaxcode($this, $this->_R['code']);
	}
}
?>