<?php
if (!defined('IN_59MIAO'))
{
	exit('Access Defined');
}
class SellerlistModel extends Model {
	private $_api='';
	private $_sellercare='';
	public function __construct() {
		parent::__construct();
		$this->_fields = array('id','sid','name','site_logo','net_logo','sitetype','category_id','category_name','recommend','click_url','sort','description','freeshipment','installment','has_invoice','state');
		$this->_tables = array(DB_FREFIX.'seller_list');
		$this->_check = new SellerlistCheck();
		list(
				$this->_R['id'],
				$this->_R['page']
		) = $this->getRequest()->getParam(array(
				isset($_GET['id']) ? $_GET['id'] : null,
				isset($_GET['page'])?$_GET['page']:1				
		));
		$this->_api=new ApiModel();
		$this->_sellercare=new SellercateModel();
	}
	//获取商家分类
	public function GetSellerCat(){		
		return $this->_sellercare->findAllNoLimit();
	}	
	//获取商品分类
	public function GetItemCats(){
		return $this->_api->api59miao();	
	}
	//获取商品详情信息
	public function ShopListGet($page_no,$page_size){
		$data=$this->_api->ShopListGet($page_no,$page_size);
		return $data['shops']['shop'];		
	}
	public function findAll() {
		return parent::select(array('id','sid','name','site_logo','net_logo','sitetype','category_id','category_name','recommend','click_url','sort','description','freeshipment','installment','has_invoice','state'), 
											array('limit'=>$this->_limit, 'order'=>'sort ASC'));
	}	
	//获取指定分类商家
	public function GetSeller(){		
		return parent::select(array('id','sid','name','site_logo','net_logo','sitetype','category_id','category_name','recommend','click_url','sort','description','freeshipment','installment','has_invoice','state'), 
											array('order'=>'sort ASC'));
	}
	//获取推荐在首页的推荐商家
	public function GetRecSeller(){
		$_where = array("recommend=1");
		return parent::select(array('id','sid','name','site_logo','net_logo','sitetype','category_id','category_name','recommend','click_url','sort','description','freeshipment','installment','has_invoice','state'), 
											array('where'=>$_where,'order'=>'sort ASC'));
	}	
	public function findOne() {
		$_where = array("id='{$this->_R['id']}'");
		if (!$this->_check->oneCheck($this, $_where)) $this->_check->error();
		return parent::select(array('id','sid','name','site_logo','net_logo','sitetype','category_id','category_name','recommend','click_url','sort','description','freeshipment','installment','has_invoice','state'),
											array('where'=>$_where, 'limit'=>'1'));
	}	
	public function total(){
		return parent::total();
	}
	public function isOne($_param){
		return parent::isOne($_param);
	}
	//用于同步数据的update
	public function b2cupdate($_param,$_updateData){
		return parent::update($_param, $_updateData);
	}
	//用于同步数据的add
	public function b2cadd($_updateData){
		return parent::add($_updateData);
	}
	
	public function add() {		
		if (!$this->_check->addCheck($this)) $this->_check->error();
		$_addData = $this->getRequest()->add($this->_fields);
		if(!is_numeric($_addData['sort'])){
			$_addData['sort']=10;
		}
		$_addData['sitetype']=implode(',',$_addData['sitetype']);		
		return parent::add($_addData);
	}	
	public function update() {
		$_where = array("id='{$this->_R['id']}'");		
		if (!$this->_check->oneCheck($this, $_where)) $this->_check->error();
		if (!$this->_check->updateCheck($this)) $this->_check->error();
		$_updateData = $this->getRequest()->update($this->_fields);		
		$_updateData['sitetype']=implode(',',$_updateData['sitetype']);	
		return parent::update($_where, $_updateData);
	}	
	public function delete() {
		$_where = array("id='{$this->_R['id']}'");
		return parent::delete($_where);
	}	
	public function sort() {
		foreach ($_POST['sort'] as $_key=>$_value){
			if (!is_numeric($_value)) continue;
			$_setField = array('sort'=>$_value);
			$_where = array("id='$_key'");
			parent::update($_where, $_setField);
		}
		return true;
	}
}
?>