<?php
//数据库连接类，不建议直接使用DB，而是对DB封装一层
//这个类不会被污染，不会被直接调用
class DB {
	//mysql数据库连接对象
	private $conn = null;
	private $result=null; 
	//用于存放实例化的对象
	static private $_instance = null;
	
	//公共静态方法获取实例化的对象
	static protected function getInstance() {
		if (!(self::$_instance instanceof self)) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}	
	//私有克隆
	private function __clone() {}
	
	//私有构造
	private function __construct() {
		//连接数据库
		$this->connect();
	}
	
	//新增
	protected function add($_tables, Array $_addData) {
		$_addFields = array();
		$_addValues = array();
		foreach ($_addData as $_key=>$_value) {
			$_addFields[] = $_key;
			$_addValues[] = $_value;
		}
		$_addFields = implode(',', $_addFields);
		$_addValues = implode("','", $_addValues);
		$_sql = "INSERT INTO $_tables[0] ($_addFields) VALUES ('$_addValues')";
		$rel = $this->execute($_sql);
		return mysql_affected_rows();
	}
	
	//修改
	protected function update($_tables, Array $_param, Array $_updateData) {
		$_where = $_setData = '';
		foreach ($_param as $_key=>$_value) {
			$_where .= $_value.' AND ';
		}
		$_where = 'WHERE '.substr($_where, 0, -4);
		foreach ($_updateData as $_key=>$_value) {
			if (Validate::isArray($_value)) {
				$_setData .= "$_key=$_value[0],";
			} else {
				$_setData .= "$_key='$_value',";
			}
		}
		$_setData = substr($_setData, 0, -1);
		$_sql = "UPDATE $_tables[0] SET $_setData $_where LIMIT 1";
		$rel = $this->execute($_sql);
		return mysql_affected_rows();
	}
	
	//验证一条数据
	protected function isOne($_tables, Array $_param) {
		$_where = '';
		foreach ($_param as $_key=>$_value) {
			$_where .=$_value.' AND ';
		}
		$_where = 'WHERE '.substr($_where, 0, -4);
		$_sql = "SELECT id FROM $_tables[0] $_where LIMIT 1";
		$rel = $this->execute($_sql);
		return mysql_num_rows($rel);
	}
	
	//删除
	protected function delete($_tables, Array $_param) {
		$_where = '';
		foreach ($_param as $_key=>$_value) {
			$_where .= $_value.' AND ';
		}
		$_where = 'WHERE '.substr($_where, 0, -4);
		$_sql = "DELETE FROM $_tables[0] $_where LIMIT 1";
		$rel=$this->execute($_sql);
		return mysql_affected_rows();
	}
	
	//查询
	protected function select($_tables, Array $_fileld, Array $_param = array()) {
		$_limit = $_order = $_where = '';
		if (Validate::isArray($_param) && !Validate::isNullArray($_param)) {
			$_limit = isset($_param['limit']) ? 'LIMIT '.$_param['limit'] : '';
			$_order = isset($_param['order']) ? 'ORDER BY '.$_param['order'] : '';
			if (isset($_param['where'])) {
				foreach ($_param['where'] as $_key=>$_value) {
					$_where .= $_value.' AND ';
				}
				$_where = 'WHERE '.substr($_where, 0, -4);
			}
		}
		$_selectFields = implode(',', $_fileld);
		$_table = isset($_tables[1]) ? $_tables[0].','.$_tables[1] : $_tables[0];
		$_sql = "SELECT $_selectFields FROM $_table $_where $_order $_limit";
		$_stmt = $this->execute($_sql);
		$_result = array();
		while (!!$_objs = mysql_fetch_object($_stmt)) {
			$_result[] = $_objs;
		}
		return Tool::setHtmlString($_result);
	}
	
	//总记录
	protected function total($_tables, Array $_param = array()) {
		$_where = '';
		if (isset($_param['where'])) {
			foreach ($_param['where'] as $_key=>$_value) {
				$_where .= $_value.' AND ';
			}
			$_where = 'WHERE '.substr($_where, 0, -4);
		}
		$_sql = "SELECT COUNT(*) as count FROM $_tables[0] $_where";
		$_stmt = $this->execute($_sql);
		$rel_count=mysql_fetch_object($_stmt);
		return $rel_count->count;
	}
	/*mysql数据库连接*/
	public function connect() {		
		$this->conn = mysql_connect(DB_HOST, DB_USER, DB_PASS);	

		if (!mysql_select_db(DB_NAME, $this->conn)) {
			exit('数据库连接不正确');
		}
		mysql_query("SET NAMES UTf8");
	}

	/*数据库执行语句，可执行查询添加修改删除等任何sql语句*/
	public function execute($sql) {
		if ($sql == "") {
			exit("SQL查询语句为空");
		}
		$result = mysql_query($sql, $this->conn);

		if (!$result) {
			//调试中使用，sql语句出错时会自动打印出来
			exit('SQL语句'.$sql.'发生错误');
		} else {
			$this->result = $result;
		}
		return $this->result;
	}
	
}
?>