<?php
//上传文件类
if (!defined('IN_59MIAO'))
{
	exit('Access Defined');
}
class FileUpload {
	private $error;			//错误代码
	private $maxsize;		//表单最大值
	private $type;				//类型
	private $typeArr = array('image/jpeg','image/pjpeg','image/png','image/x-png','image/gif');		//类型合集
	private $path;				//目录路径
	private $today;			//今天目录
	private $name;			//文件名
	private $tmp;				//临时文件
	private $linkpath;		//链接路径
	private $linkpath_min; //小图片的连接路径
	private $linktotay;		//今天目录（相对）
	private $souse_path;        //图片原文件目录
	private $min_path;          //图片新文件目录
	
	//构造方法，初始化
	public function __construct($_file,$_maxsize) {
		$this->error = $_FILES[$_file]['error'];
		$this->maxsize = $_maxsize / 1024;
		$this->type = $_FILES[$_file]['type'];
		$this->path = ROOT_PATH.'/'.UPDIR;
		$this->linktotay = date('Ymd').'/';
		$this->today = $this->path.$this->linktotay;
		
		$this->name = $_FILES[$_file]['name'];
		$this->tmp = $_FILES[$_file]['tmp_name'];
		$this->souse_path=$this->today.SOURCE_PATH;  //原图片路径
		$this->min_path=$this->today.MIN_PATH;       //现在的图片路径
		$this->checkError();
		$this->checkType();
		$this->checkPath();
		$this->moveUpload();
	}
	
	//返回原路径
	public function getSourcePath() {
		//$_path = $_SERVER["SCRIPT_NAME"];
		//$_dir = dirname(dirname($_path));
		//if ($_dir == '\\') $_dir = '/';
		//$this->linkpath = $_dir.$this->linkpath;		
		return $this->linkpath;
	}
	//返回现在的路径
	public function getMinPath() {
		//$_path = $_SERVER["SCRIPT_NAME"];
		//$_dir = dirname(dirname($_path));
		//if ($_dir == '\\') $_dir = '/';
		//$this->linkpath = $_dir.$this->linkpath;		
		return $this->linkpath_min;
	}
	//获取小文件的路径
	
	//移动文件
	private function moveUpload() {
		if (is_uploaded_file($this->tmp)) {
			if (!move_uploaded_file($this->tmp,$this->setNewName())) {
				Tool::alertBack('警告：上传失败！');
			}
		} else {
			Tool::alertBack('警告：临时文件不存在！');
		}
	}
	
	//设置新文件名
	private function setNewName() {
		$_nameArr = explode('.',$this->name);
		$_postfix = $_nameArr[count($_nameArr)-1];
		$_newname = date('YmdHis').mt_rand(100,1000).'.'.$_postfix;
		$this->linkpath = UPDIR.$this->linktotay.SOURCE_PATH.$_newname;
		//$this->linkpath = $this->today.$_newname;
		$this->linkpath_min = UPDIR.$this->linktotay.MIN_PATH.$_newname;
		return $this->souse_path.$_newname;   //返回原图片路径
	}
	
	//验证目录
	private function checkPath() {
		if (!is_dir($this->path) || !is_writeable($this->path)) {
			if (!mkdir($this->path)) {
				Tool::alertBack('警告：主目录创建失败！');
			}
		}
	if (!is_dir($this->today) || !is_writeable($this->today)) {
			if (!mkdir($this->today)) {
				Tool::alertBack('警告：二级子目录创建失败！');
			}
		}
		if (!is_dir($this->souse_path) || !is_dir($this->min_path) || !is_writeable($this->souse_path) || !is_writeable($this->min_path)) {
			if (!mkdir($this->souse_path) || !mkdir($this->min_path)) {
				Tool::alertBack('警告：三级子目录录创建失败！');
			}
		}
		
	}
	
	//验证类型
	private function checkType() {
		if (!in_array($this->type,$this->typeArr)) {
			Tool::alertBack('警告：不合法的上传类型！');
		}
	}
	
	//验证错误
	private function checkError() {
		if (!empty($this->error)) {
			switch ($this->error) {
				case 1 :
					Tool::alertBack('警告：上传值超过了约定最大值！');
					break;
				case 2 :
					Tool::alertBack('警告：上传值超过了'.$this->maxsize.'KB！');
					break;
				case 3 :
					Tool::alertBack('警告：只有部分文件被上传！');
					break;
				case 4 :
					Tool::alertBack('警告：没有任何文件被上传！');
					break;
				default:
					Tool::alertBack('警告：未知错误！');
			}
		}
	}
}
?>