<?php
class Tenpay extends Pay{
	private $info;
	private $path;
	function __construct(){
		$path = str_replace("/Tenpay.class.php","/",str_replace("\\","/",__FILE__));
		$this->path = $path;
	}

	function pay($paybankId,$amount,$outTradeNo){
		$domain = $_SERVER['HTTP_HOST'];
		$info = $this->bankInfo($paybankId);
		require_once ($this->path."Tenpay/PayRequestHandler.class.php");
		$bargainor_id = $info['apiPid'];
		$key = $info['apiKey'];
		$return_url = 'http://'.$domain.'/pay/payReturn/tenpay';
		$strDate = date("Ymd");
		$strTime = date("His");
		$randNum = rand(1000, 9999);
		$strReq = $strTime . $randNum;	//10位序列号,可以自行调整。
		$sp_billno = $outTradeNo;	/* 商家订单号,长度若超过32位，取前32位。财付通只记录商家订单号，不保证唯一。 */
		$transaction_id = $bargainor_id . $strDate . $strReq;/* 财付通交易单号，10位商户号+8位时间（YYYYmmdd)+10位流水号*/
		$total_fee = $amount*100;	/* 商品价格（包含运费），以分为单位 */
		$desc = "订单号：" . $transaction_id;		/* 商品名称 */
		/* 创建支付请求对象 */
		$reqHandler = new PayRequestHandler();
		$reqHandler->init();
		$reqHandler->setKey($key);
		$reqHandler->setParameter("cs", "utf-8");
		$reqHandler->setParameter("bargainor_id", $bargainor_id);			//商户号
		$reqHandler->setParameter("sp_billno", $sp_billno);					//商户订单号
		$reqHandler->setParameter("transaction_id", $transaction_id);		//财付通交易单号
		$reqHandler->setParameter("total_fee", $total_fee);					//商品总金额,以分为单位
		$reqHandler->setParameter("return_url", $return_url);				//返回处理地址
		$reqHandler->setParameter("desc", "订单号：" . $transaction_id);	//商品名称
		//用户ip,测试环境时不要加这个ip参数，正式环境再加此参数
		//$reqHandler->setParameter("spbill_create_ip", $_SERVER['REMOTE_ADDR']);
		//$reqUrl = $reqHandler->getRequestURL();
		$form = $reqHandler->getRequestForm();

		echo $form;
	}
	
	function payReturn(){
		global $db;
		require_once ($this->path."Tenpay/PayResponseHandler.class.php");
		$sp_billno = getgpc("sp_billno");
		$bankId = $db->getOne("select bankId from qk_onlinepay where outTradeNo='$sp_billno'");
		$apiKey = $db->getOne("select apiKey from qk_paybank where id='$bankId'");
		$key = $apiKey;
		$resHandler = new PayResponseHandler();
		$resHandler->setKey($key);
		if($resHandler->isTenpaySign()) {
			$sp_billno = $resHandler->getParameter("sp_billno");
			$transaction_id = $resHandler->getParameter("transaction_id");
			$total_fee = $resHandler->getParameter("total_fee");
			$pay_result = $resHandler->getParameter("pay_result");
			if( "0" == $pay_result ) {
				//------------------------------
				//处理业务开始
				//------------------------------
						$outTradeNo = $sp_billno;
						load_class("pay");
						$pm = new PayModel();
						$payInfo = $pm->getInfo(array("outTradeNo"=>$outTradeNo));
						if($payInfo && $payInfo['amount']*100==$total_fee){
							$sql = "update qk_onlinepay set iStatus=14,transactionId='".$transaction_id."' where id='".$payInfo['id']."'";
							$db->query($sql);
							$orderId = $payInfo['orderId'];
							load_class("order");
							$om = new OrderModel();
							$orderInfo = $om->getInfo(array("id"=>$orderId));
							if($orderInfo['iStatus']){
								$sql = "update qk_order set iStatus=5 where id='".$orderInfo['id']."'";
								$db->query($sql);
									//调用doShow, 打印meta值跟js代码,告诉财付通处理成功,并在用户浏览器显示$show页面.
									global $baseUrl;
									$show = $baseUrl."pay/result/status/success";
									$resHandler->doShow($show);
									exit("Success");
								//return true;
							}
							exit("Order Error");
						}
				exit("Pay Error");
				//注意交易单不要重复处理
				//注意判断返回金额
				return false;
				//------------------------------
				//处理业务完毕
				//------------------------------	
			} else {
				exit("Status Error");
				return false;
				//当做不成功处理
				//echo "<br/>" . "支付失败" . "<br/>";
			}
			
		} else {
			exit("Sign Error");
			return false;
			//echo "<br/>" . "认证签名失败" . "<br/>";
		}
		//header("Location:".$baseUrl."pay/result/status/success");
		return false;
	}
}
?>