<?php

!defined('IN_TIPASK') && exit('Access Denied');

class usermodel {

    var $db;
    var $base;

    function usermodel(&$base) {
        $this->base = $base;
        $this->db = $base->db;
    }

    function get_by_uid($uid, $loginstatus = 1) {
        $user = $this->db->fetch_first("SELECT * FROM " . DB_TABLEPRE . "user WHERE uid='$uid'");
        $user['avatar'] = get_avatar_dir($uid);
        $user['register_time'] = tdate($user['regtime']);
        $user['lastlogin'] = tdate($user['lastlogin']);
        $user['grouptitle'] = $this->base->usergroup[$user['groupid']]['grouptitle'];
        $user['category'] = $this->get_category($user['uid']);
        ($loginstatus == 1) && $user['islogin'] = $this->is_login($uid);
        ($loginstatus == 2) && $user['refresh_time'] = tdate($this->get_refresh_time($uid));
        return $user;
    }

    function get_by_username($username) {
        $user = $this->db->fetch_first("SELECT * FROM " . DB_TABLEPRE . "user WHERE username='$username'");
        return $user;
    }

    function get_by_email($email) {
        $user = $this->db->fetch_first("SELECT * FROM " . DB_TABLEPRE . "user WHERE email='$email'");
        return $user;
    }

    //һ
    function get_by_name_email($name, $email) {
        $user = $this->db->fetch_first("SELECT * FROM " . DB_TABLEPRE . "user WHERE email='$email' AND `username`='$name'");
        return $user;
    }

    /*  */

    function adoptpercent($user) {
        $adoptpercent = 0;
        if (0 != $user['answers']) {
            $adoptpercent = round(($user['adopts'] / $user['answers']), 3) * 100;
        }
        return $adoptpercent;
    }

    function get_list($start = 0, $limit = 10) {
        $userlist = array();
        $query = $this->db->query("SELECT * FROM " . DB_TABLEPRE . "user  ORDER BY uid DESC LIMIT $start,$limit");
        while ($user = $this->db->fetch_array($query)) {
            $user['lastlogintime'] = tdate($user['lastlogin']);
            $user['regtime'] = tdate($user['regtime']);
            $userlist[] = $user;
        }
        return $userlist;
    }

    function get_active_list($start = 0, $limit = 10) {
        $userlist = array();
        $query = $this->db->query("SELECT * FROM " . DB_TABLEPRE . "user ORDER BY answers DESC,lastlogin DESC,credit2 DESC LIMIT $start,$limit");
        while ($user = $this->db->fetch_array($query)) {
            $user['avatar'] = get_avatar_dir($user['uid']);
            $userlist[] = $user;
        }
        return $userlist;
    }

    function get_lastest_register($start = 0, $limit = 5) {
        $userlist = array();
        $query = $this->db->query("SELECT * FROM " . DB_TABLEPRE . "user ORDER BY regtime DESC LIMIT $start,$limit");
        while ($user = $this->db->fetch_array($query)) {
            $userlist[] = $user;
        }
        return $userlist;
    }

    function get_answer_top($start = 0, $limit = 8) {
        $userlist = array();
        $query = $this->db->query("SELECT * FROM " . DB_TABLEPRE . "user ORDER BY answers DESC,lastlogin DESC LIMIT $start,$limit");
        while ($user = $this->db->fetch_array($query)) {
            $userlist[] = $user;
        }
        return $userlist;
    }

    function list_by_search_condition($condition, $start = 0, $limit = 10) {
        $userlist = array();
        $query = $this->db->query('SELECT * FROM ' . DB_TABLEPRE . "user WHERE $condition ORDER BY `uid` DESC LIMIT $start , $limit");
        while ($user = $this->db->fetch_array($query)) {
            $user['regtime'] = tdate($user['regtime']);
            $user['lastlogintime'] = tdate($user['lastlogin']);
            $userlist[] = $user;
        }
        return $userlist;
    }

    /* ûһʱĻֻȡǰ100 */

    function list_by_credit($type = 0, $limit = 100) {
        $userlist = array();
        $starttime = 0;
        if (1 == $type) {
            $starttime = $this->base->time - 7 * 24 * 3600;
        }
        if (2 == $type) {
            $starttime = $this->base->time - 30 * 24 * 3600;
        }
        $sqlarray = array(
            'SELECT u.uid,u.groupid, u.username,u.gender,u.lastlogin,u.credit2,u.questions,u.answers,u.adopts FROM ' . DB_TABLEPRE . "user  u ORDER BY `credit2` DESC,u.answers DESC  LIMIT 0,$limit",
            "SELECT u.uid,u.groupid, u.username,u.gender,u.lastlogin,sum( c.credit2 ) credit2,u.questions,u.answers,u.adopts FROM " . DB_TABLEPRE . "user u," . DB_TABLEPRE . "credit c   WHERE u.uid=c.uid AND c.time>$starttime   GROUP BY u.uid ORDER BY credit2  DESC,u.answers DESC LIMIT 0,$limit",
            "SELECT u.uid,u.groupid, u.username,u.gender,u.lastlogin,sum( c.credit2 ) credit2,u.questions,u.answers,u.adopts  FROM " . DB_TABLEPRE . "user u," . DB_TABLEPRE . "credit c   WHERE u.uid=c.uid AND c.time>$starttime   GROUP BY u.uid ORDER BY credit2  DESC,u.answers DESC LIMIT 0,$limit"
        );
        $query = $this->db->query($sqlarray[$type]);
        while ($user = $this->db->fetch_array($query)) {
            $user['gender'] = (1 == $user['gender']) ? '' : 'Ů';
            $user['lastlogin'] = tdate($user['lastlogin']);
            $user['grouptitle'] = $this->base->usergroup[$user['groupid']]['grouptitle'];
            $user['avatar'] = get_avatar_dir($user['uid']);
            $userlist[] = $user;
        }
        return $userlist;
    }

    function refresh($uid, $islogin = 1, $cookietime = 0) {
        @$sid = tcookie('sid');
        $this->base->user = $this->db->fetch_first("SELECT * FROM " . DB_TABLEPRE . "user u," . DB_TABLEPRE . "usergroup g WHERE u.uid=$uid AND u.groupid=g.groupid");
        $this->db->query("UPDATE " . DB_TABLEPRE . "user SET `lastlogin`={$this->base->time}  WHERE `uid`=$uid"); //¼ʱ
        $this->db->query("REPLACE INTO " . DB_TABLEPRE . "session (sid,uid,islogin,ip,`time`) VALUES ('$sid',$uid,$islogin,'{$this->base->ip}',{$this->base->time})");
        $password = $this->base->user['password'];
        $auth = authcode("$uid\t$password", 'ENCODE');
        if ($cookietime)
            tcookie('auth', $auth, $cookietime);
        else
            tcookie('auth', $auth);

        tcookie('loginuser', '');
        $this->base->user['newmsg'] = 0;
    }

    function refresh_session_time($sid, $uid) {
        $lastrefresh = intval(tcookie("lastrefresh"));
        if (!$lastrefresh) {
            if ($uid) {
                $this->db->query("UPDATE " . DB_TABLEPRE . "session SET `time` = {$this->base->time} WHERE sid='$sid'");
            } else {
                $session = $this->db->fetch_first("SELECT * FROM " . DB_TABLEPRE . "session WHERE sid='$sid'");
                if ($session) {
                    $this->db->query("UPDATE " . DB_TABLEPRE . "session SET `time` = {$this->base->time} WHERE sid='$sid'");
                } else {
                    $this->db->query("INSERT INTO " . DB_TABLEPRE . "session (sid,`ip`,`time`) VALUES ('$sid','{$this->base->ip}',{$this->base->time})");
                }
            }
            tcookie("lastrefresh", '1', 60);
        }
    }

    /* ûҪuid */

    function add($username, $password, $email = '', $uid = 0) {
        $password = md5($password);
        if ($uid) {
            $this->db->query("REPLACE INTO  " . DB_TABLEPRE . "user (uid,username,password,email,regip,regtime,`lastlogin`) VALUES ('$uid','$username','$password','$email','" . getip() . "',{$this->base->time},{$this->base->time})");
        } else {
            $this->db->query("INSERT INTO " . DB_TABLEPRE . "user(username,password,email,regip,regtime,`lastlogin`) values ('$username','$password','$email','" . getip() . "',{$this->base->time},{$this->base->time})");
            $uid = $this->db->insert_id();
        }
        return $uid;
    }

    //ipַ
    function is_allowed_register() {
        $starttime = strtotime("-1 day");
        $endtime = strtotime("+1 day");
        $usernum = $this->db->result_first("SELECT count(*) FROM " . DB_TABLEPRE . "user WHERE regip='{$this->base->ip}' AND regtime>$starttime AND regtime<$endtime ");
        if ($usernum >= $this->base->setting['max_register_num']) {
            return false;
        }
        return true;
    }

    /* ޸û */

    function uppass($uid, $password) {
        $password = md5($password);
        $this->db->query('UPDATE ' . DB_TABLEPRE . "user SET `password`='" . $password . "' WHERE `uid`=$uid ");
    }

    /* ûϢ */

    function update($uid, $gender, $bday, $phone, $qq, $msn, $introduction, $signature, $isnotify = 1) {
        $this->db->query("UPDATE " . DB_TABLEPRE . "user SET `gender`='$gender',`bday`='$bday',`phone`='$phone',`qq`='$qq',`msn`='$msn',`introduction`='$introduction',`signature`='$signature',`isnotify`='$isnotify'  WHERE `uid`=$uid");
    }

    function update_email($email, $uid) {
        $this->db->query("UPDATE " . DB_TABLEPRE . "user SET `email`='$email' WHERE `uid`=$uid");
    }

    /* ƷһûϢ */

    function update_gift($uid, $realname, $email, $phone, $qq) {
        $this->db->query("UPDATE " . DB_TABLEPRE . "user SET `realname`='$realname',`email`='$email',`phone`='$phone',`qq`='$qq' WHERE `uid`=$uid");
    }

    /* ̨ûϢ */

    function update_user($uid, $username, $passwd, $email, $groupid, $credits, $credit1, $credit2, $gender, $bday, $phone, $qq, $msn, $introduction, $signature) {
        $this->db->query("UPDATE " . DB_TABLEPRE . "user SET `username`='$username',`password`='$passwd',`email`='$email',`groupid`='$groupid',`credits`=$credits,`credit1`=$credit1,`credit2`=$credit2,`gender`='$gender',`bday`='$bday',`phone`='$phone',`qq`='$qq',`msn`='$msn',introduction='$introduction',`signature`='$signature'  WHERE `uid`=$uid");
    }

    /* authstr */

    function update_authstr($uid, $authstr) {
        $this->db->query("UPDATE " . DB_TABLEPRE . "user SET `authstr`='$authstr'  WHERE `uid`=$uid");
    }

    /* ɾû */

    function remove($uids, $all = 0) {
        $this->db->query("DELETE FROM `" . DB_TABLEPRE . "user` WHERE `uid` IN ($uids)");
        $this->db->query("DELETE FROM `" . DB_TABLEPRE . "famous` WHERE `uid` IN ($uids)");
        /* ɾͻش */
        if ($all) {
            $this->db->query("DELETE FROM `" . DB_TABLEPRE . "question` WHERE `authorid` IN ($uids)");
            $this->db->query("DELETE FROM `" . DB_TABLEPRE . "answer` WHERE `authorid` IN ($uids)");
            $this->db->query("UPDATE `" . DB_TABLEPRE . "question` SET answers=answers-1 WHERE `authorid` IN ($uids)");
        }
    }

    function logout() {
        tcookie('sid', '', 0);
        tcookie('auth', '', 0);
        tcookie('loginuser', '', 0);
        $lasttime = $this->db->result_first("SELECT MAX(time) FROM ".DB_TABLEPRE."session WHERE uid=" . $this->base->user['uid']);
        $this->db->query("DELETE FROM " . DB_TABLEPRE . "session WHERE uid=" . $this->base->user['uid']." AND `time`<$lasttime");
    }

    function save_code($code) {
        $uid = $this->base->user['uid'];
        $sid = $this->base->user['sid'];
        $islogin = $this->db->result_first("SELECT islogin FROM " . DB_TABLEPRE . "session WHERE sid='$sid'");
        $islogin = $islogin ? $islogin : 0;
        $this->db->query("REPLACE INTO " . DB_TABLEPRE . "session (sid,uid,code,islogin,`time`) VALUES ('$sid',$uid,'$code','$islogin',{$this->base->time})");
    }

    function get_code() {
        $sid = $this->base->user['sid'];
        return $this->db->result_first("SELECT code FROM " . DB_TABLEPRE . "session WHERE sid='$sid'");
    }

    function is_login($uid = 0) {
        (!$uid) && $uid = $this->base->user['uid'];
        $onlinetime = $this->base->time - intval($this->base->setting['sum_onlineuser_time']) * 60;
        $islogin = $this->db->result_first("SELECT islogin FROM " . DB_TABLEPRE . "session WHERE uid=$uid AND time>$onlinetime");
        if ($islogin && $uid > 0) {
            return $islogin;
        }
        return false;
    }

    function get_refresh_time($uid) {
        return $this->db->result_first("SELECT time FROM " . DB_TABLEPRE . "session WHERE uid=$uid ORDER BY time DESC");
    }

    /* ͷ֤ͨ */

    function passport_client() {
        $passport_action = 'passport_' . $this->base->get[1]; //loginlogoutregister
        $location = $this->base->setting['passport_server'] . '/' . $this->base->setting[$passport_action];
        $forward = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : SITE_URL;
        header('location:' . $location . (false === strpos($location, '?') ? '?' : '&') . 'forward=' . $forward);
        exit;
    }

    /* ֤ͨ */

    function passport_server($forward) {
        $action = $this->base->get[1];
        ('register' == $action) && $action = 'login';
        $member['username'] = $this->base->user['username'];
        $member['password'] = $this->base->user['password'];
        $member['email'] = $this->base->user['email'];
        $member['cktime'] = $this->base->time + (60 * 60 * 24 * 365);
        $userstr = 'time=' . $this->base->time;
        foreach ($member as $key => $val) {
            $userstr .= "&$key=$val";
        }
        $userdb = authcode($userstr, 'ENCODE', $this->base->setting['passport_key']);
        $verify = md5($action . $userdb . $forward . $this->base->setting['passport_key']);
        $location = $this->base->setting['passport_client'] . '?action=' . $action . '&userdb=' . urlencode($userdb) . '&forward=' . urlencode($forward) . '&verify=' . $verify;
        header('location:' . $location);
        exit;
    }

    /* ûϸ */

    function credit_detail($uid) {
        $detail1 = $detail2 = $detail3 = array('reward' => 0, 'punish' => 0, 'offer' => 0, 'adopt' => 0, 'other' => 0);
        $query = $this->db->query("SELECT * FROM " . DB_TABLEPRE . "credit c  where c.uid=" . $uid);
        while ($credit = $this->db->fetch_array($query)) {
            switch ($credit['operation']) {
                case 'reward'://÷
                    $detail1['reward']+=$credit['credit1'];
                    $detail2['reward']+=$credit['credit2'];
                    $detail3['reward']+=$credit['credit3'];
                    break;
                case 'punish'://÷
                    $detail1['punish']+=$credit['credit1'];
                    $detail2['punish']+=$credit['credit2'];
                    $detail3['punish']+=$credit['credit3'];
                    break;
                case 'offer'://͸
                    $detail2['offer']+=$credit['credit2'];
                    break;
                case 'adopt'://شⱻΪ
                    $detail2['adopt']+=$credit['credit2'];
                    break;
                default:
                    $detail1['other']+=$credit['credit1'];
                    $detail2['other']+=$credit['credit2'];
                    $detail3['other']+=$credit['credit3'];
                    break;
            }
        }
        return array($detail1, $detail2);
    }

    /* ûϷ */

    function check_usernamecensor($username) {
        $censorusername = $this->base->setting['censor_username'];
        $censorexp = '/^(' . str_replace(array('\\*', "\r\n", ' '), array('.*', '|', ''), preg_quote(($censorusername = trim($censorusername)), '/')) . ')$/i';
        if ($censorusername && preg_match($censorexp, $username)) {
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /* ʼַϷ */

    function check_emailaccess($email) {
        $setting = $this->base->setting;
        $accessemail = $setting['access_email'];
        $censoremail = $setting['censor_email'];
        $accessexp = '/(' . str_replace("\r\n", '|', preg_quote(trim($accessemail), '/')) . ')$/i';
        $censorexp = '/(' . str_replace("\r\n", '|', preg_quote(trim($censoremail), '/')) . ')$/i';
        if ($accessemail || $censoremail) {
            if (($accessemail && !preg_match($accessexp, $email)) || ($censoremail && preg_match($censorexp, $email))) {
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            return TRUE;
        }
    }

    function add_category($cid, $uid) {
        $this->db->query("INSERT INTO " . DB_TABLEPRE . "user_category(cid,uid) VALUES ($cid,$uid)");
    }

    function get_category($uid) {
        $query = $this->db->query("SELECT * FROM " . DB_TABLEPRE . "user_category WHERE uid=$uid");
        $categorylist = array();
        while ($category = $this->db->fetch_array($query)) {
            $category['categoryname'] = $this->base->category[$category['cid']]['name'];
            $categorylist[] = $category;
        }
        return $categorylist;
    }

    function remove_category($cid, $uid) {
        $this->db->query("DELETE FROM " . DB_TABLEPRE . "user_category WHERE cid=$cid AND uid=$uid");
    }

    function update_elect($uid, $elect) {
        $elect && $elect = $this->base->time;
        $this->db->query("UPDATE `" . DB_TABLEPRE . "user` SET `elect`=$elect WHERE `uid`=$uid");
    }

    function update_expert($uids, $type) {
        $this->db->query("UPDATE " . DB_TABLEPRE . "user SET expert=$type WHERE uid IN (" . implode(",", $uids) . ")");
    }

    function get_login_auth($uid, $type = 'qq') {
        return $this->db->fetch_first("SELECT * FROM " . DB_TABLEPRE . "login_auth WHERE type='$type' AND uid=$uid");
    }

    function remove_login_auth($uid, $type = 'qq') {
        $this->db->query("DELETE FROM " . DB_TABLEPRE . "login_auth WHERE type='$type' AND uid=$uid");
    }

    /* ȡעûĿ */

    function rownum_alluser() {
        return array($this->db->fetch_total('user', ' 1=1'));
    }

    /* ȡûĿ */

    function rownum_onlineuser() {
        $end = $this->base->time - intval($this->base->setting['sum_onlineuser_time']) * 60;
        $query = $this->db->query("SELECT *  FROM " . DB_TABLEPRE . "session WHERE time>$end GROUP BY ip");
        $ret = $this->db->num_rows($query);
        return $ret;
    }

    function list_online_user($start = 0, $limit = 50) {
        $onlinelist = array();
        $end = $this->base->time - intval($this->base->setting['sum_onlineuser_time']) * 60;
        $query = $this->db->query("SELECT s.ip,s.uid,u.username,s.time FROM " . DB_TABLEPRE . "session AS s LEFT  JOIN " . DB_TABLEPRE . "user AS u ON u.uid=s.uid WHERE s.time>$end GROUP BY s.ip ORDER BY s.time DESC LIMIT $start,$limit");
        while ($online = $this->db->fetch_array($query)) {
            $online['online_time'] = tdate($online['time']);
            $onlinelist[] = $online;
        }
        return $onlinelist;
    }

    /* עб */

    function get_follower($uid, $start = 0, $limit = 20) {
        $followerlist = array();
        $query = $this->db->query("SELECT * FROM " . DB_TABLEPRE . "user_attention WHERE uid=$uid ORDER BY time DESC LIMIT $start,$limit");
        while ($follower = $this->db->fetch_array($query)) {
            $follower['avatar'] = get_avatar_dir($follower['followerid']);
            $followerlist[] = $follower;
        }
        return $followerlist;
    }

    /* ѹעб */

    function get_attention($followerid, $start = 0, $limit = 20) {
        $attentionlist = array();
        $query = $this->db->query("SELECT u.uid,u.username FROM " . DB_TABLEPRE . "user_attention AS ua," . DB_TABLEPRE . "user AS u WHERE ua.uid=u.uid AND ua.followerid=$followerid ORDER BY ua.time DESC LIMIT $start,$limit");
        while ($attention = $this->db->fetch_array($query)) {
            $attention['avatar'] = get_avatar_dir($attention['uid']);
            $attentionlist[] = $attention;
        }
        return $attentionlist;
    }

    /* ѹעб */

    function get_attention_question($followerid, $start = 0, $limit = 20) {
        $questionlist = array();
        $query = $this->db->query("SELECT q.cid,q.title,q.id,qa.time  FROM " . DB_TABLEPRE . "question AS q," . DB_TABLEPRE . "question_attention as qa WHERE q.id=qa.qid AND qa.followerid=$followerid ORDER BY qa.time DESC LIMIT $start,$limit");
        while ($question = $this->db->fetch_array($query)) {
            $question['attention_time'] = tdate($question['time']);
            $question['category_name'] = $this->base->category[$question['cid']]['name'];
            $questionlist[] = $question;
        }
        return $questionlist;
    }

    function rownum_attention_question($followerid) {
        return $this->db->result_first("SELECT count(*)  FROM " . DB_TABLEPRE . "question AS q," . DB_TABLEPRE . "question_attention as qa WHERE q.id=qa.qid AND qa.followerid=$followerid");
    }

    /* Ƿע */

    function is_followed($uid, $followerid) {
        return $this->db->result_first("SELECT COUNT(*) FROM " . DB_TABLEPRE . "user_attention WHERE uid=$uid AND followerid=$followerid");
    }

    /* ע */

    function follow($sourceid, $followerid, $follower, $type = 'question') {
        $sourcefield = 'qid';
        ($type != 'question') && $sourcefield = 'uid';
        $this->db->query("INSERT INTO " . DB_TABLEPRE . $type . "_attention($sourcefield,followerid,follower,time) VALUES ($sourceid,$followerid,'$follower',{$this->base->time})");
        if ($type == 'question') {
            $this->db->query("UPDATE " . DB_TABLEPRE . "question SET attentions=attentions+1 WHERE `id`=$sourceid");
        } else if ($type == 'user') {
            $this->db->query("UPDATE " . DB_TABLEPRE . "user SET followers=followers+1 WHERE `uid`=$sourceid");
            $this->db->query("UPDATE " . DB_TABLEPRE . "user SET attentions=attentions+1 WHERE `uid`=$followerid");
        }
    }

    /* ȡע */

    function unfollow($sourceid, $followerid, $type = 'question') {
        $sourcefield = 'qid';
        ($type != 'question') && $sourcefield = 'uid';
        $this->db->query("DELETE FROM " . DB_TABLEPRE . $type . "_attention WHERE $sourcefield=$sourceid AND followerid=$followerid");
        if ($type == 'question') {
            $this->db->query("UPDATE " . DB_TABLEPRE . "question SET attentions=attentions-1 WHERE `id`=$sourceid");
        } else if ($type == 'user') {
            $this->db->query("UPDATE " . DB_TABLEPRE . "user SET followers=followers-1 WHERE `uid`=$sourceid");
            $this->db->query("UPDATE " . DB_TABLEPRE . "user SET attentions=attentions-1 WHERE `uid`=$followerid");
        }
    }

}

?>