<?php
// +-----------------------------------------------------------------------------------
// | Software: [ThinkPHP framework]
// | Version: V4.0
// | Site: http://www.czreg.com
// +-----------------------------------------------------------------------------------
// | Author: 飘叶 <cds425@163.com>
// | Copyright (c) 2012-2014, http://www.czreg.com All Rights Reserved.
// | time:2014.11.08
// | explain:用户版块管理类
// +-----------------------------------------------------------------------------------

namespace Admin\Controller;
use Think\Controller;
class UserController extends AdminController {
    public function _initialize () {
        parent::_initialize();
        $this->leftmain=6;
    }

    //用户管理
    public function index(){
        $this->topmain=1;
    	$User=M('User');
        if(I('get.action')=="del"){
            $delUser=$User->where(array('id'=>I('get.id')))->delete();
            if($delUser!==false){
                $this->success('删除成功',U('index',array('p'=>I('get.p'))));
            }else{
                $this->error('删除失败');
            }
            exit;
        }
        $p=empty($_GET['p'])?'1':$_GET['p'];
        $this->list = $User->field('id,username,nickname,level,jf,created,updataed,qqopenid')->order('id desc')->page($p.',10')->select();
        $count=$User->field('id')->count();
        $Page = new \Think\Page($count,10);// 实例化分页类 传入总记录数和每页显示的记录数
        $Page->rollPage=5;//页码每页显示数量
        $Page->lastSuffix = false;//尾页是否显示总页数
        $Page->setConfig('header','条记录');
        $Page->setConfig('prev','上一页');
        $Page->setConfig('next','下一页');
        $Page->setConfig('first','首页');
        $Page->setConfig('last','尾页');
        $Page->setConfig('theme','<div class="digg">%FIRST% %UP_PAGE% %LINK_PAGE% %DOWN_PAGE% %END% </div>');
        $show       = $Page->show();// 分页显示输出
        $this->assign('page',$show);// 赋值分页输出
        $this->p=$p;
        $this->display();
    }

    //用户修改
   public function edit(){
        $this->topmain=2;
        $id=I('get.id');
        $p=I('get.p');
        if(IS_POST){
            $data=I('post.');
            if(I('post.userpass')!=''){
            	$data['userpass'] = md5(I('post.userpass'));
            }else{
                unset($data['userpass']); 
            }
            $saveUser=M('User')->where('id='.$id)->save($data);
            if($saveUser!==false){
                $this->success('修改成功',U('index',array('p'=>$p)));
            }else{
                $this->error('修改失败');
            }
        }else{
            $this->user = M('User')->where('id='.$id)->find();
            $this->p= $p;
           $this->show();
        }
    }

    //发送邮件
    public function sendmessage(){
    	$this->topmain=3;
    	if(IS_POST){
    		//发送邮件
    		$auth=session(user_auth);
    		$admininfo=M('Admin')->where(array('id'=>$auth['id']))->find();
    		if(I('post.all')==9){
    			//发送个人邮件
    			$user = M('User')->field('id')->where(array('username'=>I('post.user')))->find();
    			if($user['id']!=''){
    				$sendinfo = M('Message')->add(array('userid'=>$user['id'],'send'=>$admininfo['nickname'],'title'=>I('post.title'),'content'=>I('post.content','',false),'timeline'=>time()));
    			}else{
    				$this->error('收件人不存在');
    			}
    		}else{
    			//群发邮件
    			$user = M('User')->field('id')->select();
    			foreach ($user as $value) {
    				$sendinfo = M('Message')->add(array('userid'=>$value['id'],'send'=>$admininfo['nickname'],'title'=>I('post.title'),'content'=>I('post.content','',false),'timeline'=>time()));
    			}
    		}
    		if($sendinfo!==false){
                $this->success('发送成功',U('sendmessage'));
            }else{
                $this->error('发送失败');
            }
    	}else{
    		if(I('get.action')=='clear'){
    			//清理3个月前的数据
    			$deltime = strtotime('-3 month',time());
    			$delinfo = M('Message')->where('timeline<'.$deltime)->delete();
    			if($delinfo!==false){
	                $this->success('清理成功',U('sendmessage'));
		        }else{
		             $this->error('清理失败');
		        }
				exit;
    		}else{
    			//显示邮件列表
    			$prefix=C('DB_PREFIX');
    			$p=empty($_GET['p'])?'1':$_GET['p'];
		        $this->list = M('Message')->field('title,send,timeline,isread,username')->join('__USER__ ON __USER__.id = __MESSAGE__.userid','LEFT')->order($prefix.'message.id desc')->page($p.',10')->select();
		        $count=M('Message')->field('id')->count();
		        $Page = new \Think\Page($count,10);// 实例化分页类 传入总记录数和每页显示的记录数
		        $Page->rollPage=5;//页码每页显示数量
		        $Page->lastSuffix = false;//尾页是否显示总页数
		        $Page->setConfig('header','条记录');
		        $Page->setConfig('prev','上一页');
		        $Page->setConfig('next','下一页');
		        $Page->setConfig('first','首页');
		        $Page->setConfig('last','尾页');
		        $Page->setConfig('theme','<div class="digg">%FIRST% %UP_PAGE% %LINK_PAGE% %DOWN_PAGE% %END% </div>');
		        $show       = $Page->show();// 分页显示输出
		        $this->assign('page',$show);// 赋值分页输出
		        $this->p=$p;
    			$this->show();
    		}
    	}
    }
}