<?php
// +-----------------------------------------------------------------------------------
// | Software: [ThinkPHP framework]
// | Version: 2014.9
// | Site: http://www.czreg.com
// +-----------------------------------------------------------------------------------
// | Author: 飘叶 <cds425@163.com>
// | Copyright (c) 2012-2014, http://www.czreg.com All Rights Reserved.
// | time:2014.10.25
// | explain:网站基础配置
// +-----------------------------------------------------------------------------------
return array(
	//'配置项'=>'配置值'
	//'SHOW_PAGE_TRACE' =>true,
	'APP_AUTOLOAD_LAYER'    =>  'Controller,Model', // 自动加载的应用类库层 关闭APP_USE_NAMESPACE后有效

    //加载额外的配置文件
    'LOAD_EXT_CONFIG' => 'info,db', 

    //路由
    'URL_ROUTER_ON'   => true, 
    'URL_ROUTE_RULES'=>array(
        'newstype/:type\d'        => 'News/index',
        'news/:id\d'               => 'News/show',
        'protype/:type\d'         => 'Pro/index',
        'pro/:id\d'                => 'Pro/show',
        'softtype/:type\d'        => 'soft/index',
        'soft/:id\d'               => 'soft/show',
        'about/:id\d'              => 'about/index',
    ),
    
	/* Cookie设置 */
    'COOKIE_EXPIRE'         =>  0,    // Cookie有效期
    'COOKIE_DOMAIN'         =>  '',      // Cookie有效域名
    'COOKIE_PATH'           =>  '/',     // Cookie路径
    'COOKIE_PREFIX'         =>  'e_qm_',      // Cookie前缀 避免冲突
    'COOKIE_HTTPONLY'       =>  '',      // Cookie httponly设置

    /* 默认设定 */
    'DEFAULT_M_LAYER'       =>  'Model', // 默认的模型层名称
    'DEFAULT_C_LAYER'       =>  'Controller', // 默认的控制器层名称
    'DEFAULT_V_LAYER'       =>  'View', // 默认的视图层名称
    'DEFAULT_LANG'          =>  'zh-cn', // 默认语言
    'DEFAULT_THEME'         =>  '',	// 默认模板主题名称
    'MODULE_ALLOW_LIST'    =>    array('Home','Admin','Install'),
    'DEFAULT_MODULE'        =>  'Home',  // 默认模块
    'DEFAULT_CONTROLLER'    =>  'Index', // 默认控制器名称
    'DEFAULT_ACTION'        =>  'index', // 默认操作名称
    'DEFAULT_CHARSET'       =>  'utf-8', // 默认输出编码
    'DEFAULT_TIMEZONE'      =>  'PRC',	// 默认时区
    'DEFAULT_AJAX_RETURN'   =>  'JSON',  // 默认AJAX 数据返回格式,可选JSON XML ...
    'DEFAULT_JSONP_HANDLER' =>  'jsonpReturn', // 默认JSONP格式返回的处理方法
    'DEFAULT_FILTER'        =>  'htmlspecialchars', // 默认参数过滤方法 用于I函数...

    // 布局设置
    'TMPL_ENGINE_TYPE'      =>  'Think',     // 默认模板引擎 以下设置仅对使用Think模板引擎有效
    'TMPL_CACHFILE_SUFFIX'  =>  '.php',      // 默认模板缓存后缀
    'TMPL_DENY_FUNC_LIST'   =>  'echo,exit',    // 模板引擎禁用函数
    'TMPL_DENY_PHP'         =>  false, // 默认模板引擎是否禁用PHP原生代码
    'TMPL_L_DELIM'          =>  '{',            // 模板引擎普通标签开始标记
    'TMPL_R_DELIM'          =>  '}',            // 模板引擎普通标签结束标记


     /* URL设置 */
    'URL_CASE_INSENSITIVE'  =>  true,   // 默认false 表示URL区分大小写 true则表示不区分大小写
    'URL_MODEL'             =>  2,       // URL访问模式,可选参数0、1、2、3,代表以下四种模式：
    // 0 (普通模式); 1 (PATHINFO 模式); 2 (REWRITE  模式); 3 (兼容模式)  默认为PATHINFO 模式
    'URL_PATHINFO_DEPR'     =>  '/',	// PATHINFO模式下，各参数之间的分割符号
    'URL_HTML_SUFFIX'       =>  'html',  // URL伪静态后缀设置

    'TMPL_ACTION_ERROR'     =>  'Public/dispatch_jump', // 默认错误跳转对应的模板文件
	'TMPL_ACTION_SUCCESS'   =>  'Public/dispatch_jump', // 默认成功跳转对应的模板文件


    

);