<?php

// +-----------------------------------------------------------------------------------
// | Software: [ThinkPHP framework]
// | Version: V4.0
// | Site: http://www.czreg.com
// +-----------------------------------------------------------------------------------
// | Author: 飘叶 <cds425@163.com>
// | Copyright (c) 2012-2015, http://www.czreg.com All Rights Reserved.
// | time:2015.1.12
// | explain:新闻类
// +-----------------------------------------------------------------------------------

namespace Home\Controller;
use Think\Controller;
class NewsController extends PublicController {

    public function _initialize () {
        parent::_initialize();
        //+--------------------+
        //| 广告输出           |
        //+--------------------+
        $this->ad = M('Ad')->order('id desc')->where(array('title'=>2))->order('position asc')->find();
        $this->mainstyle = 2;
    }



    public function index(){
        $type = I('get.type');
        //+--------------------+
        //| 最新新闻输出	   |
        //+--------------------+
        $news=M('News');
        $prefix=C('DB_PREFIX');
        $newscls = M('News_cls')->order('id desc')->select();
        $this->newscls = $newscls;//新闻分类
        $p=empty($_GET['p'])?'1':$_GET['p'];
        if(!empty($type)){
            //分类显示
            $list = $news->field('title,timeline,name,img,lable,type,'.$prefix.'news.id,'.$prefix.'news_cls.id as clsid')->join('__NEWS_CLS__ ON __NEWS_CLS__.id = __NEWS__.type','LEFT')->where(array('type'=>$type))->order($prefix.'news.id desc')->page($p.',8')->select();
            $this->list = $list;
            $count=$news->field('id')->where(array('type'=>$type))->count();
            foreach ($newscls as $v) {
                if($v['id']==$type){
                    $clsname = $v['name'];
                }
            }
            $this->clsname = $clsname;
        }elseif(I('get.keyword')!=''){
            //搜索
            $list = $news->field('title,timeline,name,img,lable,type,'.$prefix.'news.id,'.$prefix.'news_cls.id as clsid')->join('__NEWS_CLS__ ON __NEWS_CLS__.id = __NEWS__.type','LEFT')->where(array('title'=>array('like','%'.I('get.keyword').'%')))->order($prefix.'news.id desc')->page($p.',8')->select();
                $this->list = $list;
                $count=$news->field('id')->where(array('title'=>array('like','%'.I('get.keyword').'%')))->count();
                $this->clsname = '搜索结果';
        }else{
            $list = $news->field('title,timeline,name,img,lable,type,'.$prefix.'news.id,'.$prefix.'news_cls.id as clsid')->join('__NEWS_CLS__ ON __NEWS_CLS__.id = __NEWS__.type','LEFT')->order($prefix.'news.id desc')->page($p.',8')->select();
            $this->list = $list;
        $count=$news->field('id')->count();
        }

        $Page = new \Think\Page($count,C('NEWS'));// 实例化分页类 传入总记录数和每页显示的记录数
        $show       = $Page->show();// 分页显示输出
        $this->assign('page',$show);// 赋值分页输出
        $this->p=$p;
        $this->display();
    }

    //新闻查看页
    public function show(){
        $id = I('get.id');
        $newscls = M('News_cls')->order('id desc')->select();
        $this->newscls = $newscls;//新闻分类
        $news = M('News')->where('id='.$id)->find();
        $this->news = $news;
        M('News')->where('id='.$id)->setInc('readnum',1);
        //上一篇
        $front=M('News')->field('title,id')->where("id<".$id)->order('id desc')->limit('1')->find();
        $f=!$front?'没有了':'<A href="'.U('/news/'.$front['id']).'">'.$front['title'].'</A>';
        $this->assign('front',$f);
        //下一篇
        $after=M('News')->field('title,id')->where("id>".$id)->order('id desc')->limit('1')->find();
        $f=!$after?'没有了':'<A href="'.U('/news/'.$after['id']).'">'.$after['title'].'</A>';
        $this->assign('after',$f);
        $this->display();
    }

    //新闻评论
    public function renews(){
        $data   = I('post.');
        if(check_user_login()===false){
            $this->error('请先登陆');
            exit;
        }
        $savere = M('renews')->add($data);
        if($savere !== false){
            $this->success('评论成功');
        }else{
            $this->error('评论失败');
        }
    }
}