<?php

// +-----------------------------------------------------------------------------------

// | Software: [ThinkPHP framework]

// | Version: V4.0

// | Site: http://www.czreg.com

// +-----------------------------------------------------------------------------------

// | Author: 飘叶 <cds425@163.com>

// | Copyright (c) 2012-2015, http://www.czreg.com All Rights Reserved.

// | time:2015.1.12

// | explain:软件类

// +-----------------------------------------------------------------------------------

namespace Home\Controller;

use Think\Controller;

class SoftController extends PublicController {

    public function _initialize () {

        parent::_initialize();

        //+--------------------+

        //| 广告输出           |

        //+--------------------+

        $this->ad = M('Ad')->order('id desc')->where(array('title'=>4))->find();

        $this->mainstyle = 4;

    }



    public function index(){

        $type = I('get.type');

        //+--------------------+

        //| 最新软件输出	   |

        //+--------------------+

        $soft=M('soft');

        $prefix=C('DB_PREFIX');



        $softcls = M('soft_cls')->order('id desc')->select();

        $this->softcls = $softcls;//软件分类



        $p=empty($_GET['p'])?'1':$_GET['p'];

        if(!empty($type)){
            $list = $soft->field('title,timeline,readnum,downnum,name,img,type,'.$prefix.'soft.id,'.$prefix.'soft_cls.id as clsid')->join('__SOFT_CLS__ ON __SOFT_CLS__.id = __SOFT__.type','LEFT')->where(array('type'=>$type))->order($prefix.'soft.id desc')->page($p.',5')->select();
            $this->list = $list;
            foreach ($softcls as $v) {
                if($v['id']==$type){
                    $clsname = $v['name'];
                }
            }
            $this->clsname = $clsname;
            $count=$soft->field('id')->where(array('type'=>$type))->count();
        }elseif(I('get.keyword')!=''){
            //搜索
            $list = $soft->field('title,timeline,readnum,downnum,name,img,type,'.$prefix.'soft.id,'.$prefix.'soft_cls.id as clsid')->join('__SOFT_CLS__ ON __SOFT_CLS__.id = __SOFT__.type','LEFT')->where(array('title'=>array('like','%'.I('get.keyword').'%')))->order($prefix.'soft.id desc')->page($p.',5')->select();
                $this->list = $list;
                $count=$soft->field('id')->where(array('title'=>array('like','%'.I('get.keyword').'%')))->count();
                $this->clsname = '搜索结果';
        }else{
            $list = $soft->field('title,timeline,readnum,name,img,type,'.$prefix.'soft.id,'.$prefix.'soft_cls.id as clsid')->join('__SOFT_CLS__ ON __SOFT_CLS__.id = __SOFT__.type','LEFT')->order($prefix.'soft.id desc')->page($p.',5')->select();
            $this->list = $list;
        $count=$soft->field('id')->count();
        }

        $Page = new \Think\Page($count,5);// 实例化分页类 传入总记录数和每页显示的记录数

        $show       = $Page->show();// 分页显示输出

        $this->assign('page',$show);// 赋值分页输出

        $this->p=$p;

        $this->display();

    }



    //软件查看页

    public function show(){

        $id = I('get.id');

        $softcls = M('soft_cls')->order('id desc')->select();

        $this->softcls = $softcls;//软件分类

        $soft = M('soft')->where('id='.$id)->find();

        $this->soft = $soft;

        M('soft')->where('id='.$id)->setInc('readnum',1);

        //上一篇

        $front=M('soft')->field('title,id')->where("id<".$id)->order('id desc')->limit('1')->find();

        $f=!$front?'没有了':'<A href="'.U('show',array('id'=>$front['id'])).'">'.$front['title'].'</A>';

        $this->assign('front',$f);

        //下一篇

        $after=M('soft')->field('title,id')->where("id>".$id)->order('id desc')->limit('1')->find();

        $f=!$after?'没有了':'<A href="'.U('show',array('id'=>$after['id'])).'">'.$after['title'].'</A>';

        $this->assign('after',$f);

        $this->display();

    }



    //软件评论

    public function resoft(){

        $data   = I('post.');

        if(check_user_login()===false){

            $this->error('请先登陆');

            exit;

        }

        $savere = M('resoft')->add($data);

        if($savere !== false){

            $this->success('评论成功');

        }else{

            $this->error('评论失败');

        }



    }

}