<?php
// +-----------------------------------------------------------------------------------
// | Software: [ThinkPHP framework]
// | Version: 2014.9
// | Site: http://www.czreg.com
// +-----------------------------------------------------------------------------------
// | Author: 飘叶 <cds425@163.com>
// | Copyright (c) 2012-2014, http://www.czreg.com All Rights Reserved.
// +-----------------------------------------------------------------------------------


namespace Home\Controller;
use Think\Controller;
class UserController extends PublicController {

	public function _initialize(){
		parent::_initialize();
		check_login();
    }

    function _empty(){
		header("HTTP/1.0 404 Not Found");
		$this->display('Public:404');
	}

    public function index(){
    	//用户中心首页
        $this->display();
    }

    //会员签到
    public function sign(){
    	$num=rand(1,2);
    	$listjf=M('Jflog')->where(array('date'=>date('Y-m-d'),'type'=>1,'userid'=>session('userid')))->find();
    	if(empty($listjf)){
	    	$arrdata = array(
	    		'userid'	=> session('userid'),
	    		'jf' 		=> $num,
	    		'date'		=> date('Y-m-d'),
	    		'cls'		=> 1,
	    	);
	    	M('Jflog')->add($arrdata);
	        M('User')->where(array('id'=>session('userid')))->setInc('jf',$num);
	        $data=$num;
	        $this->ajaxReturn($data);
	    }else{
	        $data=0;
	    	 $this->ajaxReturn($data);
	    }
    }

    //解除绑定
    public function unbind($type){
    	$con['userid']=session('userid');
    	switch ($type) {
    		case 'qq':
    			$data['qqopenid']='';
    			break;
    		case 'wx':
    			$data['wxopenid']='';
    			break;
    		
    		default:
    			$this->error("解绑错误");
    			break;
    	}
    	$list=M('User')->where(array('id'=>$con['userid']))->save($data);
    	if($list!==false){
    		$this->success('解绑成功');
    	}else{
    		$this->error("解绑错误");
    	}
    }

    //上传头像
    public function pics(){
    	if(IS_POST){
           $con['userid']=session('userid');
           $config = $this->configset;//网站配置输出 
	        if($config['upimg']==1){
	            //使用七牛存储图片
	            $setting=C('UPLOAD_SITEIMG_QINIU');
	            $Upload = new \Think\Upload($setting);
	            $info = $Upload->uploadOne($_FILES['upfile']);
	        }else{
	            //本地图片处理
	            $upload = new \Think\Upload();// 实例化上传类
	            $upload->maxSize   =  524288 ;// 设置附件上传大小    
	            $upload->exts      =     array('jpg', 'gif', 'png', 'jpeg');// 设置附件上传类型    
	            $upload->savePath  =     ''; // 设置附件上传目录
	            $info   =   $upload->uploadOne($_FILES['upfile']);
	        } 
            if(!$info) {
            // 上传错误提示错误信息        
                $this->error($upload->getError());    
            }else{
            // 上传成功
            	if($config['upimg']==1){
	                $data['img']   = $config['imgurl'].$info['name'];
	            }else{
	                $data['img']   ="/Uploads/".$info['savepath'].$info['savename'];
	            }
               $list=M('User')->where(array('id'=>$con['userid']))->save($data);
               if($list!==false){
                    $this->success('更新头像成功',U('pics'));
               }else{
                    $this->error('更新失败');
               }
            } 
    	}else{
    		$this->show();
    	}
    }
    //设头像为空白
    public function pics_default(){
        $con['id']=session('userid');
        $list=M('User')->where($con)->save(array('img'=>''));
       if($list!==false){
            $this->success('已成功设为默认头像',U('pics'));
       }else{
            $this->error('设置默认头像失败');
       }
    }

    //修改资料
    public function edit(){
        if(IS_POST){
            $con['id']=session('userid');
            $data = array(
                'nickname'  => I('post.nickname'), 
                'sex' 		=> I('post.sex'), 
                'birthday'  => I('post.birthday'),
                'realname'  => I('post.realname'),
                'phone'		=> i('post.phone'),
                'address'	=> I('post.address'),
                );
            //补填用户名
            if( I('post.name')!=''){
                $findlist = M('User')->where($con)->find();
                if($findlist["username"]!=''){
                    $this->error('该用户名已经填写了，系统不允许再次填写！');
                }else{
                   $list = M('User')->where(array('username'=>I('post.name')))->find();
                   if(empty($list)){
                        $data['username']=I('post.name');
                   }else{
                        $this->error('该用户名已经存在！');
                   }
                }
            }
            if(I('post.password')!=''){
                $data['userpass']=md5(I('post.password'));
            }
           $savelist = M('User')->where($con)->save($data);
           if($savelist!==false){
                $this->success('资料更新成功',U('edit'));
           }else{
                $this->error('资料更新失败');
           }
        }else{
            $this->show();
        }
    }

    //积分日志程序
    public function log(){
        $con['userid']=session('userid');
        $p=empty($_GET['p'])?'1':$_GET['p'];
        $Jflog=M('Jflog');
        $list=$Jflog->where($con)->page($p.',10')->order('id desc')->select();
        $this->list=$list;
        $count      = $Jflog->where($con)->count();// 查询满足要求的总记录数
        $Page       = new \Think\Page($count,10);// 实例化分页类 传入总记录数和每页显示的记录数
        $show       = $Page->show();// 分页显示输出
        $this->assign('page',$show);// 赋值分页输出
        $this->jftype=C('JFTYPE');//积分类型输出
        $this->show();
    } 

    //用户邮件
    public function message(){
        $ms       = M('Message');
        $p=empty($_GET['p'])?'1':$_GET['p'];
        $this->list = $ms->field('id,title,timeline,isread')->where(array('userid'=>session('userid')))->page($p.',10')->order('id desc')->select();
        $count      = $ms->where(array('userid'=>session('userid')))->count();// 查询满足要求的总记录数
        $Page       = new \Think\Page($count,10);// 实例化分页类 传入总记录数和每页显示的记录数
        $show       = $Page->show();// 分页显示输出
        $this->assign('page',$show);// 赋值分页输出
        $this->show();  
    }

    //查看邮件
    public function showmessage(){
        $id = I('id');
        if(I('do')=='del'){
            $del = M('Message')->where(array('id'=>$id,'userid'=>session('userid')))->delete();
            if($del!==false){
                $this->success('删除成功',U('message'));
            }else{
                $this->error('删除失败');
            }
            exit;
        }
        $list = M('Message')->where(array('id'=>$id,'userid'=>session('userid')))->find();
        if(empty($list)){
            $this->show("邮件不存在或者已删除");
        }else{
            $this->list = $list;
            M('Message')->where(array('id'=>$id,'userid'=>session('userid')))->save(array('isread'=>1));
            $this->show();
        }
        
    }
    //维修件
    public function wx(){
    	$ms       = M('wx');
    	$p=empty($_GET['p'])?'1':$_GET['p'];
        $this->list = $ms->field('id,wxno,wxparts,createtime,status,firstprice,price')->where(array('userid'=>session('userid')))->page($p.',10')->order('id desc')->select();
        $count      = $ms->where(array('userid'=>session('userid')))->count();// 查询满足要求的总记录数
        $Page       = new \Think\Page($count,10);// 实例化分页类 传入总记录数和每页显示的记录数
        $show       = $Page->show();// 分页显示输出
        $this->wxtype=C('WXTYPE');//维修类型输出
    	$this->show();
    }

    //查看维修内容
    public function showwx(){
    	$id = I('id');
    	$list = M('wx')->where(array('id'=>$id,'userid'=>session('userid')))->find();
        if(I('do')=='del'){
        	if($list['status']!=0){
        		$this->error('取消失败');
        		exit;
        	}
            $del = M('wx')->where(array('id'=>$id,'userid'=>session('userid')))->save(array('status'=>9));
            if($del!==false){
            	M('wxlog')->add(array('wxid'=>$id,'status'=>9,'content'=>'用户取消','timeline'=>time()));
                $this->success('取消成功',U('wx'));
            }else{
                $this->error('取消失败');
            }
            exit;
        }
        if(empty($list)){
            $this->show("维修件不存在或者已删除");
        }else{
            $this->list = $list;
            $this->log  = M('wxlog')->where(array('wxid'=>$id))->order('id asc')->select();
            $this->wxtype=C('WXTYPE');//维修类型输出
            $this->show();
        }
    }
    //修改维修件
    public function wx_edit(){
        $id = I('get.id');
        $list = M('wx')->where(array('id'=>$id,'userid'=>session('userid')))->find();
        $log  = M('wxlog')->where(array('wxid'=>$id,'status'=>0))->order('id desc')->find();
        if($list['status']!=0){
            $this->error('当前状态不允许修改');
            exit;
        }
        if(IS_POST){
            $data = array(
                'wxparts'    => I('wxj'),
                'createtime' => time(),
            );
            $saveparts  = M('wx')->where(array('id'=>$id,'userid'=>session('userid')))->save($data);
            if($saveparts!==false){
                $savelog    = M('wxlog')->where(array('wxid'=>$id,'status'=>0))->save(array('content'=>I('content','',false),'timeline'=>time()));
                $this->success('修改成功',U('wx'));
            }else{
                $this->error('修改失败');
            }
        }else{
            $this->list = $list;
            $this->log  = $log;
            $this->wxtype=C('WXTYPE');//维修类型输出
            $this->show();
        }
    }

    //添加维修件
    public function wx_add(){
    	if(IS_POST){
            $wxauto = get_webconfig('auto_wx');//获取是否自动编号
    		$userid=session('userid');
            $userinfo=$this->user;
            if($userinfo['realname']=='' || $userinfo['phone']=='' || $userinfo['address']==''){
            	$this->error('请先补全用户资料',U('edit'));
            }
            if(I('wxj')==''){
            	$this->error('请填写维修件');
            }
    		$data = array(
    			'userid' 	 => session('userid'),
    			'wxparts'	 => I('wxj'),
    			'createtime' => time(),
    		);
            if($wxauto==1){
                $data['wxno'] = get_webconfig('wx_autono').date('ymdHis').rand(10,99);
            }
    		$addnum = M('wx')->add($data);
    		if($addnum!==false){
    			M('wxlog')->add(array('wxid'=>$addnum,'status'=>0,'content'=>I('content','',false),'timeline'=>time()));
    			$this->success('添加成功',U('wx'));
    		}else{
    			$this->error('添加失败');
    		}
    		
    	}else{
    		//
    		$this->show();
    	}
    }

}