<?php
function C($name = null, $value = null, $default = null)
{
	static $_config = array();

	if (empty($name)) {
		return $_config;
	}

	if (is_string($name)) {
		if (!strpos($name, '.')) {
			$name = strtoupper($name);
			if (is_null($value))
				return isset($_config[$name]) ? $_config[$name] : $default;
			$_config[$name] = $value;
			return null;
		}

		$name = explode('.', $name);
		$name[0] = strtoupper($name[0]);
		if (is_null($value))
			return isset($_config[$name[0]][$name[1]]) ? $_config[$name[0]][$name[1]] : $default;
		$_config[$name[0]][$name[1]] = $value;
		return null;
	}

	if (is_array($name)) {
		$_config = array_merge($_config, array_change_key_case($name, CASE_UPPER));
		return null;
	}
	return null;
}


function load_config($file, $parse = CONF_PARSE)
{
	$ext = pathinfo($file, PATHINFO_EXTENSION);
	switch ($ext) {
		case 'php':
			return include $file;
		case 'ini':
			return parse_ini_file($file);
		case 'yaml':
			return yaml_parse_file($file);
		case 'xml':
			return (array)simplexml_load_file($file);
		case 'json':
			return json_decode(file_get_contents($file), true);
		default:
			if (function_exists($parse)) {
				return $parse($file);
			} else {
				E(L('_NOT_SUPPORT_') . ':' . $ext);
			}
	}
}


if (!function_exists('yaml_parse_file')) {
	function yaml_parse_file($file)
	{
		vendor('spyc.Spyc');
		return Spyc::YAMLLoad($file);
	}
}


function E($msg, $code = 0)
{
	throw new Think\Exception($msg, $code);
}


function G($start, $end = '', $dec = 4)
{
	static $_info = array();
	static $_mem = array();
	if (is_float($end)) {
		$_info[$start] = $end;
	} elseif (!empty($end)) {
		if (!isset($_info[$end])) $_info[$end] = microtime(TRUE);
		if (MEMORY_LIMIT_ON && $dec == 'm') {
			if (!isset($_mem[$end])) $_mem[$end] = memory_get_usage();
			return number_format(($_mem[$end] - $_mem[$start]) / 1024);
		} else {
			return number_format(($_info[$end] - $_info[$start]), $dec);
		}

	} else {
		$_info[$start] = microtime(TRUE);
		if (MEMORY_LIMIT_ON) $_mem[$start] = memory_get_usage();
	}
	return null;
}


function L($name = null, $value = null)
{
	static $_lang = array();

	if (empty($name))
		return $_lang;


	if (is_string($name)) {
		$name = strtoupper($name);
		if (is_null($value)) {
			return isset($_lang[$name]) ? $_lang[$name] : $name;
		} elseif (is_array($value)) {

			$replace = array_keys($value);
			foreach ($replace as &$v) {
				$v = '{$' . $v . '}';
			}
			return str_replace($replace, $value, isset($_lang[$name]) ? $_lang[$name] : $name);
		}
		$_lang[$name] = $value;
		return null;
	}

	if (is_array($name))
		$_lang = array_merge($_lang, array_change_key_case($name, CASE_UPPER));
	return null;
}

function selectmb()
{
	if (!$mb = $_COOKIE['klmz_mb']) {
		if (isMobile()) {
			$mb = 'wap';
		} else {
			$mb = 'web';
		}
	}
	return $mb;
}

function trace($value = '[think]', $label = '', $level = 'DEBUG', $record = false)
{
	return Think\Think::trace($value, $label, $level, $record);
}


function compile($filename)
{
	$content = php_strip_whitespace($filename);
	$content = trim(substr($content, 5));

	$content = preg_replace('/\/\/\[RUNTIME\](.*?)\/\/\[\/RUNTIME\]/s', '', $content);
	if (0 === strpos($content, 'namespace')) {
		$content = preg_replace('/namespace\s(.*?);/', 'namespace \1{', $content, 1);
	} else {
		$content = 'namespace {' . $content;
	}
	if ('?>' == substr($content, -2))
		$content = substr($content, 0, -2);
	return $content . '}';
}


function T($template = '', $layer = '')
{


	if (false === strpos($template, '://')) {
		$template = 'http://' . str_replace(':', '/', $template);
	}
	$info = parse_url($template);
	$file = $info['host'] . (isset($info['path']) ? $info['path'] : '');
	$module = isset($info['user']) ? $info['user'] . '/' : MODULE_NAME . '/';
	$extend = $info['scheme'];
	$layer = $layer ? $layer : C('DEFAULT_V_LAYER');


	$auto = C('AUTOLOAD_NAMESPACE');
	if ($auto && isset($auto[$extend])) {
		$baseUrl = $auto[$extend] . $module . $layer . '/';
	} elseif (C('VIEW_PATH')) {

		$baseUrl = C('VIEW_PATH');
	} elseif (defined('TMPL_PATH')) {

		$baseUrl = TMPL_PATH . $module;
	} else {
		$baseUrl = APP_PATH . $module . $layer . '/';
	}


	$theme = substr_count($file, '/') < 2 ? C('DEFAULT_THEME') : '';


	$depr = C('TMPL_FILE_DEPR');
	if ('' == $file) {

		$file = CONTROLLER_NAME . $depr . ACTION_NAME;
	} elseif (false === strpos($file, '/')) {
		$file = CONTROLLER_NAME . $depr . $file;
	} elseif ('/' != $depr) {
		$file = substr_count($file, '/') > 1 ? substr_replace($file, $depr, strrpos($file, '/'), 1) : str_replace('/', $depr, $file);
	}
	return $baseUrl . ($theme ? $theme . '/' : '') . $file . C('TMPL_TEMPLATE_SUFFIX');
}


function I($name, $default = '', $filter = null, $datas = null)
{
	static $_PUT = null;
	if (strpos($name, '/')) {
		list($name, $type) = explode('/', $name, 2);
	} elseif (C('VAR_AUTO_STRING')) {
		$type = 's';
	}
	if (strpos($name, '.')) {
		list($method, $name) = explode('.', $name, 2);
	} else {
		$method = 'param';
	}
	switch (strtolower($method)) {
		case 'get'     :
			$input =& $_GET;
			break;
		case 'post'    :
			$input =& $_POST;
			break;
		case 'put'     :
			if (is_null($_PUT)) {
				parse_str(file_get_contents('php://input'), $_PUT);
			}
			$input = $_PUT;
			break;
		case 'param'   :
			switch ($_SERVER['REQUEST_METHOD']) {
				case 'POST':
					$input = $_POST;
					break;
				case 'PUT':
					if (is_null($_PUT)) {
						parse_str(file_get_contents('php://input'), $_PUT);
					}
					$input = $_PUT;
					break;
				default:
					$input = $_GET;
			}
			break;
		case 'path'    :
			$input = array();
			if (!empty($_SERVER['PATH_INFO'])) {
				$depr = C('URL_PATHINFO_DEPR');
				$input = explode($depr, trim($_SERVER['PATH_INFO'], $depr));
			}
			break;
		case 'request' :
			$input =& $_REQUEST;
			break;
		case 'session' :
			$input =& $_SESSION;
			break;
		case 'cookie'  :
			$input =& $_COOKIE;
			break;
		case 'server'  :
			$input =& $_SERVER;
			break;
		case 'globals' :
			$input =& $GLOBALS;
			break;
		case 'data'    :
			$input =& $datas;
			break;
		default:
			return null;
	}
	if ('' == $name) {
		$data = $input;
		$filters = isset($filter) ? $filter : C('DEFAULT_FILTER');
		if ($filters) {
			if (is_string($filters)) {
				$filters = explode(',', $filters);
			}
			foreach ($filters as $filter) {
				$data = array_map_recursive($filter, $data);
			}
		}
	} elseif (isset($input[$name])) {
		$data = $input[$name];
		$filters = isset($filter) ? $filter : C('DEFAULT_FILTER');
		if ($filters) {
			if (is_string($filters)) {
				if (0 === strpos($filters, '/')) {
					if (1 !== preg_match($filters, (string)$data)) {

						return isset($default) ? $default : null;
					}
				} else {
					$filters = explode(',', $filters);
				}
			} elseif (is_int($filters)) {
				$filters = array($filters);
			}

			if (is_array($filters)) {
				foreach ($filters as $filter) {
					if (function_exists($filter)) {
						$data = is_array($data) ? array_map_recursive($filter, $data) : $filter($data);
					} else {
						$data = filter_var($data, is_int($filter) ? $filter : filter_id($filter));
						if (false === $data) {
							return isset($default) ? $default : null;
						}
					}
				}
			}
		}
		if (!empty($type)) {
			switch (strtolower($type)) {
				case 'a':
					$data = (array)$data;
					break;
				case 'd':
					$data = (int)$data;
					break;
				case 'f':
					$data = (float)$data;
					break;
				case 'b':
					$data = (boolean)$data;
					break;
				case 's':
				default:
					$data = (string)$data;
			}
		}
	} else {
		$data = isset($default) ? $default : null;
	}
	is_array($data) && array_walk_recursive($data, 'think_filter');
	return $data;
}

function array_map_recursive($filter, $data)
{
	$result = array();
	foreach ($data as $key => $val) {
		$result[$key] = is_array($val)
			? array_map_recursive($filter, $val)
			: call_user_func($filter, $val);
	}
	return $result;
}


function N($key, $step = 0, $save = false)
{
	static $_num = array();
	if (!isset($_num[$key])) {
		$_num[$key] = (false !== $save) ? S('N_' . $key) : 0;
	}
	if (empty($step)) {
		return $_num[$key];
	} else {
		$_num[$key] = $_num[$key] + (int)$step;
	}
	if (false !== $save) {
		S('N_' . $key, $_num[$key], $save);
	}
	return null;
}


function parse_name($name, $type = 0)
{
	if ($type) {
		return ucfirst(preg_replace_callback('/_([a-zA-Z])/', function ($match) {
			return strtoupper($match[1]);
		}, $name));
	} else {
		return strtolower(trim(preg_replace('/[A-Z]/', '_' . "\\" . '0', $name), '_'));
	}
}


function require_cache($filename)
{
	static $_importFiles = array();
	if (!isset($_importFiles[$filename])) {
		if (file_exists_case($filename)) {
			require $filename;
			$_importFiles[$filename] = true;
		} else {
			$_importFiles[$filename] = false;
		}
	}
	return $_importFiles[$filename];
}


function file_exists_case($filename)
{
	if (is_file($filename)) {
		if (IS_WIN && APP_DEBUG) {
			if (basename(realpath($filename)) != basename($filename))
				return false;
		}
		return true;
	}
	return false;
}


function import($class, $baseUrl = '', $ext = EXT)
{
	static $_file = array();
	$class = str_replace(array('.', '#'), array('/', '.'), $class);
	if (isset($_file[$class . $baseUrl]))
		return true;
	else
		$_file[$class . $baseUrl] = true;
	$class_strut = explode('/', $class);
	if (empty($baseUrl)) {
		if ('@' == $class_strut[0] || MODULE_NAME == $class_strut[0]) {

			$baseUrl = MODULE_PATH;
			$class = substr_replace($class, '', 0, strlen($class_strut[0]) + 1);
		} elseif ('Common' == $class_strut[0]) {

			$baseUrl = COMMON_PATH;
			$class = substr($class, 7);
		} elseif (in_array($class_strut[0], array('Think', 'Org', 'Behavior', 'Com', 'Vendor')) || is_dir(LIB_PATH . $class_strut[0])) {

			$baseUrl = LIB_PATH;
		} else {
			$baseUrl = APP_PATH;
		}
	}
	if (substr($baseUrl, -1) != '/')
		$baseUrl .= '/';
	$classfile = $baseUrl . $class . $ext;
	if (!class_exists(basename($class), false)) {

		return require_cache($classfile);
	}
	return null;
}


function load($name, $baseUrl = '', $ext = '.php')
{
	$name = str_replace(array('.', '#'), array('/', '.'), $name);
	if (empty($baseUrl)) {
		if (0 === strpos($name, '@/')) {
			$baseUrl = MODULE_PATH . 'Common/';
			$name = substr($name, 2);
		} else {
			$array = explode('/', $name);
			$baseUrl = APP_PATH . array_shift($array) . '/Common/';
			$name = implode('/', $array);
		}
	}
	if (substr($baseUrl, -1) != '/')
		$baseUrl .= '/';
	require_cache($baseUrl . $name . $ext);
}


function vendor($class, $baseUrl = '', $ext = '.php')
{
	if (empty($baseUrl))
		$baseUrl = VENDOR_PATH;
	return import($class, $baseUrl, $ext);
}


function D($name = '', $layer = '')
{
	if (empty($name)) return new Think\Model;
	static $_model = array();
	$layer = $layer ?: C('DEFAULT_M_LAYER');
	if (isset($_model[$name . $layer]))
		return $_model[$name . $layer];
	$class = parse_res_name($name, $layer);
	if (class_exists($class)) {
		$model = new $class(basename($name));
	} elseif (false === strpos($name, '/')) {

		if (!C('APP_USE_NAMESPACE')) {
			import('Common/' . $layer . '/' . $class);
		} else {
			$class = '\\Common\\' . $layer . '\\' . $name . $layer;
		}
		$model = class_exists($class) ? new $class($name) : new Think\Model($name);
	} else {
		Think\Log::record('D方法实例化没找到模型类' . $class, Think\Log::NOTICE);
		$model = new Think\Model(basename($name));
	}
	$_model[$name . $layer] = $model;
	return $model;
}


function M($name = '', $tablePrefix = '', $connection = '')
{
	static $_model = array();
	if (strpos($name, ':')) {
		list($class, $name) = explode(':', $name);
	} else {
		$class = 'Think\Model';
	}
	$guid = (is_array($connection) ? implode('', $connection) : $connection) . $tablePrefix . $name . '_' . $class;
	if (!isset($_model[$guid]))
		$_model[$guid] = new $class($name, $tablePrefix, $connection);
	return $_model[$guid];
}


function parse_res_name($name, $layer, $level = 1)
{
	if (strpos($name, '://')) {
		list($extend, $name) = explode('://', $name);
	} else {
		$extend = '';
	}
	if (strpos($name, '/') && substr_count($name, '/') >= $level) {
		list($module, $name) = explode('/', $name, 2);
	} else {
		$module = defined('MODULE_NAME') ? MODULE_NAME : '';
	}
	$array = explode('/', $name);
	if (!C('APP_USE_NAMESPACE')) {
		$class = parse_name($name, 1);
		import($module . '/' . $layer . '/' . $class . $layer);
	} else {
		$class = $module . '\\' . $layer;
		foreach ($array as $name) {
			$class .= '\\' . parse_name($name, 1);
		}

		if ($extend) {
			$class = $extend . '\\' . $class;
		}
	}
	return $class . $layer;
}


function controller($name, $path = '')
{
	$layer = C('DEFAULT_C_LAYER');
	if (!C('APP_USE_NAMESPACE')) {
		$class = parse_name($name, 1) . $layer;
		import(MODULE_NAME . '/' . $layer . '/' . $class);
	} else {
		$class = ($path ? basename(ADDON_PATH) . '\\' . $path : MODULE_NAME) . '\\' . $layer;
		$array = explode('/', $name);
		foreach ($array as $name) {
			$class .= '\\' . parse_name($name, 1);
		}
		$class .= $layer;
	}
	if (class_exists($class)) {
		return new $class();
	} else {
		return false;
	}
}


function A($name, $layer = '', $level = 0)
{
	static $_action = array();
	$layer = $layer ?: C('DEFAULT_C_LAYER');
	$level = $level ?: ($layer == C('DEFAULT_C_LAYER') ? C('CONTROLLER_LEVEL') : 1);
	if (isset($_action[$name . $layer]))
		return $_action[$name . $layer];

	$class = parse_res_name($name, $layer, $level);
	if (class_exists($class)) {
		$action = new $class();
		$_action[$name . $layer] = $action;
		return $action;
	} else {
		return false;
	}
}


function R($url, $vars = array(), $layer = '')
{
	$info = pathinfo($url);
	$action = $info['basename'];
	$module = $info['dirname'];
	$class = A($module, $layer);
	if ($class) {
		if (is_string($vars)) {
			parse_str($vars, $vars);
		}
		return call_user_func_array(array(&$class, $action . C('ACTION_SUFFIX')), $vars);
	} else {
		return false;
	}
}


function tag($tag, &$params = NULL)
{
	\Think\Hook::listen($tag, $params);
}


function B($name, $tag = '', &$params = NULL)
{
	if ('' == $tag) {
		$name .= 'Behavior';
	}
	return \Think\Hook::exec($name, $tag, $params);
}


function strip_whitespace($content)
{
	$stripStr = '';

	$tokens = token_get_all($content);
	$last_space = false;
	for ($i = 0, $j = count($tokens); $i < $j; $i++) {
		if (is_string($tokens[$i])) {
			$last_space = false;
			$stripStr .= $tokens[$i];
		} else {
			switch ($tokens[$i][0]) {

				case T_COMMENT:
				case T_DOC_COMMENT:
					break;

				case T_WHITESPACE:
					if (!$last_space) {
						$stripStr .= ' ';
						$last_space = true;
					}
					break;
				case T_START_HEREDOC:
					$stripStr .= '<<<THINK[@string_WPShZaWElWGcwOmsWEeZ]THINK;' . "\n" . '';
					for ($k = $i + 1; $k < $j; $k++) {
						if (is_string($tokens[$k]) && $tokens[$k] == ';') {
							$i = $k;
							break;
						} else if ($tokens[$k][0] == T_CLOSE_TAG) {
							break;
						}
					}
					break;
				default:
					$last_space = false;
					$stripStr .= $tokens[$i][1];
			}
		}
	}
	return $stripStr;
}


function throw_exception($msg, $type = 'Think\\Exception', $code = 0)
{
	Think\Log::record('建议使用E方法替代throw_exception', Think\Log::NOTICE);
	if (class_exists($type, false))
		throw new $type($msg, $code);
	else
		Think\Think::halt($msg);
}


function dump($var, $echo = true, $label = null, $strict = true)
{
	$label = ($label === null) ? '' : rtrim($label) . ' ';
	if (!$strict) {
		if (ini_get('html_errors')) {
			$output = print_r($var, true);
			$output = '<pre>' . $label . htmlspecialchars($output, ENT_QUOTES) . '</pre>';
		} else {
			$output = $label . print_r($var, true);
		}
	} else {
		ob_start();
		var_dump($var);
		$output = ob_get_clean();
		if (!extension_loaded('xdebug')) {
			$output = preg_replace('/\]\=\>\n(\s+)/m', '] => ', $output);
			$output = '<pre>' . $label . htmlspecialchars($output, ENT_QUOTES) . '</pre>';
		}
	}
	if ($echo) {
		echo($output);
		return null;
	} else
		return $output;
}


function layout($layout)
{
	if (false !== $layout) {

		C('LAYOUT_ON', true);
		if (is_string($layout)) {
			C('LAYOUT_NAME', $layout);
		}
	} else {
		C('LAYOUT_ON', false);
	}
}

function get_curl($url, $post = 0, $referer = 0, $cookie = 0, $header = 0, $ua = 0, $nobaody = 0)
{
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	if ($post) {
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
	}
	if ($header) {
		curl_setopt($ch, CURLOPT_HEADER, TRUE);
	}
	if ($cookie) {
		curl_setopt($ch, CURLOPT_COOKIE, $cookie);
	}
	if ($referer) {
		if ($referer == 1) {
			curl_setopt($ch, CURLOPT_REFERER, "http://m.qzone.com/infocenter?g_f=");
		} else {
			curl_setopt($ch, CURLOPT_REFERER, $referer);
		}
	}
	if ($ua) {
		curl_setopt($ch, CURLOPT_USERAGENT, $ua);
	} else {
		curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Linux; U; Android 4.0.4; es-mx; HTC_One_X Build/IMM76D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0');
	}
	if ($nobaody) {
		curl_setopt($ch, CURLOPT_NOBODY, 1);//主要头部
		//curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);//跟随重定向
	}
	curl_setopt($ch, CURLOPT_ENCODING, "gzip");
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	$ret = curl_exec($ch);
	curl_close($ch);
	return $ret;

}

function U($url = '', $vars = '', $suffix = true, $domain = false)
{

	$info = parse_url($url);
	$url = !empty($info['path']) ? $info['path'] : ACTION_NAME;
	if (isset($info['fragment'])) {
		$anchor = $info['fragment'];
		if (false !== strpos($anchor, '?')) {
			list($anchor, $info['query']) = explode('?', $anchor, 2);
		}
		if (false !== strpos($anchor, '@')) {
			list($anchor, $host) = explode('@', $anchor, 2);
		}
	} elseif (false !== strpos($url, '@')) {
		list($url, $host) = explode('@', $info['path'], 2);
	}

	if (isset($host)) {
		$domain = $host . (strpos($host, '.') ? '' : strstr($_SERVER['HTTP_HOST'], '.'));
	} elseif ($domain === true) {
		$domain = $_SERVER['HTTP_HOST'];
		if (C('APP_SUB_DOMAIN_DEPLOY')) {
			$domain = $domain == 'localhost' ? 'localhost' : 'www' . strstr($_SERVER['HTTP_HOST'], '.');

			foreach (C('APP_SUB_DOMAIN_RULES') as $key => $rule) {
				$rule = is_array($rule) ? $rule[0] : $rule;
				if (false === strpos($key, '*') && 0 === strpos($url, $rule)) {
					$domain = $key . strstr($domain, '.');
					$url = substr_replace($url, '', 0, strlen($rule));
					break;
				}
			}
		}
	}


	if (is_string($vars)) {
		parse_str($vars, $vars);
	} elseif (!is_array($vars)) {
		$vars = array();
	}
	if (isset($info['query'])) {
		parse_str($info['query'], $params);
		$vars = array_merge($params, $vars);
	}


	$depr = C('URL_PATHINFO_DEPR');
	$urlCase = C('URL_CASE_INSENSITIVE');
	if ($url) {
		if (0 === strpos($url, '/')) {
			$route = true;
			$url = substr($url, 1);
			if ('/' != $depr) {
				$url = str_replace('/', $depr, $url);
			}
		} else {
			if ('/' != $depr) {
				$url = str_replace('/', $depr, $url);
			}

			$url = trim($url, $depr);
			$path = explode($depr, $url);
			$var = array();
			$varModule = C('VAR_MODULE');
			$varController = C('VAR_CONTROLLER');
			$varAction = C('VAR_ACTION');
			$var[$varAction] = !empty($path) ? array_pop($path) : ACTION_NAME;
			$var[$varController] = !empty($path) ? array_pop($path) : CONTROLLER_NAME;
			if ($maps = C('URL_ACTION_MAP')) {
				if (isset($maps[strtolower($var[$varController])])) {
					$maps = $maps[strtolower($var[$varController])];
					if ($action = array_search(strtolower($var[$varAction]), $maps)) {
						$var[$varAction] = $action;
					}
				}
			}
			if ($maps = C('URL_CONTROLLER_MAP')) {
				if ($controller = array_search(strtolower($var[$varController]), $maps)) {
					$var[$varController] = $controller;
				}
			}
			if ($urlCase) {
				$var[$varController] = parse_name($var[$varController]);
			}
			$module = '';

			if (!empty($path)) {
				$var[$varModule] = implode($depr, $path);
			} else {
				if (C('MULTI_MODULE')) {
					if (MODULE_NAME != C('DEFAULT_MODULE') || !C('MODULE_ALLOW_LIST')) {
						$var[$varModule] = MODULE_NAME;
					}
				}
			}
			if ($maps = C('URL_MODULE_MAP')) {
				if ($_module = array_search(strtolower($var[$varModule]), $maps)) {
					$var[$varModule] = $_module;
				}
			}
			if (isset($var[$varModule])) {
				$module = $var[$varModule];
				unset($var[$varModule]);
			}

		}
	}

	if (C('URL_MODEL') == 0) {
		$url = __APP__ . '?' . C('VAR_MODULE') . '=' . $module . '&' . http_build_query(array_reverse($var));
		if ($urlCase) {
			$url = strtolower($url);
		}
		if (!empty($vars)) {
			$vars = http_build_query($vars);
			$url .= '&' . $vars;
		}
	} else {
		if (isset($route)) {
			$url = __APP__ . '/' . rtrim($url, $depr);
		} else {
			$module = (defined('BIND_MODULE') && BIND_MODULE == $module) ? '' : $module;
			$url = __APP__ . '/' . ($module ? $module . MODULE_PATHINFO_DEPR : '') . implode($depr, array_reverse($var));
		}
		if ($urlCase) {
			$url = strtolower($url);
		}
		if (!empty($vars)) {
			foreach ($vars as $var => $val) {
				if ('' !== trim($val)) $url .= $depr . $var . $depr . urlencode($val);
			}
		}
		if ($suffix) {
			$suffix = $suffix === true ? C('URL_HTML_SUFFIX') : $suffix;
			if ($pos = strpos($suffix, '|')) {
				$suffix = substr($suffix, 0, $pos);
			}
			if ($suffix && '/' != substr($url, -1)) {
				$url .= '.' . ltrim($suffix, '.');
			}
		}
	}
	if (isset($anchor)) {
		$url .= '#' . $anchor;
	}
	if ($domain) {
		$url = (is_ssl() ? 'https://' : 'http://') . $domain . $url;
	}
	return $url;
}

function J()
{
	if ($_SESSION['thinkphpcode']) {
		return $_SESSION['thinkphpcode'];
	} else {
		return;
	}
}

function W($name, $data = array())
{
	return R($name, $data, 'Widget');
}


function is_ssl()
{
	if (isset($_SERVER['HTTPS']) && ('1' == $_SERVER['HTTPS'] || 'on' == strtolower($_SERVER['HTTPS']))) {
		return true;
	} elseif (isset($_SERVER['SERVER_PORT']) && ('443' == $_SERVER['SERVER_PORT'])) {
		return true;
	}
	return false;
}

function redirect($url, $time = 0, $msg = '')
{

	$url = str_replace(array('' . "\n" . '', '' . "\r" . ''), '', $url);
	if (empty($msg))
		$msg = '系统将在' . $time . '秒之后自动跳转到' . $url . '！';
	if (!headers_sent()) {

		if (0 === $time) {
			header('Location: ' . $url);
		} else {
			header('refresh:' . $time . ';url=' . $url . '');
			echo($msg);
		}
		exit();
	} else {
		$str = '<meta http-equiv=\'Refresh\' content=\'' . $time . ';URL=' . $url . '\'>';
		if ($time != 0)
			$str .= $msg;
		exit($str);
	}
}


function S($name, $value = '', $options = null)
{
	static $cache = '';
	if (is_array($options)) {
		// 缓存操作的同时初始化
		$type = isset($options['type']) ? $options['type'] : '';
		$cache = Think\Cache::getInstance($type, $options);
	} elseif (is_array($name)) { // 缓存初始化
		$type = isset($name['type']) ? $name['type'] : '';
		$cache = Think\Cache::getInstance($type, $name);
		return $cache;
	} elseif (empty($cache)) { // 自动初始化
		$cache = Think\Cache::getInstance();
	}
	if ('' === $value) { // 获取缓存
		return $cache->get($name);
	} elseif (is_null($value)) { // 删除缓存
		return $cache->rm($name);
	} else { // 缓存数据
		if (is_array($options)) {
			$expire = isset($options['expire']) ? $options['expire'] : NULL;
		} else {
			$expire = is_numeric($options) ? $options : NULL;
		}
		return $cache->set($name, $value, $expire);
	}
}


function F($name, $value = '', $path = DATA_PATH)
{
	static $_cache = array();
	$filename = $path . $name . '.php';
	if ('' !== $value) {
		if (is_null($value)) {

			if (false !== strpos($name, '*')) {
				return false;
			} else {
				unset($_cache[$name]);
				return Think\Storage::unlink($filename, 'F');
			}
		} else {
			Think\Storage::put($filename, serialize($value), 'F');

			$_cache[$name] = $value;
			return null;
		}
	}

	if (isset($_cache[$name]))
		return $_cache[$name];
	if (Think\Storage::has($filename, 'F')) {
		$value = unserialize(Think\Storage::read($filename, 'F'));
		$_cache[$name] = $value;
	} else {
		$value = false;
	}
	return $value;
}


function to_guid_string($mix)
{
	if (is_object($mix)) {
		return spl_object_hash($mix);
	} elseif (is_resource($mix)) {
		$mix = get_resource_type($mix) . strval($mix);
	} else {
		$mix = serialize($mix);
	}
	return md5($mix);
}


function xml_encode($data, $root = 'think', $item = 'item', $attr = '', $id = 'id', $encoding = 'utf-8')
{
	if (is_array($attr)) {
		$_attr = array();
		foreach ($attr as $key => $value) {
			$_attr[] = '' . $key . '="' . $value . '"';
		}
		$attr = implode(' ', $_attr);
	}
	$attr = trim($attr);
	$attr = empty($attr) ? '' : ' ' . $attr . '';
	$xml = '<?xml version="1.0" encoding="' . $encoding . '"?>';
	$xml .= '<' . $root . '' . $attr . '>';
	$xml .= data_to_xml($data, $item, $id);
	$xml .= '</' . $root . '>';
	return $xml;
}


function data_to_xml($data, $item = 'item', $id = 'id')
{
	$xml = $attr = '';
	foreach ($data as $key => $val) {
		if (is_numeric($key)) {
			$id && $attr = ' ' . $id . '="' . $key . '"';
			$key = $item;
		}
		$xml .= '<' . $key . '' . $attr . '>';
		$xml .= (is_array($val) || is_object($val)) ? data_to_xml($val, $item, $id) : $val;
		$xml .= '</' . $key . '>';
	}
	return $xml;
}


function session($name = '', $value = '')
{
	$prefix = C('SESSION_PREFIX');
	if (is_array($name)) {
		if (isset($name['prefix'])) C('SESSION_PREFIX', $name['prefix']);
		if (C('VAR_SESSION_ID') && isset($_REQUEST[C('VAR_SESSION_ID')])) {
			session_id($_REQUEST[C('VAR_SESSION_ID')]);
		} elseif (isset($name['id'])) {
			session_id($name['id']);
		}
		if ('common' == APP_MODE) {
			ini_set('session.auto_start', 0);
		}
		if (isset($name['name'])) session_name($name['name']);
		if (isset($name['path'])) session_save_path($name['path']);
		if (isset($name['domain'])) ini_set('session.cookie_domain', $name['domain']);
		if (isset($name['expire'])) {
			ini_set('session.gc_maxlifetime', $name['expire']);
			ini_set('session.cookie_lifetime', $name['expire']);
		}
		if (isset($name['use_trans_sid'])) ini_set('session.use_trans_sid', $name['use_trans_sid'] ? 1 : 0);
		if (isset($name['use_cookies'])) ini_set('session.use_cookies', $name['use_cookies'] ? 1 : 0);
		if (isset($name['cache_limiter'])) session_cache_limiter($name['cache_limiter']);
		if (isset($name['cache_expire'])) session_cache_expire($name['cache_expire']);
		if (isset($name['type'])) C('SESSION_TYPE', $name['type']);
		if (C('SESSION_TYPE')) {
			$type = C('SESSION_TYPE');
			$class = strpos($type, '\\') ? $type : 'Think\Session\Driver\\' . ucwords(strtolower($type));
			$hander = new $class();
			session_set_save_handler(
				array(&$hander, "open"),
				array(&$hander, "close"),
				array(&$hander, "read"),
				array(&$hander, "write"),
				array(&$hander, "destroy"),
				array(&$hander, "gc"));
		}

		if (C('SESSION_AUTO_START')) session_start();
	} elseif ('' === $value) {
		if ('' === $name) {

			return $prefix ? $_SESSION[$prefix] : $_SESSION;
		} elseif (0 === strpos($name, '[')) {
			if ('[pause]' == $name) {
				session_write_close();
			} elseif ('[start]' == $name) {
				session_start();
			} elseif ('[destroy]' == $name) {
				$_SESSION = array();
				session_unset();
				session_destroy();
			} elseif ('[regenerate]' == $name) {
				session_regenerate_id();
			}
		} elseif (0 === strpos($name, '?')) {
			$name = substr($name, 1);
			if (strpos($name, '.')) {
				list($name1, $name2) = explode('.', $name);
				return $prefix ? isset($_SESSION[$prefix][$name1][$name2]) : isset($_SESSION[$name1][$name2]);
			} else {
				return $prefix ? isset($_SESSION[$prefix][$name]) : isset($_SESSION[$name]);
			}
		} elseif (is_null($name)) {
			if ($prefix) {
				unset($_SESSION[$prefix]);
			} else {
				$_SESSION = array();
			}
		} elseif ($prefix) {
			if (strpos($name, '.')) {
				list($name1, $name2) = explode('.', $name);
				return isset($_SESSION[$prefix][$name1][$name2]) ? $_SESSION[$prefix][$name1][$name2] : null;
			} else {
				return isset($_SESSION[$prefix][$name]) ? $_SESSION[$prefix][$name] : null;
			}
		} else {
			if (strpos($name, '.')) {
				list($name1, $name2) = explode('.', $name);
				return isset($_SESSION[$name1][$name2]) ? $_SESSION[$name1][$name2] : null;
			} else {
				return isset($_SESSION[$name]) ? $_SESSION[$name] : null;
			}
		}
	} elseif (is_null($value)) {
		if (strpos($name, '.')) {
			list($name1, $name2) = explode('.', $name);
			if ($prefix) {
				unset($_SESSION[$prefix][$name1][$name2]);
			} else {
				unset($_SESSION[$name1][$name2]);
			}
		} else {
			if ($prefix) {
				unset($_SESSION[$prefix][$name]);
			} else {
				unset($_SESSION[$name]);
			}
		}
	} else {
		if (strpos($name, '.')) {
			list($name1, $name2) = explode('.', $name);
			if ($prefix) {
				$_SESSION[$prefix][$name1][$name2] = $value;
			} else {
				$_SESSION[$name1][$name2] = $value;
			}
		} else {
			if ($prefix) {
				$_SESSION[$prefix][$name] = $value;
			} else {
				$_SESSION[$name] = $value;
			}
		}
	}
	return null;
}


function cookie($name = '', $value = '', $option = null)
{

	$config = array(
		'prefix' => C('COOKIE_PREFIX'),
		'expire' => C('COOKIE_EXPIRE'),
		'path' => C('COOKIE_PATH'),
		'domain' => C('COOKIE_DOMAIN'),
		'secure' => C('COOKIE_SECURE'),
		'httponly' => C('COOKIE_HTTPONLY'),
	);

	if (!is_null($option)) {
		if (is_numeric($option))
			$option = array('expire' => $option);
		elseif (is_string($option))
			parse_str($option, $option);
		$config = array_merge($config, array_change_key_case($option));
	}
	if (!empty($config['httponly'])) {
		ini_set('session.cookie_httponly', 1);
	}

	if (is_null($name)) {
		if (empty($_COOKIE))
			return null;

		$prefix = empty($value) ? $config['prefix'] : $value;
		if (!empty($prefix)) {
			foreach ($_COOKIE as $key => $val) {
				if (0 === stripos($key, $prefix)) {
					setcookie($key, '', time() - 3600, $config['path'], $config['domain'], $config['secure'], $config['httponly']);
					unset($_COOKIE[$key]);
				}
			}
		}
		return null;
	} elseif ('' === $name) {

		return $_COOKIE;
	}
	$name = $config['prefix'] . str_replace('.', '_', $name);
	if ('' === $value) {
		if (isset($_COOKIE[$name])) {
			$value = $_COOKIE[$name];
			if (0 === strpos($value, 'think:')) {
				$value = substr($value, 6);
				return array_map('urldecode', json_decode(MAGIC_QUOTES_GPC ? stripslashes($value) : $value, true));
			} else {
				return $value;
			}
		} else {
			return null;
		}
	} else {
		if (is_null($value)) {
			setcookie($name, '', time() - 3600, $config['path'], $config['domain'], $config['secure'], $config['httponly']);
			unset($_COOKIE[$name]);
		} else {

			if (is_array($value)) {
				$value = 'think:' . json_encode(array_map('urlencode', $value));
			}
			$expire = !empty($config['expire']) ? time() + intval($config['expire']) : 0;
			setcookie($name, $value, $expire, $config['path'], $config['domain'], $config['secure'], $config['httponly']);
			$_COOKIE[$name] = $value;
		}
	}
	return null;
}


function load_ext_file($path)
{

	if ($files = C('LOAD_EXT_FILE')) {
		$files = explode(',', $files);
		foreach ($files as $file) {
			$file = $path . 'Common/' . $file . '.php';
			if (is_file($file)) include $file;
		}
	}

	if ($configs = C('LOAD_EXT_CONFIG')) {
		if (is_string($configs)) $configs = explode(',', $configs);
		foreach ($configs as $key => $config) {
			$file = is_file($config) ? $config : $path . 'Conf/' . $config . CONF_EXT;
			if (is_file($file)) {
				is_numeric($key) ? C(load_config($file)) : C($key, load_config($file));
			}
		}
	}
}


function get_client_ip($type = 0, $adv = false)
{
	$type = $type ? 1 : 0;
	static $ip = NULL;
	if ($ip !== NULL) return $ip[$type];
	if ($adv) {
		if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
			$arr = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
			$pos = array_search('unknown', $arr);
			if (false !== $pos) unset($arr[$pos]);
			$ip = trim($arr[0]);
		} elseif (isset($_SERVER['HTTP_CLIENT_IP'])) {
			$ip = $_SERVER['HTTP_CLIENT_IP'];
		} elseif (isset($_SERVER['REMOTE_ADDR'])) {
			$ip = $_SERVER['REMOTE_ADDR'];
		}
	} elseif (isset($_SERVER['REMOTE_ADDR'])) {
		$ip = $_SERVER['REMOTE_ADDR'];
	}

	$long = sprintf('%u', ip2long($ip));
	$ip = $long ? array($ip, $long) : array('0.0.0.0', 0);
	return $ip[$type];
}


function send_http_status($code)
{
	static $_status = array(

		100 => 'Continue',
		101 => 'Switching Protocols',

		200 => 'OK',
		201 => 'Created',
		202 => 'Accepted',
		203 => 'Non-Authoritative Information',
		204 => 'No Content',
		205 => 'Reset Content',
		206 => 'Partial Content',

		300 => 'Multiple Choices',
		301 => 'Moved Permanently',
		302 => 'Moved Temporarily ',
		303 => 'See Other',
		304 => 'Not Modified',
		305 => 'Use Proxy',

		307 => 'Temporary Redirect',

		400 => 'Bad Request',
		401 => 'Unauthorized',
		402 => 'Payment Required',
		403 => 'Forbidden',
		404 => 'Not Found',
		405 => 'Method Not Allowed',
		406 => 'Not Acceptable',
		407 => 'Proxy Authentication Required',
		408 => 'Request Timeout',
		409 => 'Conflict',
		410 => 'Gone',
		411 => 'Length Required',
		412 => 'Precondition Failed',
		413 => 'Request Entity Too Large',
		414 => 'Request-URI Too Long',
		415 => 'Unsupported Media Type',
		416 => 'Requested Range Not Satisfiable',
		417 => 'Expectation Failed',

		500 => 'Internal Server Error',
		501 => 'Not Implemented',
		502 => 'Bad Gateway',
		503 => 'Service Unavailable',
		504 => 'Gateway Timeout',
		505 => 'HTTP Version Not Supported',
		509 => 'Bandwidth Limit Exceeded'
	);
	if (isset($_status[$code])) {
		header('HTTP/1.1 ' . $code . ' ' . $_status[$code]);

		header('Status:' . $code . ' ' . $_status[$code]);
	}
}

function think_filter(&$value)
{


	if (preg_match('/^(EXP|NEQ|GT|EGT|LT|ELT|OR|XOR|LIKE|NOTLIKE|NOT BETWEEN|NOTBETWEEN|BETWEEN|NOTIN|NOT IN|IN)$/i', $value)) {
		$value .= ' ';
	}
}


function in_array_case($value, $array)
{
	return in_array(strtolower($value), array_map('strtolower', $array));
}

function get_count($table, $where = '', $z = '')
{
	return M($table)->where($where)->count($z);
}

function get_net_count($do, $net)
{
	return M('qqs')->where('' . $do . 'net=' . $net . '')->count('qid');
}

function get_qqnick($uin, $sid)
{
	if ($data = file_get_contents('http://users.qzone.qq.com/fcg-bin/cgi_get_portrait.fcg?get_nick=1&uins=' . $uin)) {
		$data = str_replace(array('portraitCallBack(', ')'), array('', ''), $data);
		$data = mb_convert_encoding($data, 'UTF-8', 'GBK');
		$row = json_decode($data, true);;
		return $row[$uin][6];
	}
}

function think_send_mail($to, $name = '快乐云邮件', $subject = '', $body = '', $attachment = null)
{
	vendor('phpmailer.class#phpmailer');
	$mail = new PHPMailer();
	$mail->CharSet = 'UTF-8';
	$mail->IsSMTP();
	$mail->SMTPDebug = 0;


	$mail->SMTPAuth = true;
	$mail->SMTPSecure = false;
	$mail->Host = C('mail_host') ? C('mail_host') : 'smtp.qq.com';
	$mail->Port = C('mail_port') ? C('mail_port') : '465';
	$mail->Username = C('mail_email');
	$mail->Password = C('mail_pwd');
	$mail->SetFrom(C('mail_email'), C('web_name'));
	$mail->AddReplyTo($replyEmail, $replyName);
	$mail->Subject = $subject;
	$mail->MsgHTML($body);
	$mail->AddAddress($to, $name);
	return $mail->Send() ? true : $mail->ErrorInfo;
}

?>