<?php

// Stop direct call
if ( preg_match( '#' . basename( __FILE__ ) . '#', $_SERVER['PHP_SELF'] ) ) {
    die( '不允许直接调用此页.' );
}

if ( !class_exists( 'SlickQuizAdmin' ) ) {
    class SlickQuizAdmin extends SlickQuizModel
    {

        var $quizzes = array();


        function list_all_quizzes()
        {
            global $quizzes;

            $quizzes = $this->get_all_quizzes();

            if (count($quizzes) > 0) {
                foreach ($quizzes as $quiz) {
                    echo  $this->generate_quiz_row($quiz);
                }
            } else {
                echo "<tr><td colspan=7>您还未创建任何问卷.</td></tr>";
            }
        }

        function generate_quiz_row( $quiz )
        {
            $id           = $quiz->id;
            $status       = $this->get_quiz_status( $quiz );
            $statusButton = $this->get_quiz_status_button( $quiz );
            $qCount       = $status == self::PUBLISHED ? $quiz->publishedQCount : $quiz->workingQCount;
            $actions      = '';
            $quizRow      = '';

            // Editor or Admin Options
            if ( current_user_can( 'publish_pages' ) ) {
                if ( $status == self::PUBLISHED ) {
                    $actions .= '<a class="unpublish_quiz unpublish" title="取消问卷" '
                             . 'href="' . admin_url( 'admin-ajax.php?id=' ) . $id . '">'
                             . '<img id="unpublishquiz-' . $id . '" '
                             . 'src="' . plugins_url( '/images/remove.png' , dirname( __FILE__ ) ) . '"'
                             . ' width="16" height="16" alt="取消问卷" /></a> ';
                }
                $actions .= '<a class="delete_quiz delete" title="删除问卷" '
                         . 'href="' . admin_url( 'admin-ajax.php?id=' ) . $id . '">'
                         . '<img id="deletequiz-' . $id . '" '
                         . 'src="' . plugins_url( '/images/bin_closed.png' , dirname( __FILE__ ) ) . '"'
                         . ' width="16" height="16" alt="删除问卷" /></a> ';
                $actions .= '<a class="edit_quiz" title="编辑问卷" '
                         . 'href="' . admin_url( 'admin.php?page=slickquiz-edit&id=' ) . $id . '">'
                         . '<img id="editquiz-' . $id . '" '
                         . 'src="' . plugins_url( '/images/edit.png' , dirname( __FILE__ ) ) . '"'
                         . ' width="16" height="16" alt="编辑问卷" /></a> ';
            }

            $actions .= '<a class="preview_quiz preview" title="预览问卷" '
                     . 'href="' . admin_url( 'admin.php?page=slickquiz-preview&id=' ) . $id . '&readOnly">'
                     . '<img id="previewquiz-' . $id . '" '
                     . 'src="' . plugins_url( '/images/view.png' , dirname( __FILE__ ) ) . '"'
                     . ' width="16" height="16" alt="预览问卷" /></a> &nbsp; ';

            $scoreLink = '<a href="' . admin_url( 'admin.php?page=slickquiz-scores&id=' . $quiz->id ) . '">'
                       . '<img src="' . plugins_url( '/images/user_comment.png' , dirname( __FILE__ ) ) . '"'
                       . ' alt="问卷分数" /></a>';

            $quizRow .= '<tr>';
            $quizRow .= '<td class="table_id">' . $quiz->id . '</td>';
            $quizRow .= '<td class="table_name">' . $quiz->name . '</td>';
            $quizRow .= '<td class="table_count">' . $qCount . '</td>';
            $quizRow .= '<td class="table_updated">' . $quiz->lastUpdatedDate . '</td>';
            $quizRow .= '<td class="table_pubDate">' . ($status == self::PUBLISHED ? $quiz->publishedDate : '') . '</td>';
            $quizRow .= '<td class="table_status">' . $statusButton . '</td>';
            $quizRow .= '<td class="table_scores">' . $scoreLink . '</td>';
            $quizRow .= '<td class="table_actions">' . $actions . '</td>';
            $quizRow .= '</tr>';

            return $quizRow;
        }

        function get_quiz_count( $ret = false )
        {
            global $quizzes;
            if ( $ret )
                return count( $quizzes );
            else
                echo count( $quizzes );
        }

        function show_alert_messages()
        {
            if ( isset( $_GET['success'] ) )
                echo '<div id="message" class="updated"><p>您的测验已发布</p></div>';

            if ( isset( $_GET['unpublish'] ) )
                echo '<div id="message" class="updated"><p>您的测验尚未发布.</p></div>';
        }

    }
}

if ( class_exists( 'SlickQuizAdmin' ) ) {
    global $slickQuizAdmin;
    $slickQuizAdmin = new SlickQuizAdmin();
}

?>

<div class="wrap slickQuiz quizList">
    <h2>调查问卷管理 <?php if ( current_user_can( 'publish_pages' ) ) { // Editor or Admin Only  ?><a href="<?php echo admin_url( 'admin.php?page=slickquiz-new' ); ?>" class="add-new-h2" title="Create a new Quiz">添加新问卷</a><?php } ?></h2>

    <?php $slickQuizAdmin->show_alert_messages(); ?>

    <p>添加以下短代码将问卷添加到页面、侧边小工具处。其中“X”是问卷ID</p>

    <code>[slickquiz id=X]</code>

    <p class="statusLegend">
        <strong>状态:</strong> &nbsp;&nbsp;&nbsp;
        <img title="已发布" src="<?php echo plugins_url( '/images/activate.png' , dirname( __FILE__ ) ); ?>"> 已发布 &nbsp;&nbsp;&nbsp;
        <img title="未发布更改" src="<?php echo plugins_url( '/images/alert.png' , dirname( __FILE__ ) ); ?>"> 未发布更改 &nbsp;&nbsp;&nbsp;
        <img title="未发布" src="<?php echo plugins_url( '/images/suspend.png' , dirname( __FILE__ ) ); ?>"> 未发布 &nbsp;&nbsp;&nbsp;
    </p>

    <table id="record_view" class="wp-list-table widefat quizzes">
        <thead>
            <tr>
                <th scope="col" class="table_id">ID</th>
                <th scope="col" class="table_name">名称</th>
                <th scope="col" class="table_count">问题计数</th>
                <th scope="col" class="table_updated">最后更新日期</th>
                <th scope="col" class="table_pubDate">发布时间</th>
                <th scope="col" class="table_status">状态</th>
                <th scope="col" class="table_scores">得分</th>
                <th scope="col" class="table_actions"></th>
            </tr>
        </thead>
         <tbody>
            <?php $slickQuizAdmin->list_all_quizzes(); ?>
        </tbody>
    </table>
    <div class="tablenav bottom">
        <div class="tablenav-pages one-page"><span class="displaying-num"><?php $slickQuizAdmin->get_quiz_count() ?> <?php if ( $slickQuizAdmin->get_quiz_count(true) == 1 ) { ?>个调查问卷<?php } else { ?>个调查问卷<?php } ?></span>
    </div>
</div>
