<?php

// Stop direct call
if ( preg_match( '#' . basename( __FILE__ ) . '#', $_SERVER['PHP_SELF'] ) ) {
    die( '不能直接调用此页.' );
}

if ( !class_exists( 'SlickQuizEdit' ) ) {
    class SlickQuizEdit extends SlickQuizModel
    {

        var $quiz = '';
        var $statusBtn = '';


        // Constructor
        function __construct()
        {
            global $quiz, $pluginOptions;

            $this->get_admin_options();

            $quiz = $this->get_quiz_by_id( $_GET['id'] );

            // Add Form JS
            // wp_enqueue_script( 'tiny_mce' );
            // the_editor('', 'quizContent');
        }

        function get_quiz_status_info()
        {
            global $quiz, $statusBtn;
            $statusBtn = $this->get_quiz_status_button( $quiz, true );
            echo $statusBtn;
        }

        function get_quiz_json()
        {
            global $quiz;
            echo $quiz->workingJson;
        }

        function show_discard_option()
        {
            global $statusBtn;
            $pos = strpos( $statusBtn, "title='" . self::UNPUBLISHED_CHANGES . "'" );
            return ( $pos === false ? false : true );
        }

        function show_alert_messages()
        {
            if ( isset( $_GET['success'] ) )
                echo '<div id="message" class="updated"><p>您的更改已保存.</p></div>';
        }

    }
}

if ( class_exists( 'SlickQuizEdit' ) ) {
    global $slickQuizEdit;
    $slickQuizEdit = new SlickQuizEdit();
}

?>
<div class="wrap slickQuiz slickQuizWrapper">
    <?php $slickQuizEdit->show_alert_messages(); ?>

    <h2 class="notPublished">编辑问卷</h2>

    <div class="floatLeft">
        <p class="statusLegend">
            <strong>状态:</strong> &nbsp;&nbsp;&nbsp; <?php $slickQuizEdit->get_quiz_status_info(); ?>
        </p>

        <p class="required">所有标记 <img alt="*" height="16" src="<?php echo plugins_url( '/images/required.png' , dirname( __FILE__ ) ); ?>" width="16" /> 的区域都是必填项.</p>
    </div>

    <div class="floatRight">
        <div class="top_button_bar">
            <?php if ( $slickQuizEdit->show_discard_option() ) { ?>
            <button class="button discard" title="放弃草稿修改" value="放弃草稿修改">
                <img alt="放弃草稿" height="16" src="<?php echo plugins_url( '/images/arrow_undo.png' , dirname( __FILE__ ) ); ?>" width="16" /> 放弃草稿
            </button>
            <?php } ?>
            <a class="button" href="<?php echo admin_url( 'admin.php?page=slickquiz' ); ?>" title="取消操作">
                <img alt="取消" src="<?php echo plugins_url( '/images/remove.png' , dirname( __FILE__ ) ); ?>" width="16" height="16" /> 取消
            </a>
        </div>
    </div>

    <div class="quizFormWrapper">
    </div>

    <div class="bottom_button_bar">
        <button class="button publish" title="保存并发布问卷." value="发布">
            <img alt="发布" height="16" src="<?php echo plugins_url( '/images/save.png' , dirname( __FILE__ ) ); ?>" width="16"> 发布
        </button>
        <?php if ( $slickQuizEdit->show_discard_option() ) { ?>
        <button class="button discard" title="放弃草稿修改" value="放弃草稿修改">
            <img alt="放弃草稿" height="16" src="<?php echo plugins_url( '/images/arrow_undo.png' , dirname( __FILE__ ) ); ?>" width="16" /> 放弃草稿
        </button>
        <?php } ?>
        <button class="button draft" title="保存为草稿." value="Draft">
            <img alt="保存草稿" height="16" src="<?php echo plugins_url( '/images/save.png' , dirname( __FILE__ ) ); ?>" width="16"> 保存草稿
        </button>
        <button class="button preview" title="保存为草稿并预览." value="预览">
            <img alt="预览" height="16" src="<?php echo plugins_url( '/images/view.png' , dirname( __FILE__ ) ); ?>" width="16" /> 预览
        </button>
        <p class="previewNote"><em>预览将更改保存为一个草稿版本.</em></p>
    </div>
</div>

<script type="text/javascript">
    var quizJSON = <?php $slickQuizEdit->get_quiz_json(); ?>;
    var disableRanking = <?php echo( $slickQuizEdit->get_admin_option( 'disable_ranking' ) == '1' ? 'true' : 'false' ); ?>;
</script>
