<?php

// Stop direct call
if ( preg_match( '#' . basename( __FILE__ ) . '#', $_SERVER['PHP_SELF'] ) ) {
    die( '你不能直接调用此页.' );
}

if ( !class_exists( 'SlickQuizHelper' ) ) {
    class SlickQuizHelper
    {

        /**
         * Statuses
         */
        const PUBLISHED           = '已发布';
        const UNPUBLISHED_CHANGES = '未发布更改';
        const NOT_PUBLISHED       = '未发布';

        var $adminOptionsName = "slick_quiz_options";
        var $adminOptions     = array();


        // Set and return Admin Options
        function get_admin_options()
        {
            $this->adminOptions = apply_filters( 'slickquiz_admin_options', array(
                'disabled_quiz_message'        => '<strong>对不起.</strong> 该问卷已被禁用.',
                'missing_quiz_message'         => '<strong>对不起.</strong> 未能找到对应的问卷.',
                'start_button_text'            => '开始!',
                'check_answer_text'            => '提交答案!',
                'next_question_text'           => '下一页 &raquo;',
                'complete_button_text'         => '',
                'back_button_text'             => '返回',
                'try_again_text'               => '请再试一次',
                'your_score_text'              => '您的得分:',
                'your_ranking_text'            => '您的排名:',
                'score_template_text'          => '%score / %total',
                'question_count_text'          => 'Question %current of %total',
                'question_template_text'       =>  '%count. %text',
                'skip_start_button'            => '0',
                'number_of_questions'          => '',
                'random_sort_questions'        => '0',
                'random_sort_answers'          => '0',
                'random_sort'                  => '0',
                'disable_next'                 => '0',
                'perquestion_responses'        => '1',
                'perquestion_response_answers' => '0',
                'completion_responses'         => '0',
                'question_count'               => '1',
                'question_number'              => '1',
                'score_as_percentage'          => '0',
                'disable_score'                => '0',
                'disable_ranking'              => '0',
                'save_scores'                  => '0',
                'name_label'                   => '您的姓名:',
                'email_label'                  => '',
                'share_links'                  => '0',
                'share_message'                => '我是个 [RANK]! 我刚刚拿下 [SCORE] 在 [NAME] 调查问卷!',
                'twitter_account'              => '',
                'no_filter_quizzes'            => '1'
            ) );

            $pluginOptions = get_option( $this->adminOptionsName );

            // If options have been set, override defaults
            if ( !empty( $pluginOptions ) ) {
                foreach ( $pluginOptions as $key => $option )
                    $this->adminOptions[$key] = $option;
            }

            update_option( $this->adminOptionsName, $this->adminOptions );

            return $this->adminOptions;
        }

        // Get requested admin option
        function get_admin_option( $option, $echo = false )
        {
            $value = isset($this->adminOptions[$option])
                ? $this->adminOptions[$option] : NULL;
            if ( $echo ) {
                echo $value;
            } else {
                return $value;
            }
        }

    }
}

?>
