<?php

// Stop direct call
if ( preg_match( '#' . basename( __FILE__ ) . '#', $_SERVER['PHP_SELF'] ) ) {
    die( '你不能直接调用此页.' );
}

if ( !class_exists( 'SlickQuizNew' ) ) {
    class SlickQuizNew extends SlickQuizModel
    {

        // Constructor
        function __construct()
        {
            global $pluginOptions;

            $this->get_admin_options();

            // Add Form JS
            // wp_enqueue_script( 'tiny_mce' );
            // the_editor('', 'quizContent');
        }

    }
}

if ( class_exists( 'SlickQuizNew' ) ) {
    global $slickQuizNew;
    $slickQuizNew = new SlickQuizNew();
}

?>

<div class="wrap slickQuiz slickQuizWrapper">
    <div class="floatLeft">
        <h2 class="notPublished">创建一个新的问卷</h2>
        <p class="required">所有标记 <img alt="*" height="16" src="<?php echo plugins_url( '/images/required.png' , dirname( __FILE__ ) ); ?>" width="16" /> 的均是必填项.</p>
    </div>

    <div class="floatRight">
        <div class="top_button_bar">
            <a class="button" href="<?php echo admin_url( 'admin.php?page=slickquiz' ); ?>" title="取消此操作">
                <img alt="Cancel" src="<?php echo plugins_url( '/images/remove.png' , dirname( __FILE__ ) ); ?>" width="16" height="16" /> 取消
            </a>
        </div>

    </div>

    <div class="quizFormWrapper">
    </div>

    <div class="bottom_button_bar">
        <button class="button publish" title="保存并发布问卷." value="发布">
            <img alt="发布" height="16" src="<?php echo plugins_url( '/images/save.png' , dirname( __FILE__ ) ); ?>" width="16"> 发布
        </button>
        <button class="button draft" title="保存此问卷为草稿." value="草稿">
            <img alt="草稿" height="16" src="<?php echo plugins_url( '/images/save.png' , dirname( __FILE__ ) ); ?>" width="16"> 保存草稿
        </button>
        <button class="button preview" title="保存并预览草稿." value="预览">
            <img alt="预览" height="16" src="<?php echo plugins_url( '/images/view.png' , dirname( __FILE__ ) ); ?>" width="16" /> 预览
        </button>
        <p class="previewNote"><em>预览将保存更改到一个草稿版本.</em></p>
    </div>
</div>

<script type="text/javascript">
    var disableRanking = <?php echo( $slickQuizNew->get_admin_option( 'disable_ranking' ) == '1' ? 'true' : 'false' ); ?>;
</script>
