<?php

// Stop direct call
if ( preg_match( '#' . basename( __FILE__ ) . '#', $_SERVER['PHP_SELF'] ) ) {
    die( '你不能直接调用此页.' );
}

if ( !class_exists( 'SlickQuizOptions' ) ) {
    class SlickQuizOptions extends SlickQuizHelper
    {

        var $updated = false;


        function __construct()
        {
            global $updated, $current_user;

            $this->get_admin_options();

            if ( isset( $_POST['slickQuizOptions'] ) ) {
                // Handle checkboxes
                if ( isset( $_POST['slickQuizOptions']['perquestion_response_answers'] ) != true ) {
                    $_POST['slickQuizOptions']['perquestion_response_answers'] = '0';
                }
                if ( isset( $_POST['slickQuizOptions']['score_as_percentage'] ) != true ) {
                    $_POST['slickQuizOptions']['score_as_percentage'] = '0';
                }

                $this->adminOptions = array_merge( $this->adminOptions, stripslashes_deep( $_POST['slickQuizOptions'] ) );
                update_option( $this->adminOptionsName, $this->adminOptions );

                add_user_meta( $current_user->ID, 'slickquiz_ignore_notice_disabled', 'true', true );

                $updated = true;
            }
        }

        function show_alert_messages()
        {
            global $updated;
            if ( $updated )
                echo '<div id="message" class="updated"><p>您的调查问卷已经更新.</p></div>';
        }

    }
}

if ( class_exists( 'SlickQuizOptions' ) ) {
    global $slickQuizOptions;
    $slickQuizOptions = new SlickQuizOptions();
}

?>

<div class="wrap slickQuiz quizOptions">
    <?php $slickQuizOptions->show_alert_messages(); ?>

    <h2>SlickQuiz 默认选项</h2>

    <form method="post" action="<?php echo $_SERVER["REQUEST_URI"]; ?>">
        <h3 class="title">设置</h3>
        <p>使用下面的区域设置按钮，标签，和消息的副本.</p>
        <table class="form-table">
            <tbody>
                <tr valign="top">
                    <th scope="row" style="width: 250px;">
                        <label for="slickQuizOptions[start_button_text]"><em>开始</em> 按钮文本</label>
                    </th>
                    <td>
                        <input  type="text" name="slickQuizOptions[start_button_text]" class="regular-text"
                            value="<?php _e( apply_filters( 'format_to_edit', $slickQuizOptions->get_admin_option( 'start_button_text' ) ), 'SlickQuizPlugin' ); ?>" />
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row" style="width: 250px;">
                        <label for="slickQuizOptions[question_count_text]"><em>问题数</em> 标签</label>
                    </th>
                    <td>
                        <input  type="text" name="slickQuizOptions[question_count_text]" class="regular-text"
                            value="<?php _e( apply_filters( 'format_to_edit', $slickQuizOptions->get_admin_option( 'question_count_text' ) ), 'SlickQuizPlugin' ); ?>" />
                            <br /><small><em>编号格式及问题. <code>%current</code> 和 <code>%total</code> 为占位符，将输出相应的值。
                            <br />仅在启用"显示问题数?"时显示.</em></small>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row" style="width: 250px;">
                        <label for="slickQuizOptions[question_template_text]"><em>问题模板</em> 文本</label>
                    </th>
                    <td>
                        <input  type="text" name="slickQuizOptions[question_template_text]" class="regular-text"
                            value="<?php _e( apply_filters( 'format_to_edit', $slickQuizOptions->get_admin_option( 'question_template_text' ) ), 'SlickQuizPlugin' ); ?>" />
                            <br /><small><em>The format of the question number and question. <code>%count</code> and <code>%text</code> are placeholders that will output the appropriate values.
                            <br /><code>%count</code> will only be available if "Display the question number?" is enabled</em></small>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="slickQuizOptions[check_answer_text]"><em>提交答案</em> 按钮文本</label>
                    </th>
                    <td>
                        <input type="text" name="slickQuizOptions[check_answer_text]" class="regular-text" required
                            value="<?php _e( apply_filters( 'format_to_edit', $slickQuizOptions->get_admin_option( 'check_answer_text' ) ), 'SlickQuizPlugin' ); ?>" />
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="slickQuizOptions[next_question_text]"><em>下一个问题</em> 按钮文本</label>
                    </th>
                    <td>
                        <input type="text" name="slickQuizOptions[next_question_text]" class="regular-text" required
                            value="<?php _e( apply_filters( 'format_to_edit', $slickQuizOptions->get_admin_option( 'next_question_text' ) ), 'SlickQuizPlugin' ); ?>" />
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="slickQuizOptions[back_button_text]"><em>返回</em> 按钮文本</label>
                    </th>
                    <td>
                        <input type="text" name="slickQuizOptions[back_button_text]" class="regular-text"
                            value="<?php _e( apply_filters( 'format_to_edit', $slickQuizOptions->get_admin_option( 'back_button_text' ) ), 'SlickQuizPlugin' ); ?>" /><br />
                        <small><em>留空将不显示返回按钮.</em></small></label>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="slickQuizOptions[complete_button_text]"><em>问卷完成</em> 按钮文本</label><br/>
                        <small><em>例如 "查看您的结果!"</em></small></label>
                    </th>
                    <td>
                        <input type="text" name="slickQuizOptions[complete_button_text]" class="regular-text"
                            value="<?php _e( apply_filters( 'format_to_edit', $slickQuizOptions->get_admin_option( 'complete_button_text' ) ), 'SlickQuizPlugin' ); ?>" /><br />
                        <small><em>留空将不显示“下一问题”按钮.</em></small></label>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="slickQuizOptions[try_again_text]"><em>再试一次</em> 按钮文本</label>
                    </th>
                    <td>
                        <input type="text" name="slickQuizOptions[try_again_text]" class="regular-text"
                            value="<?php _e( apply_filters( 'format_to_edit', $slickQuizOptions->get_admin_option( 'try_again_text' ) ), 'SlickQuizPlugin' ); ?>" /><br />
                        <small><em>留空将不显示“再试一次”按钮.</em></small></label>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="slickQuizOptions[your_score_text]"><em>得分</em> 结果文本</label>
                    </th>
                    <td>
                        <input type="text" name="slickQuizOptions[your_score_text]" class="regular-text"
                            value="<?php _e( apply_filters( 'format_to_edit', $slickQuizOptions->get_admin_option( 'your_score_text' ) ), 'SlickQuizPlugin' ); ?>" />
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="slickQuizOptions[score_template_text]"><em>得分模板</em> 文本</label>
                    </th>
                    <td>
                        <input type="text" name="slickQuizOptions[score_template_text]" class="regular-text"
                            value="<?php _e( apply_filters( 'format_to_edit', $slickQuizOptions->get_admin_option( 'score_template_text' ) ), 'SlickQuizPlugin' ); ?>" />
                            &nbsp;&nbsp;&nbsp;&nbsp; <input type="checkbox" name="slickQuizOptions[score_as_percentage]" value="1"
                            <?php $slickQuizOptions->get_admin_option( 'score_as_percentage' ) == '1' ? print_r('checked="checked"') : ''; ?> /> 显示得分率（百分比）
                            <br /><small><em>最终得分的格式. <code>%score</code> 和 <code>%total</code> 为占位符，将输出相应的值。<br/>如果启用“显示得分率，你可能需要适当调整评分模板文本。</em></small>
</em></small>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="slickQuizOptions[your_ranking_text]"><em>排行</em> 结果文本</label>
                    </th>
                    <td>
                        <input type="text" name="slickQuizOptions[your_ranking_text]" class="regular-text"
                            value="<?php _e( apply_filters( 'format_to_edit', $slickQuizOptions->get_admin_option( 'your_ranking_text' ) ), 'SlickQuizPlugin' ); ?>" />
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="slickQuizOptions[disabled_quiz_message]">如果问卷被 <em>禁用</em>显示消息:</label>
                    </th>
                    <td>
                        <input type="text" name="slickQuizOptions[disabled_quiz_message]" class="large-text"
                            value="<?php _e( apply_filters( 'format_to_edit', $slickQuizOptions->get_admin_option( 'disabled_quiz_message' ) ), 'SlickQuizPlugin' ); ?>" />
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="slickQuizOptions[missing_quiz_message]">如果问卷被 <em>删除</em>显示消息:</label>
                    </th>
                    <td>
                        <input type="text" name="slickQuizOptions[missing_quiz_message]" class="large-text"
                            value="<?php _e( apply_filters( 'format_to_edit', $slickQuizOptions->get_admin_option( 'missing_quiz_message' ) ), 'SlickQuizPlugin' ); ?>" />
                    </td>
                </tr>
            </tbody>
        </table>

        <h3 class="title">功能设置</h3>
        <p>调整下面的选项来改变你的问卷行为.</p>
        <table class="form-table">
            <tbody>
                <tr valign="top">
                    <th scope="row" style="width: 250px;">
                        <label for="slickQuizOptions[number_of_questions]">要显示的问题的数量？</label>
                    </th>
                    <td>
                        <input type="text" name="slickQuizOptions[number_of_questions]" class="regular-text"
                            value="<?php _e( apply_filters( 'format_to_edit', $slickQuizOptions->get_admin_option( 'number_of_questions' ) ), 'SlickQuizPlugin' ); ?>" />
                        <br /><small><em>如果留空，则加载所有问题。<br />如果设置，您可能希望还能够随机的（问题）排序，以确保您获得混合组问题每个页面加载.</em></small>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="slickQuizOptions[skip_start_button]">跳过“开始”按钮？</label>
                    </th>
                    <td>
                        <input type="radio" name="slickQuizOptions[skip_start_button]" value="0"
                            <?php $slickQuizOptions->get_admin_option( 'skip_start_button' ) == '0' ? print_r('checked="checked"') : ''; ?> /> 否 &nbsp;
                        <input type="radio" name="slickQuizOptions[skip_start_button]" value="1"
                            <?php $slickQuizOptions->get_admin_option( 'skip_start_button' ) == '1' ? print_r('checked="checked"') : ''; ?> /> 是
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="slickQuizOptions[random_sort_questions]">随机排序问题？</label>
                    </th>
                    <td>
                        <input type="radio" name="slickQuizOptions[random_sort_questions]" value="0"
                            <?php $slickQuizOptions->get_admin_option( 'random_sort_questions' ) == '0' ? print_r('checked="checked"') : ''; ?> /> 否 &nbsp;
                        <input type="radio" name="slickQuizOptions[random_sort_questions]" value="1"
                            <?php $slickQuizOptions->get_admin_option( 'random_sort_questions' ) == '1' ? print_r('checked="checked"') : ''; ?> /> 是
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="slickQuizOptions[random_sort_answers]">随机排序答案？</label>
                    </th>
                    <td>
                        <input type="radio" name="slickQuizOptions[random_sort_answers]" value="0"
                            <?php $slickQuizOptions->get_admin_option( 'random_sort_answers' ) == '0' ? print_r('checked="checked"') : ''; ?> /> 否 &nbsp;
                        <input type="radio" name="slickQuizOptions[random_sort_answers]" value="1"
                            <?php $slickQuizOptions->get_admin_option( 'random_sort_answers' ) == '1' ? print_r('checked="checked"') : ''; ?> /> 是
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="slickQuizOptions[disable_next]">如果没有答案被选定则禁止提交？</label>
                    </th>
                    <td>
                        <input type="radio" name="slickQuizOptions[disable_next]" value="0"
                            <?php $slickQuizOptions->get_admin_option( 'disable_next' ) == '0' ? print_r('checked="checked"') : ''; ?> /> 否 &nbsp;
                        <input type="radio" name="slickQuizOptions[disable_next]" value="1"
                            <?php $slickQuizOptions->get_admin_option( 'disable_next' ) == '1' ? print_r('checked="checked"') : ''; ?> /> 是
                    </td>
                </tr>
                <tr id="responses" valign="top">
                    <th scope="row">
                        <label for="slickQuizOptions[perquestion_responses]">显示正确/错误的 <em>每个问题后的</em>响应消息?</label>
                    </th>
                    <td>
                        <input type="radio" name="slickQuizOptions[perquestion_responses]" value="0"
                            <?php $slickQuizOptions->get_admin_option( 'perquestion_responses' ) == '0' ? print_r('checked="checked"') : ''; ?> /> 否 &nbsp;
                        <input type="radio" name="slickQuizOptions[perquestion_responses]" value="1"
                            <?php $slickQuizOptions->get_admin_option( 'perquestion_responses' ) == '1' ? print_r('checked="checked"') : ''; ?> /> 是
                        &nbsp;&nbsp;&nbsp;&nbsp; <input type="checkbox" name="slickQuizOptions[perquestion_response_answers]" value="1"
                            <?php $slickQuizOptions->get_admin_option( 'perquestion_response_answers' ) == '1' ? print_r('checked="checked"') : ''; ?> /> 同时显示答案选项
                        <br /><small><em>选择“是”将提交答案后显示结果消息.<br />启用时，同时启用“显示选项”将包括答案选项与结果.</em></small>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="slickQuizOptions[completion_responses]">显示正确/错误的 <em>在测试完成</em>响应消息?</label>
                    </th>
                    <td>
                        <input type="radio" name="slickQuizOptions[completion_responses]" value="0"
                            <?php $slickQuizOptions->get_admin_option( 'completion_responses' ) == '0' ? print_r('checked="checked"') : ''; ?> /> 否 &nbsp;
                        <input type="radio" name="slickQuizOptions[completion_responses]" value="1"
                            <?php $slickQuizOptions->get_admin_option( 'completion_responses' ) == '1' ? print_r('checked="checked"') : ''; ?> /> 是
                        <br /><small><em>选择“是”在测试结束将显示选项和结果的消息.</em></small>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="slickQuizOptions[question_count]">显示完成进度?</label>
                        <br /><small><em>例如： "问题：3/10"</em></small>
                    </th>
                    <td>
                        <input type="radio" name="slickQuizOptions[question_count]" value="0"
                            <?php $slickQuizOptions->get_admin_option( 'question_count' ) == '0' ? print_r('checked="checked"') : ''; ?> /> 否 &nbsp;
                        <input type="radio" name="slickQuizOptions[question_count]" value="1"
                            <?php $slickQuizOptions->get_admin_option( 'question_count' ) == '1' ? print_r('checked="checked"') : ''; ?> /> 是
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="slickQuizOptions[question_number]">显示问题数量?</label>
                        <br /><small><em>例如：1-1。显示的是什么颜色的？"</em></small>
                    </th>
                    <td>
                        <input type="radio" name="slickQuizOptions[question_number]" value="0"
                            <?php $slickQuizOptions->get_admin_option( 'question_number' ) == '0' ? print_r('checked="checked"') : ''; ?> /> 否 &nbsp;
                        <input type="radio" name="slickQuizOptions[question_number]" value="1"
                            <?php $slickQuizOptions->get_admin_option( 'question_number' ) == '1' ? print_r('checked="checked"') : ''; ?> /> 是
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="slickQuizOptions[disable_score]">不显示得分？</label>
                    </th>
                    <td>
                        <input type="radio" name="slickQuizOptions[disable_score]" value="0"
                            <?php $slickQuizOptions->get_admin_option( 'disable_score' ) == '0' ? print_r('checked="checked"') : ''; ?> /> 否 &nbsp;
                        <input type="radio" name="slickQuizOptions[disable_score]" value="1"
                            <?php $slickQuizOptions->get_admin_option( 'disable_score' ) == '1' ? print_r('checked="checked"') : ''; ?> /> 是
                        <br /><small><em>注：如果启用“保存用户得分”得分仍将被保存，.</em></small>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="slickQuizOptions[disable_ranking]">不显示得分排名结果</label>
                    </th>
                    <td>
                        <input type="radio" name="slickQuizOptions[disable_ranking]" value="0"
                            <?php $slickQuizOptions->get_admin_option( 'disable_ranking' ) == '0' ? print_r('checked="checked"') : ''; ?> /> 否 &nbsp;
                        <input type="radio" name="slickQuizOptions[disable_ranking]" value="1"
                            <?php $slickQuizOptions->get_admin_option( 'disable_ranking' ) == '1' ? print_r('checked="checked"') : ''; ?> /> 是
                        <br /><small><em>注: 如果禁用, 排行结果将不再生成.</em></small>
                    </td>
                </tr>
            </tbody>
        </table>

        <h3 class="title">得分保存选项</h3>
        <table class="form-table">
            <tbody>
                <tr valign="top">
                    <th scope="row" style="width: 250px;">
                        <label for="slickQuizOptions[save_scores]">保存用户得分?</label>
                    </th>
                    <td>
                        <input type="radio" name="slickQuizOptions[save_scores]" value="0"
                            <?php $slickQuizOptions->get_admin_option( 'save_scores' ) == '0' ? print_r('checked="checked"') : ''; ?> /> 否 &nbsp;
                        <input type="radio" name="slickQuizOptions[save_scores]" value="1"
                            <?php $slickQuizOptions->get_admin_option( 'save_scores' ) == '1' ? print_r('checked="checked"') : ''; ?> /> 是
                        <br /><small><em>选择“是”将要求没有登陆用户，在进行问卷之前输入他们的用户名.</em></small>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="slickQuizOptions[name_label]"><em>用户名</em> 标签文本</label>
                    </th>
                    <td>
                        <input type="text" name="slickQuizOptions[name_label]" class="regular-text"
                            value="<?php _e( apply_filters( 'format_to_edit', $slickQuizOptions->get_admin_option( 'name_label' ) ), 'SlickQuizPlugin' ); ?>" />
                        <br /><small><em>如果保存得分被启用，并且用户没有登录。这个字段将显示<br />
                           如果保存用户得分被启用，用户名将被永久保存</em></small>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="slickQuizOptions[email_label]"><em>用户邮箱</em> 标签文字</label>
                    </th>
                    <td>
                        <input type="text" name="slickQuizOptions[email_label]" class="regular-text"
                            value="<?php _e( apply_filters( 'format_to_edit', $slickQuizOptions->get_admin_option( 'email_label' ) ), 'SlickQuizPlugin' ); ?>" />
                        <br /><small><em>如果为空，没有电子邮件字段将显示和电子邮件地址将不会被储存.<br />如果保存得分被启用，并且用户没有登录。这个字段将显示.</em></small>
                    </td>
                </tr>
            </tbody>
        </table>

        <h3 class="title">分享选项</h3>
        <table class="form-table">
            <tbody>
                <tr valign="top">
                    <th scope="row" style="width: 250px;">
                        <label for="slickQuizOptions[share_links]">启用分享（Twitter，Facebook和电子邮件）按钮？</label>
                    </th>
                    <td>
                        <input type="radio" name="slickQuizOptions[share_links]" value="0"
                            <?php $slickQuizOptions->get_admin_option( 'share_links' ) == '0' ? print_r('checked="checked"') : ''; ?> /> 否 &nbsp;
                        <input type="radio" name="slickQuizOptions[share_links]" value="1"
                            <?php $slickQuizOptions->get_admin_option( 'share_links' ) == '1' ? print_r('checked="checked"') : ''; ?> /> 是
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="slickQuizOptions[share_message]">分享消息:</label>
                    </th>
                    <td>
                        <input type="text" name="slickQuizOptions[share_message]" class="regular-text"
                            value="<?php _e( apply_filters( 'format_to_edit', $slickQuizOptions->get_admin_option( 'share_message' ) ), 'SlickQuizPlugin' ); ?>" />
                        <br /><small><em>您可以使用下面的简码插入问卷名称 [NAME], 得分 [SCORE], 以及 排行 [RANK].</em></small>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="slickQuizOptions[twitter_account]">Twitter 用户名使用的分享按钮:</label>
                    </th>
                    <td>
                        <input type="text" name="slickQuizOptions[twitter_account]" class="regular-text"
                            value="<?php _e( apply_filters( 'format_to_edit', $slickQuizOptions->get_admin_option( 'twitter_account' ) ), 'SlickQuizPlugin' ); ?>" />
                        <br /><span left-pos="0|10" right-pos="0|10" space="">你不</span><span left-pos="11|19" right-pos="11|19" space="">需要包含</span><span left-pos="31|1" right-pos="31|1" space="">@</span><span left-pos="33|6" right-pos="33|6" space="">符号</span><span left-pos="39|1" right-pos="39|1" space="">。</span></td>
                    </td>
                </tr>
            </tbody>
        </table>

        <h3 class="title">其它</h3>
        <table class="form-table">
            <tbody>
                <tr valign="top">
                    <th scope="row" style="width: 250px;">
                        <label for="slickQuizOptions[no_filter_quizzes]">在调查问卷中启用WordPress的垃圾过滤功能？</label>
                    </th>
                    <td>
                        <input type="radio" name="slickQuizOptions[no_filter_quizzes]" value="0"
                            <?php $slickQuizOptions->get_admin_option( 'no_filter_quizzes' ) == '0' ? print_r('checked="checked"') : ''; ?> /> 否 &nbsp;
                        <input type="radio" name="slickQuizOptions[no_filter_quizzes]" value="1"
                            <?php $slickQuizOptions->get_admin_option( 'no_filter_quizzes' ) == '1' ? print_r('checked="checked"') : ''; ?> /> 是
                        <br /><small><em>Enabling fitlers allows for the inclusion of shortcodes and other plugin hooks.<br/>如果你的问卷显示异常，请禁用此选项</em></small>
                    </td>
                </tr>
            </tbody>
        </table>

        <?php do_action( 'slickquiz_after_options', $slickQuizOptions ); ?>

        <p class="submit">
            <input type="submit" name="submit" id="submit" class="button-primary" value="<?php _e('更新选项', 'SlickQuizPlugin') ?>" />
        </p>
    </form>
</div>
