<?php
require_once('cfg.php');
require_once(SITEROOT . '/common/function.php');
require_once(SITEROOT . '/common/form.php');

$act=f('act','g');

if($act=='login') {
	$arr=pFormCfg('/form/login.formCfg');
	formReturnJson($arr);
	$sqlArr=array (
		'asql' =>
		array (
			'type' => 'select',
			'tbl' => 'member',
			'fld' => 'userName,userRole,pwd',
			'where' =>
			array (
				'userName' => array(),
				'pwd' => array(),
			)
		),
		'stmt' =>
		array (
			'userName' => f('userName'),
			'pwd' => f('pwd'),
		),
	);
	$rs=exeCmd($sqlArr,'array');
	if(count($rs)==0) {
		$msg='账号密码有误,请重新输入';
		$reUrl='';
	}else{
		loginSession($rs[0]['userName'],$rs[0]['pwd'],$rs[0]['userRole']);
		$msg='';
		$reUrl='/member/';
	}
	echo json_encode(array('alert'=>$msg,'reUrl'=>$reUrl));
	die();
}

if($act=='reg') {
	$arr=pFormCfg('/form/reg.formCfg');
	formReturnJson($arr);
	if(!chkSubmitChkCode(f('chkCode'))) {
		echo json_encode(array('alert'=>'验证码不正确，请重新输入'));
		die();
	}
	$sqlArr=array (
		'sql' => 'select count(id) from member where userName=@userName',
		'stmt' =>
		array (
			'userName' => f('userName'),
		)
	);
	$rsNum=exeCmd($sqlArr,'value');
	if($rsNum>0) {
		echo json_encode(array('alert'=>'用户名已存在，请重新输入'));
		die();
	}

	if(!isne(f('email'))) {
		$sqlArr=array (
			'sql' => 'select count(id) from member where email=@email',
			'stmt' =>
			array (
				'userName' => f('email'),
			)
		);
		$rsNum=(int)exeCmd($sqlArr,'value');
		if($rsNum>0) {
			echo json_encode(array('alert'=>'电子邮件已存在，请重新输入'));
			die();
		}
	}

	$sqlArr=array (
		'asql' =>
		array (
			'type' => 'insert',
			'tbl' => 'member',
			'fld' =>
			array (
				'editTime' => '',
				'userName' => '',
				'email' => '',
				'userRole' => '',
				'pwd' => '',
				'userDesc' => '',
			),
		),
		'stmt' =>
		array (
			'editTime' =>date("Y-m-d H:i:s" ,time()),
			'userName' => f('userName'),
			'email' => f('email'),
			'userRole' => array(f('userRole'),'i'),
			'pwd' => f('pwd'),
			'userDesc' => serialize(f('userDesc')),
		),
	);
	//var_dump($_POST);die();
	exeCmd($sqlArr);
	loginSession(f('userName'),f('pwd'),f('userRole'));
	echo json_encode(array('reUrl'=>'/member/'));
	die();
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<?php
$g_head['css']=array('/css/common.css');
$g_head['js']=array('/js/jquery-1.4.2.min.js','/js/chkForm.js','/js/ajaxForm.js','/js/common.js');
echo pageHead();
?>
<style type="text/css">

.loginDiv .top{height:60px;background:url(/images/reg.png) no-repeat -7px -80px;}
.loginDiv .dForm{border:1px #ccc solid;border-top:0;margin:0px 2px 0px 3px;}
.loginDiv .formTbl th{font-weight:normal;color:#666;}
.loginDiv .formTbl input{width:250px;border:1px #ccc solid;}
.loginDiv .formTbl .sub{width:100px;height:30px;border:0;background:url(/images/reg.png) no-repeat -8px -158px;font-size:14px;font-weight:bold;color:white;}

.regDiv .top{height:60px;background:url(/images/reg.png) no-repeat -5px 0px;}
.regDiv .dForm{border:1px #ccc solid;border-top:0;margin:0px 2px 0px 3px;}
.regDiv .formTbl th{font-weight:normal;color:#666;}
.regDiv .formTbl .inp{border:1px #ccc solid;}
.regDiv .formTbl .sub{width:100px;height:30px;border:0;background:url(/images/reg.png) no-repeat -129px -158px;font-size:14px;font-weight:bold;color:white;}
</style>
</head>
<?php require_once('top.php'); ?>

<div class="grid_12 loginDiv">
	<div class="top">&#160;</div>
	<div class="dForm">
		<?php echo file_get_contents(SITEROOT.'/form/login.html');?>
	</div>
</div>

<div class="grid_12 regDiv">
	<div class="top">&#160;</div>
	<div class="dForm">
		<?php echo file_get_contents(SITEROOT.'/form/reg.html');?>
	</div>
</div>

<div class="clear"></div>
<div class="blankBar"></div>

<?php require_once('bot.php'); ?>