<?xml version='1.0'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output indent="no" omit-xml-declaration="yes" method="html"/>
<xsl:param name="u"/>
<xsl:param name="showTj">1</xsl:param>
<xsl:template match="/">
<div class="kechenBox">
<xsl:if test="$showTj=1">
	<div class="kechenTabs">
		<div class="tabs-trigger">
			<a href="javascript:void(0)" class="current">重点课程推荐</a>
			<a href="javascript:void(0)">特惠课程</a>
			<div class="clear"></div>
		</div>
		<div class="tabs-panel">
			<div class="panel">
				<ul>
				<li class="th col1">课程名称</li>
				<li class="th col2">发布时间</li>
				<li class="th col3">上课地点</li>
				<li class="th col4">&#160;</li>
				<xsl:for-each select="/root/data/row[position() &lt;=8 and @isTj=1]">
					<xsl:apply-templates select="/root/data/row[@cid=current()/@cid]"/>
				</xsl:for-each>
				<li class="clear"></li>
				</ul>
			</div>
			<div class="panel">
				<ul>
				<li class="th col1">课程名称</li>
				<li class="th col2">发布时间</li>
				<li class="th col3">上课地点</li>
				<li class="th col4">&#160;</li>
				<xsl:for-each select="/root/data/row[position() &lt;=8 and @isSale=1]">
					<xsl:apply-templates select="/root/data/row[@cid=current()/@cid]"/>
				</xsl:for-each>
				<li class="clear"></li>
				</ul>
			</div>
		</div>
	</div>
</xsl:if>

	<div class="catalogDiv">
		<div class="ti"><a href="javascript:void(0)">全部培训课程</a></div>
		<ul>
			<xsl:for-each select="/root/catalog/item">
				<li class="hli"><a href="?u={$u}#listBar{@cid}"><xsl:value-of select="@cName"/></a></li>
			</xsl:for-each>
			<li class="clear"></li>
		</ul>
	</div>

	<dl class="boxItem">
		<xsl:apply-templates select="/root/catalog/item"/>
	</dl>
</div>
</xsl:template>

<xsl:template match="catalog/item">
<dt><a name="listBar{@cid}"></a><xsl:value-of select="@cName"/></dt>
<dd>
	<ul>
		<li class="th col1">课程名称</li>
		<li class="th col2">发布时间</li>
		<li class="th col3">上课地点</li>
		<li class="th col4">&#160;</li>
		<xsl:apply-templates select="/root/data/row[@cid=current()/@cid]"/>
		<li class="clear"></li>
	</ul>
</dd>
</xsl:template>

<xsl:template match="/root/data/row">
	<li class="hli col1"><a href="/kechen.php?id={@id}" target="_blank"><xsl:value-of select="@title"/></a></li>
	<li class="hli col2"><xsl:value-of select="substring-before(@editTime,' ')"/></li>
	<li class="hli col3"><xsl:value-of select="contDesc/@上课地点"/></li>
	<li class="hli col4"><a href="/kechen.php?id={@id}#bm" target="_blank" class="bm">&#160;</a></li>
</xsl:template>

</xsl:stylesheet>