<?xml version='1.0'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output indent="no" omit-xml-declaration="yes" method="html"/>
<xsl:param name="siteName"/>
<xsl:param name="siteUrl"/>

<xsl:template match="/">
<div class="kechenCont">
	<xsl:apply-templates/>
</div>
</xsl:template>

<xsl:template match="row">
	<div class="ti"><xsl:value-of select="@title"/></div>
	<div class="row1 clearfix">
		<div class="img"><img src="{@b_logo}"/></div>
		<ul class="ulItem">
			<li>
				<span>学费：</span> <xsl:value-of select="contDesc/@学费"/>&#160;&#160;&#160;
				<span class="bfont">培训通优惠价格：</span> <span class="bfont"><xsl:value-of select="contDesc/@优惠价格"/></span>
			</li>
			<li>
				<span>开课时间：</span> <xsl:value-of select="contDesc/@开课时间"/>&#160;&#160;&#160;
				<span>学时：</span> <xsl:value-of select="contDesc/@学时"/>&#160;&#160;&#160;
				<span>浏览量：</span> <xsl:value-of select="@viewNum"/>
			</li>
			<li>
				<span>授课机构：</span> <a href="/school/?id={@b_id}"><xsl:value-of select="@b_title"/></a>
			</li>
			<li>
				<span>上课地点：</span> <xsl:value-of select="contDesc/@上课地点"/>
			</li>
			<li class="btnList">
				<a class="btn1" href="http://wpa.qq.com/msgrd?V=1&amp;Uin={@b_qq}&amp;Exe=QQ&amp;Site={$siteName}:{$siteUrl}&amp;Menu=Yes">&#160;</a>
				<a class="btn2" href="?id={@id}#bm">&#160;</a>
				<div class="clear"></div>
			</li>
			<li class="phone">
				联系电话： <xsl:value-of select="b_contDesc/@联系电话"/>
			</li>
		</ul>
	</div>
	<div class="cont">
		<div class="tab"><span>详细介绍</span></div>
		<div class="sti">
			<ul>
				<li><span>【联系地址】：</span><xsl:value-of select="b_contDesc/@联系地址"/></li>
				<li><span>【交通线路】：</span><xsl:value-of select="b_contDesc/@交通线路"/></li>
				<li><span>【邮政编码】：</span><xsl:value-of select="b_contDesc/@邮政编码"/></li>
				<li><span>【联 系 人】：</span><xsl:value-of select="b_contDesc/@联系人"/></li>
			</ul>
		</div>
	</div>
	<div class="content">
		<xsl:value-of select="@content" disable-output-escaping="yes"/>
	</div>

	<a name="bm"></a>

	<div class="ordersDiv">
		<div class="tibar">
			在线留言/报名
		</div>
		<div class="formDiv">
			{%ordersForm%}
		</div>
	</div>
</xsl:template>

</xsl:stylesheet>