<?xml version='1.0'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output indent="no" omit-xml-declaration="no" method="html" encoding="utf-8"/>
<xsl:param name="linkAdd"/>
<xsl:template match="/">
	<div class="kechenPan">
		<div class="top">
			<a href="javascript:void()" class="topa _menu" pos="2,0,-10">&#160;</a>
			<xsl:call-template name="menu">
				<xsl:with-param name="pid">0</xsl:with-param>
			</xsl:call-template>
		</div>
		<div class="middle">
			<dl>
				<xsl:apply-templates select="/list/item[@isTj=1]"/>
			</dl>
		</div>
		<div class="bottom">&#160;</div>
	</div>
</xsl:template>

<xsl:template match="/list/item">
	<dt>
		<a href="{$linkAdd}cid={@id}" class="dta _menu" pos="2,5,-10"><xsl:value-of select="@cName"/></a>
		<xsl:call-template name="menu">
			<xsl:with-param name="pid"><xsl:value-of select="@id"/></xsl:with-param>
		</xsl:call-template>
	</dt>
	<dd>
		<ul class="ddul">
			<xsl:for-each select="item[@isTj=1]">
				<li class="hli">
				<a href="{$linkAdd}cid={@id}" class="dda">
				<xsl:if test="item">
					<xsl:attribute name="class">dda hasChild _menu</xsl:attribute>
					<xsl:attribute name="pos">2,10,-12</xsl:attribute>
				</xsl:if>
				<xsl:value-of select="@cName"/></a>
				<xsl:if test="item">
					<xsl:call-template name="menu">
						<xsl:with-param name="pid"><xsl:value-of select="@id"/></xsl:with-param>
					</xsl:call-template>
				</xsl:if>
				</li>
			</xsl:for-each>
			<li class="clear"></li>
		</ul>
	</dd>
</xsl:template>

<xsl:template name="menu">
	<xsl:param name="pid"/>
	<div class="childDiv">
		<div class="menuTop">&#160;</div>
		<div class="menuMiddle">
			<div class="arrow">&#160;</div>
			<div>
				<xsl:if test="$pid=0">
					<xsl:for-each select="/list/item">
						<a href="{$linkAdd}cid={@id}"><xsl:value-of select="@cName"/></a>
					</xsl:for-each>
					<a href="{$linkAdd}">更多>></a>
				</xsl:if>

				<xsl:if test="$pid &gt; 0">
					<xsl:for-each select="//item[@id=$pid]/item">
						<a href="{$linkAdd}cid={@id}"><xsl:value-of select="@cName"/></a>
					</xsl:for-each>
					<a href="{$linkAdd}?cid={$pid}">更多>></a>
				</xsl:if>
				<div class="clear"></div>
			</div>
		</div>
		<div class="menuBottom">&#160;</div>
	</div>
</xsl:template>

</xsl:stylesheet>