<?xml version='1.0'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output indent="no" omit-xml-declaration="yes" method="html"/>
<xsl:param name="siteName"/>
<xsl:param name="siteUrl"/>
<xsl:template match="/">
<div class="kechenList">
	<ul class="tiul">
		<li class="hli col1">培训课程 / 名称</li>
		<li class="hli col2">地区</li>
		<li class="hli col3">在线咨询</li>
		<li class="hli col4">网上报名 </li>
		<li class="clear"></li>
	</ul>
	<xsl:apply-templates/>
	<div class="spBar clearfix">{%spbar%}</div>
</div>
</xsl:template>

<xsl:template match="row">
<ul>
	<xsl:attribute name="class">
	<xsl:choose>
		<xsl:when test="position() mod 2=0">listul odd</xsl:when>
		<xsl:otherwise>listul</xsl:otherwise>
	</xsl:choose>
	</xsl:attribute>
	<li class="hli col1">
		<div class="ti">
			<a href="?id={@id}"><xsl:value-of select="@title"/></a>
		</div>
		<div class="price">
			<span>学费：</span> <xsl:value-of select="contDesc/@学费"/>&#160;&#160;&#160;
			<span>培训通优惠价格：</span> <xsl:value-of select="contDesc/@优惠价格"/>&#160;&#160;&#160;
		</div>
		<div class="addr">
			<span>上课地点：</span>
			<xsl:value-of select="contDesc/@上课地点"/>
		</div>
		<div class="school">
			<span>学校名称：</span>
			<a href="/school/?id={@b_id}"><xsl:value-of select="@b_title"/></a>
		</div>
	</li>
	<li class="hli col2"><xsl:value-of select="@cityName"/></li>
	<li class="hli col3">
		<a href="http://wpa.qq.com/msgrd?V=1&amp;Uin={@b_qq}&amp;Exe=QQ&amp;Site={$siteName}:{$siteUrl}&amp;Menu=Yes">&#160;</a>
	</li>
	<li class="hli col4">
		<a href="?id={@id}#bm">&#160;</a>
	</li>
	<li class="clear"></li>
</ul>
</xsl:template>

</xsl:stylesheet>