<?xml version='1.0'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output indent="no" omit-xml-declaration="yes" method="html"/>
<xsl:param name="siteName"/>
<xsl:param name="siteUrl"/>
<xsl:template match="/">
<div class="schoolList">
	<ul class="tiul">
		<li class="hli col1">机构名称 / 位置</li>
		<li class="hli col2">课程类型</li>
		<li class="hli col3">在线咨询</li>
		<li class="hli col4">网上报名 </li>
		<li class="clear"></li>
	</ul>
	<xsl:apply-templates/>
	<div class="spBar clearfix">{%spbar%}</div>
</div>
</xsl:template>

<xsl:template match="row">
<ul>
	<xsl:attribute name="class">
	<xsl:choose>
		<xsl:when test="position() mod 2=0">listul odd</xsl:when>
		<xsl:otherwise>listul</xsl:otherwise>
	</xsl:choose>
	</xsl:attribute>
	<li class="hli col1 clearfix">
		<div class="img"><a href="/school/?id={@id}"><img src="{@logo}"/></a></div>
		<div class="tis">
			<div class="ti">
				<a href="/school/?id={@id}"><xsl:value-of select="@title"/></a>
			</div>
			<div class="school">
				<span>学校地址：</span>
				<xsl:value-of select="contDesc/@联系地址"/>
			</div>
			<div class="phone">
				<span>联系电话：</span>
				<xsl:value-of select="contDesc/@联系电话"/>
			</div>
		</div>
	</li>
	<li class="hli col2"><xsl:value-of select="@schoolCName"/></li>
	<li class="hli col3">
		<a href="http://wpa.qq.com/msgrd?V=1&amp;Uin={@qq}&amp;Exe=QQ&amp;Site={$siteName}:{$siteUrl}&amp;Menu=Yes">&#160;</a>
	</li>
	<li class="hli col4">
		<a href="/school/?id={@id}">&#160;</a>
	</li>
	<li class="clear"></li>
</ul>
</xsl:template>

</xsl:stylesheet>