<?php
/**
 * admin用户校验
 * @author yaoying
 * @version $Id: adminVerifier.class.php 43 2010-09-07 09:12:56Z xwb $
 */
class adminVerifier{
	
	var $db;
	
	function adminVerifier(){
		$this->db = XWB_plugin::getDB();
	}
	
	/**
	 * 
	 * @param string $username
	 * @param string $password
	 * @param int $questionid
	 * @param string $answer
	 * @param boolen $isuid 使用UID验证么？
	 * @return integer 大于0，则返回登录uid。否则为错误信息：
	 *    -1:UC用户不存在，或者被删除
	 *    -2:密码错
	 *    -3:安全提问错
	 *    -4:用户没有在dz注册
	 *    -5:不是管理员帐号
	 */
	function verify( $username, $password, $questionid = '', $answer = '',$isuid = 0 ){
		if ( defined('UC_API') ){
			return $this->verifyUCDZ( $username, $password, $questionid, $answer, $isuid );
		}else{
			return $this->verifyDZ( $username, $password, $questionid, $answer, $isuid );
		}
	}
	
	/**
	 * 没有UC的情况下进行是否是dz管理员的身份验证
	 * @param string $username
	 * @param string $password
	 * @param int $questionid
	 * @param string $answer
	 * @param boolen $isuid 使用UID验证么？
	 * @return integer 大于0，则返回登录uid。否则为错误信息：
	 *    -1:用户不存在，或者被删除
	 *    -2:密码错
	 *    -3:安全提问错
	 *    -5:不是管理员帐号
	 */
	function verifyDZ( $username, $password, $questionid = '', $answer = '',$isuid = 0 ){
		
		if($isuid) {
			$field = 'uid';
		} else {
			$field = 'username';
		}
		$username = mysql_real_escape_string($username);
		$md5_password = md5($password);
		$secques = $this->quescrypt($questionid, $answer);
		$member =$this->db->fetch_first("SELECT uid, username, adminid, password, secques
												FROM ". XWB_S_TBPRE. "members
												WHERE {$field} ='{$username}'");
		
		if( !$member ){
			return -1;
		}elseif( $member['password'] !== $md5_password ){
			return -2;
		}elseif( $member['secques'] !== $secques ){
			return -3;
		}elseif( $member['adminid'] != 1 ){
			return -5;
		}else{
			return (int)$member['uid'];
		}
		
	}
	
	/**
	 * 有UC的情况下进行是否是dz管理员的身份验证
	 * @param string $username
	 * @param string $password
	 * @param int $questionid
	 * @param string $answer
	 * @param boolen $isuid 使用UID验证么？
	 * @return integer 大于0，则返回登录uid。否则为错误信息：
	 *    -1:UC用户不存在，或者被删除
	 *    -2:密码错
	 *    -3:安全提问错
	 *    -4:用户没有在dz注册
	 *    -5:不是管理员帐号
	 */
	function verifyUCDZ( $username, $password, $questionid = '', $answer = '',$isuid = 0 ){
		
		require_once XWB_S_ROOT. '/uc_client/client.php';
		$ucresult = uc_user_login ($username, $password, $isuid, 1, $questionid, $answer );
		if( $ucresult[0] < 1 ){
			return $ucresult[0];
		}
		
		$uid = (int)$ucresult[0];
		$member =$this->db->fetch_first("SELECT uid, username, adminid
												FROM ". XWB_S_TBPRE. "members
												WHERE uid='{$uid}'");
		
		if( !$member ){
			return -4;
		}elseif( $member['adminid'] != 1 ){
			return -5;
		}else{
			return (int)$member['uid'];
		}
	}
	
	
	/**
	 * 根据安全提问和答案生成安全提问相关验证字段
	 * @param int $questionid
	 * @param string $answer
	 * @return string
	 */
	function quescrypt($questionid, $answer) {
		return $questionid > 0 && $answer != '' ? substr ( md5 ( $answer . md5 ( $questionid ) ), 16, 8 ) : '';
	}
	
	
	/**
	 * 仅用于本插件的安装程序
	 * @param string 安装类型标识，用于安装session校验
	 * 
	 */
	function verifyForInstall($id='xwb_default_id'){
		
		$verified = false;
		$msg = $username = $userpass = $questionid = $questionanswer = '';
		
		if (isset ( $_SESSION [XWB_CLIENT_SESSION] ['XWB_INSTALL_AUTH'] )) {
			$verify = md5 ( XWB_CLIENT_SESSION . XWB_S_CHARSET. XWB_P_ROOT .$id );
			if ($_SESSION [XWB_CLIENT_SESSION] ['XWB_INSTALL_AUTH'] != $verify) {
				unset ( $_SESSION [XWB_CLIENT_SESSION] ['XWB_INSTALL_AUTH'] );
				//$msg = 'session验证失效，请重新验证！';
			} else {
				$verified = true;
			}
		
		} else {
			
			unset ( $_SESSION [XWB_CLIENT_SESSION] ['XWB_INSTALL_AUTH'] );
			$username = ( string ) XWB_plugin::V ( 'p:username' );
			$userpass = ( string ) XWB_plugin::V ( 'p:userpass' );
			$questionid = ( int ) XWB_plugin::V ( 'p:questionid' );
			$questionanswer = ( string ) XWB_plugin::V ( 'p:questionanswer' );
			
			if ($username && $userpass) {
				$username = XWB_plugin::convertEncoding ( $username, 'UTF-8', XWB_S_CHARSET );
				$userpass = XWB_plugin::convertEncoding ( $userpass, 'UTF-8', XWB_S_CHARSET );
				$questionanswer = XWB_plugin::convertEncoding ( $questionanswer, 'UTF-8', XWB_S_CHARSET );
				
				require_once 'adminVerifier.class.php';
				$verify = new adminVerifier ();
				$result = $verify->verify ( $username, $userpass, $questionid, $questionanswer );
				if ($result < 0) {
					switch ($result){
						case '-1':
							$msg = '用户不存在，请重新输入！';
							break;
						case '-2':
							$msg = '密码错误，请重新输入！';
							break;
						case '-3':
							$msg = '安全提问验证失败，请重新输入！';
							break;
						case '-4':
							$msg = '用户在论坛没有注册，请重新输入！';
							break;
						case '-5':
							$msg = '不是管理员帐号，请重新输入！';
							break;
						default:
							$msg = '验证错误，请重新输入！';
							break;
							
					}
				
				} else {
					$_SESSION [XWB_CLIENT_SESSION] ['XWB_INSTALL_AUTH'] = md5 ( XWB_CLIENT_SESSION . XWB_S_CHARSET. XWB_P_ROOT .$id );
					$verified = true;
				}
			}
		}
		
		if ($verified === false) {
			include dirname(__FILE__) . '/tpl/pwdverify.php';
			exit ();
		}
		
		
	}
	
}