<?php
class xwb_uninstall {
	var $v = array();
	var $tpl_dir = "";
	var $error = false;
	var $tips = array();
	function xwb_uninstall(){
		global $_xwb_install;
		$this->tpl_dir = dirname(__FILE__).'/tpl';
		$this->v = $_xwb_install;
		$this->_chkIsAdmin();
	}
	
	function _getDirNames($dir){
		$d = dir($dir."/");
		$dn	= array();
		while (false !== ($f = $d->read())) {
		   if(is_dir($dir."/".$f) && $f!='.' && $f!='..') $dn[]=$f;
		}
		$d->close();
		return $dn;
	}
	
	function getCfg(){
		$cfg = array();
		$ver = substr(XWB_S_VERSION,0,3);
		
		$cfg['delete_data']		= array();
		$cfg['delete_data'][]	= 'xwb.php';
		
		$cfg['rervert_data']	= array();
		$cfg['rervert_data'][]	= 'include/common.inc.php';
		$cfg['rervert_data'][]	= 'include/newthread.inc.php';
		$cfg['rervert_data'][]	= 'include/newreply.inc.php';
		$cfg['rervert_data'][]	= 'viewthread.php';
		//根据不同的版本配置不同的HAC(PHP部分)
		switch ($ver) {
			case '6.0' : 
				$cfg['rervert_data'][]	= 'include/viewpro.inc.php';
				break;
			case '6.1' : 
			case '7.0' : 
			case '7.1' : 
			case '7.2' : 
				$cfg['rervert_data'][]	= 'space.php';
				break;
			default :
				break;
		}
		
		//后台文件
		$cfg['rervert_data'][]	= 'admin/menu.inc.php';
		$cfg['rervert_data'][]	= 'admin/home.inc.php';
		
		$tp = 'templates/default/';
		$cfg['rervert_data'][]	= $tp.'register.htm';
		$cfg['rervert_data'][]	= $tp.'login.htm';
		$cfg['rervert_data'][]	= $tp.'personal_navbar.htm';
		$cfg['rervert_data'][]	= $tp.'memcp_profile.htm';
		//根据不同的版本配置不同的HAC(模板部分)
		switch ($ver) {
			case '6.0' :
				$cfg['rervert_data'][]	= $tp.'viewthread.htm';
				$cfg['rervert_data'][]	= $tp.'post_newthread.htm';
				$cfg['rervert_data'][]	= $tp.'viewpro.htm';
				$cfg['rervert_data'][]	= $tp.'nopermission.htm';
				break;
			case '6.1' : 
				$cfg['rervert_data'][]	= $tp.'viewthread.htm';
				$cfg['rervert_data'][]	= $tp.'post_newthread.htm';
				$cfg['rervert_data'][]	= $tp.'viewpro_classic.htm';
				$cfg['rervert_data'][]	= $tp.'nopermission.htm';
				break;
			case '7.0' : 
				$cfg['rervert_data'][]	= $tp.'viewthread_node.htm';
				$cfg['rervert_data'][]	= $tp.'post.htm';
				$cfg['rervert_data'][]	= $tp.'viewpro_classic.htm';
				break;
			case '7.1' : 
				$cfg['rervert_data'][]	= $tp.'viewthread_node.htm';
				$cfg['rervert_data'][]	= $tp.'post.htm';
				$cfg['rervert_data'][]	= $tp.'viewpro_classic.htm';
				break;
			case '7.2' : 
				$cfg['rervert_data'][]	= $tp.'viewthread_node.htm';
				$cfg['rervert_data'][]	= $tp.'post.htm';
				$cfg['rervert_data'][]	= $tp.'viewpro_classic.htm';
				break;
			default :
				break;
		}
	
		$skNmaes = $this->_getDirNames(XWB_S_ROOT.'/templates');
		foreach ($skNmaes as $sk){
			if ( $sk=='admin' || !file_exists(XWB_S_ROOT.'/templates/'.$sk."/footer.htm") ) continue;
			$cfg['rervert_data'][] = 'templates/'.$sk."/footer.htm" ;
		}
		
		$cfg['db_data'] = array();
		$cfg['db_data']['xwb_bind_thread']	= "DROP TABLE IF EXISTS `%s`";
		$cfg['db_data']['xwb_bind_info'] 	= "DROP TABLE IF EXISTS `%s`";
		//根据不同的版本配置不同的HAC
		switch ($ver) {
			case '6.0' : 
			case '6.1' : 
				break;
			case '7.0' : 
				break;
			case '7.1' : 
				break;
			case '7.2' : 
				break;
			default :
				$this->error('不支持的站点版本： '.XWB_S_VERSION);
			break;
		}
		
		return $cfg ;
		
	}
	
	
	function uninstall($st){
		$st*=1;
		if (!in_array($st,array(0,1))){
			$this->error('非法操作，步骤参数错误！');
		}
		
		$func = 'step'.$st;
		$this->$func();
	}
	
	function step0(){
		$image_file = "icon.gif";
		$showTab = 'info';
		$btn_enable = 'class="btn"';
		$btn_name = '确定卸载';
		$link = '?step=1&delete_data=0';
		include $this->tpl_dir.'/uninstall.php';
		exit;
	}
	
	function step1(){
		
		//关闭评论回推功能，防止卸载后API仍被使用
		//XWB_plugin::setPCfg( 'is_rsync_comment', 0 );
		
		$cfg = $this->getCfg();
		
		//print_r($cfg);exit;
		$tips = array();
		$st = true;
		//delete file 
		foreach ($cfg['delete_data'] as $df){
			$f = XWB_S_ROOT.'/'.$df;
			if (file_exists($f)){
				if (!@unlink($f)){
					$st = false;
					//删除不了就清空文件
					@file_put_contents($f, 'FILE CANNOT DEL, PLEASE DEL IT MANUALLY!');
					$tips[] = array(0, '删除文件 '.$df.' 失败，检查权限后重试，或者手工删除');
				}else{
					$tips[] = array(1, '删除文件 '.$df.' 成功');
				}
			}
		}
		
		//revert file
		foreach ($cfg['rervert_data'] as $hf){
			$f = XWB_S_ROOT.'/'.$hf;
			if (file_exists($f)){
				$s = file_get_contents($f);
				$s = preg_replace($this->v['hack_flag']['pc'], '', $s);
				$s = preg_replace($this->v['hack_flag']['hc'], '', $s);
				if (!file_put_contents($f,$s)){
					$st = false;
					$tips[] = array(0, '还原文件 '.$hf.' 失败，检查权限后重试');
				}else{
					$tips[] = array(1, '还原文件 '.$hf.' 成功');
				}
			}
		}
		
		if (!empty($_GET['delete_data'])){
			//delete db data
			$db = XWB_plugin::getDB();
			foreach ($cfg['db_data'] as $name=>$format){
				$tbSql = sprintf($format,XWB_S_TBPRE.$name);
				$db->query($tbSql);
				$tips[] = array(1, "删除数据表 [PRE_]$name 成功");
			}
			$_GET['delete_data'] = 1;
		}else{
			$tips[] = array(1, "已保留微博插件数据");
			$_GET['delete_data'] = 0;
		}
		
		$showTab	= 'uninstall';
		$btn_enable = 'class="btn"';
		$btn_name	= $st ? '完 成' : '重试';
		$link		= $st ? '../../index.php' : 'uninstall.php?step=1&delete_data='.$_GET['delete_data'] ;
		$image_file = $st ? 'sucess.png':"icon.gif";
		if($st){
			unset ( $_SESSION [XWB_CLIENT_SESSION] ['XWB_INSTALL_AUTH'] );
		}
		
		require_once XWB_P_ROOT. '/lib/xwbSite.inc.php';
		xwb_updateSiteCache();
		
		@unlink($GLOBALS['_xwb_install']['lock_file']);
		
		include $this->tpl_dir.'/uninstall.php';
		exit;
	}
	
	function error($msg){
		$image_file = "icon.gif";
		$showTab = 'error';
		$errorMsg = $msg;
		$btn_enable = 'class="btn"';
		$btn_name = '重试';
		$link = '?step=1';
		include $this->tpl_dir.'/uninstall.php';
		exit;
	}
	
	
	
	function _chkIsAdmin(){
			require_once 'adminVerifier.class.php';
			$verify = new adminVerifier ();
			$verify->verifyForInstall('xwb_plugin_uninstall');
	}
	
}
?>