<?php

/**
 * clientUser ，用于oauth、绑定状态等相关的session管理
 * 本例不提供单例化方法，请自行保证单例性
 * 本类在使用前，必须自行开启session_start();
 * 
 * @author xionghui<xionghui1@staff.sina.com.cn>
 * @since 2010-06-08
 * @copyright SINA INC.
 * @version $Id: clientUser.class.php 43 2010-09-07 09:12:56Z xwb $
 */

class clientUser 
{
	var $uidField;
	var $dk = '';
	
	/**
	 * 构造方法
	 * @param $uidField
	 * @uses XWB_CLIENT_SESSION常量
	 */
	function clientUser($uidField='uid'){
		$this->uidField = $uidField;
		$this->dk = XWB_CLIENT_SESSION;
	}
	//-----------------------------------------------------------------------
	function setOAuthKey($keys,$is_confirm = false){
		$k = $is_confirm ? 'XWB_OAUTH_KEYS2' : 'XWB_OAUTH_KEYS1' ;
		$this->setInfo(array("$k"=>$keys));
	}
	//-----------------------------------------------------------------------
	function getOAuthKey($is_confirm = false){
		$k = $is_confirm ? 'XWB_OAUTH_KEYS2' : 'XWB_OAUTH_KEYS1' ;
		return $this->getInfo($k);
	}
	//-----------------------------------------------------------------------
	function getToken(){
		$key2 = $this->getOAuthKey(true);
		return empty($key2) ? $this->getOAuthKey(false) : $key2;
	}
	//-----------------------------------------------------------------------
	function clearToken(){
		$this->setOAuthKey(array(),true);
		$this->setOAuthKey(array(),false);
	}
	//-----------------------------------------------------------------------
	function clearInfo(){
		$_SESSION[$this->dk] = array();
	}
	
	function setInfo($k,$v=false){
		if( is_array($k) ){
			$_SESSION[$this->dk] = array_merge($_SESSION[$this->dk],$k);
		}else{
			$_SESSION[$this->dk][$k] = $v;
		}
	}
	//-----------------------------------------------------------------------
	function getInfo($key=false){
		if($key){
			return isset($_SESSION[$this->dk][$key]) ? $_SESSION[$this->dk][$key] : null;
		}else{
			return $_SESSION[$this->dk];
		}
	}
	//-----------------------------------------------------------------------
	function delInfo($k){
		if ( !isset($_SESSION[$this->dk]) || empty($_SESSION[$this->dk]) ){
			return true;
		}
		if(!is_array($k)) {$k = array($k);}
		foreach($k as $kv ){
			if (isset($_SESSION[$this->dk][$kv])) unset($_SESSION[$this->dk][$kv]);
		}
		return true;
	}
	//-----------------------------------------------------------------------
	function isLogin(){
		$r = $this->getInfo($this->uidField);
		return !empty($r);
	}
	//-----------------------------------------------------------------------
}
?>