<?php
/**
 * 本文件主要用于通过模拟UC来兼容DZ6和DZ6.1F版本
 * （请注意：6.1F绝对不是6.1；6.1F是无UC 6.1版本，为半官方产品{@link http://www.freediscuz.net/}，现在插件暂时不支持该程序；下面不再提示此消息）
 * 请注意，在使用该文件的部分函数，对应的部分表不能进行INSERT INTO操作，
 * 比如在DZ6 / DZ6.1F中使用了uc_user_register注册了一个用户后，就不能用返回的uid再次INSERT INTO members表和memberfields表！
 * 详细情况，请看每个函数的说明。
 * 
 * @since 2010-07-22
 * @copyright Xweibo (C)1996-2099 SINA Inc.
 * @author  yaoying <yaoying@staff.sina.com.cn>
 * @version $Id: compatDZ6.inc.php 43 2010-09-07 09:12:56Z xwb $
 */

if( !defined('IS_IN_XWB_PLUGIN') ){
	exit('Access Denied!');
}


define('UC_USER_CHECK_USERNAME_FAILED', -1);
define('UC_USER_USERNAME_BADWORD', -2);
define('UC_USER_USERNAME_EXISTS', -3);
define('UC_USER_EMAIL_FORMAT_ILLEGAL', -4);
define('UC_USER_EMAIL_ACCESS_ILLEGAL', -5);
define('UC_USER_EMAIL_EXISTS', -6);

/**
 * 模拟UC，在DZ6 / DZ6.1F进行用户注册的函数（初始groupid为10）。
 * 警告：在DZ6 / DZ6.1F中使用本函数注册了一个用户后，就不能用返回的uid再次INSERT INTO members表和memberfields表！
 *
 * @param string $username
 * @param string $password
 * @param string $email
 * @param string $questionid
 * @param string $answer
 * @return int
 */
function uc_user_register($username, $password, $email, $questionid = '', $answer = ''){
	
	if(($status = _check_username($username)) < 0) {
		return $status;
	}
	if(($status = _check_email($email)) < 0) {
		return $status;
	}
	
	$username = mysql_real_escape_string($username);
	$password = md5((string)$password);
	$email = mysql_real_escape_string($email);
	//quescrypt函数在DZ6存在
	$secques = quescrypt($questionid, $answer);

	$GLOBALS['db']->query("INSERT INTO {$GLOBALS['tablepre']}members (username, password, secques, adminid, groupid, regip, regdate, lastip, lastvisit, lastactivity, posts, credits, extcredits1, extcredits2, extcredits3, extcredits4, extcredits5, extcredits6, extcredits7, extcredits8, email, showemail, timeoffset, pmsound, invisible, newsletter)
			VALUES ('$username', '$password', '$secques', '0', '10', '{$GLOBALS['onlineip']}', '{$GLOBALS['timestamp']}', '{$GLOBALS['onlineip']}', '{$GLOBALS['timestamp']}', '{$GLOBALS['timestamp']}', '0', {$GLOBALS['initcredits']}, '$email', '0', '9999', '1', 'O', '1')");
	$uid = $GLOBALS['db']->insert_id();
	$GLOBALS['db']->query("INSERT INTO {$GLOBALS['tablepre']}memberfields (uid)
			VALUES ('$uid')");
	return $uid;
}


/**
 * 模拟UC，在DZ6 / DZ6.1F进行用户查找的函数。
 *
 * @param string $username
 * @param int $isuid
 * @return array
 */
function uc_get_user( $username, $isuid = 0 ){
	$username = daddslashes((string)$username);
	if( $isuid ){
		$sqlSearch = 'uid';
	}else{
		$sqlSearch = 'username';
	}
	$query = $GLOBALS['db']->query("SELECT uid, username, email FROM {$GLOBALS['tablepre']}members WHERE {$sqlSearch}='{$username}' LIMIT 0,1 ");
	$result = $userinfo = array();
	while ( $user = $GLOBALS['db']->fetch_array($query) ) {
		$userinfo = $user;
	}
	if( empty($userinfo) ){
		return 0;
	}else{
		$result[0] = $userinfo['uid'];
		$result[1] = $userinfo['username'];
		$result[2] = $userinfo['email'];
		return $result;
	}
}

/**
 * 模拟UC，在DZ6 / DZ6.1F检查用户名合法性的函数。
 *
 * @param string $username
 * @return int 检查结果。0为正常，负为出错代码
 */
function _check_username($username){
	$len = strlen($username);
	$guestexp = '\xA1\xA1|\xAC\xA3|^Guest|^\xD3\xCE\xBF\xCD|\xB9\x43\xAB\xC8';
	$censorexp = '/^('.str_replace(array('\\*', "\r\n", ' '), array('.*', '|', ''), preg_quote(($GLOBALS['censoruser'] = trim($GLOBALS['censoruser'])), '/')).')$/i';
	if( $len > 15 || $len < 3 || preg_match("/^\s*$|^c:\\con\\con$|[%,\*\"\s\t\<\>\&]|$guestexp/is", $username) || ($GLOBALS['censoruser'] && @preg_match($censorexp, $username))) {
		return UC_USER_USERNAME_BADWORD;
	}
	
	$username = mysql_real_escape_string($username);
	$query = $GLOBALS['db']->query("SELECT uid FROM {$GLOBALS['tablepre']}members WHERE username='{$username}' LIMIT 0,1 ");
	if($GLOBALS['db']->num_rows($query)) {
		return UC_USER_USERNAME_EXISTS;
	}
	
	return 0;
}

/**
 * 模拟UC，在DZ6 / DZ6.1F检查email合法性的函数。
 *
 * @param string $email
 * @return int 检查结果。0为正常，负为出错代码
 */
function _check_email($email){
	//isemail函数在DZ6存在
	if( !isemail($email) ){
		return UC_USER_EMAIL_FORMAT_ILLEGAL;
	}
	
	$accessexp = '/('.str_replace("\r\n", '|', preg_quote($GLOBALS['accessemail'], '/')).')$/i';
	$censorexp = '/('.str_replace("\r\n", '|', preg_quote($GLOBALS['censoremail'], '/')).')$/i';
	$invalidemail = $GLOBALS['accessemail'] ? !preg_match($accessexp, $email) : $GLOBALS['censoremail'] && preg_match($censorexp, $email);
	if($invalidemail) {
		return UC_USER_EMAIL_ACCESS_ILLEGAL;
	}
	
	$email = mysql_real_escape_string($email);
	if( isset($GLOBALS['doublee']) && ($GLOBALS['doublee'] == 0) ){
		$query = $GLOBALS['db']->query("SELECT uid FROM {$GLOBALS['tablepre']}members WHERE email='{$email}' LIMIT 0,1  ");
		if($GLOBALS['db']->num_rows($query)) {
			return UC_USER_EMAIL_EXISTS;
		}
	}
	
	return 0;
}

