<?php

/**
 * XWB客户端API同步器 MOD。
 * 只有在api文件内使用：
 * 	define('POST_API_ON', true);
 * 定义开启后，才能使用该MODULE。
 * 根据该系统的编写，不能暴露给外部使用的方法需要用_进行私有化保护
 * 
 * @author yaoying
 * @since 2010-7-30
 * @version $Id: xwbClientAPISync.mod.php 10 2010-09-01 08:06:21Z xwb $
 *
 */
class xwbClientAPISync{
	
	/**
	 * db实例。由于本类使用非常多的db操作，故干脆用一个属性保存
	 */
	var $db;
	
	/**
	 * mid数组地图，方便循环的时候记住哪些mid已经查询到绑定了tid
	 * @var array
	 */
	var $midMap = array();
	
	/**
	 * tid数组地图，方便循环的时候记住哪些tid已经查询过了，以及该tid的信息
	 * @var array
	 */
	var $tidMap = array();
	
	/**
	 * fid数组地图，方便循环的时候记住哪些fid已经查询过了，以及该fid的信息
	 * @var array
	 */
	var $fidMap = array();
	
	/**
	 * 当前API操作用户身份。
	 * 通过方法_initAPIuser初始化数据
	 *
	 * @var array
	 */
	var $APIuser = array();
	
	
	/**
	 * 构造方法
	 * @return xwbClientAPISync
	 */
	function xwbClientAPISync(){
		exit('COMMENT API IS DISABLED!');
		$this->db = XWB_plugin::getDB();
		$this->_initAPIuser();
	}
	
	
	/**
	 * 初始化当前API用户身份
	 */
	function _initAPIuser(){
		$this->APIuser['ip'] = XWB_plugin::getIP();
		$this->APIuser['uid'] = (int)XWB_plugin::pCfg('sync_uid');
		$this->APIuser['username'] = XWB_plugin::pCfg('sync_username');
		$this->APIuser['timestamp'] = (int)$GLOBALS['timestamp'];   //DZ已有的变量，直接使用之
	}
	

	/**
	 * 外部接口：实现评论回推回论坛回帖的功能
	 * 必须调用_checkLegel方法保证是API调用
	 */
	function syncCommentToPost(){
		$check = $this->_checkAPILegel();
		if( $check < 0 ){
			$this->_respond( $check, '错误：API合法性检查错误' );
		}
		
		//检查设置
		if( (int)XWB_plugin::pCfg('is_rsync_comment')  != 1 ){
			$this->_respond( '-11', '错误：设置已经关闭了评论回推' );
		}
		
		//获取服务器POST过来的数据
		$data = $this->_getSyncData();
		if( !is_array($data) ){
			$this->_respond( (int)$data, '错误：数据获取失败' );
		}
		
		//1表示推送评论
		if( 1 == $data['type'] ){
			foreach ( (array)$data['data'] as $key => $weibo ){
				$tid = $this->_getBindTid((int)$weibo['mid']);
				if( $tid <= 1){
					continue;
				}
				$content = $this->_createContent($weibo);
				if( !empty($content) ){
					$this->_insertPostsTable( $tid, $content );
				}
			}
			$this->_respond(0, '成功：评论回推成功。');
			
		}elseif( 2 == $data['type'] ){
			$this->_respond(-101, '失败：当前不支持推送评论删除');
		}else{
			$this->_respond(-102, '失败：当前服务器指定的推送类型有误！');
		}

	}
	
	
	/**
	 * 获取服务器POST过来的、需要评论回推的同步数据（保护方法）
	 * @return mixed 正常则返回解码成功的数组数据，否则返回错误代码如下：
	 * 	-21：API没有发送相关数据
	 * 	-22：JSON解码API相关数据失败
	 */
	function _getSyncData(){
		$return = array();
		$postdata = XWB_plugin::V('p:data');
		if( empty($postdata) ){
			return -21;
		}
		
		$return = json_decode( $postdata, true );
		
		if( empty($return) || !isset($return['data']) ){
			return -22;
		}
		return $return;
	}
	
	
	/**
	 * 根据mid，查找出对应绑定的tid（保护方法）
	 *
	 * @param integer $mid 微博mid
	 * @return integer 获取结果：
	 * 	正整数：（正常）绑定了该mid的tid
	 * 	-31：（异常）没有一个tid绑定了该mid
	 * 	-32：（异常）tid不存在
	 * 	-33：（异常）tid已关闭
	 * 	-34：（异常）tid已放入回收站
	 * 	-35：（异常）tid没有对应的fid板块
	 */
	function _getBindTid( $mid ){
		
		if( !isset($this->midMap[$mid]) ){
			$this->midMap[$mid] = (int)$this->db->result_first('SELECT tid FROM '. XWB_S_TBPRE. "xwb_bind_thread WHERE `mid` = '". (int)$mid. "' LIMIT 1");
		}
		
		//检查mid是否绑定了某个tid？
		$tid = $this->midMap[$mid];
		if( !$tid || $tid < 1 ){
			return -31;
		}
		
		//tid状态标记检查
		if( !isset( $this->tidMap[$tid]['status'] ) ){
			$this->tidMap[$tid] = $this->db->fetch_first('SELECT * FROM '. XWB_S_TBPRE. "threads WHERE tid = '". $tid. "' LIMIT 1");
			if( empty($this->tidMap[$tid]) ){
				//检查tid是否存在？
				$this->tidMap[$tid]['status'] =  -32;
			}elseif( $this->tidMap[$tid]['closed'] != 0 ){
				//检查tid是否已关闭？
				$this->tidMap[$tid]['status'] = -33;
			}elseif( $this->tidMap[$tid]['displayorder'] < 0 ){
				//检查tid是否已经放入回收站？
				$this->tidMap[$tid]['status'] = -34;
			}else{
				//OK
				$this->tidMap[$tid]['status'] = 0;
			}
		}
		
		if( $this->tidMap[$tid]['status'] < 0 ){
			return $this->tidMap[$tid]['status'];
		}
		
		$fid = (int)$this->tidMap[$tid]['fid'];
		if( !isset($this->fidMap[$fid]) ){
			$this->fidMap[$fid] = (array)$this->db->fetch_first('SELECT * FROM '. XWB_S_TBPRE. "forums WHERE fid = '". $fid. "' LIMIT 1");
		}
		
		if( empty($this->fidMap[$fid]) ){
			return -35;
		}
		
		return $tid;

		
	}
	
	
	
	/**
	 * 根据发送过来的数据，组装出已经转码的、要插入对应数据库的回帖内容
	 *
	 * @param array $data API发送过来的数据
	 * @return string 要插入的回帖内容（已经转码）
	 */
	function _createContent( $data ){
		//转换为论坛所需要的字符集
		$content = XWB_plugin::convertEncoding( (string)$data['content'], 'UTF-8', XWB_S_CHARSET);
		//DZ函数
		$content = dhtmlspecialchars($content);
		
		if( !empty($data['url']) ){
			$baseurl = XWB_plugin::siteUrl();
			$content = $content. "\n\n". '[size=2][color=gray]'. XWB_plugin::L('xwb_reply_from') .
							' [img]' . $baseurl . XWB_P_DIR_NAME . '/../../images/bgimg/icon_logo.png[/img] '.
							'[url=' . (string)$data['url'] . ']' . (string)$data['url'] . '[/url][/color][/size]';
		}
		
		$content = $this->_filterContent($content);
		return $content;
	}
	
	
	/**
	 * 根据DZ设置，过滤帖子内容和拦截论坛设置禁用词
	 * （代码直接来自include/discuzcode.func.php中的censor函数代码）
	 *
	 * @param string $message 已经转码的内容
	 * @return string 正常则返回过滤的帖子内容，否则将返回空值''，表示因为含有论坛设置禁用词而不能通过检查
	 */
	function _filterContent( $message ){
		global $_DCACHE;
		require(XWB_S_ROOT.'/forumdata/cache/cache_censor.php');

		if($_DCACHE['censor']['banned']) {
			$bbcodes = 'b|i|u|color|size|font|align|list|indent|url|email|hide|quote|code|free|table|tr|td|img|swf|attach|payto|float'.($_DCACHE['bbcodes_display'] ? '|'.implode('|', array_keys($_DCACHE['bbcodes_display'])) : '');
			if(preg_match($_DCACHE['censor']['banned'], @preg_replace(array("/\[($bbcodes)=?.*\]/iU", "/\[\/($bbcodes)\]/i"), '', $message).$message)) {
				return '';
			}
		}
		return empty($_DCACHE['censor']['filter']) ? $message :
			@preg_replace($_DCACHE['censor']['filter']['find'], $_DCACHE['censor']['filter']['replace'], $message);
	}
	
	/**
	 * 插入回帖内容到指定tid中（保护方法）
	 *
	 * @param integer $tid
	 * @param string $content
	 * @return boolen 总为true
	 */
	function _insertPostsTable( $tid, $content ){
		//安全性过滤
		$uid = (int)$this->APIuser['uid'];
		$username = mysql_real_escape_string( XWB_plugin::convertEncoding($this->APIuser['username'], 'UTF-8', XWB_S_CHARSET) );
		$ip = mysql_real_escape_string($this->APIuser['ip']);		
		$fid = (int)$this->tidMap[$tid]['fid'];
		$content = mysql_real_escape_string($content);
		
		//设置一些默认值
		$subject = '';
		$isanonymous = 0;
		$bbcodeoff = 0;
		$smileyoff = 0;
		$parseurloff = 0;
		$htmlon = 0;
		$usesig = 1;
		$invisible = 0;
		$attachment = 0;
		
		//写入帖子cdb_posts表
		$this->db->query("INSERT INTO ". XWB_S_TBPRE. "posts (fid, tid, first, author, authorid, subject, dateline, message, useip, invisible, anonymous, usesig, htmlon, bbcodeoff, smileyoff, parseurloff, attachment)
				VALUES ('$fid', '$tid', '0', '$username', '$uid', '$subject', '{$this->APIuser['timestamp']}', '$content', '$ip', '$invisible', '$isanonymous', '$usesig', '$htmlon', '$bbcodeoff', '$smileyoff', '$parseurloff', '$attachment')");
		$pid = $this->db->insert_id();
		
		//针对DZ7.0及以下版本中，“我的回复”是一个单独表的情形进行处理
		if( version_compare( XWB_S_VERSION , '7.0.0', '<=') ){
			$this->db->query("REPLACE INTO ". XWB_S_TBPRE. "myposts (uid, tid, pid, position, dateline, special) VALUES ('$uid', '$tid', '$pid', '".($this->tidMap[$tid]['replies'] + 1)."', '{$this->APIuser['timestamp']}', '{$this->tidMap[$tid]['special']}')", 'UNBUFFERED');
		}
		
		//更新主帖表相关信息
		$this->db->query("UPDATE ". XWB_S_TBPRE. "threads SET lastposter='$username', lastpost='{$this->APIuser['timestamp']}', replies=replies+1 ".($attachment ? ", attachment='$attachment'" : '').", subscribed=0 WHERE tid='$tid'", 'UNBUFFERED');
		
		//更新个人回帖数
		$this->db->query("UPDATE ". XWB_S_TBPRE. "members SET posts=posts+1,lastpost='{$this->APIuser['timestamp']}' WHERE uid='$uid'", 'UNBUFFERED');

		//更新板块表相关信息
		$lastpost = mysql_real_escape_string( "{$tid}\t{$this->tidMap[$tid]['subject']}\t{$this->APIuser['timestamp']}\t{$username}" );
		$this->db->query("UPDATE ". XWB_S_TBPRE. "forums SET lastpost='$lastpost', posts=posts+1, todayposts=todayposts+1 WHERE fid='$fid'", 'UNBUFFERED');

		if( $this->fidMap[$fid]['type'] == 'sub' ){
			$fup = (int)$this->fidMap[$fid]['fup'];
			$this->db->query("UPDATE ". XWB_S_TBPRE. "forums SET lastpost='$lastpost' WHERE fid='{$fup}'", 'UNBUFFERED');
		}
		return true;
		
	}
	
	
	
	/**
	 * 检查调用该文件和API的合法性（保护方法）
	 * @return integer 检查结果。正常为0，否则：
	 * 	-1：调用方法不对（必须通过API调用文件调用）
	 * 	-2：调用方法不对（不是通过HTTP POST调用API）
	 * 	-3：APPKEY校验失败
	 */
	function _checkAPILegel(){
		if(!defined('POST_API_ON')){
			return -1;
		}
		
		if( !isset($_SERVER['REQUEST_METHOD']) || (string)$_SERVER['REQUEST_METHOD'] !== 'POST' ){
			return -2;
		}
		
		//appkey检测
		$appkeyPost = XWB_plugin::V('p:appkey');
		$appkeyLocal = md5( XWB_APP_KEY. '_'. XWB_APP_SECRET_KEY );
		if( empty($appkeyPost) || $appkeyPost != $appkeyLocal ){
			return -3;
		}
		
		return 0;
	}
	
	/**
	 * 输出服务器所需要的数据。
	 *
	 * @param integer $errno 错误代码。
	 * 	根据文档要求，成功时errno返回1，失败返回0；而本类失败时为复数，正确时为0或以上。因此需要进行转换
	 * @param string $errmsg 可选，只是留个接口，用于LOG记录。
	 */
	function _respond( $errno , $errmsg = '' ){
		
		//DEBUG 日志
		if( $errno < 0 ){
			XWB_plugin::LOG("[API COMMENT SYNC ERROR]\tERRNO: {$errno}\tERRMSG: {$errmsg}");
		}
		//DEBUG END

		//默认为成功
		$respond = array( 'errno' => 1 );
		if( $errno < 0 ){
			$respond['errno'] = 0;
		}
		echo json_encode($respond);
		exit;
	}
	
}