<?php

/**
 * 同步发帖和回帖到微博中
 * 
 * @author xionghui
 * @since 2010-6
 * @version $Id: xwb_plugins_publish.class.php 54 2010-09-09 12:16:47Z xwb $
 *
 */
class xwb_plugins_publish{
	function xwb_plugins_publish(){}
	/**
	 * 同步主题
	 * @param $content string 同步内容
	 */
	function thread() {
		global $pid,$tid,$ftp,$attachurl,$dateformat,$timeformat,$attachurl,$_DCACHE;
		$db = XWB_plugin::getDB();
		$tablepre = XWB_S_TBPRE;
		$baseurl = XWB_plugin::siteUrl();
		$sql = 'SELECT * FROM ' .$tablepre . 'posts WHERE `pid`=' . $pid . ' AND `first` = 1 LIMIT 1  ';
		$postinfo = $db->fetch_first($sql);
		
		// 转码
		$subject = $this->_convert($postinfo['subject']);
		$message = $this->_convert($postinfo['message']);
		
		// 过滤UBB与表情
		$subject = $this->_filter($subject);
		$message = $this->_filter($message);
		
		//去重和合并处理
		$message = $this->_mergeMessage( $subject, $message );
		
		$link = ' ' .$baseurl . 'viewthread.php?tid=' . $tid;
		$length = 140 - ceil(strlen( urlencode($link) ) * 0.5) ;   //2个字母为1个字
		$message = $this->_substr($message, $length);
		
		//将最后附带的url给删除。
		$message = preg_replace("|\s*http://[a-z0-9-\.\?\=&_@/%#]*\$|sim", "", $message);
		
		$message .= $link;
		
		// 取出第一张图片
		$first_img_url = '';
		if( XWB_plugin::pCfg('is_upload_image') ){
			$image_list = $this->_getImage($pid, $postinfo['message']);
			if( isset( $image_list[0] ) ){
				$first_img_url = $image_list[0];
			}
		}
		
		$wb = XWB_plugin::getWB();
		$ret = array();

		// 同步到微博
		if (!empty($first_img_url)) {
			$ret = $wb->upload($message, $first_img_url, null, null, false);
			
			if ( in_array($ret['error'] , array('Error: system error, does multipart has image?','Error: unsupported image type, only suport JPG, GIF, PNG!')) ) {
				$ret = $wb->update($message, false);
			}
		} else {
			$ret = $wb->update($message, false);
		}
		
		//同步微博后的ID
		if ($ret['id']) {
			$mid = $ret['id'];
			$this->_setSynId($tid, $mid);
			//插入“已同步到......”到指定pid中。
			if( XWB_plugin::pCfg('wb_addr_display') ){
				$redirectURL = XWB_API_URL. $ret['user']['id']. '/statuses/'. $ret['id'];
				$baseurl = XWB_plugin::siteUrl();

				$insertSyncUBB = '[size=2][color=gray]'. XWB_plugin::L('xwb_topic_has_sycn_to') .
							' [img]' . $baseurl . XWB_P_DIR_NAME . '/images/bgimg/icon_logo.png[/img] '.
							'[url=' . $redirectURL . ']' . $redirectURL . '[/url][/color][/size]';
				$messagepid = mysql_real_escape_string( $postinfo['message'] . "\n\n" . $insertSyncUBB );
				$db->query( 'UPDATE '.$tablepre .'posts SET `bbcodeoff` = 0, `message` = \''.$messagepid . '\' WHERE `pid` = \'' . $pid .'\''  );

				//file_put_contents( dirname(__FILE__).'/../log/ddd.txt' ,$messagepid , FILE_APPEND);
			}
		}
	}

	/**
	 * 同步回复
	 */
	function reply() {
		global $tid,$pid,$ftp,$attachurl,$dateformat,$timeformat,$attachurl,$_DCACHE;
		$mid = $this->_isSyn($tid);
		// 如果帖子没有被设置为同步到微博，则返回
		if (!$mid) {
			return;
		}
		// 如果用户没有绑定微博帖号，则返回
		if (!XWB_plugin::isUserBinded()) {
			return;
		}
		$db = XWB_plugin::getDB();
		$tablepre = XWB_S_TBPRE;
		$baseurl = XWB_plugin::siteUrl();
		$sql = 'SELECT * FROM ' .$tablepre . 'posts WHERE `pid`=' . $pid. ' LIMIT 1  ';
		$postinfo = $db->fetch_first($sql);

		// 转码
		$message = $this->_convert($postinfo['message']);
		// 过滤UBB和表情
		$message = $this->_filter($message);
		$link = ' ' . $baseurl . 'viewthread.php?tid=' . $tid;
		$length = 140 - ceil(strlen( urlencode($link) ) * 0.5) ;   //2个字母为1个字
		$message = $this->_substr($message, $length);
		//将最后附带的url给删除。
		$message = preg_replace("|\s*http://[a-z0-9-\.\?\=&_@/%#]*\$|sim", "", $message);
		
		$message .= $link;
		//@todo 同步到微博
		$wb = XWB_plugin::getWB();
		$rs = $wb->comment($mid, $message,null, false);
		
	}
	
	
	/**
	 * 转换为微博可以使用的编码
	 */
	function _convert($msg) {
		return XWB_plugin::convertEncoding($msg, XWB_S_CHARSET, 'UTF-8');
	}

	/**
	 * 过滤发布内容
	 */
	function _filter($content) {
		global $_DCACHE;
		//将[attachimg]和[attach]的UBB标签连同内容给全部删除
		$content = preg_replace('!\[(attachimg|attach)\]([^\[]+)\[/(attachimg|attach)\]!', '', $content);
		
		// 过滤UBB
		$re ="#\[([a-z]+)(?:=[^\]]*)?\](.*?)\[/\\1\]#sim";
		while(preg_match($re, $content)) {
			$content = preg_replace($re, '\2', $content);
		}

		// 过滤表情
		$re = $_DCACHE['smileycodes'];
		$content = str_replace($re, '', $content);
		$content = preg_replace($_DCACHE['smilies']['searcharray'], '', $content);
		//多个空格合为一个空格；前后空格去掉
		$content = preg_replace("#\s+#", ' ', $content);
		$content = trim($content);
		
		return $content;
	}
	
	
	
	/**
	 * 标题和内容去重，然后合并
	 *
	 */
	function _mergeMessage( $subject, $message ){
		$result = '';
		
		if( $subject != '' ){
			//当处理完成的帖子内容，全部去掉前后空格 包含于 帖子标题 ，则仅取帖子标题作为微博内容。并且返回。
			if( false !== strpos( $subject , $message ) ){
				$result = $subject;
				return $result;
			}

			//当处理完成的帖子内容，开头与帖子标题重复时，去掉帖子标题，仅取帖子内容作为微博内容。并且返回。
			if( 0 === strpos( $message, $subject ) ){
				$result = $message;
				return $result;
			}
		}
		
		//以上皆不符合，就直接进行整合。
		$result = $subject . ' | ' . $message;
		return $result;
	}

	/**
	 * 取得指定帖子图片的数组
	 * @param $pid int 论坛posts id
	 * @param $msg string 发布内容
	 * @param $num int 需要返回的图片数，默认为1张
	 * @return array
	 */
	function _getImage($pid, $msg, $num = 1) {
		global $attachurl, $ftp;
		require_once DISCUZ_ROOT.'./include/attachment.func.php';
		$baseurl = XWB_plugin::siteUrl();
		$db = XWB_plugin::getDB();
		$tablepre = XWB_S_TBPRE;

		$attachfind = $attachreplace = $attachments = array();
		$query = $db->query("SELECT * FROM {$tablepre}attachments WHERE pid='{$pid}'");
		while($attach = $db->fetch_array($query)) {
			// 只使用附件为图片、没有阅读权限和金钱权限、并且大小小于1Ｍ的发送到微博
			if($attach['isimage'] && $attach['price'] == 0 && $attach['readperm'] == 0 && $attach['filesize'] <= 1024 * 1024) {
				$attach['url'] = $attach['remote'] ? $ftp['attachurl'] : $attachurl;
				$attachfind[] = "/\[attach\]$attach[aid]\[\/attach\]/i";
				$attachreplace[] = '[attachimg]'.$baseurl . $attachurl . '/' . $attach['attachment'].'[/attachimg]';
			}
			
			$attachments[] = $attach;
		}
		//$postinfo['subject'] = str_replace('"', '&quot;', $postinfo['subject']);
		//$postinfo['message'] = dhtmlspecialchars($postinfo['message']);
		if($attachfind) {
			$msg = preg_replace($attachfind, $attachreplace, $msg);
		}
		// 还原<img>为[img]
		$msg = preg_replace('/<img[^>]+src="([^\'"]+)"[^>]+>/',"[img]\\1[/img]", $msg);
		$image_list = array();
		if (preg_match_all('!\[(attachimg|img)\]([^\[]+)\[/(attachimg|img)\]!', $msg, $match, PREG_PATTERN_ORDER)) {
			if( count($match[2]) > $num ){
				$image_list = array_slice($match[2], 0, $num);
			}else{
				$image_list = $match[2];
			}
		}
		return $image_list;
	}
	
	/**
	 * 对utf-8编码截取
	 * @param $str string 要截取的源内容
	 * @param $length int 要截取的长度
	 */
	function _substr($str, $length) {
		
		//如果有mb_substr就用这个函数
		//英语截取太短，故放弃mb_substr
		/*
		if( function_exists('mb_substr') ){
			return mb_substr($str, 0, $length, 'UTF-8');
		}
		*/
		
		//否则用以下自写函数操作
		//防止后面的操作导致内存溢出
		if( strlen($str) > $length + 600 ){
			$str = substr($str, 0, $length + 600);
		}
		
		$p = '/[\x01-\x7f]|[\xc2-\xdf][\x80-\xbf]|[\xe0-\xef][\x80-\xbf]{2}|[\xf0-\xff][\x80-\xbf]{3}/';
		preg_match_all($p,$str,$o);
		$size = sizeof($o[0]);
		$count = 0;
		for ($i=0; $i<$size; $i++) {
			if (strlen($o[0][$i]) > 1) {
				$count += 1;
			} else {
				$count += 0.5;
			}
			
			if ($count  > $length) {
				$i-=1;
				break;
			}
			
		}
		return implode('', array_slice($o[0],0, $i));
	}
	
	
	/**
	 * 主题是否已经同步
	 * @param $tid int thread id
	 * @return false|int
	 */
	function _isSyn($tid) {
		$db = XWB_plugin::getDB();
		$tablepre = XWB_S_TBPRE;
		$sql = 'SELECT *FROM ' . $tablepre . 'xwb_bind_thread WHERE `tid`=' . $tid;
		$rs = $db->fetch_first($sql);
		if (!$rs) {
			return false;
		}
		return $rs['mid'];
	}

	/**
	 * 设置帖子同步标志
	 * @param $tid int thread id
	 * @param $mid int 微博id
	 */
	function _setSynId($tid, $mid) {
		$db = XWB_plugin::getDB();
		$tablepre = XWB_S_TBPRE;
		$sql = 'INSERT INTO ' . $tablepre . 'xwb_bind_thread VALUES(' .$tid. ', ' . $mid . ')';
		$db->query($sql);
		if ($db->affected_rows()) {
			return true;
		}
		return false;
	}
	


}
