<?php
/*
 * [XTCMS] (C)2001-2010 XunTeng Inc.
 * This is NOT a freeware, use is subject to license terms
 * Author :Silence (QQ:85825770 E-Mail:85825770@qq.com)
 * $Id$
 */
require('paymentPlugin.php');
class pay_sdecp extends paymentPlugin{
    var $name = '山东省电子商务支付平台';
    var $logo = 'ecpay_logo';
    var $version = 20100623;
    var $charset = 'gb2312';
    var $submitUrl = 'http://pay.sdecp.com.cn/epay/Settle2.jsp';
    var $submitButton = 'http://img.alipay.com/pimg/button_alipaybutton_o_a.gif';
    var $supportCurrency = array("CNY"=>"0");
    var $supportArea = array('AREA_CNY');
    var $desc = '山东省唯一的基础性电子商务综合服务平台，是有中国特色、代表山东形象的电子商务门户，在全省未来经济发展和社会生活的宏伟蓝图中起纽带作用；国内首次将电子商务服务与网上社区服务相统一, 首个与银联共建支付网关的省级电子商务综合服务平台。';
    var $orderby = 1531;//不能和其他支付方式的orderby重复，否则重复的会显示不出来
    var $head_charset="gb2312";

    function toSubmit($payment){
    	//私钥值
        $ikey = $this->getConf($payment['M_OrderId'], 'PrivateKey');
		//获得表单传过来的数据
		//商户代码（MerchantID）
		$return['MerchantID'] = $this->getConf($payment['M_OrderId'], 'member_id');
		//商户系统生成的订单号
		$return['TransactionID'] = $payment['M_OrderId'];
		//支付金额，保留两个小数位
		$return['Amount'] = number_format($payment['M_Amount'],2);
		//订单支付结果返回地址
		$return['MerchantURL'] = $this->callbackUrl;
		//连接字符串
		$sourceMsg = $return['MerchantID'].$return['TransactionID'].$return['orderid'].$return['Amount'].$return['MerchantURL'];
		//签名
		$return['Signature'] = sha1($sourceMsg.$ikey);;
       return $return;
    }

    function callback($in,&$paymentId,&$money,&$message,&$tradeno){
    	//获取订单号
    	$paymentId = trim($in['TransactionID']);
		//获取商户号
		$MerchantID = trim($in['MerchantID']);
		//获取实际支付金额
		$money = trim($in['Amount']);
		//获取处理结果
		$Succeed = trim($in['Succeed']);
		//获取加密签名串
		$Signature = trim($in['Signature']);
		//获取加密密钥
		$key=$this->getConf($paymentId,'PrivateKey');
		//生成签名
		$strSignature = sha1($MerchantID.$paymentId.$money.$Succeed.$key);
    	if ( $Signature !=$strSignature){
			$message = "验证签名错误！";
            return PAY_ERROR;
		}else{
			if(isset($Succeed)){
				if($Succeed=="1"){
					$message="支付成功！";
                	return PAY_SUCCESS;
				}else{
     				$message = "支付失败！";
					return PAY_FAILED;
				}
			}
		}
	}

    function getfields(){
    	return array(
				'member_id'=>array(
                        'label'=>'客户号',
                        'type'=>'string'
                    ),
                'PrivateKey'=>array(
                        'label'=>'私钥',
                        'type'=>'string'
                )
    	);
    }
}