<?php
/*
 * 百度知道开放平台OPEN API PHP SDK V0.1 (数据合作)
 * ------------------------------------------------------
 * 基于 iknow-975(5.2.12) 标准
 * 作者 zxing0214@qq.com
 * 微博 http://t.qq.com/zxing0214
 * 演示 http://ask.m148.com/
 * ------------------------------------------------------
 * 提供接口：
 * getQuestionList 基于百度知道分类ID获取对应分类下的问题列表
 * getQuestionSearch 基于检索关键字在百度知道中搜索匹配的问题列表
 * getQuestionInfo 基于百度知道问题ID获取对应问题的数据以及回答
 * getQuestionAnswer 基于百度知道问题ID、回答ID获取对应问题的数据的回答
 * question 向百度知道进行提问
 * answer 对百度知道问题进行回答
 * 该SDK需要开启CURL
 * ------------------------------------------------------
 * 测试代码：
 * $zhidaoopenapi = new ZhidaoOpenApi();
 * $list = $zhidaoopenapi->getQuestionList(92);
 * print_r($list);
 * ------------------------------------------------------
 * 百度知道开放平台：
 * http://www.baidu.com/search/openiknow/
 * 申请后联系百度客服要求转换为数据合作，申请成功后百度会邮件告知你 APP KEY 和 SECRET。
 * 你就可以使用该SDK将你的网站与百度知道开放平台连接起来，
 * 让百度知道的问题源源不断流入你的网站，让你的回答返回到百度知道，
 * 虽然百度不给百度知道外链赋予权重，但其他搜索引擎给百度知道的外链赋予权重！
 */
//  App Key --
define( 'IKNOW_KEY', '******' );
//  App Secret
define( 'IKNOW_SKEY', '***' );
// 知道 HTTP 接口
define( 'IKNOW_HTTP_API', 'http://open.zhidao.baidu.com/restserver/zhidao' );
// 返回格式 json
define( 'IKNOW_RETURN_FORMAT', 'json' );

class ZhidaoOpenApi {

    public $http_info;
    public $http_code;
    public $http_header;
    public $url;
    // 告知百度执行标准 和 联系方式 以方便百度联系
    public $useragent = 'OpenAPI( iknow-975(5.2.12) ask.m148.com By:zxing0214@qq.com QQ:86021451)';
    public $timeout = 30;
    public $ssl_verifypeer = false;

    /**
     *  基于百度知道分类ID获取对应分类下的问题列表
     *
     * @param Int $cid 知道频道的分类ID
     * @param Int $qstatus 问题状态 0为待解决 1为已解决
     *
     * @return Array()
     */
    public function getQuestionList($cid, $qstatus=0, $page_no=1, $page_size=25) {
        $page_no = empty( $page_no ) ? '1' : $page_no;
        $param_array = array(
            'method' => 'baidu.zhidao.getQuestionList',
            'cid' => $cid,
            'qstatus' => $qstatus,
            'page_no' => $page_no,
            'page_size' => $page_size
        );
        return $this->_get( $param_array );
    }

    /**
     * 基于检索关键字在百度知道中搜索匹配的问题列表
     *
     * @param String $keywords 检索关键字 多个检索关键字之间使用+号连接
     * @param Int $qstatus 问题状态 0为待解决 1为已解决
     * @param Int $page_no 当前页码
     * @param Int $page_size 每页条数
     *
     * @return Array()
     */
    public function getQuestionSearch($keywords, $qstatus=0, $page_no=1, $page_size=5) {
        $page_no = empty( $page_no ) ? '1' : $page_no;
        $param_array = array(
            'method' => 'baidu.zhidao.getQuestionSearch',
            'keywords' => $keywords,
            'qstatus' => $qstatus,
            'page_no' => $page_no,
            'page_size' => $page_size
        );
        return $this->_get( $param_array );
    }

    /**
     * 基于百度知道问题ID获取对应问题的数据以及回答
     *
     * @param int $qid 百度知道的问题ID
     *
     * @return Array()
     */
    public function getQuestionInfo($qid) {
        $param_array = array(
            'method' => 'baidu.zhidao.getQuestionInfo',
            'qid' => $qid,
        );
        return $this->_get( $param_array );
    }

    /**
     * 基于百度知道问题ID、回答ID获取对应问题的数据的回答
     *
     * @param int $qid 百度知道的问题ID
     * @param int $aid 百度知道的回答ID
     *
     * @return Array()
     */
    public function getQuestionAnswer($qid, $aid) {
        $param_array = array(
            'method' => 'baidu.zhidao.getQuestionAnswer',
            'qid' => $qid,
            'aid' => $aid,
        );
        return $this->_get( $param_array );
    }

    /**
     * 向百度知道进行提问
     *
     * @param string $title 问题标题
     * @param string $content 问题内容
     * @param int $cid 分类id
     * @param string $utype 频道使用的用户系统类型
     * @param int $uid 在频道登陆过的用户id（自有用户系统必填）
     * @param string $uname 在频道登陆过的用户名（百度用户系统必填）
     *
     * @return Array()
     */
    public function question($title, $content, $cid, $utype, $uid, $uname) {
        $param_array = array(
            'method' => 'baidu.zhidao.question',
            'title' => $title,
            'content' => $content,
            'cid' => $cid,
            'utype' => $utype,
            'uid' => $uid,
            'uname' => $uname,
        );
        return $this->_post( $param_array );
    }

    /**
     * 对百度知道问题进行回答
     *
     * @param string $qid 回答的问题ID
     * @param string $content 回答内容
     * @param string $cite 回答参考资料
     * @param string $utype 频道使用的用户系统类型
     * @param int $uid 在频道登陆过的用户id（自有用户系统必填）
     * @param string $uname 在频道登陆过的用户名（百度用户系统必填）
     *
     * @return Array()
     */
    public function answer($qid, $content, $cite, $utype, $uid, $uname) {
        $param_array = array(
            'method' => 'baidu.zhidao.answer',
            'qid' => $qid,
            'content' => $content,
            'cite' => $cite,
            'utype' => $utype,
            'uid' => $uid,
            'uname' => $uname,
        );
        return $this->_post( $param_array );
    }

    /**
     * 对请求信息 进行签名
     * 此函数会补全系统级请求参数 并自动为请求签名
     *
     * @return Array()
     */
    private function _GenerateSig(&$param_array) {
        $str = '';
        // 补全系统级请求参数
        $param_array['api_key'] = IKNOW_KEY;
        $param_array['call_id'] = time();
        $param_array['format'] = IKNOW_RETURN_FORMAT;
        $param_array['ie'] = 'UTF-8';
        //对param_array中的参数名称进行升序排序
        ksort( $param_array );
        //按照如下格式转换数组为string格式
        foreach ( $param_array as $k => $v ) {
            $str .= "$k=$v";
        }
        // string末端补充api_secret密钥 后 取得MD5值 即为 bd_sig
        $param_array['bd_sig'] = md5( $str . IKNOW_SKEY );
    }

    /**
     * 向 知道开放平台发起GET请求
     *
     * @param Array $param_array 请求参数数组
     *
     * @return Array
     */
    private function _get($param_array) {
        $this->_GenerateSig( $param_array );
        $url = IKNOW_HTTP_API . '?';
        foreach ( $param_array as $key => $value ) {
            $param_array[$key] = $key . '=' . $value;
        }
        $url .= implode( '&', $param_array );
        $response = $this->_Http( $url, 'GET' );
        if ( IKNOW_RETURN_FORMAT === 'json' ) {
            return json_decode( $response, true );
        }
        return $response;
    }

    /**
     * 向 知道开放平台发起 POST 请求
     *
     * @param Array $param_array 请求参数数组
     *
     * @return Array
     */
    private function _post($param_array) {
        $this->_GenerateSig( $param_array );
        $url = IKNOW_HTTP_API;
        // 整理POST数据
        $post_data = '';
        $keys = self::_urlencode_rfc3986( array_keys( $param_array ) );
        $values = self::_urlencode_rfc3986( array_values( $param_array ) );
        $param_array = array_combine( $keys, $values );
        uksort( $param_array, 'strcmp' );
        $pairs = array();
        foreach ( $param_array as $parameter => $value ) {
            if ( is_array( $value ) ) {
                natsort( $value );
                foreach ( $value as $duplicate_value ) {
                    $pairs[] = $parameter . '=' . $duplicate_value;
                }
            } else {
                $pairs[] = $parameter . '=' . $value;
            }
        }
        $post_data = implode( '&', $pairs );
        // 发出请求
        $response = $this->_Http( $url, 'POST', $post_data );
        if ( IKNOW_RETURN_FORMAT === 'json' ) {
            $response = json_decode( $response, true );
        }
        return $response;
    }

    /**
     * 对请求进行URL编码 (rfc3986标准)
     *
     * @return string
     */
    public static function _urlencode_rfc3986($input) {
        if ( is_array( $input ) ) {
            return array_map( array(__CLASS__, '_urlencode_rfc3986'), $input );
        } else if ( is_scalar( $input ) ) {
            return str_replace(
                    '+', ' ', str_replace( '%7E', '~', rawurlencode( $input ) )
            );
        } else {
            return '';
        }
    }

    /**
     * CURL 发出一个 HTTP 请求
     *
     * @return string API results
     */
    private function _Http($url, $method, $postfields = NULL) {
        $this->http_info = array();
        $ci = curl_init();
        /* Curl settings */
        curl_setopt( $ci, CURLOPT_USERAGENT, $this->useragent );
        curl_setopt( $ci, CURLOPT_CONNECTTIMEOUT, $this->timeout );
        curl_setopt( $ci, CURLOPT_TIMEOUT, $this->timeout );
        curl_setopt( $ci, CURLOPT_RETURNTRANSFER, TRUE );
        curl_setopt( $ci, CURLOPT_SSL_VERIFYPEER, $this->ssl_verifypeer );
        curl_setopt( $ci, CURLOPT_HEADERFUNCTION, array($this, 'getHeader') );
        curl_setopt( $ci, CURLOPT_HEADER, FALSE );
        switch ( $method ) {
            case 'POST':
                curl_setopt( $ci, CURLOPT_POST, TRUE );
                if ( !empty( $postfields ) ) {
                    curl_setopt( $ci, CURLOPT_POSTFIELDS, $postfields );
                }
                break;
            case 'DELETE':
                curl_setopt( $ci, CURLOPT_CUSTOMREQUEST, 'DELETE' );
                if ( !empty( $postfields ) ) {
                    $url = "{$url}?{$postfields}";
                }
        }
        $header_array = array();
        $header_array2 = array();
        foreach ( $header_array as $k => $v ) {
            array_push( $header_array2, $k . ': ' . $v );
        }
        curl_setopt( $ci, CURLOPT_HTTPHEADER, $header_array2 );
        curl_setopt( $ci, CURLINFO_HEADER_OUT, TRUE );
        curl_setopt( $ci, CURLOPT_URL, $url );
        $response = curl_exec( $ci );
        $this->http_code = curl_getinfo( $ci, CURLINFO_HTTP_CODE );
        $this->http_info = array_merge( $this->http_info, curl_getinfo( $ci ) );
        $this->url = $url;
        curl_close( $ci );
        return $response;
    }

    /**
     * CURL 读取响应头信息
     *
     * @return int
     */
    public function getHeader($ch, $header) {
        $i = strpos( $header, ':' );
        if ( !empty( $i ) ) {
            $key = str_replace( '-', '_', strtolower( substr( $header, 0, $i ) ) );
            $value = trim( substr( $header, $i + 2 ) );
            $this->http_header[$key] = $value;
        }
        return strlen( $header );
    }

}