DROP TABLE IF EXISTS qb_members;
CREATE TABLE `qb_members` (
  `uid` mediumint(7) unsigned NOT NULL auto_increment,
  `username` varchar(30) NOT NULL default '',
  `password` varchar(32) NOT NULL default '',
  PRIMARY KEY  (`uid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_memberdata;
CREATE TABLE `qb_memberdata` (
  `uid` mediumint(7) unsigned NOT NULL default '0',
  `username` varchar(50) NOT NULL default '',
  `qq_api` varchar(32) NOT NULL default '',
  `question` varchar(32) NOT NULL default '',
  `groupid` smallint(4) NOT NULL default '0',
  `grouptype` tinyint(1) NOT NULL default '0',
  `groups` varchar(255) NOT NULL default '',
  `yz` tinyint(1) NOT NULL default '0',
  `newpm` tinyint(1) NOT NULL default '0',
  `medals` varchar(255) NOT NULL default '',
  `money` mediumint(7) unsigned NOT NULL default '0',
  `totalspace` bigint(13) NOT NULL default '0',
  `usespace` bigint(13) NOT NULL default '0',
  `oltime` int(10) NOT NULL default '0',
  `lastvist` int(10) NOT NULL default '0',
  `lastip` varchar(15) NOT NULL default '',
  `regdate` int(10) NOT NULL default '0',
  `regip` varchar(15) NOT NULL default '',
  `sex` tinyint(1) NOT NULL default '0',
  `bday` date NOT NULL default '0000-00-00',
  `icon` varchar(150) NOT NULL default '',
  `introduce` text NOT NULL,
  `hits` int(7) NOT NULL default '0',
  `lastview` int(10) NOT NULL default '0',
  `oicq` varchar(11) NOT NULL default '',
  `msn` varchar(50) NOT NULL default '',
  `homepage` varchar(150) NOT NULL default '',
  `email` varchar(50) NOT NULL default '',
  `provinceid` mediumint(6) NOT NULL default '0',
  `cityid` mediumint(7) NOT NULL default '0',
  `address` varchar(255) NOT NULL default '',
  `postalcode` varchar(6) NOT NULL default '',
  `mobphone` varchar(12) NOT NULL default '',
  `telephone` varchar(25) NOT NULL default '',
  `idcard` varchar(20) NOT NULL default '',
  `truename` varchar(20) NOT NULL default '',
  `config` text NOT NULL,
  `moneycard` mediumint(7) unsigned NOT NULL default '0',
  `email_yz` tinyint(1) NOT NULL default '0',
  `mob_yz` tinyint(1) NOT NULL default '0',
  `idcard_yz` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`uid`),
  KEY `groups` (`groups`),
  KEY `sex` (`sex`,`bday`,`cityid`),
  KEY `qq_api` (`qq_api`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_group;
CREATE TABLE `qb_group` (
  `gid` smallint(4) NOT NULL auto_increment,
  `gptype` tinyint(1) NOT NULL default '0',
  `grouptitle` varchar(50) NOT NULL default '',
  `levelnum` mediumint(7) NOT NULL default '0',
  `totalspace` int(10) NOT NULL default '0',
  `allowsearch` tinyint(1) NOT NULL default '0',
  `powerdb` text NOT NULL,
  `allowadmin` tinyint(1) NOT NULL default '0',
  `allowadmindb` text,
  PRIMARY KEY  (`gid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_menu;
CREATE TABLE `qb_menu` (
  `id` mediumint(5) NOT NULL auto_increment,
  `fid` mediumint(5) NOT NULL default '0',
  `name` varchar(80) NOT NULL default '',
  `linkurl` varchar(150) NOT NULL default '',
  `color` varchar(15) NOT NULL default '',
  `target` tinyint(1) NOT NULL default '0',
  `moduleid` tinyint(2) NOT NULL default '0',
  `type` tinyint(2) NOT NULL default '0',
  `hide` tinyint(1) NOT NULL default '0',
  `list` smallint(4) NOT NULL default '0',
  `extend` varchar(30) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_admin_menu;
CREATE TABLE `qb_admin_menu` (
  `id` mediumint(5) NOT NULL auto_increment,
  `fid` mediumint(5) NOT NULL default '0',
  `name` text NOT NULL,
  `linkurl` varchar(150) NOT NULL default '',
  `color` varchar(15) NOT NULL default '',
  `target` tinyint(1) NOT NULL default '0',
  `list` smallint(4) NOT NULL default '0',
  `groupid` mediumint(5) NOT NULL default '0',
  `iftier` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `groupid` (`groupid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_module;
CREATE TABLE `qb_module` (
  `id` mediumint(5) NOT NULL auto_increment,
  `type` tinyint(1) NOT NULL default '0',
  `name` varchar(30) NOT NULL default '',
  `pre` varchar(20) NOT NULL default '',
  `dirname` varchar(30) NOT NULL default '',
  `domain` varchar(100) NOT NULL default '',
  `admindir` varchar(20) NOT NULL default '',
  `config` text NOT NULL,
  `list` mediumint(5) NOT NULL default '0',
  `admingroup` varchar(150) NOT NULL default '',
  `adminmember` text NOT NULL,
  `ifclose` tinyint(1) NOT NULL default '0',
  `ifsys` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_alonepage;
CREATE TABLE `qb_alonepage` (
  `id` mediumint(5) NOT NULL auto_increment,
  `fid` mediumint(5) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `title` varchar(100) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `style` varchar(15) NOT NULL default '',
  `tpl_head` varchar(50) NOT NULL default '',
  `tpl_main` varchar(50) NOT NULL default '',
  `tpl_foot` varchar(50) NOT NULL default '',
  `filename` varchar(100) default NULL,
  `filepath` varchar(30) NOT NULL default '',
  `descrip` text NOT NULL,
  `keywords` varchar(255) NOT NULL default '',
  `content` text NOT NULL,
  `hits` int(7) NOT NULL default '0',
  `ishtml` tinyint(1) NOT NULL default '0',
  `city_id` mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `city_id` (`city_id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_config;
CREATE TABLE `qb_config` (
  `c_key` varchar(50) NOT NULL default '',
  `c_value` text NOT NULL,
  `c_descrip` text NOT NULL,
  PRIMARY KEY  (`c_key`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_hack;
CREATE TABLE `qb_hack` (
  `keywords` varchar(30) NOT NULL default '',
  `name` varchar(30) NOT NULL default '',
  `isclose` tinyint(1) NOT NULL default '0',
  `author` varchar(30) NOT NULL default '',
  `config` text NOT NULL,
  `htmlcode` text NOT NULL,
  `hackfile` text NOT NULL,
  `hacksqltable` text NOT NULL,
  `adminurl` varchar(150) NOT NULL default '',
  `about` text NOT NULL,
  `class1` varchar(30) NOT NULL default '',
  `class2` varchar(30) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `linkname` text NOT NULL,
  `isbiz` tinyint(1) NOT NULL default '0',
  UNIQUE KEY `keywords` (`keywords`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_label;
CREATE TABLE `qb_label` (
  `lid` int(10) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `ch` smallint(4) NOT NULL default '0',
  `chtype` tinyint(2) NOT NULL default '0',
  `tag` varchar(50) NOT NULL default '',
  `type` varchar(30) NOT NULL default '',
  `typesystem` tinyint(1) NOT NULL default '0',
  `code` text NOT NULL,
  `divcode` text,
  `hide` tinyint(1) NOT NULL default '0',
  `js_time` int(10) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `pagetype` tinyint(3) NOT NULL default '0',
  `module` mediumint(6) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `if_js` tinyint(1) NOT NULL default '0',
  `style` varchar(40) NOT NULL default '',
  PRIMARY KEY  (`lid`),
  KEY `ch` (`ch`,`pagetype`,`module`,`fid`,`chtype`),
  KEY `tag` (`tag`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_pm;
CREATE TABLE `qb_pm` (
  `mid` int(10) unsigned NOT NULL auto_increment,
  `touid` mediumint(8) unsigned NOT NULL default '0',
  `togroups` varchar(80) NOT NULL default '',
  `fromuid` mediumint(8) unsigned NOT NULL default '0',
  `username` varchar(15) NOT NULL default '',
  `type` enum('rebox','sebox','public') NOT NULL default 'rebox',
  `ifnew` tinyint(1) NOT NULL default '0',
  `title` varchar(130) NOT NULL default '',
  `mdate` int(10) unsigned NOT NULL default '0',
  `content` text NOT NULL,
  PRIMARY KEY  (`mid`),
  KEY `touid` (`touid`),
  KEY `fromuid` (`fromuid`),
  KEY `type` (`type`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_upfile;
CREATE TABLE `qb_upfile` (
  `up_id` mediumint(7) NOT NULL auto_increment,
  `module_id` smallint(4) NOT NULL default '0',
  `ids` varchar(255) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `url` varchar(150) NOT NULL default '',
  `filename` varchar(100) NOT NULL default '',
  `num` smallint(5) NOT NULL default '0',
  `if_tmp` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`up_id`),
  KEY `filename` (`filename`),
  KEY `if_tmp` (`if_tmp`),
  KEY `posttime` (`posttime`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_area;
CREATE TABLE `qb_area` (
  `fid` mediumint(7) unsigned NOT NULL auto_increment,
  `fup` mediumint(7) unsigned NOT NULL default '0',
  `name` varchar(200) NOT NULL default '',
  `class` smallint(4) NOT NULL default '0',
  `sons` smallint(4) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `admin` varchar(100) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `listorder` tinyint(2) NOT NULL default '0',
  `passwd` varchar(32) NOT NULL default '',
  `logo` varchar(150) NOT NULL default '',
  `descrip` text NOT NULL,
  `style` varchar(50) NOT NULL default '',
  `template` text NOT NULL,
  `jumpurl` varchar(150) NOT NULL default '',
  `maxperpage` tinyint(3) NOT NULL default '0',
  `metakeywords` varchar(255) NOT NULL default '',
  `metadescription` varchar(255) NOT NULL default '',
  `allowcomment` tinyint(1) NOT NULL default '0',
  `allowpost` varchar(150) NOT NULL default '',
  `allowviewtitle` varchar(150) NOT NULL default '',
  `allowviewcontent` varchar(150) NOT NULL default '',
  `allowdownload` varchar(150) NOT NULL default '',
  `forbidshow` tinyint(1) NOT NULL default '0',
  `config` text NOT NULL,
  PRIMARY KEY  (`fid`),
  KEY `fup` (`fup`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_jfabout;
CREATE TABLE `qb_jfabout` (
  `id` mediumint(7) NOT NULL auto_increment,
  `fid` mediumint(5) NOT NULL default '0',
  `title` varchar(150) NOT NULL default '',
  `content` text NOT NULL,
  `list` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_jfsort;
CREATE TABLE `qb_jfsort` (
  `fid` mediumint(5) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  PRIMARY KEY  (`fid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_moneycard;
CREATE TABLE `qb_moneycard` (
  `id` mediumint(7) NOT NULL auto_increment,
  `passwd` varchar(32) NOT NULL default '',
  `moneyrmb` int(7) NOT NULL default '0',
  `moneycard` int(7) NOT NULL default '0',
  `ifsell` tinyint(1) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(32) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_olpay;
CREATE TABLE `qb_olpay` (
  `id` mediumint(7) NOT NULL auto_increment,
  `orderid` int(10) NOT NULL default '0',
  `numcode` varchar(32) NOT NULL default '',
  `money` varchar(15) NOT NULL default '0',
  `ifpay` tinyint(1) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(32) NOT NULL default '',
  `paytype` tinyint(3) NOT NULL default '0',
  `moduleid` mediumint(5) NOT NULL default '0',
  `formid` mediumint(5) NOT NULL default '0',
  `banktype` varchar(15) NOT NULL default '',
  `articleid` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `numcode` (`numcode`),
  KEY `paytype` (`paytype`),
  KEY `formid` (`formid`),
  KEY `articleid` (`articleid`),
  KEY `moduleid` (`moduleid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_propagandize;
CREATE TABLE `qb_propagandize` (
  `id` int(10) NOT NULL auto_increment,
  `uid` mediumint(7) NOT NULL default '0',
  `ip` bigint(11) NOT NULL default '0',
  `day` smallint(3) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `fromurl` varchar(150) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `day` (`day`,`uid`,`ip`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_template;
CREATE TABLE `qb_template` (
  `id` mediumint(5) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `type` smallint(4) NOT NULL default '0',
  `filepath` varchar(100) NOT NULL default '',
  `descrip` text NOT NULL,
  `list` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_ad_compete_place;
CREATE TABLE `qb_ad_compete_place` (
  `id` mediumint(7) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `isclose` tinyint(1) NOT NULL default '0',
  `list` int(10) NOT NULL default '0',
  `price` mediumint(5) NOT NULL default '0',
  `day` mediumint(4) NOT NULL default '0',
  `adnum` smallint(3) NOT NULL default '0',
  `wordnum` smallint(3) NOT NULL default '0',
  `autoyz` tinyint(1) NOT NULL default '1',
  `demourl` varchar(150) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_ad_compete_user;
CREATE TABLE `qb_ad_compete_user` (
  `ad_id` mediumint(7) NOT NULL auto_increment,
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `begintime` int(10) NOT NULL default '0',
  `endtime` int(10) NOT NULL default '0',
  `money` mediumint(6) NOT NULL default '0',
  `id` mediumint(7) NOT NULL default '0',
  `yz` tinyint(1) NOT NULL default '1',
  `adlink` varchar(200) NOT NULL default '',
  `adword` varchar(255) NOT NULL default '',
  `hits` mediumint(7) NOT NULL default '0',
  `color` varchar(20) NOT NULL default '',
  `fonttype` tinyint(1) NOT NULL default '0',
  `city_id` mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (`ad_id`),
  KEY `id` (`id`,`endtime`,`money`,`yz`,`city_id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_ad_config;
CREATE TABLE `qb_ad_config` (
  `c_key` varchar(50) NOT NULL default '',
  `c_value` text NOT NULL,
  `c_descrip` text NOT NULL,
  PRIMARY KEY  (`c_key`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_ad_norm_place;
CREATE TABLE `qb_ad_norm_place` (
  `id` mediumint(7) NOT NULL auto_increment,
  `keywords` varchar(50) NOT NULL default '',
  `name` varchar(100) NOT NULL default '',
  `type` varchar(30) NOT NULL default '0',
  `isclose` tinyint(1) NOT NULL default '0',
  `begintime` int(10) NOT NULL default '0',
  `endtime` int(10) NOT NULL default '0',
  `adcode` text NOT NULL,
  `posttime` int(10) NOT NULL default '0',
  `list` int(10) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `hits` mediumint(7) NOT NULL default '0',
  `money` mediumint(6) NOT NULL default '0',
  `moneycard` mediumint(6) NOT NULL default '0',
  `ifsale` tinyint(1) NOT NULL default '0',
  `autoyz` tinyint(1) NOT NULL default '0',
  `demourl` varchar(150) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_ad_norm_user;
CREATE TABLE `qb_ad_norm_user` (
  `u_id` mediumint(7) NOT NULL auto_increment,
  `id` mediumint(7) NOT NULL default '0',
  `u_uid` mediumint(7) NOT NULL default '0',
  `u_username` varchar(30) NOT NULL default '',
  `u_day` smallint(4) NOT NULL default '0',
  `u_begintime` int(10) NOT NULL default '0',
  `u_endtime` int(10) NOT NULL default '0',
  `u_hits` mediumint(7) NOT NULL default '0',
  `u_yz` tinyint(1) NOT NULL default '0',
  `u_code` text NOT NULL,
  `u_money` mediumint(7) NOT NULL default '0',
  `u_moneycard` mediumint(7) NOT NULL default '0',
  `u_posttime` int(10) NOT NULL default '0',
  `city_id` mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (`u_id`),
  KEY `u_endtime` (`u_endtime`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_crontab;
CREATE TABLE `qb_crontab` (
  `id` mediumint(7) NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  `minutetime` mediumint(4) NOT NULL default '0',
  `daytime` varchar(4) NOT NULL default '0',
  `whiletime` int(10) NOT NULL default '0',
  `lasttime` int(10) NOT NULL default '0',
  `filepath` varchar(50) NOT NULL default '',
  `about` text NOT NULL,
  `ifstop` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `ifstop` (`ifstop`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_adminwork;
CREATE TABLE `qb_fenlei_adminwork` (
  `aid` mediumint(7) NOT NULL auto_increment,
  `type` varchar(30) NOT NULL default '',
  `id` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `ifpm` tinyint(1) NOT NULL default '0',
  `fen` smallint(4) NOT NULL default '0',
  `reason` text NOT NULL,
  `posttime` int(10) NOT NULL default '0',
  PRIMARY KEY  (`aid`),
  KEY `type` (`type`),
  KEY `id` (`id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_area;
CREATE TABLE `qb_fenlei_area` (
  `fid` mediumint(7) unsigned NOT NULL default '0',
  `fup` mediumint(7) unsigned NOT NULL default '0',
  `name` varchar(200) NOT NULL default '',
  `class` smallint(4) NOT NULL default '0',
  `sons` smallint(4) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `admin` varchar(100) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `listorder` tinyint(2) NOT NULL default '0',
  `passwd` varchar(32) NOT NULL default '',
  `logo` varchar(150) NOT NULL default '',
  `descrip` text NOT NULL,
  `style` varchar(50) NOT NULL default '',
  `template` text NOT NULL,
  `jumpurl` varchar(150) NOT NULL default '',
  `maxperpage` tinyint(3) NOT NULL default '0',
  `metakeywords` varchar(255) NOT NULL default '',
  `metadescription` varchar(255) NOT NULL default '',
  `allowcomment` tinyint(1) NOT NULL default '0',
  `allowpost` varchar(150) NOT NULL default '',
  `allowviewtitle` varchar(150) NOT NULL default '',
  `allowviewcontent` varchar(150) NOT NULL default '',
  `allowdownload` varchar(150) NOT NULL default '',
  `forbidshow` tinyint(1) NOT NULL default '0',
  `config` text NOT NULL,
  `dirname` varchar(150) NOT NULL default '',
  `hits` mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (`fid`),
  KEY `fup` (`fup`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_buyad;
CREATE TABLE `qb_fenlei_buyad` (
  `aid` mediumint(7) NOT NULL auto_increment,
  `sortid` mediumint(7) NOT NULL default '0',
  `cityid` mediumint(7) NOT NULL default '0',
  `id` int(10) NOT NULL default '0',
  `mid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `begintime` int(10) NOT NULL default '0',
  `endtime` int(10) NOT NULL default '0',
  `money` mediumint(7) NOT NULL default '0',
  `hits` mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (`aid`),
  KEY `sortid` (`sortid`,`money`,`endtime`,`cityid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_city;
CREATE TABLE `qb_fenlei_city` (
  `fid` mediumint(7) unsigned NOT NULL default '0',
  `fup` mediumint(7) unsigned NOT NULL default '0',
  `name` varchar(200) NOT NULL default '',
  `class` smallint(4) NOT NULL default '0',
  `sons` smallint(4) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `admin` varchar(100) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `listorder` tinyint(2) NOT NULL default '0',
  `passwd` varchar(32) NOT NULL default '',
  `logo` varchar(150) NOT NULL default '',
  `descrip` text NOT NULL,
  `style` varchar(50) NOT NULL default '',
  `template` text NOT NULL,
  `jumpurl` varchar(150) NOT NULL default '',
  `maxperpage` tinyint(3) NOT NULL default '0',
  `metakeywords` varchar(255) NOT NULL default '',
  `metadescription` varchar(255) NOT NULL default '',
  `allowcomment` tinyint(1) NOT NULL default '0',
  `allowpost` varchar(150) NOT NULL default '',
  `allowviewtitle` varchar(150) NOT NULL default '',
  `allowviewcontent` varchar(150) NOT NULL default '',
  `allowdownload` varchar(150) NOT NULL default '',
  `forbidshow` tinyint(1) NOT NULL default '0',
  `config` text NOT NULL,
  `hits` mediumint(7) NOT NULL default '0',
  `letter` varchar(5) NOT NULL default '',
  `domain` varchar(150) NOT NULL default '',
  `dirname` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`fid`),
  KEY `fup` (`fup`),
  KEY `letter` (`letter`),
  KEY `list` (`list`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_class;
CREATE TABLE `qb_fenlei_class` (
  `fid` int(7) NOT NULL auto_increment,
  `fup` int(7) NOT NULL default '0',
  `name` varchar(60) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  PRIMARY KEY  (`fid`),
  KEY `fup` (`fup`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_collection;
CREATE TABLE `qb_fenlei_collection` (
  `cid` mediumint(7) NOT NULL auto_increment,
  `id` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  PRIMARY KEY  (`cid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_comments;
CREATE TABLE `qb_fenlei_comments` (
  `cid` mediumint(7) unsigned NOT NULL auto_increment,
  `cuid` int(7) NOT NULL default '0',
  `type` tinyint(2) NOT NULL default '0',
  `id` int(10) unsigned NOT NULL default '0',
  `fid` mediumint(7) unsigned NOT NULL default '0',
  `uid` mediumint(7) unsigned NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `content` text NOT NULL,
  `ip` varchar(15) NOT NULL default '',
  `icon` tinyint(3) NOT NULL default '0',
  `yz` tinyint(1) NOT NULL default '0',
  `flowers` smallint(4) NOT NULL default '0',
  `egg` smallint(4) NOT NULL default '0',
  PRIMARY KEY  (`cid`),
  KEY `type` (`type`),
  KEY `cuid` (`cuid`),
  KEY `id` (`id`,`yz`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_config;
CREATE TABLE `qb_fenlei_config` (
  `c_key` varchar(50) NOT NULL default '',
  `c_value` text NOT NULL,
  `c_descrip` text NOT NULL,
  PRIMARY KEY  (`c_key`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_content;
CREATE TABLE `qb_fenlei_content` (
  `id` int(10) NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  `albumid` mediumint(7) NOT NULL default '0',
  `albumname` varchar(50) NOT NULL default '',
  `mid` smallint(4) NOT NULL default '0',
  `spid` mediumint(7) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `fname` varchar(50) NOT NULL default '',
  `fid_bak1` mediumint(7) NOT NULL default '0',
  `fid_bak2` mediumint(7) NOT NULL default '0',
  `fid_bak3` mediumint(7) NOT NULL default '0',
  `info` tinyint(2) NOT NULL default '0',
  `hits` mediumint(7) NOT NULL default '0',
  `comments` mediumint(7) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `list` varchar(10) NOT NULL default '',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `titlecolor` varchar(15) NOT NULL default '',
  `fonttype` tinyint(1) NOT NULL default '0',
  `picurl` varchar(150) NOT NULL default '',
  `ispic` tinyint(1) NOT NULL default '0',
  `yz` tinyint(1) NOT NULL default '0',
  `yzer` varchar(30) NOT NULL default '',
  `yztime` int(10) NOT NULL default '0',
  `levels` tinyint(2) NOT NULL default '0',
  `levelstime` int(10) NOT NULL default '0',
  `keywords` varchar(100) NOT NULL default '',
  `jumpurl` varchar(150) NOT NULL default '',
  `iframeurl` varchar(150) NOT NULL default '',
  `style` varchar(15) NOT NULL default '',
  `head_tpl` varchar(150) NOT NULL default '',
  `main_tpl` varchar(150) NOT NULL default '',
  `foot_tpl` varchar(100) NOT NULL default '',
  `target` tinyint(1) NOT NULL default '0',
  `ishtml` tinyint(1) NOT NULL default '0',
  `ip` varchar(15) NOT NULL default '',
  `lastfid` mediumint(7) NOT NULL default '0',
  `money` mediumint(7) NOT NULL default '0',
  `passwd` varchar(32) NOT NULL default '',
  `editer` varchar(30) NOT NULL default '',
  `edittime` int(10) NOT NULL default '0',
  `begintime` int(10) NOT NULL default '0',
  `endtime` int(10) NOT NULL default '0',
  `config` text NOT NULL,
  `lastview` int(10) NOT NULL default '0',
  `city_id` mediumint(7) NOT NULL default '0',
  `zone_id` mediumint(7) NOT NULL default '0',
  `street_id` mediumint(7) NOT NULL default '0',
  `editpwd` varchar(32) NOT NULL default '',
  `showday` mediumint(4) NOT NULL default '0',
  `visit_log` text NOT NULL,
  `visit_num` mediumint(7) unsigned NOT NULL default '0',
  `telephone` varchar(30) NOT NULL default '',
  `mobphone` varchar(12) NOT NULL default '',
  `email` varchar(50) NOT NULL default '',
  `oicq` varchar(11) NOT NULL default '',
  `msn` varchar(50) NOT NULL default '',
  `linkman` varchar(20) NOT NULL default '',
  `postcode` varchar(6) NOT NULL default '',
  `address` varchar(250) NOT NULL default '',
  `weburl` varchar(150) NOT NULL default '',
  `fax` varchar(30) NOT NULL default '',
  `maps` varchar(50) NOT NULL default '',
  `picnum` smallint(4) NOT NULL default '0',
  `replytime` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `fid` (`fid`),
  KEY `ispic` (`ispic`),
  KEY `city_id` (`city_id`),
  KEY `zone_id` (`zone_id`),
  KEY `street_id` (`street_id`),
  KEY `list` (`list`,`fid`,`city_id`,`yz`),
  KEY `hits` (`hits`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_content_1;
CREATE TABLE `qb_fenlei_content_1` (
  `rid` mediumint(7) NOT NULL auto_increment,
  `id` mediumint(7) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `content` mediumtext NOT NULL,
  `my_bus` varchar(50) NOT NULL default '',
  `my_station` varchar(100) NOT NULL default '',
  `my_rooms` varchar(30) NOT NULL default '',
  `my_price` int(8) NOT NULL default '0',
  `my_peitao` varchar(150) NOT NULL default '',
  `my_acreage` varchar(12) NOT NULL default '',
  `my_fitment` varchar(15) NOT NULL default '',
  `my_floor` varchar(12) NOT NULL default '',
  `sortid` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`rid`),
  KEY `fid` (`fid`),
  KEY `id` (`id`),
  KEY `uid` (`uid`),
  KEY `sortid` (`sortid`),
  KEY `my_rooms` (`my_rooms`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_content_13;
CREATE TABLE `qb_fenlei_content_13` (
  `rid` mediumint(7) NOT NULL auto_increment,
  `id` int(10) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `content` mediumtext NOT NULL,
  `sortid` tinyint(3) NOT NULL default '0',
  `sortid2` tinyint(3) NOT NULL default '0',
  `my_228` tinyint(1) NOT NULL default '0',
  `my_837` varchar(100) NOT NULL default '',
  `my_613` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`rid`),
  KEY `fid` (`fid`),
  KEY `id` (`id`),
  KEY `uid` (`uid`),
  KEY `sortid` (`sortid`),
  KEY `my_228` (`my_228`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_content_14;
CREATE TABLE `qb_fenlei_content_14` (
  `rid` mediumint(7) NOT NULL auto_increment,
  `id` int(10) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `content` mediumtext NOT NULL,
  `sortid` tinyint(3) NOT NULL default '0',
  `sortid2` tinyint(3) NOT NULL default '0',
  `my_382` tinyint(1) NOT NULL default '0',
  `my_835` varchar(100) NOT NULL default '',
  `my_491` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`rid`),
  KEY `fid` (`fid`),
  KEY `id` (`id`),
  KEY `uid` (`uid`),
  KEY `sortid` (`sortid`),
  KEY `my_382` (`my_382`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_content_2;
CREATE TABLE `qb_fenlei_content_2` (
  `rid` mediumint(7) NOT NULL auto_increment,
  `id` mediumint(7) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `content` mediumtext NOT NULL,
  `sortid` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`rid`),
  KEY `fid` (`fid`),
  KEY `id` (`id`),
  KEY `uid` (`uid`),
  KEY `sortid` (`sortid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_content_3;
CREATE TABLE `qb_fenlei_content_3` (
  `rid` mediumint(7) NOT NULL auto_increment,
  `id` mediumint(7) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `content` mediumtext NOT NULL,
  `my_jobs` varchar(30) NOT NULL default '',
  `my_nums` varchar(12) NOT NULL default '',
  `my_jobabout` mediumtext NOT NULL,
  `my_workplace` varchar(30) NOT NULL default '',
  `wage` tinyint(1) NOT NULL default '0',
  `sortid` char(1) NOT NULL default '',
  PRIMARY KEY  (`rid`),
  KEY `fid` (`fid`),
  KEY `id` (`id`),
  KEY `uid` (`uid`),
  KEY `wage` (`wage`),
  KEY `sortid` (`sortid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_content_4;
CREATE TABLE `qb_fenlei_content_4` (
  `rid` mediumint(7) NOT NULL auto_increment,
  `id` mediumint(7) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `content` mediumtext NOT NULL,
  `sortid` tinyint(1) NOT NULL default '0',
  `my_jobs` varchar(30) NOT NULL default '',
  `my_schoolage` varchar(30) NOT NULL default '',
  `my_sex` varchar(4) NOT NULL default '',
  `my_age` varchar(8) NOT NULL default '',
  `my_workplace` varchar(50) NOT NULL default '',
  `my_wage` varchar(30) NOT NULL default '',
  PRIMARY KEY  (`rid`),
  KEY `fid` (`fid`),
  KEY `id` (`id`),
  KEY `uid` (`uid`),
  KEY `sortid` (`sortid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_content_5;
CREATE TABLE `qb_fenlei_content_5` (
  `rid` mediumint(7) NOT NULL auto_increment,
  `id` mediumint(7) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `content` mediumtext NOT NULL,
  `my_age` varchar(8) NOT NULL default '',
  `my_height` varchar(8) NOT NULL default '',
  `my_job` varchar(30) NOT NULL default '',
  `my_weight` varchar(15) NOT NULL default '',
  `my_interest` varchar(100) NOT NULL default '',
  `my_sex` varchar(4) NOT NULL default '',
  `sortid` tinyint(1) NOT NULL default '0',
  `schoo_age` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`rid`),
  KEY `fid` (`fid`),
  KEY `id` (`id`),
  KEY `uid` (`uid`),
  KEY `sortid` (`sortid`),
  KEY `schoo_age` (`schoo_age`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_content_6;
CREATE TABLE `qb_fenlei_content_6` (
  `rid` mediumint(7) NOT NULL auto_increment,
  `id` mediumint(7) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `content` mediumtext NOT NULL,
  `my_price` int(7) NOT NULL default '0',
  `my_hownew` varchar(12) NOT NULL default '',
  `my_outprice` int(10) NOT NULL default '0',
  `sortid` char(1) NOT NULL default '',
  PRIMARY KEY  (`rid`),
  KEY `fid` (`fid`),
  KEY `id` (`id`),
  KEY `uid` (`uid`),
  KEY `sortid` (`sortid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_content_7;
CREATE TABLE `qb_fenlei_content_7` (
  `rid` mediumint(7) NOT NULL auto_increment,
  `id` mediumint(7) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `content` mediumtext NOT NULL,
  `my_acreage` varchar(12) NOT NULL default '',
  `my_price` int(10) NOT NULL default '0',
  `my_fitment` varchar(20) NOT NULL default '',
  `my_floor` varchar(5) NOT NULL default '',
  `my_station` varchar(50) NOT NULL default '',
  `my_bus` varchar(50) NOT NULL default '',
  `sortid` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`rid`),
  KEY `fid` (`fid`),
  KEY `id` (`id`),
  KEY `uid` (`uid`),
  KEY `sortid` (`sortid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_db;
CREATE TABLE `qb_fenlei_db` (
  `id` int(10) NOT NULL auto_increment,
  `fid` mediumint(7) NOT NULL default '0',
  `city_id` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `fid` (`fid`),
  KEY `city_id` (`city_id`),
  KEY `uid` (`uid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_dianping;
CREATE TABLE `qb_fenlei_dianping` (
  `cid` mediumint(7) unsigned NOT NULL auto_increment,
  `cuid` int(7) NOT NULL default '0',
  `type` tinyint(2) NOT NULL default '0',
  `id` mediumint(7) unsigned NOT NULL default '0',
  `fid` mediumint(7) unsigned NOT NULL default '0',
  `uid` mediumint(7) unsigned NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `content` text NOT NULL,
  `ip` varchar(15) NOT NULL default '',
  `icon` tinyint(3) NOT NULL default '0',
  `yz` tinyint(1) NOT NULL default '0',
  `fen1` smallint(4) NOT NULL default '0',
  `fen2` smallint(4) NOT NULL default '0',
  `fen3` smallint(4) NOT NULL default '0',
  `fen4` smallint(4) NOT NULL default '0',
  `fen5` smallint(4) NOT NULL default '0',
  `flowers` smallint(4) NOT NULL default '0',
  `egg` smallint(4) NOT NULL default '0',
  `price` mediumint(5) NOT NULL default '0',
  `keywords` varchar(100) NOT NULL default '',
  `keywords2` varchar(100) NOT NULL default '',
  `fen6` varchar(150) NOT NULL default '',
  PRIMARY KEY  (`cid`),
  KEY `type` (`type`),
  KEY `cuid` (`cuid`),
  KEY `id` (`id`,`yz`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_field;
CREATE TABLE `qb_fenlei_field` (
  `id` mediumint(7) NOT NULL auto_increment,
  `mid` mediumint(5) NOT NULL default '0',
  `title` varchar(50) NOT NULL default '',
  `field_name` varchar(30) NOT NULL default '',
  `field_type` varchar(15) NOT NULL default '',
  `field_leng` smallint(3) NOT NULL default '0',
  `orderlist` int(10) NOT NULL default '0',
  `form_type` varchar(15) NOT NULL default '',
  `field_inputwidth` smallint(3) default NULL,
  `field_inputheight` smallint(3) NOT NULL default '0',
  `form_set` text NOT NULL,
  `form_value` text NOT NULL,
  `form_units` varchar(30) NOT NULL default '',
  `form_title` text NOT NULL,
  `mustfill` tinyint(1) NOT NULL default '0',
  `listshow` tinyint(1) NOT NULL default '0',
  `listfilter` tinyint(1) default NULL,
  `search` tinyint(1) NOT NULL default '0',
  `allowview` varchar(255) NOT NULL default '',
  `allowpost` varchar(255) NOT NULL default '',
  `js_check` text NOT NULL,
  `js_checkmsg` varchar(255) NOT NULL default '',
  `classid` mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_friendlink;
CREATE TABLE `qb_fenlei_friendlink` (
  `id` mediumint(5) NOT NULL auto_increment,
  `fid` int(7) NOT NULL default '0',
  `name` varchar(30) NOT NULL default '',
  `url` varchar(150) NOT NULL default '',
  `logo` varchar(150) NOT NULL default '',
  `descrip` varchar(255) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `ifhide` tinyint(1) NOT NULL default '0',
  `iswordlink` tinyint(1) default NULL,
  `hits` tinyint(7) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `uid` int(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `yz` tinyint(1) NOT NULL default '1',
  `endtime` int(10) NOT NULL default '0',
  `city_id` mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `yz` (`yz`,`endtime`,`ifhide`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_module;
CREATE TABLE `qb_fenlei_module` (
  `id` smallint(4) NOT NULL auto_increment,
  `sort_id` mediumint(5) NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  `list` smallint(4) NOT NULL default '0',
  `style` varchar(50) NOT NULL default '',
  `config` text NOT NULL,
  `config2` text NOT NULL,
  `comment_type` tinyint(1) NOT NULL default '0',
  `ifdp` tinyint(1) NOT NULL default '0',
  `template` text NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_module_sort;
CREATE TABLE `qb_fenlei_module_sort` (
  `sort_id` mediumint(5) NOT NULL auto_increment,
  `sort_name` varchar(30) NOT NULL default '',
  PRIMARY KEY  (`sort_id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_pic;
CREATE TABLE `qb_fenlei_pic` (
  `pid` mediumint(7) NOT NULL auto_increment,
  `id` mediumint(10) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `mid` smallint(4) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `imgurl` varchar(150) NOT NULL default '',
  `name` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`pid`),
  KEY `id` (`id`),
  KEY `fid` (`fid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_report;
CREATE TABLE `qb_fenlei_report` (
  `rid` mediumint(7) NOT NULL auto_increment,
  `id` mediumint(7) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `onlineip` varchar(15) NOT NULL default '',
  `type` tinyint(2) NOT NULL default '0',
  `content` text NOT NULL,
  `iftrue` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`rid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_sort;
CREATE TABLE `qb_fenlei_sort` (
  `fid` mediumint(7) unsigned NOT NULL auto_increment,
  `fup` mediumint(7) unsigned NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  `mid` smallint(4) NOT NULL default '0',
  `class` smallint(4) NOT NULL default '0',
  `sons` smallint(4) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `admin` varchar(100) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `listorder` tinyint(2) NOT NULL default '0',
  `passwd` varchar(32) NOT NULL default '',
  `logo` varchar(150) NOT NULL default '',
  `descrip` text NOT NULL,
  `style` varchar(50) NOT NULL default '',
  `template` text NOT NULL,
  `jumpurl` varchar(150) NOT NULL default '',
  `maxperpage` tinyint(3) NOT NULL default '0',
  `metatitle` varchar(250) NOT NULL default '',
  `metakeywords` varchar(255) NOT NULL default '',
  `metadescription` varchar(255) NOT NULL default '',
  `allowcomment` tinyint(1) NOT NULL default '0',
  `allowpost` varchar(150) NOT NULL default '',
  `allowviewtitle` varchar(150) NOT NULL default '',
  `allowviewcontent` varchar(150) NOT NULL default '',
  `allowdownload` varchar(150) NOT NULL default '',
  `forbidshow` tinyint(1) NOT NULL default '0',
  `config` mediumtext NOT NULL,
  `index_show` tinyint(1) NOT NULL default '0',
  `contents` mediumint(4) NOT NULL default '0',
  `tableid` varchar(30) NOT NULL default '',
  `dir_name` varchar(50) NOT NULL default '',
  `ifcolor` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`fid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_street;
CREATE TABLE `qb_fenlei_street` (
  `fid` mediumint(7) unsigned NOT NULL auto_increment,
  `fup` mediumint(7) unsigned NOT NULL default '0',
  `name` varchar(200) NOT NULL default '',
  `class` smallint(4) NOT NULL default '0',
  `sons` smallint(4) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `admin` varchar(100) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `listorder` tinyint(2) NOT NULL default '0',
  `passwd` varchar(32) NOT NULL default '',
  `logo` varchar(150) NOT NULL default '',
  `descrip` text NOT NULL,
  `style` varchar(50) NOT NULL default '',
  `template` text NOT NULL,
  `jumpurl` varchar(150) NOT NULL default '',
  `maxperpage` tinyint(3) NOT NULL default '0',
  `metakeywords` varchar(255) NOT NULL default '',
  `metadescription` varchar(255) NOT NULL default '',
  `allowcomment` tinyint(1) NOT NULL default '0',
  `allowpost` varchar(150) NOT NULL default '',
  `allowviewtitle` varchar(150) NOT NULL default '',
  `allowviewcontent` varchar(150) NOT NULL default '',
  `allowdownload` varchar(150) NOT NULL default '',
  `forbidshow` tinyint(1) NOT NULL default '0',
  `config` text NOT NULL,
  `dirname` varchar(150) NOT NULL default '',
  PRIMARY KEY  (`fid`),
  KEY `fup` (`fup`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_fenlei_zone;
CREATE TABLE `qb_fenlei_zone` (
  `fid` mediumint(7) unsigned NOT NULL auto_increment,
  `fup` mediumint(7) unsigned NOT NULL default '0',
  `name` varchar(200) NOT NULL default '',
  `class` smallint(4) NOT NULL default '0',
  `sons` smallint(4) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `admin` varchar(100) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `listorder` tinyint(2) NOT NULL default '0',
  `passwd` varchar(32) NOT NULL default '',
  `logo` varchar(150) NOT NULL default '',
  `descrip` text NOT NULL,
  `style` varchar(50) NOT NULL default '',
  `template` text NOT NULL,
  `jumpurl` varchar(150) NOT NULL default '',
  `maxperpage` tinyint(3) NOT NULL default '0',
  `metakeywords` varchar(255) NOT NULL default '',
  `metadescription` varchar(255) NOT NULL default '',
  `allowcomment` tinyint(1) NOT NULL default '0',
  `allowpost` varchar(150) NOT NULL default '',
  `allowviewtitle` varchar(150) NOT NULL default '',
  `allowviewcontent` varchar(150) NOT NULL default '',
  `allowdownload` varchar(150) NOT NULL default '',
  `forbidshow` tinyint(1) NOT NULL default '0',
  `config` text NOT NULL,
  `dirname` varchar(150) NOT NULL default '',
  PRIMARY KEY  (`fid`),
  KEY `fup` (`fup`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_moneylog;
CREATE TABLE `qb_moneylog` (
  `id` mediumint(7) NOT NULL auto_increment,
  `uid` mediumint(7) NOT NULL default '0',
  `money` mediumint(7) NOT NULL default '0',
  `about` varchar(255) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `uid` (`uid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_yzimg;
CREATE TABLE `qb_yzimg` (
  `sid` varchar(8) NOT NULL default '',
  `imgnum` varchar(6) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  UNIQUE KEY `sid` (`sid`),
  KEY `posttime` (`imgnum`,`posttime`)
) TYPE=HEAP;


INSERT INTO `qb_members` VALUES ('1','admin','21232f297a57a5a743894a0e4a801fc3');
INSERT INTO `qb_memberdata` VALUES ('1','admin','BA598D96B196817A143DE2D8FAF06644','','3','1','','1','0','','1379','0','79412604','3778049','1306901043','127.0.0.1','1253678332','127.0.0.1','1','1890-00-00','http://v7.com/upload_files/icon/1.jpg','','84','1295430845','888888','','','65223@qq.com','20','345','cvbnmmm','','13399999999','','','ѧ','a:1:{s:7:\"endtime\";s:0:\"\";}','5','0','0','0');
INSERT INTO `qb_group` VALUES ('2','1','ο','0','0','0','a:54:{s:10:\"upfileType\";s:0:\"\";s:13:\"upfileMaxSize\";s:0:\"\";s:14:\"PassContribute\";s:1:\"1\";s:17:\"SearchArticleType\";s:1:\"1\";s:16:\"PostArticleYzImg\";s:1:\"1\";s:13:\"EditPassPower\";s:1:\"0\";s:12:\"SetTileColor\";s:1:\"0\";s:14:\"SetSellArticle\";s:1:\"0\";s:17:\"SetSpecialArticle\";s:1:\"0\";s:17:\"SetArticleKeyword\";s:1:\"0\";s:20:\"AddArticleKeywordNum\";s:0:\"\";s:21:\"AddArticleCopyfromNum\";s:0:\"\";s:18:\"SelectArticleStyle\";s:1:\"0\";s:16:\"SelectArticleTpl\";s:1:\"0\";s:13:\"SetArticleTpl\";s:1:\"0\";s:18:\"SetArticlePosttime\";s:1:\"0\";s:18:\"SetArticleViewtime\";s:1:\"0\";s:16:\"SetArticleHitNum\";s:1:\"0\";s:18:\"SetArticlePassword\";s:1:\"0\";s:19:\"SetArticleDownGroup\";s:1:\"0\";s:19:\"SetArticleViewGroup\";s:1:\"0\";s:17:\"SetArticleJumpurl\";s:1:\"0\";s:19:\"SetArticleIframeurl\";s:1:\"0\";s:21:\"SetArticleDescription\";s:1:\"0\";s:16:\"SetArticleTopCom\";s:1:\"0\";s:13:\"SetSmallTitle\";s:1:\"0\";s:19:\"CommentArticleYzImg\";s:1:\"1\";s:17:\"CollectArticleNum\";s:0:\"\";s:15:\"CreatSpecialNum\";s:0:\"\";s:13:\"PostNoDelCode\";s:1:\"0\";s:7:\"SetVote\";s:1:\"0\";s:11:\"SetHtmlName\";s:1:\"0\";s:16:\"PassContributeSP\";s:1:\"0\";s:14:\"AllowUploadMax\";s:1:\"0\";s:11:\"comment_num\";s:2:\"10\";s:10:\"comment_yz\";s:1:\"1\";s:11:\"comment_img\";s:1:\"0\";s:16:\"sell_postauto_yz\";s:1:\"0\";s:15:\"buy_postauto_yz\";s:1:\"0\";s:15:\"post_pingpai_yz\";s:1:\"0\";s:10:\"use2domain\";s:1:\"0\";s:16:\"useHomepageStyle\";s:1:\"0\";s:21:\"view_buy_view_contact\";s:1:\"0\";s:13:\"post_sell_num\";s:0:\"\";s:12:\"post_buy_num\";s:0:\"\";s:13:\"post_news_num\";s:0:\"\";s:14:\"post_photo_num\";s:0:\"\";s:11:\"post_hr_num\";s:0:\"\";s:17:\"post_zhanghui_num\";s:0:\"\";s:12:\"post_ZLG_num\";s:0:\"\";s:16:\"post_pingpai_num\";s:0:\"\";s:19:\"post_baojiadian_num\";s:0:\"\";s:19:\"post_xunjiadian_num\";s:0:\"\";s:24:\"post_info_collection_num\";s:0:\"\";}','0','');
INSERT INTO `qb_group` VALUES ('3','1','Ա','0','0','0','a:26:{s:10:\"upfileType\";s:0:\"\";s:13:\"upfileMaxSize\";s:0:\"\";s:14:\"PassContribute\";s:1:\"1\";s:13:\"EditPassPower\";s:1:\"0\";s:14:\"AllowUploadMax\";s:1:\"1\";s:11:\"comment_num\";s:0:\"\";s:10:\"comment_yz\";s:1:\"1\";s:11:\"comment_img\";s:1:\"0\";s:16:\"sell_postauto_yz\";s:1:\"0\";s:15:\"buy_postauto_yz\";s:1:\"0\";s:15:\"post_pingpai_yz\";s:1:\"0\";s:10:\"use2domain\";s:1:\"0\";s:16:\"useHomepageStyle\";s:1:\"0\";s:21:\"view_buy_view_contact\";s:1:\"0\";s:13:\"post_sell_num\";s:0:\"\";s:12:\"post_buy_num\";s:0:\"\";s:13:\"post_news_num\";s:0:\"\";s:14:\"post_photo_num\";s:0:\"\";s:11:\"post_hr_num\";s:0:\"\";s:17:\"post_zhanghui_num\";s:0:\"\";s:12:\"post_ZLG_num\";s:0:\"\";s:16:\"post_pingpai_num\";s:0:\"\";s:19:\"post_baojiadian_num\";s:0:\"\";s:19:\"post_xunjiadian_num\";s:0:\"\";s:24:\"post_info_collection_num\";s:0:\"\";s:18:\"allow_get_homepage\";s:1:\"1\";}','1','a:58:{s:13:\"center_config\";s:1:\"1\";s:8:\"user_reg\";s:1:\"1\";s:11:\"module_list\";s:1:\"1\";s:9:\"hack_list\";s:1:\"1\";s:9:\"blend_set\";s:1:\"1\";s:14:\"alonepage_list\";s:1:\"1\";s:9:\"mysql_out\";s:1:\"1\";s:10:\"mysql_into\";s:1:\"1\";s:9:\"mysql_del\";s:1:\"1\";s:9:\"mysql_sql\";s:1:\"1\";s:9:\"menu_list\";s:1:\"1\";s:14:\"adminmenu_list\";s:1:\"1\";s:11:\"member_list\";s:1:\"1\";s:8:\"regfield\";s:1:\"1\";s:16:\"member_addmember\";s:1:\"1\";s:10:\"group_list\";s:1:\"1\";s:16:\"group_list_admin\";s:1:\"1\";s:9:\"group_add\";s:1:\"1\";s:10:\"alipay_set\";s:1:\"1\";s:14:\"moneycard_make\";s:1:\"1\";s:7:\"js_list\";s:1:\"1\";s:12:\"propagandize\";s:1:\"1\";s:11:\"jfadmin_mod\";s:1:\"1\";s:15:\"attachment_list\";s:1:\"1\";s:9:\"area_list\";s:1:\"1\";s:10:\"upgrade_ol\";s:1:\"1\";s:14:\"limitword_list\";s:1:\"1\";s:12:\"message_send\";s:1:\"1\";s:9:\"mail_send\";s:1:\"1\";s:8:\"sms_send\";s:1:\"1\";s:8:\"cnzz_set\";s:1:\"1\";s:15:\"logs_login_logs\";s:1:\"1\";s:18:\"logs_admin_do_logs\";s:1:\"1\";s:5:\"login\";s:1:\"1\";s:8:\"moneylog\";s:1:\"1\";s:7:\"crontab\";s:1:\"1\";s:27:\"Module_fenlei_center_config\";s:1:\"1\";s:25:\"Module_fenlei_center_html\";s:1:\"1\";s:27:\"Module_fenlei_center_settpl\";s:1:\"1\";s:29:\"Module_fenlei_center_settable\";s:1:\"1\";s:22:\"Module_fenlei_autopass\";s:1:\"1\";s:26:\"Module_fenlei_center_label\";s:1:\"1\";s:18:\"Module_fenlei_list\";s:1:\"1\";s:21:\"Module_fenlei_comment\";s:1:\"1\";s:22:\"Module_fenlei_dianping\";s:1:\"1\";s:18:\"Module_fenlei_sort\";s:1:\"1\";s:20:\"Module_fenlei_module\";s:1:\"1\";s:23:\"Module_fenlei_fieldsort\";s:1:\"1\";s:18:\"Module_fenlei_city\";s:1:\"1\";s:20:\"Module_fenlei_report\";s:1:\"1\";s:21:\"Module_fenlei_replace\";s:1:\"1\";s:24:\"Module_fenlei_friendlink\";s:1:\"1\";s:16:\"Module_ad_center\";s:1:\"1\";s:21:\"Module_ad_norm_listad\";s:1:\"1\";s:25:\"Module_ad_norm_listuserad\";s:1:\"1\";s:24:\"Module_ad_compete_listad\";s:1:\"1\";s:26:\"Module_ad_compete_listuser\";s:1:\"1\";s:6:\"mymenu\";N;}');
INSERT INTO `qb_group` VALUES ('8','0','ͨԱ','0','50','0','a:62:{s:10:\"upfileType\";s:0:\"\";s:13:\"upfileMaxSize\";s:0:\"\";s:14:\"PassContribute\";s:1:\"1\";s:13:\"EditPassPower\";s:1:\"0\";s:17:\"SearchArticleType\";s:1:\"1\";s:12:\"SetTileColor\";s:1:\"0\";s:14:\"SetSellArticle\";s:1:\"0\";s:13:\"SetSmallTitle\";s:1:\"0\";s:17:\"SetSpecialArticle\";s:1:\"1\";s:17:\"SetArticleKeyword\";s:1:\"1\";s:20:\"AddArticleKeywordNum\";s:1:\"0\";s:16:\"PostArticleYzImg\";s:1:\"0\";s:21:\"AddArticleCopyfromNum\";s:1:\"0\";s:16:\"SelectArticleTpl\";s:1:\"0\";s:13:\"SetArticleTpl\";s:1:\"0\";s:18:\"SelectArticleStyle\";s:1:\"0\";s:18:\"SetArticlePosttime\";s:1:\"0\";s:18:\"SetArticleViewtime\";s:1:\"0\";s:16:\"SetArticleHitNum\";s:1:\"0\";s:18:\"SetArticlePassword\";s:1:\"0\";s:19:\"SetArticleDownGroup\";s:1:\"0\";s:19:\"SetArticleViewGroup\";s:1:\"0\";s:17:\"SetArticleJumpurl\";s:1:\"0\";s:19:\"SetArticleIframeurl\";s:1:\"0\";s:21:\"SetArticleDescription\";s:1:\"0\";s:16:\"SetArticleTopCom\";s:1:\"0\";s:17:\"CollectArticleNum\";s:2:\"30\";s:15:\"CreatSpecialNum\";s:1:\"7\";s:19:\"CommentArticleYzImg\";s:1:\"1\";s:11:\"SetHtmlName\";s:1:\"0\";s:7:\"SetVote\";s:1:\"1\";s:16:\"PassContributeSP\";s:1:\"0\";s:13:\"PostNoDelCode\";s:1:\"0\";s:14:\"AllowUploadMax\";s:1:\"0\";s:11:\"comment_num\";s:0:\"\";s:10:\"comment_yz\";s:1:\"0\";s:11:\"comment_img\";s:1:\"0\";s:16:\"sell_postauto_yz\";s:1:\"1\";s:15:\"buy_postauto_yz\";s:1:\"1\";s:15:\"post_pingpai_yz\";s:1:\"1\";s:10:\"use2domain\";s:1:\"0\";s:16:\"useHomepageStyle\";s:1:\"0\";s:21:\"view_buy_view_contact\";s:1:\"0\";s:13:\"post_sell_num\";s:1:\"5\";s:12:\"post_buy_num\";s:1:\"5\";s:13:\"post_news_num\";s:1:\"5\";s:14:\"post_photo_num\";s:2:\"10\";s:11:\"post_hr_num\";s:1:\"5\";s:17:\"post_zhanghui_num\";s:1:\"5\";s:12:\"post_ZLG_num\";s:1:\"0\";s:16:\"post_pingpai_num\";s:1:\"5\";s:19:\"post_baojiadian_num\";s:1:\"5\";s:19:\"post_xunjiadian_num\";s:1:\"5\";s:24:\"post_info_collection_num\";s:2:\"30\";s:18:\"allow_get_homepage\";s:1:\"1\";s:16:\"shop_postauto_yz\";s:1:\"1\";s:14:\"tg_postauto_yz\";s:1:\"1\";s:14:\"post_coupon_yz\";s:1:\"0\";s:13:\"post_shop_num\";s:1:\"5\";s:11:\"post_tg_num\";s:1:\"3\";s:15:\"post_coupon_num\";s:1:\"3\";s:13:\"post_gift_num\";s:1:\"0\";}','0','');
INSERT INTO `qb_group` VALUES ('9','0','VIPԱ','10000','0','0','a:61:{s:17:\"SearchArticleType\";s:1:\"0\";s:16:\"PostArticleYzImg\";s:1:\"0\";s:14:\"PassContribute\";s:1:\"1\";s:13:\"EditPassPower\";s:1:\"0\";s:12:\"SetTileColor\";s:1:\"0\";s:14:\"SetSellArticle\";s:1:\"0\";s:17:\"SetSpecialArticle\";s:1:\"0\";s:17:\"SetArticleKeyword\";s:1:\"0\";s:20:\"AddArticleKeywordNum\";s:0:\"\";s:21:\"AddArticleCopyfromNum\";s:0:\"\";s:18:\"SelectArticleStyle\";s:1:\"0\";s:16:\"SelectArticleTpl\";s:1:\"0\";s:13:\"SetArticleTpl\";s:1:\"0\";s:18:\"SetArticlePosttime\";s:1:\"0\";s:18:\"SetArticleViewtime\";s:1:\"0\";s:16:\"SetArticleHitNum\";s:1:\"0\";s:18:\"SetArticlePassword\";s:1:\"0\";s:19:\"SetArticleDownGroup\";s:1:\"0\";s:19:\"SetArticleViewGroup\";s:1:\"0\";s:17:\"SetArticleJumpurl\";s:1:\"0\";s:19:\"SetArticleIframeurl\";s:1:\"0\";s:21:\"SetArticleDescription\";s:1:\"0\";s:16:\"SetArticleTopCom\";s:1:\"0\";s:13:\"SetSmallTitle\";s:1:\"0\";s:19:\"CommentArticleYzImg\";s:1:\"0\";s:17:\"CollectArticleNum\";s:0:\"\";s:15:\"CreatSpecialNum\";s:0:\"\";s:14:\"AllowUploadMax\";s:1:\"0\";s:10:\"upfileType\";s:0:\"\";s:13:\"upfileMaxSize\";s:0:\"\";s:11:\"comment_num\";s:2:\"30\";s:10:\"comment_yz\";s:1:\"0\";s:11:\"comment_img\";s:1:\"0\";s:16:\"sell_postauto_yz\";s:1:\"1\";s:15:\"buy_postauto_yz\";s:1:\"1\";s:15:\"post_pingpai_yz\";s:1:\"1\";s:10:\"use2domain\";s:1:\"1\";s:16:\"useHomepageStyle\";s:1:\"1\";s:21:\"view_buy_view_contact\";s:1:\"1\";s:9:\"topmyinfo\";s:0:\"\";s:12:\"topmyinfoday\";s:0:\"\";s:13:\"topcompanyday\";s:0:\"\";s:13:\"post_sell_num\";s:2:\"50\";s:12:\"post_buy_num\";s:2:\"50\";s:13:\"post_news_num\";s:2:\"50\";s:14:\"post_photo_num\";s:3:\"100\";s:11:\"post_hr_num\";s:2:\"20\";s:17:\"post_zhanghui_num\";s:2:\"20\";s:12:\"post_ZLG_num\";s:1:\"5\";s:19:\"post_baojiadian_num\";s:2:\"50\";s:19:\"post_xunjiadian_num\";s:2:\"50\";s:16:\"post_pingpai_num\";s:2:\"10\";s:24:\"post_info_collection_num\";s:3:\"100\";s:18:\"allow_get_homepage\";s:1:\"1\";s:16:\"shop_postauto_yz\";s:1:\"1\";s:14:\"tg_postauto_yz\";s:1:\"1\";s:14:\"post_coupon_yz\";s:1:\"1\";s:13:\"post_shop_num\";s:3:\"100\";s:11:\"post_tg_num\";s:2:\"50\";s:15:\"post_coupon_num\";s:2:\"50\";s:13:\"post_gift_num\";s:1:\"0\";}','0','');
INSERT INTO `qb_group` VALUES ('10','0','ʯԱ','30000','0','0','a:57:{s:17:\"SearchArticleType\";s:1:\"0\";s:19:\"CommentArticleYzImg\";s:1:\"0\";s:17:\"CollectArticleNum\";s:0:\"\";s:15:\"CreatSpecialNum\";s:0:\"\";s:16:\"PassContributeSP\";s:1:\"0\";s:16:\"PostArticleYzImg\";s:1:\"0\";s:14:\"PassContribute\";s:1:\"1\";s:13:\"EditPassPower\";s:1:\"0\";s:13:\"PostNoDelCode\";s:1:\"0\";s:7:\"SetVote\";s:1:\"0\";s:12:\"SetTileColor\";s:1:\"0\";s:14:\"SetSellArticle\";s:1:\"0\";s:18:\"SelectArticleStyle\";s:1:\"0\";s:16:\"SelectArticleTpl\";s:1:\"0\";s:13:\"SetArticleTpl\";s:1:\"0\";s:18:\"SetArticlePosttime\";s:1:\"0\";s:18:\"SetArticleViewtime\";s:1:\"0\";s:16:\"SetArticleHitNum\";s:1:\"0\";s:18:\"SetArticlePassword\";s:1:\"0\";s:19:\"SetArticleDownGroup\";s:1:\"0\";s:19:\"SetArticleViewGroup\";s:1:\"0\";s:17:\"SetArticleJumpurl\";s:1:\"0\";s:19:\"SetArticleIframeurl\";s:1:\"0\";s:21:\"SetArticleDescription\";s:1:\"0\";s:16:\"SetArticleTopCom\";s:1:\"0\";s:11:\"SetHtmlName\";s:1:\"0\";s:14:\"AllowUploadMax\";s:1:\"0\";s:10:\"upfileType\";s:0:\"\";s:13:\"upfileMaxSize\";s:0:\"\";s:11:\"comment_num\";s:0:\"\";s:10:\"comment_yz\";s:1:\"1\";s:11:\"comment_img\";s:1:\"1\";s:16:\"sell_postauto_yz\";s:1:\"1\";s:15:\"buy_postauto_yz\";s:1:\"1\";s:15:\"post_pingpai_yz\";s:1:\"1\";s:10:\"use2domain\";s:1:\"1\";s:16:\"useHomepageStyle\";s:1:\"1\";s:21:\"view_buy_view_contact\";s:1:\"1\";s:13:\"post_sell_num\";s:3:\"100\";s:12:\"post_buy_num\";s:3:\"100\";s:13:\"post_news_num\";s:3:\"100\";s:14:\"post_photo_num\";s:3:\"100\";s:11:\"post_hr_num\";s:3:\"100\";s:17:\"post_zhanghui_num\";s:3:\"100\";s:12:\"post_ZLG_num\";s:2:\"10\";s:16:\"post_pingpai_num\";s:2:\"10\";s:19:\"post_baojiadian_num\";s:3:\"100\";s:19:\"post_xunjiadian_num\";s:3:\"100\";s:24:\"post_info_collection_num\";s:3:\"300\";s:18:\"allow_get_homepage\";s:1:\"1\";s:16:\"shop_postauto_yz\";s:1:\"1\";s:14:\"tg_postauto_yz\";s:1:\"1\";s:14:\"post_coupon_yz\";s:1:\"1\";s:13:\"post_shop_num\";s:3:\"200\";s:11:\"post_tg_num\";s:3:\"100\";s:15:\"post_coupon_num\";s:2:\"50\";s:13:\"post_gift_num\";s:1:\"1\";}','0','');
INSERT INTO `qb_admin_menu` VALUES ('87','0','Ҫ','','','0','7','3','0');
INSERT INTO `qb_admin_menu` VALUES ('90','87','ҳ಼','index.php?lfj=module_admin&dirname=f&file=center&job=settable','','0','0','3','0');
INSERT INTO `qb_admin_menu` VALUES ('144','0','','','','0','8','3','0');
INSERT INTO `qb_admin_menu` VALUES ('145','144','ȫֲ','index.php?lfj=center&job=config','','0','0','3','0');
INSERT INTO `qb_admin_menu` VALUES ('146','144','ز','index.php?lfj=module_admin&dirname=f&file=center&job=post','','0','0','3','0');
INSERT INTO `qb_admin_menu` VALUES ('147','87','ҳǩ','index.php?lfj=module_admin&dirname=f&file=center&job=label','','0','10','3','0');
INSERT INTO `qb_admin_menu` VALUES ('148','87','Ϣ','index.php?lfj=module_admin&dirname=f&file=list&job=list','','0','0','3','0');
INSERT INTO `qb_admin_menu` VALUES ('149','87','۹','index.php?lfj=module_admin&dirname=f&file=comment&job=list','','0','0','3','0');
INSERT INTO `qb_admin_menu` VALUES ('150','87','Ŀ','index.php?lfj=module_admin&dirname=f&file=sort&job=listsort','','0','0','3','0');
INSERT INTO `qb_admin_menu` VALUES ('151','87','е','index.php?lfj=module_admin&dirname=f&file=city&job=city','','0','0','3','0');
INSERT INTO `qb_admin_menu` VALUES ('152','87','ӹ','index.php?lfj=module_admin&dirname=f&file=friendlink&job=list','','0','0','3','0');
INSERT INTO `qb_module` VALUES ('2','2','ϵͳ','ad_','a_d','','','','0','','','0','0');
INSERT INTO `qb_module` VALUES ('1','2','Ϣ','fenlei_','f','','','a:7:{s:12:\"list_PhpName\";s:18:\"list.php?&fid=$fid\";s:12:\"show_PhpName\";s:29:\"bencandy.php?&fid=$fid&id=$id\";s:8:\"MakeHtml\";N;s:14:\"list_HtmlName1\";N;s:14:\"show_HtmlName1\";N;s:14:\"list_HtmlName2\";N;s:14:\"show_HtmlName2\";N;}','80','','','0','1');
INSERT INTO `qb_alonepage` VALUES ('1','0','','','1229507597','0','','','','','','friendlink.htm','','','','<table cellSpacing=4 cellPadding=4 width=\"100%\" border=0>\r\n<tbody>\r\n<tr>\r\n<td width=\"20%\"><a href=\"http://www.mmcbbs.com/\" target=_blank>ݼݼ̳</a></td>\r\n<td width=\"20%\"><a href=\"http://www.liuv.net/\" target=_blank>ˮ</a></td>\r\n<td width=\"20%\"><a href=\"http://pic.goodod.com/\" target=_blank>ŷֻͼƬ</a></td>\r\n<td width=\"20%\"><a href=\"http://www.tianyakezhan.com/\" target=_blank>Ŀջ</a></td>\r\n<td width=\"20%\"><a href=\"http://www.czin.cn/\" target=_blank></a></td></tr>\r\n<tr>\r\n<td width=\"20%\"><a href=\"http://www.jneg.com.cn/\" target=_blank>ܼ԰</a></td>\r\n<td width=\"20%\"><a href=\"http://www.wyrj.com/\" target=_blank>˼</a></td>\r\n<td width=\"20%\"><a href=\"http://www.nenbei.com/\" target=_blank>۱</a></td>\r\n<td width=\"20%\"><a href=\"http://www.photosbar.com/\" target=_blank>ͼ</a></td>\r\n<td width=\"20%\"><a href=\"http://www.ok586.cn/\" target=_blank></a></td></tr>\r\n<tr>\r\n<td width=\"20%\"><a href=\"http://www.51solo.net/\" target=_blank>Ұ</a></td>\r\n<td width=\"20%\"><a href=\"http://www.toopd.com/\" target=_blank></a></td>\r\n<td width=\"20%\"><a href=\"http://www.qiqig.com/\" target=_blank></a></td>\r\n<td width=\"20%\"><a href=\"http://www.jxsrjys.com.cn/\" target=_blank>Ľ</a></td>\r\n<td width=\"20%\"><a href=\"http://www.unok.net/\" target=_blank></a></td></tr>\r\n<tr>\r\n<td width=\"20%\"><a href=\"http://mmm.pudou.com/\" target=_blank>˶й</a></td>\r\n<td width=\"20%\"><a href=\"http://www.itzhan.com/\" target=_blank>IT</a></td>\r\n<td width=\"20%\"><a href=\"http://www.hkwtv.com/\" target=_blank></a></td>\r\n<td width=\"20%\">&nbsp;</td>\r\n<td width=\"20%\">&nbsp;</td></tr></tbody></table>','54','0','0');
INSERT INTO `qb_config` VALUES ('yzImgComment','0','');
INSERT INTO `qb_config` VALUES ('flashtime','0','');
INSERT INTO `qb_config` VALUES ('showComment','1','');
INSERT INTO `qb_config` VALUES ('forbidComment','0','');
INSERT INTO `qb_config` VALUES ('showCommentRows','8','');
INSERT INTO `qb_config` VALUES ('viewNoPassGuestBook','1','');
INSERT INTO `qb_config` VALUES ('yzImgContribute','0','');
INSERT INTO `qb_config` VALUES ('groupPassContribute','3','');
INSERT INTO `qb_config` VALUES ('limitRegTime','','');
INSERT INTO `qb_config` VALUES ('MaxOnlineUser','1000','');
INSERT INTO `qb_config` VALUES ('groupPassShopYz','3,4','');
INSERT INTO `qb_config` VALUES ('groupPassPassGuestBook','3','');
INSERT INTO `qb_config` VALUES ('ifOpenGuestBook','1','');
INSERT INTO `qb_config` VALUES ('yzImgGuestBook','1','');
INSERT INTO `qb_config` VALUES ('ContributeFid','2','');
INSERT INTO `qb_config` VALUES ('groupPassLogYz','3,4','');
INSERT INTO `qb_config` VALUES ('forbidReg','0','');
INSERT INTO `qb_config` VALUES ('FtpPort','21','');
INSERT INTO `qb_config` VALUES ('PostSortStep','2','');
INSERT INTO `qb_config` VALUES ('ListSonline','2','');
INSERT INTO `qb_config` VALUES ('_Notice','29weSgiaHR0cDovL3d3dy5waHAxNjguY29tL05vdGljZS8/dXJsPSR3ZWJkYlt3d3dfdXJsXSIsUEhQMTY4X1BBVEguImNhY2hlL05vdGljZS5waHAiKTs=','');
INSERT INTO `qb_config` VALUES ('CommentTime','5','');
INSERT INTO `qb_config` VALUES ('weburl','/','');
INSERT INTO `qb_config` VALUES ('MailType','smtp','');
INSERT INTO `qb_config` VALUES ('yeepay_key','ve4ets3huzxruch0tsf6nga7a2lpckm8h9p7qnefj31q49ms8bhl3qin6q0g','');
INSERT INTO `qb_config` VALUES ('allowMemberCommentPass','1','');
INSERT INTO `qb_config` VALUES ('AvoidGatherPre','','');
INSERT INTO `qb_config` VALUES ('AvoidCopy','0','');
INSERT INTO `qb_config` VALUES ('AvoidGather','0','');
INSERT INTO `qb_config` VALUES ('AvoidSave','0','');
INSERT INTO `qb_config` VALUES ('waterpos','7','');
INSERT INTO `qb_config` VALUES ('adminPostEditType','html','');
INSERT INTO `qb_config` VALUES ('article_show_step','0','');
INSERT INTO `qb_config` VALUES ('ifContribute','1','');
INSERT INTO `qb_config` VALUES ('allowGuestSearch','0','');
INSERT INTO `qb_config` VALUES ('kill_badword','0','');
INSERT INTO `qb_config` VALUES ('ShowKeywordColor','#F70968','');
INSERT INTO `qb_config` VALUES ('ifShowKeyword','1','');
INSERT INTO `qb_config` VALUES ('UseFtp','0','');
INSERT INTO `qb_config` VALUES ('FtpDir','111','');
INSERT INTO `qb_config` VALUES ('FtpWeb','','');
INSERT INTO `qb_config` VALUES ('FtpPwd','admin','');
INSERT INTO `qb_config` VALUES ('FtpName','admin','');
INSERT INTO `qb_config` VALUES ('photoShowType','0','');
INSERT INTO `qb_config` VALUES ('groupTime','180','');
INSERT INTO `qb_config` VALUES ('allowGuestCommentPass','1','');
INSERT INTO `qb_config` VALUES ('ShowMenu','0','');
INSERT INTO `qb_config` VALUES ('GuestBookNum','8','');
INSERT INTO `qb_config` VALUES ('ShopNormalSend','8','');
INSERT INTO `qb_config` VALUES ('ShopEmsSend','25','');
INSERT INTO `qb_config` VALUES ('groupUpType','1','');
INSERT INTO `qb_config` VALUES ('allowDownMv','0','');
INSERT INTO `qb_config` VALUES ('SPlist_filename2','listsp.php?fid-{$fid}-page-{$page}.htm','');
INSERT INTO `qb_config` VALUES ('waterimg','images/default/water.gif','');
INSERT INTO `qb_config` VALUES ('MailId','lfj846@163.com','');
INSERT INTO `qb_config` VALUES ('HideNopowerPost','1','');
INSERT INTO `qb_config` VALUES ('autoPlayFirstMv','1','');
INSERT INTO `qb_config` VALUES ('allowGuestComment','1','');
INSERT INTO `qb_config` VALUES ('PostNotice','<font face=SimSun>\r\n<p><font face=SimSun>1תݣдԴַ<br />2İȨ뷨ɷ߳е</font></p></font>','');
INSERT INTO `qb_config` VALUES ('ListLeng','70','');
INSERT INTO `qb_config` VALUES ('propagandize_jumpto','/','');
INSERT INTO `qb_config` VALUES ('propagandize_LogDay','5','');
INSERT INTO `qb_config` VALUES ('propagandize_close','0','');
INSERT INTO `qb_config` VALUES ('propagandize_Money','2','');
INSERT INTO `qb_config` VALUES ('YZ_IdcardMoney','20','');
INSERT INTO `qb_config` VALUES ('EditYzEmail','0','');
INSERT INTO `qb_config` VALUES ('EditYzMob','0','');
INSERT INTO `qb_config` VALUES ('EditYzIdcard','0','');
INSERT INTO `qb_config` VALUES ('YZ_EmailMoney','10','');
INSERT INTO `qb_config` VALUES ('YZ_MobMoney','15','');
INSERT INTO `qb_config` VALUES ('MailServer','smtp.163.com','');
INSERT INTO `qb_config` VALUES ('sms_wi_id','2','');
INSERT INTO `qb_config` VALUES ('sms_wi_pwd','3','');
INSERT INTO `qb_config` VALUES ('sms_es_key','2','');
INSERT INTO `qb_config` VALUES ('sms_es_name','1','');
INSERT INTO `qb_config` VALUES ('sms_type','winic','');
INSERT INTO `qb_config` VALUES ('SPbencandy_filename2','showsp.php?fid-{$fid}-id-{$id}-page-{$page}.htm','');
INSERT INTO `qb_config` VALUES ('list_filename2','list.php?fid-{$fid}-page-{$page}.htm','');
INSERT INTO `qb_config` VALUES ('YzImg_voice','0','');
INSERT INTO `qb_config` VALUES ('close_count','0','');
INSERT INTO `qb_config` VALUES ('Reg_Field','a:1:{s:8:\\\"field_db\\\";a:0:{}}','');
INSERT INTO `qb_config` VALUES ('passport_TogetherLogin','1','');
INSERT INTO `qb_config` VALUES ('Listsortnameline','2','');
INSERT INTO `qb_config` VALUES ('ListSonLeng','34','');
INSERT INTO `qb_config` VALUES ('ListSonRows','9','');
INSERT INTO `qb_config` VALUES ('JsListLeng','36','');
INSERT INTO `qb_config` VALUES ('forbidRegIp','','');
INSERT INTO `qb_config` VALUES ('cache_time_js','-1','');
INSERT INTO `qb_config` VALUES ('SideSortStyle','side_sort/2','');
INSERT INTO `qb_config` VALUES ('SideTitleStyle','side_tpl/2','');
INSERT INTO `qb_config` VALUES ('JsListRows','5','');
INSERT INTO `qb_config` VALUES ('SPlist_filename','html/4special{$fid}/list{$page}.htm','');
INSERT INTO `qb_config` VALUES ('SPbencandy_filename','html/5special{$fid}/show{$id}.htm','');
INSERT INTO `qb_config` VALUES ('cache_time_com','-1','');
INSERT INTO `qb_config` VALUES ('ArticleHeart','Ƿ|1.gif\r\n֧|2.gif\r\nܰ|3.gif\r\n|4.gif\r\nЦ|5.gif\r\n|6.gif\r\n|7.gif\r\nԾ|8.gif','');
INSERT INTO `qb_config` VALUES ('heart_time','30','');
INSERT INTO `qb_config` VALUES ('heart_noRecord','1','');
INSERT INTO `qb_config` VALUES ('ForceDel','0','');
INSERT INTO `qb_config` VALUES ('UseArticleDigg','0','');
INSERT INTO `qb_config` VALUES ('AdInfoListLeng','40','');
INSERT INTO `qb_config` VALUES ('sortNUM','27','');
INSERT INTO `qb_config` VALUES ('FtpHost','127.0.0.1','');
INSERT INTO `qb_config` VALUES ('articleNUM','77','');
INSERT INTO `qb_config` VALUES ('cache_time_like','-1','');
INSERT INTO `qb_config` VALUES ('cache_time_new','-1','');
INSERT INTO `qb_config` VALUES ('is_waterimg','1','');
INSERT INTO `qb_config` VALUES ('passport_path','../pw7','');
INSERT INTO `qb_config` VALUES ('Del_MoreUpfile','1','');
INSERT INTO `qb_config` VALUES ('passport_type','','');
INSERT INTO `qb_config` VALUES ('Info_MemberPostRepeat','0','');
INSERT INTO `qb_config` VALUES ('bokecc_id','','');
INSERT INTO `qb_config` VALUES ('Info_forbidOutPost','1','');
INSERT INTO `qb_config` VALUES ('AdInfoIndexShow','20','');
INSERT INTO `qb_config` VALUES ('hideFid','','');
INSERT INTO `qb_config` VALUES ('tenpay_key','8934e7d15453e97507ef794cf7b0519d','');
INSERT INTO `qb_config` VALUES ('RewriteUrl','0','');
INSERT INTO `qb_config` VALUES ('passport_url','http://localhost/u/bbs','');
INSERT INTO `qb_config` VALUES ('MakeIndexHtmlTime','0','');
INSERT INTO `qb_config` VALUES ('passport_pre','`dz7`.cdb_','');
INSERT INTO `qb_config` VALUES ('cache_time_pic','-1','');
INSERT INTO `qb_config` VALUES ('list_cache_time','0','');
INSERT INTO `qb_config` VALUES ('bencandy_cache_time','0','');
INSERT INTO `qb_config` VALUES ('showsp_cache_time','0','');
INSERT INTO `qb_config` VALUES ('cache_time_hot','-1','');
INSERT INTO `qb_config` VALUES ('yzNumReg','0','');
INSERT INTO `qb_config` VALUES ('pay99_id','','');
INSERT INTO `qb_config` VALUES ('MoneyRatio','100','');
INSERT INTO `qb_config` VALUES ('Money2card','0','');
INSERT INTO `qb_config` VALUES ('index_cache_time','0','');
INSERT INTO `qb_config` VALUES ('waterAlpha','80','');
INSERT INTO `qb_config` VALUES ('if_gdimg','1','');
INSERT INTO `qb_config` VALUES ('regmoney','5','');
INSERT INTO `qb_config` VALUES ('DefaultIndexHtml','0','');
INSERT INTO `qb_config` VALUES ('AutoPassCompany','1','');
INSERT INTO `qb_config` VALUES ('forbidRegName','','');
INSERT INTO `qb_config` VALUES ('UseArticleHeart','1','');
INSERT INTO `qb_config` VALUES ('AutoTitleNum','1','');
INSERT INTO `qb_config` VALUES ('deleteArticleMoney','-1','');
INSERT INTO `qb_config` VALUES ('postArticleMoney','1','');
INSERT INTO `qb_config` VALUES ('comArticleMoney','3','');
INSERT INTO `qb_config` VALUES ('hotArticleNum','100','');
INSERT INTO `qb_config` VALUES ('newArticleTime','24','');
INSERT INTO `qb_config` VALUES ('ListShowIcon','0','');
INSERT INTO `qb_config` VALUES ('autoGetKeyword','0','');
INSERT INTO `qb_config` VALUES ('autoGetSmallPic','1','');
INSERT INTO `qb_config` VALUES ('autoCutSmallPic','1','');
INSERT INTO `qb_config` VALUES ('ForbidRepeatTitle','1','');
INSERT INTO `qb_config` VALUES ('viewNoPassArticle','0','');
INSERT INTO `qb_config` VALUES ('ArticlePicWidth','800','');
INSERT INTO `qb_config` VALUES ('ArticlePicHeight','600','');
INSERT INTO `qb_config` VALUES ('ArticleDownloadDirTime','0','');
INSERT INTO `qb_config` VALUES ('ArticleDownloadUseFtp','0','');
INSERT INTO `qb_config` VALUES ('XunLei_ID','08311','');
INSERT INTO `qb_config` VALUES ('FlashGet_ID','6370','');
INSERT INTO `qb_config` VALUES ('KeepTodayCount','1','');
INSERT INTO `qb_config` VALUES ('ShopOtherSend','18','');
INSERT INTO `qb_config` VALUES ('ForbidShowPhpPage','0','');
INSERT INTO `qb_config` VALUES ('bencandy_filename2','bencandy.php?fid-{$fid}-id-{$id}-page-{$page}.htm','');
INSERT INTO `qb_config` VALUES ('MailPort','25','');
INSERT INTO `qb_config` VALUES ('alipay_key','','');
INSERT INTO `qb_config` VALUES ('tenpay_id','1900000109','');
INSERT INTO `qb_config` VALUES ('yeepay_id','10000821064','');
INSERT INTO `qb_config` VALUES ('pay99_key','','');
INSERT INTO `qb_config` VALUES ('alipay_service','create_partner_trade_by_buyer','');
INSERT INTO `qb_config` VALUES ('NewsMakeHtml','0','');
INSERT INTO `qb_config` VALUES ('list_filename','html/{$fid}/{$page}.htm','');
INSERT INTO `qb_config` VALUES ('bencandy_filename','html/{$fid}-{$dirid}/{$id}-{$page}.htm','');
INSERT INTO `qb_config` VALUES ('guide_word','','');
INSERT INTO `qb_config` VALUES ('alipay_id','test@test.com','');
INSERT INTO `qb_config` VALUES ('alipay_partner','','');
INSERT INTO `qb_config` VALUES ('gg_map_api','','');
INSERT INTO `qb_config` VALUES ('MAX_sell_telephone','10','');
INSERT INTO `qb_config` VALUES ('money_sell_telephone','50','');
INSERT INTO `qb_config` VALUES ('sell_telephone_titleNUM','12','');
INSERT INTO `qb_config` VALUES ('sell_telephone_telNUM','13','');
INSERT INTO `qb_config` VALUES ('yzImgReg','1','');
INSERT INTO `qb_config` VALUES ('Info_PostMaxNum','20','');
INSERT INTO `qb_config` VALUES ('Info_TopNum','5','');
INSERT INTO `qb_config` VALUES ('AdInfoShowTime','100','');
INSERT INTO `qb_config` VALUES ('Info_feedbackID','111111','');
INSERT INTO `qb_config` VALUES ('Info_MakeIndexHtmlTime','0','');
INSERT INTO `qb_config` VALUES ('ErrSortMoney','13','');
INSERT INTO `qb_config` VALUES ('Info_DelKeyword','\r\n','');
INSERT INTO `qb_config` VALUES ('Info_PostMaxLeng','100000','');
INSERT INTO `qb_config` VALUES ('Info_RepeatPostNum','3','');
INSERT INTO `qb_config` VALUES ('Info_postCkMob','0','');
INSERT INTO `qb_config` VALUES ('Info_postCkIp','0','');
INSERT INTO `qb_config` VALUES ('DelOtherCommentMoney','12','');
INSERT INTO `qb_config` VALUES ('otherCardMoney','11','');
INSERT INTO `qb_config` VALUES ('permitMoney','10','');
INSERT INTO `qb_config` VALUES ('IDcardMoney','9','');
INSERT INTO `qb_config` VALUES ('EmailYzMoney','8','');
INSERT INTO `qb_config` VALUES ('ReportMoney','7','');
INSERT INTO `qb_config` VALUES ('GoodCommentMoney','6','');
INSERT INTO `qb_config` VALUES ('PublicizeRegMoney','5','');
INSERT INTO `qb_config` VALUES ('ALLInfoMoney','4','');
INSERT INTO `qb_config` VALUES ('Info_loginTime','16','');
INSERT INTO `qb_config` VALUES ('Info_loginMoney','3','');
INSERT INTO `qb_config` VALUES ('Info_regmoney','1','');
INSERT INTO `qb_config` VALUES ('illInfoMoney','14','');
INSERT INTO `qb_config` VALUES ('DelReportMoney','15','');
INSERT INTO `qb_config` VALUES ('Jump_allcity','0','');
INSERT INTO `qb_config` VALUES ('Jump_fromarea','1','');
INSERT INTO `qb_config` VALUES ('Info_TopMoney','3','');
INSERT INTO `qb_config` VALUES ('Info_closeWhy','վά,ͣ','');
INSERT INTO `qb_config` VALUES ('sort_layout','10,9,150,165#2,4#1,5,3#6,7,8#','');
INSERT INTO `qb_config` VALUES ('Info_ClosePost','0','');
INSERT INTO `qb_config` VALUES ('Info_weburl','','');
INSERT INTO `qb_config` VALUES ('AdInfoIndexLeng','','');
INSERT INTO `qb_config` VALUES ('Info_ForbidMemberViewContact','0','');
INSERT INTO `qb_config` VALUES ('Info_ShowSearchContact','0','');
INSERT INTO `qb_config` VALUES ('Info_ImgShopContact','0','');
INSERT INTO `qb_config` VALUES ('Info_ForbidGuesViewContact','0','');
INSERT INTO `qb_config` VALUES ('Info_TopDay','2','');
INSERT INTO `qb_config` VALUES ('Info_MemberDayPostNum','20','');
INSERT INTO `qb_config` VALUES ('AdInfoBigsortShow','15','');
INSERT INTO `qb_config` VALUES ('InfoIndexCSRow','','');
INSERT INTO `qb_config` VALUES ('Force_Choose_City','0','');
INSERT INTO `qb_config` VALUES ('if_GGmap','1','');
INSERT INTO `qb_config` VALUES ('Info_Searchkeyword','0','');
INSERT INTO `qb_config` VALUES ('Info_GuestDayPostNum','3','');
INSERT INTO `qb_config` VALUES ('InfoIndexLeng','26','');
INSERT INTO `qb_config` VALUES ('InfoIndexRow','8','');
INSERT INTO `qb_config` VALUES ('InfoListRow','10','');
INSERT INTO `qb_config` VALUES ('AdInfoIndexRow','16','');
INSERT INTO `qb_config` VALUES ('Info_guide_word','','');
INSERT INTO `qb_config` VALUES ('Info_MemberPostMoney','2','');
INSERT INTO `qb_config` VALUES ('Info_YzKeyword_DO','0','');
INSERT INTO `qb_config` VALUES ('Info_ClosePostWhy','ϴʱ,ͣ޸Ϣ','');
INSERT INTO `qb_config` VALUES ('module_pre','fenlei_','');
INSERT INTO `qb_config` VALUES ('module_id','1','');
INSERT INTO `qb_config` VALUES ('Info_style','','');
INSERT INTO `qb_config` VALUES ('Info_metakeywords','   ҳ','');
INSERT INTO `qb_config` VALUES ('Info_webadmin','','');
INSERT INTO `qb_config` VALUES ('Info_webOpen','1','');
INSERT INTO `qb_config` VALUES ('Info_areaname','ȫ','');
INSERT INTO `qb_config` VALUES ('module_close','0','');
INSERT INTO `qb_config` VALUES ('Info_webname','Ϣ','');
INSERT INTO `qb_config` VALUES ('AdInfoSortShow','10','');
INSERT INTO `qb_config` VALUES ('Info_cityPost','0','');
INSERT INTO `qb_config` VALUES ('Info_TopColor','#F70968','');
INSERT INTO `qb_config` VALUES ('Info_Musttelephone','0','');
INSERT INTO `qb_config` VALUES ('Info_Mustmobphone','0','');
INSERT INTO `qb_config` VALUES ('Info_MustQQ','0','');
INSERT INTO `qb_config` VALUES ('Info_MustEmail','0','');
INSERT INTO `qb_config` VALUES ('InfoIndexCSLeng','','');
INSERT INTO `qb_config` VALUES ('Info_showsortnum','','');
INSERT INTO `qb_config` VALUES ('Info_ListNum','','');
INSERT INTO `qb_config` VALUES ('AdInfoListRow','10','');
INSERT INTO `qb_config` VALUES ('InfoListLeng','30','');
INSERT INTO `qb_config` VALUES ('Info_YzKeyword','԰\r\n\r\n','');
INSERT INTO `qb_config` VALUES ('rand_num','1306897497','');
INSERT INTO `qb_config` VALUES ('rand_num_inputname','jbe','');
INSERT INTO `qb_config` VALUES ('rand_num_mktime','1','');
INSERT INTO `qb_config` VALUES ('Post_group_UpPhoto','3,8,9,10','');
INSERT INTO `qb_config` VALUES ('group_UpPhoto','3,8,9,10','');
INSERT INTO `qb_config` VALUES ('Info_htmlType','0','');
INSERT INTO `qb_config` VALUES ('Info_index_cache','','');
INSERT INTO `qb_config` VALUES ('Info_list_cache','','');
INSERT INTO `qb_config` VALUES ('Info_ReportDB','Ϣ\r\nϢ\r\nΥϢ\r\nͬϢ','');
INSERT INTO `qb_config` VALUES ('path','/do','');
INSERT INTO `qb_config` VALUES ('Info_htmlname','html','');
INSERT INTO `qb_config` VALUES ('post_htmlType','0','');
INSERT INTO `qb_config` VALUES ('UpdatePostTime','3','');
INSERT INTO `qb_config` VALUES ('Info_contact','010-88888888\r\nkefu@gmail.com\r\nkefu@msn.com\r\n88888888','');
INSERT INTO `qb_config` VALUES ('Info_showday','3/10/30/60/90/180','');
INSERT INTO `qb_config` VALUES ('Info_allcityType','0','');
INSERT INTO `qb_config` VALUES ('Info_MemberChooseCity','0','');
INSERT INTO `qb_config` VALUES ('Info_ShowNoYz','1','');
INSERT INTO `qb_config` VALUES ('Info_DelEndtime','0','');
INSERT INTO `qb_config` VALUES ('companyTrade','еҵ豸\r\nͨе\r\nͨ㲿\r\n\r\n\r\n綯\r\nԪ\r\n\r\n\r\nȫ豸\r\nװ\r\nֽֽƷ\r\n繤\r\n繤\r\nͨǱ\r\nרǱ\r\nͨ豸㲿\r\n칫ĽƷ\r\n롢Լ\r\nճҾƷ\r\nľġľƷ\r\nҾ\r\nõ\r\nƷƷ\r\nʳƷ\r\nͨŲƷ\r\n\r\nӡˢ豸\r\n˶СƷ\r\nЬñ\r\nװ\r\nûѧƷ\r\nũûѧƷ\r\nճ\r\nȾϡϡͿϺī\r\n߻\r\n澫ϸѧƷ\r\nʳƷӼ\r\n\r\nƷ\r\n豸\r\n\r\nԴ\r\n͡ũƷ\r\n\r\nҽҩҽ豸\r\n֯\r\nƤ\r\núƷ\r\nճ\r\n\r\nѵ\r\n֤\r\n\r\n\r\nڴ\r\nά޼װ\r\n桢չ\r\nרҵ¼豸\r\nѧӰ\r\n༭豸\r\nǰ豸\r\nװҵ\r\nز\r\nװ\r\nʵͨ\r\n֤\r\nᡢ\r\nҵ\r\nڡ\r\nʵҵ˾ҵó\r\n¼\r\nг','');
INSERT INTO `qb_config` VALUES ('Info_UseEndTime','1','');
INSERT INTO `qb_config` VALUES ('CollectArticleNum','23','');
INSERT INTO `qb_config` VALUES ('Info_MemberPostPicNum','','');
INSERT INTO `qb_config` VALUES ('Info_GuestPostRepeat','0','');
INSERT INTO `qb_config` VALUES ('Info_GuestPostPicNum','','');
INSERT INTO `qb_config` VALUES ('PostInfoMoney','2','');
INSERT INTO `qb_config` VALUES ('Info_allowGuesSearch','1','');
INSERT INTO `qb_config` VALUES ('label_cache_time','-1','');
INSERT INTO `qb_config` VALUES ('DownLoad_readfile','1','');
INSERT INTO `qb_config` VALUES ('memberNotice','ӭѷϢ!','');
INSERT INTO `qb_config` VALUES ('AutoCutFace','0','');
INSERT INTO `qb_config` VALUES ('MailPw','p','');
INSERT INTO `qb_config` VALUES ('yzImgAdminLogin','0','');
INSERT INTO `qb_config` VALUES ('mymd5','2352993','');
INSERT INTO `qb_config` VALUES ('copyright','','');
INSERT INTO `qb_config` VALUES ('miibeian_gov_cn','ICP050453','');
INSERT INTO `qb_config` VALUES ('cookiePre','','');
INSERT INTO `qb_config` VALUES ('cookieDomain','','');
INSERT INTO `qb_config` VALUES ('forbid_show_bug','1','');
INSERT INTO `qb_config` VALUES ('mirror','http://down.qibosoft.com/other/testv6/upload_files/','');
INSERT INTO `qb_config` VALUES ('updir','upload_files','');
INSERT INTO `qb_config` VALUES ('upfileType','.rar .txt .jpg .gif .bmp .png .zip .mp3 .wma .wmv .mpeg .mpg .rm .ram .htm .doc .swf .avi .flv .sql .doc .ppt .xls .chm .pdf','');
INSERT INTO `qb_config` VALUES ('upfileMaxSize','','');
INSERT INTO `qb_config` VALUES ('totalSpace','100','');
INSERT INTO `qb_config` VALUES ('time','0','');
INSERT INTO `qb_config` VALUES ('admin_url','admin','');
INSERT INTO `qb_config` VALUES ('www_url','http://localhost/u','');
INSERT INTO `qb_config` VALUES ('style_member','default','');
INSERT INTO `qb_config` VALUES ('style','blue','');
INSERT INTO `qb_config` VALUES ('close_why','վά,\r\nͣ.','');
INSERT INTO `qb_config` VALUES ('web_open','1','');
INSERT INTO `qb_config` VALUES ('MoneyDW','','');
INSERT INTO `qb_config` VALUES ('description','ṩѷϢƽ̨','');
INSERT INTO `qb_config` VALUES ('webmail','admin@admin.com','');
INSERT INTO `qb_config` VALUES ('CommentPass_group','3','');
INSERT INTO `qb_config` VALUES ('showNoPassComment','0','');
INSERT INTO `qb_config` VALUES ('alipay_transport','https','');
INSERT INTO `qb_config` VALUES ('alipay_scale','100','');
INSERT INTO `qb_config` VALUES ('MoneyName','','');
INSERT INTO `qb_config` VALUES ('UserEmailAutoPass','1','');
INSERT INTO `qb_config` VALUES ('RegYz','1','');
INSERT INTO `qb_config` VALUES ('emailOnly','1','');
INSERT INTO `qb_config` VALUES ('reg_group','8','');
INSERT INTO `qb_config` VALUES ('QQ_login','2','');
INSERT INTO `qb_config` VALUES ('QQ_appid','','');
INSERT INTO `qb_config` VALUES ('QQ_appkey','','');
INSERT INTO `qb_config` VALUES ('QQ_QBappid','cf5fa','');
INSERT INTO `qb_config` VALUES ('QQ_QBappkey','dcb480be38e28f678112','');
INSERT INTO `qb_config` VALUES ('ForbidPostMember','','');
INSERT INTO `qb_config` VALUES ('ForbidPostIp','','');
INSERT INTO `qb_config` VALUES ('Info_GroupPostYzImg','3,8,9,10','');
INSERT INTO `qb_config` VALUES ('Info_GroupCommentYzImg','3,8,9,10','');
INSERT INTO `qb_config` VALUES ('GroupPassYz','','');
INSERT INTO `qb_config` VALUES ('GroupPostInfo','','');
INSERT INTO `qb_config` VALUES ('BuySpacesizeMoney','50','');
INSERT INTO `qb_config` VALUES ('UseMoneyType','cms','');
INSERT INTO `qb_config` VALUES ('metakeywords','ҳ ⷿ Ƹ','');
INSERT INTO `qb_config` VALUES ('webname','벩Ϣϵͳ','');
INSERT INTO `qb_hack` VALUES ('login','û¼','0','','a:3:{s:10:\"systemType\";s:6:\"php168\";s:9:\"guestcode\";s:0:\"\";}','','','','index.php?lfj=hack&hack=login&job=list','','','','0','','0');
INSERT INTO `qb_hack` VALUES ('moneylog','ûѻּ¼','0','','','','','','index.php?lfj=moneylog&job=list','','other','ȫ','0','','0');
INSERT INTO `qb_hack` VALUES ('alipay_set','ֵ֧߳','0','','','','','','index.php?lfj=alipay&job=list','','other','','9','','0');
INSERT INTO `qb_hack` VALUES ('js_list','JSݵ','0','','','','','','index.php?lfj=js&job=list','','other','','9','','0');
INSERT INTO `qb_hack` VALUES ('propagandize','ƹ׬ȡֹ','0','','','','','','index.php?lfj=propagandize&job=list','','other','','8','','0');
INSERT INTO `qb_hack` VALUES ('jfadmin_mod','ֽܹ','0','','','','','','index.php?lfj=jfadmin&job=listjf','','other','','7','','0');
INSERT INTO `qb_hack` VALUES ('attachment_list','','0','','','','','','index.php?lfj=attachment&job=list','','other','','6','','0');
INSERT INTO `qb_hack` VALUES ('area_list','','0','','','','','','index.php?lfj=area&job=list','','other','','5','','0');
INSERT INTO `qb_hack` VALUES ('upgrade_ol','ϵͳ','0','','','','','','index.php?lfj=upgrade&job=get','','other','','4','','0');
INSERT INTO `qb_hack` VALUES ('mail_send','ʼȺ','0','','','','','','index.php?lfj=mail&job=send','','other','Ϣ/ʼȺ','2','','0');
INSERT INTO `qb_hack` VALUES ('message_send','վϢȺ','0','','','','','','index.php?lfj=message&job=send','','other','Ϣ/ʼȺ','3','','0');
INSERT INTO `qb_hack` VALUES ('sms_send','ֻȺ','0','','','','','','index.php?lfj=sms&job=send','','other','Ϣ/ʼȺ','1','','0');
INSERT INTO `qb_hack` VALUES ('cnzz_set','CNZZͳ','0','','','','','','index.php?lfj=cnzz&job=ask','','other','վ⹦','3','','0');
INSERT INTO `qb_hack` VALUES ('moneycard_make','㿨ֵ','0','','','','','','index.php?lfj=moneycard&job=make','','other','','7','','1');
INSERT INTO `qb_hack` VALUES ('logs_login_logs','̨¼־','0','','','','','','index.php?lfj=logs&job=login_logs','','other','־','2','','0');
INSERT INTO `qb_hack` VALUES ('logs_admin_do_logs','̨־','0','','','','','','index.php?lfj=logs&job=admin_logs','','other','־','1','','0');
INSERT INTO `qb_hack` VALUES ('crontab','ʱ','0','','','','','','index.php?lfj=crontab&job=list','','other','ȫ','0','','0');
INSERT INTO `qb_label` VALUES ('1','','0','99','searchhotword','code','0','<A href=\"#\">һ</A> <A href=\"#\">ë</A>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','1','0','0','blue');
INSERT INTO `qb_pm` VALUES ('1','1','','1','admin','rebox','0','fdsa','1292679072','dsafds');
INSERT INTO `qb_upfile` VALUES ('1','0','0','0','1','1290486784','label','tmp-1_20101123121104_vcrd7.jpg','1','1');
INSERT INTO `qb_upfile` VALUES ('2','0','0','0','1','1290486789','label','tmp-1_20101123121109_ud6ep.jpg','1','1');
INSERT INTO `qb_upfile` VALUES ('3','0','0','0','1','1290487135','label','tmp-1_20101123121155_ihnbv.jpg','1','1');
INSERT INTO `qb_upfile` VALUES ('4','0','0','0','1','1290487151','label','tmp-1_20101123121111_d03vt.jpg','1','1');
INSERT INTO `qb_upfile` VALUES ('5','0','0','0','1','1290488480','label','tmp-1_20101123131120_6g6lw.gif','1','1');
INSERT INTO `qb_upfile` VALUES ('6','0','0','0','1','1290488773','label','tmp-1_20101123131113_owuft.gif','1','1');
INSERT INTO `qb_upfile` VALUES ('7','0','0','0','1','1290488817','label','tmp-1_20101123131157_sdv3g.png','1','1');
INSERT INTO `qb_area` VALUES ('1','0','','1','18','0','','0','0','','','','','N;','','0','','','0','','','','','0','b:0;');
INSERT INTO `qb_area` VALUES ('2','0','Ϻ','1','19','0','','0','0','','','','','N;','','0','','','0','','','','','0','b:0;');
INSERT INTO `qb_area` VALUES ('3','0','','1','18','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('4','0','','1','40','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('5','0','ӱʡ','1','11','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('6','0','ɽʡ','1','11','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('7','0','ɹ','1','12','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('8','0','ʡ','1','14','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('9','0','ʡ','1','9','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('10','0','ʡ','1','13','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('11','0','ʡ','1','13','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('12','0','㽭ʡ','1','11','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('13','0','ʡ','1','17','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('14','0','ʡ','1','9','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('15','0','ʡ','1','11','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('16','0','ɽʡ','1','17','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('17','0','ʡ','1','17','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('18','0','ʡ','1','17','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('19','0','ʡ','1','14','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('20','0','㶫ʡ','1','21','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('21','0','׳','1','14','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('22','0','ʡ','1','21','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('23','0','Ĵʡ','1','21','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('24','0','ʡ','1','9','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('25','0','ʡ','1','16','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('26','0','','1','7','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('27','0','ʡ','1','10','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('28','0','ʡ','1','14','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('29','0','ຣʡ','1','8','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('30','0','Ļ','1','5','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('31','0','½ά','1','18','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('32','0','̨ʡ','1','25','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('33','0','ر','1','18','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('34','0','ر','1','5','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('35','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('36','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('37','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('38','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('39','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('40','1','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('41','1','ʯɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('42','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('43','1','ͷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('44','1','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('45','1','ͨ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('46','1','˳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('47','1','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('48','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('49','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('50','1','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('51','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('52','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('53','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('54','2','¬','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('55','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('56','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('57','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('58','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('59','2','բ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('60','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('61','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('62','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('63','2','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('64','2','ζ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('65','2','ֶ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('66','2','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('67','2','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('68','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('69','2','ϻ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('70','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('71','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('72','3','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('73','3','Ӷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('74','3','','2','0','0','','0','0','','','','','N;','','0','','','0','','','','','0','b:0;');
INSERT INTO `qb_area` VALUES ('75','3','Ͽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('76','3','ӱ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('77','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('78','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('79','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('80','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('81','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('82','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('83','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('84','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('85','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('86','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('87','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('88','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('89','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('90','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('91','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('92','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('93','4','ɿ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('94','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('95','4','ɳƺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('96','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('97','4','ϰ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('98','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('99','4','ʢ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('100','4','˫','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('101','4','山','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('102','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('103','4','ǭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('104','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('105','4','뽭','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('106','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('107','4','ͭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('108','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('109','4','ٲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('110','4','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('111','4','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('112','4','ǿ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('113','4','ᶼ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('114','4','潭','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('115','4','¡','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('116','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('117','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('118','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('119','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('120','4','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('121','4','Ϫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('122','4','ʯ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('123','4','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('124','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('125','4','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('126','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('127','4','ϴ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('128','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('129','4','ϴ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('130','5','ʯׯ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('131','5','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('132','5','ػʵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('133','5','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('134','5','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('135','5','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('136','5','żҿ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('137','5','е','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('138','5','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('139','5','ȷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('140','5','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('141','6','̫ԭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('142','6','ͬ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('143','6','Ȫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('144','6','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('145','6','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('146','6','˷','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('147','6','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('148','6','˳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('149','6','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('150','6','ٷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('151','6','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('152','7','ͺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('153','7','ͷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('154','7','ں','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('155','7','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('156','7','ͨ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('157','7','˹','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('158','7','ױ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('159','7','׶','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('160','7','첼','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('161','7','˰','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('162','7','ֹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('163','7','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('164','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('165','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('166','8','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('167','8','˳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('168','8','Ϫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('169','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('170','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('171','8','Ӫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('172','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('173','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('174','8','̽','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('175','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('176','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('177','8','«','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('178','9','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('179','9','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('180','9','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('181','9','Դ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('182','9','ͨ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('183','9','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('184','9','ԭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('185','9','׳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('186','9','ӱ߳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('187','10','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('188','10','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('189','10','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('190','10','׸','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('191','10','˫Ѽɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('192','10','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('193','10','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('194','10','ľ˹','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('195','10','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('196','10','ĵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('197','10','ں','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('198','10','绯','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('199','10','˰','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('200','11','Ͼ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('201','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('202','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('203','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('204','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('205','11','ͨ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('206','11','Ƹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('207','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('208','11','γ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('209','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('210','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('211','11','̩','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('212','11','Ǩ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('213','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('214','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('215','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('216','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('217','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('218','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('219','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('220','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('221','12','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('222','12','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('223','12','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('224','13','Ϸ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('225','13','ߺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('226','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('227','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('228','13','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('229','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('230','13','ͭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('231','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('232','13','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('233','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('234','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('235','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('236','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('237','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('238','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('239','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('240','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('241','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('242','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('243','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('244','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('245','14','Ȫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('246','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('247','14','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('248','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('249','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('250','15','ϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('251','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('252','15','Ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('253','15','Ž','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('254','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('255','15','ӥ̶','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('256','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('257','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('258','15','˴','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('259','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('260','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('261','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('262','16','ൺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('263','16','Ͳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('264','16','ׯ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('265','16','Ӫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('266','16','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('267','16','Ϋ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('268','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('269','16','̩','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('270','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('271','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('272','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('273','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('274','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('275','16','ĳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('276','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('277','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('278','17','֣','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('279','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('280','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('281','17','ƽɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('282','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('283','17','ױ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('284','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('285','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('286','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('287','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('288','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('289','17','Ͽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('290','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('291','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('292','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('293','17','ܿ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('294','17','פ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('295','18','人','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('296','18','ʯ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('297','18','ʮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('298','18','˲','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('299','18','差','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('300','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('301','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('302','18','Т','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('303','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('304','18','Ƹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('305','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('306','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('307','18','ʩ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('308','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('309','18','Ǳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('310','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('311','18','ũ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('312','19','ɳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('313','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('314','19','̶','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('315','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('316','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('317','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('318','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('319','19','żҽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('320','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('321','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('322','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('323','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('324','19','¦','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('325','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('326','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('327','20','ع','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('328','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('329','20','麣','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('330','20','ͷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('331','20','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('332','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('333','20','տ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('334','20','ï','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('335','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('336','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('337','20','÷','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('338','20','β','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('339','20','Դ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('340','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('341','20','Զ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('342','20','ݸ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('343','20','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('344','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('345','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('346','20','Ƹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('347','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('348','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('349','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('350','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('351','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('352','21','Ǹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('353','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('354','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('355','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('356','21','ɫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('357','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('358','21','ӳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('359','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('360','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('361','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('362','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('363','22','ָɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('364','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('365','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('366','22','Ĳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('367','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('368','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('369','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('370','22','Ͳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('371','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('372','22','ٸ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('373','22','ɳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('374','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('375','22','ֶ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('376','22','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('377','22','ͤ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('378','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('379','22','ɳȺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('380','22','ɳȺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('381','22','ɳȺĵ亣','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('382','23','ɶ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('383','23','Թ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('384','23','֦','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('385','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('386','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('387','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('388','23','Ԫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('389','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('390','23','ڽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('391','23','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('392','23','ϳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('393','23','üɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('394','23','˱','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('395','23','㰲','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('396','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('397','23','Ű','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('398','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('399','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('400','23','ӲǼ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('401','23','β','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('402','23','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('403','24','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('404','24','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('405','24','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('406','24','˳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('407','24','ͭʵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('408','24','ǭϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('409','24','Ͻڵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('410','24','ǭ嶱','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('411','24','ǭϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('412','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('413','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('414','25','Ϫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('415','25','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('416','25','ͨ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('417','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('418','25','˼é','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('419','25','ٲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('420','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('421','25','ӹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('422','25','ɽ׳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('423','25','˫ɴ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('424','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('425','25','º徰','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('426','25','ŭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('427','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('428','26','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('429','26','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('430','26','ɽϵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('431','26','տ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('432','26','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('433','26','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('434','26','֥','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('435','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('436','27','ͭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('437','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('438','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('439','27','μ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('440','27','Ӱ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('441','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('442','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('443','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('444','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('445','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('446','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('447','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('448','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('449','28','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('450','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('451','28','Ҵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('452','28','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('453','28','Ȫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('454','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('455','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('456','28','¤','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('457','28','Ļ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('458','28','ϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('459','29','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('460','29','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('461','29','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('462','29','ϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('463','29','ϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('464','29','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('465','29','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('466','29','ɹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('467','30','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('468','30','ʯɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('469','30','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('470','30','ԭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('471','30','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('472','31','³ľ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('473','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('474','31','³','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('475','31','ܵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('476','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('477','31','ɹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('478','31','ɹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('479','31','յ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('480','31','տ¶','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('481','31','ʲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('482','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('483','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('484','31','ǵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('485','31','̩','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('486','31','ʯ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('487','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('488','31','ͼľ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('489','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('490','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('491','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('492','32','¡','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('493','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('494','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('495','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('496','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('497','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('498','32','԰','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('499','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('500','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('501','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('502','32','û','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('503','32','Ͷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('504','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('505','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('506','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('507','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('508','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('509','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('510','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('511','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('512','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('513','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('514','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('515','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('516','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('517','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('518','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('519','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('520','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('521','33','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('522','33','ƴ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('523','33','ͼ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('524','33','뵺','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('525','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('526','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('527','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('528','33','ɳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('529','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('530','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('531','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('532','33','Ԫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('533','34','л','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('534','34','ʥ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('535','34','д','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('536','34','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('537','34','з˳','2','0','0','','0','0','','','','','N;','','0','','','0','','','','','0','b:0;');
INSERT INTO `qb_jfabout` VALUES ('6','2','¿ɵ{$webdb[postArticleMoney]}','ֻ˺²ſɵû,û˵²û.','0');
INSERT INTO `qb_jfabout` VALUES ('7','2','ɾ¿۳{$webdb[deleteArticleMoney]}','','0');
INSERT INTO `qb_jfabout` VALUES ('5','1','ûעɵ{$webdb[regmoney]}','','0');
INSERT INTO `qb_jfabout` VALUES ('8','2','±Ϊɵ{$webdb[comArticleMoney]}','','0');
INSERT INTO `qb_jfabout` VALUES ('9','1','ÿ㿨ɶһ{$webdb[MoneyRatio]},㿨ֵͨ߳.','','0');
INSERT INTO `qb_jfsort` VALUES ('1','Ա','0');
INSERT INTO `qb_jfsort` VALUES ('2','','0');
INSERT INTO `qb_template` VALUES ('5','ͷװ','7','template/default/none.htm','','0');
INSERT INTO `qb_template` VALUES ('6','ײװ','8','template/default/none.htm','','0');
INSERT INTO `qb_template` VALUES ('23','бҳ(խ)','2','template/default/list.htm','','0');
INSERT INTO `qb_template` VALUES ('22','ҳ(խ)','3','template/default/bencandy.htm','','0');
INSERT INTO `qb_template` VALUES ('24','ҳ(խ)','1','template/default/index.htm','','0');
INSERT INTO `qb_template` VALUES ('20','ҳ()','3','template/default/bencandy_tpl_2.htm','','0');
INSERT INTO `qb_template` VALUES ('21','ҳ','9','template/default/alonepage.htm','','0');
INSERT INTO `qb_ad_compete_place` VALUES ('3','ҳ۹','0','0','50','5','8','36','1','/do/digg.php');
INSERT INTO `qb_ad_compete_user` VALUES ('11','1','admin','1239277578','1239709578','50','3','1','http://www.php168.com/','P8ٷվ','0','','0','0');
INSERT INTO `qb_ad_compete_user` VALUES ('12','1','admin','1239279810','1239711810','50','3','1','http://www.php168.com/bbs','P8ٷ̳','0','','0','0');
INSERT INTO `qb_ad_config` VALUES ('module_pre','ad_','');
INSERT INTO `qb_ad_config` VALUES ('Info_webOpen','1','');
INSERT INTO `qb_ad_config` VALUES ('module_id','24','');
INSERT INTO `qb_ad_config` VALUES ('module_close','0','');
INSERT INTO `qb_ad_config` VALUES ('Info_webname','ϵͳ','');
INSERT INTO `qb_ad_norm_place` VALUES ('1','article_list','бҳ','code','0','0','0','a:5:{s:4:\"word\";s:0:\"\";s:6:\"picurl\";s:0:\"\";s:7:\"linkurl\";s:0:\"\";s:8:\"flashurl\";s:0:\"\";s:4:\"code\";s:0:\"\";}','0','0','0','0','0','5','0','1','/do/job.php?job=jump&pagetype=list');
INSERT INTO `qb_ad_norm_place` VALUES ('10','article_content','ߵĹ','pic','1','0','0','a:8:{s:4:\"word\";s:0:\"\";s:6:\"picurl\";s:32:\"other/1_20090326120324_mnfIi.jpg\";s:7:\"linkurl\";s:22:\"http://www.php168.com/\";s:8:\"flashurl\";s:0:\"\";s:4:\"code\";s:0:\"\";s:5:\"width\";s:3:\"400\";s:6:\"height\";s:3:\"400\";s:9:\"pictarget\";s:5:\"blank\";}','0','0','0','0','0','5','1','1','/do/job.php?job=jump&pagetype=bencandy');
INSERT INTO `qb_ad_norm_place` VALUES ('2','article_show','ҳ·','code','0','0','0','a:5:{s:4:\"word\";s:0:\"\";s:6:\"picurl\";s:0:\"\";s:7:\"linkurl\";s:0:\"\";s:8:\"flashurl\";s:0:\"\";s:4:\"code\";s:1782:\"<div style=\"LINE-HEIGHT: 150%\"><a href=\"http://www.zxx6.com/\" target=_blank><font color=#ff0000><strong>վѧϰ</strong></font></a> <a href=\"http://www.angelyyl.cn/\" target=_blank></a><a href=\"http://www.czin.cn/\" target=_blank><br />ߡ˵ϼ԰</a> <br /><a href=\"http://www.sy50.com/\" target=_blank> ˽ </a> <br /><a href=\"http://www.771881.cn/\" target=_blank>㱧-Ůͬ-ܼŮվ </a><br /><a href=\"http://www.aihut.com/\" target=_blank>Сԭ </a><br /><a href=\"http://www.popyule.com/\" target=_blank>--ۺվPHP168</a> <br /><a href=\"http://www.china551.cn/\" target=_blank><font color=#ff0000></font></a> <a href=\"http://www.ym988.com/\" target=_blank>Բģ幤 </a><br /><a href=\"http://www.welights.com/\" target=_blank>ʵƾ</a> <a href=\"http://www.hnmssy.cn/\" target=_blank>Ӱ</a> <br /><a href=\"http://www.nuoyue.net/\" target=_blank><font color=#ff0000>ŵԾվ - վѧϰĺõط</font></a> <br /><a href=\"http://www.qzfl.com/\" target=_blank>Ȫݷ ȪϢ</a> <br /><a href=\"http://www.stmsn.com/\" target=_blank>й</a> <a href=\"http://www.downcc.cn/\" target=_blank>󵱼վ </a><br /><a href=\"http://www.yt12333.cn/\" target=_blank>Ͷ籣֮-ͤͶ</a> <br /><a href=\"http://www.gooyi.cn/\" target=_blank> - Ż </a><br /><a href=\"http://www.idercn.com/\" target=_blank>I.D.</a> <a href=\"http://www.tz0632.com/\" target=_blank>ݳ</a> <a href=\"http://www.doubar.com/\" target=_blank> </a></div>\r\n<div style=\"LINE-HEIGHT: 150%\"><a href=\"http://www.wfseo.org/\" target=_blank><font color=#d2691e>վŻ</font><br /></a><br /></div>\";}','0','0','0','0','0','5','0','1','/do/job.php?job=jump&pagetype=bencandy');
INSERT INTO `qb_ad_norm_place` VALUES ('11','digg_list','а߹','code','0','0','0','a:5:{s:4:\"word\";s:0:\"\";s:6:\"picurl\";s:0:\"\";s:7:\"linkurl\";s:0:\"\";s:8:\"flashurl\";s:0:\"\";s:4:\"code\";s:813:\"<div style=\"LINE-HEIGHT: 200%\"><a href=\"http://www.ibioo.com/\" target=_blank><font color=#ff0000>̹--߻վ!</font> </a><br /><a href=\"http://www.51solo.net/\" target=_blank>Żҿʼ </a><br /><a href=\"http://1.com/45/admin/www.china-highway.com\" target=_blank>·߾йٹ· </a><br /><a href=\"http://www.nenbei.com/\" target=_blank><font color=#ff0000>۱ۺӭĵ </font></a><br /><a href=\"http://www.liuv.net/\" target=_blank><font color=#ff0000>ˮ</font></a> <br /><a href=\"http://www.fming.net/\" target=_blank>ԭ ѧӰĴƽ̨ </a><br /><a href=\"http://www.netchinatown.com/\" target=_blank>ʱƳ-⻪˾Ӣ԰ </a><br /><a href=\"http://frp.ok586.cn/\" target=_blank>Ϻȴרҵ. </a></div>\";}','0','0','0','0','0','5','0','1','/do/digg.php');
INSERT INTO `qb_ad_norm_place` VALUES ('19','list_page_topad','бҳ߶λ','pic','0','0','0','a:8:{s:4:\"word\";s:0:\"\";s:6:\"picurl\";s:13:\"ad/listad.jpg\";s:7:\"linkurl\";s:22:\"http://www.yeepay.com/\";s:8:\"flashurl\";s:0:\"\";s:4:\"code\";s:0:\"\";s:5:\"width\";s:3:\"290\";s:6:\"height\";s:3:\"130\";s:9:\"pictarget\";s:5:\"blank\";}','0','0','0','2','0','10','1','1','/do/job.php?job=jump&pagetype=list');
INSERT INTO `qb_ad_norm_place` VALUES ('18','show_topad','ҳ','pic','0','0','0','a:8:{s:4:\"word\";s:0:\"\";s:6:\"picurl\";s:18:\"ad/ad_show_top.jpg\";s:7:\"linkurl\";s:22:\"http://www.yeepay.com/\";s:8:\"flashurl\";s:0:\"\";s:4:\"code\";s:0:\"\";s:5:\"width\";s:3:\"980\";s:6:\"height\";s:2:\"60\";s:9:\"pictarget\";s:5:\"blank\";}','0','0','0','0','0','10','1','1','../do/job.php?job=jump&pagetype=bencandy');
INSERT INTO `qb_ad_norm_place` VALUES ('17','show_right_top_picad','ҳ߶ͼƬλ','pic','0','0','0','a:8:{s:4:\"word\";s:0:\"\";s:6:\"picurl\";s:15:\"ad/qyshowad.jpg\";s:7:\"linkurl\";s:43:\"http://www.qy.com.cn/idc/product_double.asp\";s:8:\"flashurl\";s:0:\"\";s:4:\"code\";s:0:\"\";s:5:\"width\";s:3:\"290\";s:6:\"height\";s:3:\"110\";s:9:\"pictarget\";s:5:\"blank\";}','0','0','0','29','0','10','1','1','/do/job.php?job=jump&pagetype=bencandy');
INSERT INTO `qb_ad_norm_place` VALUES ('20','AD_list_topad','бҳ','pic','0','0','0','a:8:{s:4:\"word\";s:0:\"\";s:6:\"picurl\";s:14:\"ad/cnidca1.gif\";s:7:\"linkurl\";s:21:\"http://www.cnidc.com/\";s:8:\"flashurl\";s:0:\"\";s:4:\"code\";s:0:\"\";s:5:\"width\";s:3:\"980\";s:6:\"height\";s:2:\"60\";s:9:\"pictarget\";s:5:\"blank\";}','0','0','0','4','0','10','1','1','/do/list.php?fid=1');
INSERT INTO `qb_ad_norm_place` VALUES ('21','sp_show_ad','רҳλ','code','0','0','0','a:5:{s:4:\"word\";s:0:\"\";s:6:\"picurl\";s:0:\"\";s:7:\"linkurl\";s:0:\"\";s:8:\"flashurl\";s:0:\"\";s:4:\"code\";s:943:\"<div style=\"LINE-HEIGHT: 150%\"><a href=\"http://3cq.org/\" target=_blank>׶ һΪǵĺ</a> <br /><a href=\"http://www.liuv.net/\" target=_blank>ˮ</a> <br /><a href=\"http://www.21yao.com/\" target=_blank>ҽҩ</a><br /><a href=\"http://www.fming.net/\" target=_blank>ԭ</a> <br /><a href=\"http://www.jnrx.net/\" target=_blank></a> <br /><a href=\"http://www.7mt.cn/\" target=_blank>Ħ-йһĦгý </a><br /><a href=\"http://www.hnpolice.net/\" target=_blank>ϹߵרѧУУѻ </a><br /><a href=\"http://www.seo178.com/\" target=_blank>SEOѵѡ--SEOѵ</a> <br /><a href=\"http://www.51solo.net/\" target=_blank>Ʒƹ,SEOվŻ </a><br /><a href=\"http://www.kljy.cn/\" target=_blank>ڶͯ </a><br /><a href=\"http://www.eia8.com/job/\" target=_blank>йƸְ</a> <br /><a href=\"http://www.wenzhang8.com/\" target=_blank>° þ </a> </div>\";}','0','0','0','0','0','0','0','1','/do/showsp.php?fid=1&id=23');
INSERT INTO `qb_crontab` VALUES ('2','ݿ','0','0300','0','1292489459','inc/crontab/mysqlbak.php','','1');
INSERT INTO `qb_crontab` VALUES ('4','ո','0','','1296504125','0','inc/crontab/delete_table_upfile.php','','1');
INSERT INTO `qb_fenlei_area` VALUES ('1','0','ֱϽ','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('1','11','1','1','0','1','1288747862','1297387862','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('2','1','1','1','0','1','1288747862','1297387862','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('3','11','1','2','0','1','1288748053','1297388053','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('4','1','1','2','0','1','1288748053','1297388053','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('5','11','1','3','0','1','1288748274','1297388274','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('6','1','1','3','0','1','1288748274','1297388274','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('7','11','1','5','0','1','1288748451','1297388451','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('8','1','1','5','0','1','1288748451','1297388451','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('9','11','1','6','0','1','1288748551','1297388551','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('10','1','1','6','0','1','1288748551','1297388551','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('11','12','1','7','0','1','1288748680','1297388680','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('12','1','1','7','0','1','1288748680','1297388680','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('13','12','1','8','0','1','1288748767','1297388767','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('14','1','1','8','0','1','1288748767','1297388767','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('15','12','1','9','0','1','1288748853','1297388853','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('16','1','1','9','0','1','1288748853','1297388853','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('17','12','1','10','0','1','1288748955','1297388955','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('18','1','1','10','0','1','1288748955','1297388955','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('19','12','1','11','0','1','1288749091','1297389091','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('20','1','1','11','0','1','1288749091','1297389091','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('21','12','1','12','0','1','1288749185','1297389185','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('22','1','1','12','0','1','1288749185','1297389185','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('23','12','1','13','0','1','1288749284','1297389284','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('24','1','1','13','0','1','1288749284','1297389284','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('25','12','1','14','0','1','1288749389','1297389389','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('26','1','1','14','0','1','1288749389','1297389389','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('27','25','1','15','0','1','1288749504','1297389504','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('28','2','1','15','0','1','1288749504','1297389504','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('29','25','1','16','0','1','1288749586','1297389586','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('30','2','1','16','0','1','1288749586','1297389586','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('31','25','1','17','0','1','1288749657','1297389657','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('32','2','1','17','0','1','1288749657','1297389657','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('33','19','1','18','0','1','1288749841','1297389841','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('34','1','1','18','0','1','1288749841','1297389841','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('35','19','1','19','0','1','1288749918','1297389918','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('36','1','1','19','0','1','1288749918','1297389918','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('37','19','1','20','0','1','1288750024','1297390024','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('38','1','1','20','0','1','1288750024','1297390024','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('39','19','1','21','0','1','1288750130','1297390130','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('40','1','1','21','0','1','1288750130','1297390130','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('41','19','1','22','0','1','1288750213','1297390213','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('42','1','1','22','0','1','1288750213','1297390213','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('43','19','1','23','0','1','1288750318','1297390318','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('44','1','1','23','0','1','1288750318','1297390318','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('45','19','1','24','0','1','1288750366','1297390366','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('46','1','1','24','0','1','1288750366','1297390366','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('47','11','1','25','0','1','1288750509','1297390509','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('48','1','1','25','0','1','1288750509','1297390509','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('49','11','1','26','0','1','1288750587','1297390587','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('50','1','1','26','0','1','1288750587','1297390587','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('51','11','1','27','0','1','1288750643','1297390643','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('52','1','1','27','0','1','1288750643','1297390643','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('53','25','1','28','0','1','1288750739','1297390739','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('54','2','1','28','0','1','1288750739','1297390739','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('55','25','1','29','0','1','1288750820','1297390820','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('56','2','1','29','0','1','1288750820','1297390820','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('57','25','1','30','0','1','1288750891','1297390891','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('58','2','1','30','0','1','1288750891','1297390891','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('59','25','1','31','0','1','1288750945','1297390945','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('60','2','1','31','0','1','1288750945','1297390945','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('61','60','1','33','0','1','1288762758','1297402758','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('62','3','1','33','0','1','1288762758','1297402758','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('63','26','1','34','0','1','1288763234','1297403234','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('64','2','1','34','0','1','1288763234','1297403234','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('65','31','1','35','0','1','1288763344','1297403344','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('66','2','1','35','0','1','1288763344','1297403344','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('67','30','1','36','0','1','1288763474','1297403474','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('68','2','1','36','0','1','1288763474','1297403474','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('69','24','1','37','0','1','1288763579','1297403579','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('70','2','1','37','0','1','1288763579','1297403579','25','0');
INSERT INTO `qb_fenlei_buyad` VALUES ('71','-1','1','34','6','1','1295430799','1304070799','20','0');
INSERT INTO `qb_fenlei_city` VALUES ('1','1','','0','0','0','','0','0','','','','','|||','','0','','','0','','','','','0','','1','B','','city/BeiJing');
INSERT INTO `qb_fenlei_class` VALUES ('31','0','λ','1');
INSERT INTO `qb_fenlei_class` VALUES ('32','31','/','0');
INSERT INTO `qb_fenlei_class` VALUES ('33','31','Դ//ְԱ','0');
INSERT INTO `qb_fenlei_class` VALUES ('34','31','ҽ/ݱ','0');
INSERT INTO `qb_fenlei_class` VALUES ('38','34','ʿ/Ա','0');
INSERT INTO `qb_fenlei_class` VALUES ('37','34','ҽ/ҽʦ','0');
INSERT INTO `qb_fenlei_class` VALUES ('39','33','Ա/','0');
INSERT INTO `qb_fenlei_class` VALUES ('40','33','/Դܼ','0');
INSERT INTO `qb_fenlei_class` VALUES ('41','32','ʦ','0');
INSERT INTO `qb_fenlei_class` VALUES ('42','32','Ӳʦ','0');
INSERT INTO `qb_fenlei_config` VALUES ('AdInfoListLeng','40','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_PostMaxNum','20','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_TopNum','5','');
INSERT INTO `qb_fenlei_config` VALUES ('AdInfoSortShow','10','');
INSERT INTO `qb_fenlei_config` VALUES ('AdInfoShowTime','100','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_feedbackID','111111','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_MakeIndexHtmlTime','0','');
INSERT INTO `qb_fenlei_config` VALUES ('ErrSortMoney','13','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_DelKeyword','\r\n','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_PostMaxLeng','100000','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_RepeatPostNum','3','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_postCkMob','0','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_postCkIp','0','');
INSERT INTO `qb_fenlei_config` VALUES ('DelOtherCommentMoney','12','');
INSERT INTO `qb_fenlei_config` VALUES ('otherCardMoney','11','');
INSERT INTO `qb_fenlei_config` VALUES ('permitMoney','10','');
INSERT INTO `qb_fenlei_config` VALUES ('IDcardMoney','9','');
INSERT INTO `qb_fenlei_config` VALUES ('EmailYzMoney','8','');
INSERT INTO `qb_fenlei_config` VALUES ('ReportMoney','7','');
INSERT INTO `qb_fenlei_config` VALUES ('GoodCommentMoney','6','');
INSERT INTO `qb_fenlei_config` VALUES ('PublicizeRegMoney','5','');
INSERT INTO `qb_fenlei_config` VALUES ('ALLInfoMoney','4','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_loginTime','16','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_loginMoney','3','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_regmoney','1','');
INSERT INTO `qb_fenlei_config` VALUES ('illInfoMoney','14','');
INSERT INTO `qb_fenlei_config` VALUES ('DelReportMoney','15','');
INSERT INTO `qb_fenlei_config` VALUES ('Jump_allcity','0','');
INSERT INTO `qb_fenlei_config` VALUES ('Jump_fromarea','1','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_TopMoney','3','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_closeWhy','վά,ͣ','');
INSERT INTO `qb_fenlei_config` VALUES ('sort_layout','10,9,150,165#2,4#1,5,3#6,7,8#','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_GroupCommentYzImg','2,3,4,8,9','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_GroupPostYzImg','2,3,4,8,9','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_weburl','','');
INSERT INTO `qb_fenlei_config` VALUES ('ForbidPostIp','','');
INSERT INTO `qb_fenlei_config` VALUES ('AdInfoIndexLeng','','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_ForbidMemberViewContact','0','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_ShowSearchContact','0','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_ImgShopContact','0','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_ForbidGuesViewContact','0','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_TopDay','2','');
INSERT INTO `qb_fenlei_config` VALUES ('ForbidPostMember','','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_cityPost','0','');
INSERT INTO `qb_fenlei_config` VALUES ('AdInfoBigsortShow','15','');
INSERT INTO `qb_fenlei_config` VALUES ('InfoIndexCSRow','','');
INSERT INTO `qb_fenlei_config` VALUES ('Force_Choose_City','0','');
INSERT INTO `qb_fenlei_config` VALUES ('post_htmlType','0','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_Searchkeyword','0','');
INSERT INTO `qb_fenlei_config` VALUES ('Post_group_UpPhoto','','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_forbidOutPost','1','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_MemberPostRepeat','0','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_GuestPostRepeat','0','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_MemberPostMoney','2','');
INSERT INTO `qb_fenlei_config` VALUES ('InfoIndexLeng','26','');
INSERT INTO `qb_fenlei_config` VALUES ('InfoIndexRow','8','');
INSERT INTO `qb_fenlei_config` VALUES ('InfoListRow','10','');
INSERT INTO `qb_fenlei_config` VALUES ('AdInfoIndexRow','16','');
INSERT INTO `qb_fenlei_config` VALUES ('group_UpPhoto','','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_contact','010-88888888\r\nkefu@gmail.com\r\nkefu@msn.com\r\n88888888','');
INSERT INTO `qb_fenlei_config` VALUES ('UpdatePostTime','3','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_showday','3/10/30/60/90/180','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_guide_word','','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_ShowNoYz','1','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_DelEndtime','0','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_MemberPostPicNum','','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_MemberDayPostNum','20','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_GuestPostPicNum','','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_GuestDayPostNum','3','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_ClosePostWhy','ϴʱ,ͣ޸Ϣ','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_YzKeyword_DO','0','');
INSERT INTO `qb_fenlei_config` VALUES ('CommentPass_group','3,4','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_htmlType','0','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_allcityType','0','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_MemberChooseCity','0','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_UseEndTime','1','');
INSERT INTO `qb_fenlei_config` VALUES ('CollectArticleNum','23','');
INSERT INTO `qb_fenlei_config` VALUES ('PostInfoMoney','2','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_allowGuesSearch','1','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_ClosePost','0','');
INSERT INTO `qb_fenlei_config` VALUES ('module_pre','fenlei_','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_style','','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_metakeywords','   ҳ','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_webadmin','','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_webOpen','1','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_areaname','ȫ','');
INSERT INTO `qb_fenlei_config` VALUES ('module_id','1','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_htmlname','html','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_webname','Ϣ','');
INSERT INTO `qb_fenlei_config` VALUES ('AdInfoIndexShow','20','');
INSERT INTO `qb_fenlei_config` VALUES ('GroupPassYz','','');
INSERT INTO `qb_fenlei_config` VALUES ('GroupPostInfo','','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_TopColor','#F70968','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_Musttelephone','0','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_Mustmobphone','0','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_MustQQ','0','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_MustEmail','0','');
INSERT INTO `qb_fenlei_config` VALUES ('InfoIndexCSLeng','','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_showsortnum','','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_ListNum','','');
INSERT INTO `qb_fenlei_config` VALUES ('AdInfoListRow','10','');
INSERT INTO `qb_fenlei_config` VALUES ('InfoListLeng','30','');
INSERT INTO `qb_fenlei_config` VALUES ('showNoPassComment','0','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_YzKeyword','԰\r\n\r\n','');
INSERT INTO `qb_fenlei_config` VALUES ('rand_num','1288762604','');
INSERT INTO `qb_fenlei_config` VALUES ('rand_num_inputname','hna','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_ReportDB','Ϣ\r\nϢ\r\nΥϢ\r\nͬϢ','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_index_cache','','');
INSERT INTO `qb_fenlei_config` VALUES ('Info_list_cache','','');
INSERT INTO `qb_fenlei_config` VALUES ('rand_num_mktime','1','');
INSERT INTO `qb_fenlei_config` VALUES ('module_close','0','');
INSERT INTO `qb_fenlei_content` VALUES ('1','Сضڸװ۳','0','','1','0','11','ⷿ','0','0','0','0','4','0','1288747862','1288747862','1','admin','','0','http://pic.58.com/p1/big/n_6734506480129.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304299862','','1288747957','1','0','0','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','7','0');
INSERT INTO `qb_fenlei_content` VALUES ('2','˳ 15ƽ װ Ұ','0','','1','0','11','ⷿ','0','0','0','0','4','0','1288748053','1288748053','1','admin','','0','http://pic.58.com/p1/big/n_6677318701828.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304300053','','1288748124','1','1','1','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','3','0');
INSERT INTO `qb_fenlei_content` VALUES ('3','ׯﳬһҳ','0','','1','0','11','ⷿ','0','0','0','0','1','0','1288748274','1288748274','1','admin','','0','http://pic.58.com/p1/big/n_6669086810625.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304300274','','1288748275','1','2','0','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','5','0');
INSERT INTO `qb_fenlei_content` VALUES ('4','ͼ˦վůĵ','0','','1','0','11','ⷿ','0','0','0','0','1','0','1288748371','1288748371','1','admin','','0','http://pic.58.com/p1/big/n_6776884899585.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1289007571','','1288748373','1','3','0','','3','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','3','0');
INSERT INTO `qb_fenlei_content` VALUES ('5','ڵ еװ ش̨','0','','1','0','11','ⷿ','0','0','0','0','8','0','1288748451','1288748451','1','admin','','0','http://pic.58.com/p1/big/n_6675172719362.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304300451','','1288751630','1','3','0','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','2','0');
INSERT INTO `qb_fenlei_content` VALUES ('6','ֱ⾫װ˫ܰȫҵס','0','','1','0','11','ⷿ','0','0','0','0','1','0','1288748551','1288748551','1','admin','','0','http://pic.58.com/p1/big/n_6274044757249.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304300551','','1288748553','1','4','0','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','4','0');
INSERT INTO `qb_fenlei_content` VALUES ('7','ֱ,һ,ʹȨװԢ!','0','','1','0','12','ַ','0','0','0','0','5','0','1288748680','1288748680','1','admin','','0','http://pic.58.com/p1/big/n_6629233098498.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304300680','','1305181142','1','1','0','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','2','0');
INSERT INTO `qb_fenlei_content` VALUES ('8','һ԰,113,165Ʒ','0','','1','0','12','ַ','0','0','0','0','1','0','1288748767','1288748767','1','admin','','0','http://pic.58.com/p1/big/n_6756913455618.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304300767','','1288748768','1','1','1','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','4','0');
INSERT INTO `qb_fenlei_content` VALUES ('9',',,Ͷ,ر!!','0','','1','0','12','ַ','0','0','0','0','1','0','1288748853','1288748853','1','admin','','0','http://pic.58.com/p1/big/n_6648791474433.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304300853','','1288748854','1','2','0','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','3','0');
INSERT INTO `qb_fenlei_content` VALUES ('10','ϡȱԴ:ʾСϱ¥73ƽ+¥','0','','1','0','12','ַ','0','0','0','0','3','0','1288748955','1288748955','1','admin','','0','http://pic.58.com/p1/big/n_5923400835588.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304300955','','1288751714','1','3','0','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','6','0');
INSERT INTO `qb_fenlei_content` VALUES ('11','ڵ סѡ г12 Լ۱ȸ!','0','','1','0','12','ַ','0','0','0','0','1','0','1288749091','1288749091','1','admin','','0','http://pic.58.com/p1/big/n_6543150205444.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304301091','','1288749092','1','6','0','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','4','0');
INSERT INTO `qb_fenlei_content` VALUES ('12','ǶŶȫҵͼ۳','0','','1','0','12','ַ','0','0','0','0','2','0','1288749185','1288749185','1','admin','','0','http://pic.58.com/p1/big/n_6695274413313.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304301185','','1292137522','1','0','0','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','4','0');
INSERT INTO `qb_fenlei_content` VALUES ('13','ԷСг98ƽ160wͶʾֵ','0','','1','0','12','ַ','0','0','0','0','2','0','1288749284','1288749284','1','admin','','0','http://pic.58.com/p1/big/n_6651860091394.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304301284','','1290069132','1','3','0','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','6','0');
INSERT INTO `qb_fenlei_content` VALUES ('14','ƴ԰1.4һƽ׺÷','0','','1','0','12','ַ','0','0','0','0','3','0','1288749389','1288749389','1','admin','','0','http://pic.58.com/p1/big/n_6273115439620.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304301389','','1291987583','1','8','0','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','4','0');
INSERT INTO `qb_fenlei_content` VALUES ('15','תIBMʼǱ,ڴ1GӲ120G','0','','6','0','25','ֱʼǱ','0','0','0','0','1','0','1288749504','1288749504','1','admin','','0','http://pic.58.com/p1/big/n_6668288325380.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304301504','','1288749505','1','0','0','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','2','0');
INSERT INTO `qb_fenlei_content` VALUES ('16','תõλıʼǱ','0','','6','0','25','ֱʼǱ','0','0','0','0','1','0','1288749586','1288749586','1','admin','','0','http://pic.58.com/p1/big/n_5847911041538.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304301586','','1288749587','1','0','0','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','6','0');
INSERT INTO `qb_fenlei_content` VALUES ('17','9.9()ThinkPad E30 ʼǱ','0','','6','0','25','ֱʼǱ','0','0','0','0','2','0','1288749657','1288749657','1','admin','','0','http://pic.58.com/p1/big/n_6547264688642.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304301657','','1288749658','1','0','0','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','2','0');
INSERT INTO `qb_fenlei_content` VALUES ('18','5Aд¥ʢ165O5Ԫ/O/н','0','','7','0','19','д¥/','0','0','0','0','1','0','1288749841','1288749841','1','admin','','0','http://pic.58.com/p1/big/n_6761542190084.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304301841','','1288749842','1','1','1','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','2','0');
INSERT INTO `qb_fenlei_content` VALUES ('19',' Żóĳ270ƽ1650ƽ','0','','7','0','19','д¥/','0','0','0','0','1','0','1288749918','1288749918','1','admin','','0','http://pic.58.com/p1/big/n_6674458128129.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304301918','','1288749919','1','0','0','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','2','0');
INSERT INTO `qb_fenlei_content` VALUES ('20','SOHOؼ⡪ŵڿ','0','','7','0','19','д¥/','0','0','0','0','1','0','1288750024','1288750024','1','admin','','0','http://pic.58.com/p1/big/n_6579165722369.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1289009224','','1288750025','1','2','0','','3','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','6','0');
INSERT INTO `qb_fenlei_content` VALUES ('21','ֻ350ƽ׿䴿д¥ͼ۳','0','','7','0','19','д¥/','0','0','0','0','1','0','1288750130','1288750130','1','admin','','0','http://pic.58.com/p1/big/n_6777321068802.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304302130','','1288750131','1','2','0','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','4','0');
INSERT INTO `qb_fenlei_content` VALUES ('22','Сдּͼ(н)','0','','7','0','19','д¥/','0','0','0','0','6','0','1288750213','1288750213','1','admin','','0','http://pic.58.com/p1/big/n_5914324988418.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304302213','','1306900598','1','0','0','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','6','0');
INSERT INTO `qb_fenlei_content` VALUES ('23','!!ϵʵСдּע','0','','7','0','19','д¥/','0','0','0','0','1','0','1288750318','1288750318','1','admin','','0','http://pic.58.com/p1/big/n_6228552039169.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304302318','','1288750319','1','7','0','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','4','0');
INSERT INTO `qb_fenlei_content` VALUES ('24','סֻ㾫װ67ƽ׳!3800Ԫ','0','','7','0','19','д¥/','0','0','0','0','3','0','1288750366','1288750366','1','admin','','0','http://pic.58.com/p1/big/n_2840474831617.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304302366','','1298518591','1','0','0','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','1','0');
INSERT INTO `qb_fenlei_content` VALUES ('25','бϱͨ͸,Ҿ߼ҵȫ','0','','1','0','11','ⷿ','0','0','0','0','12','0','1288750509','1288750509','1','admin','','0','http://pic.58.com/p1/big/n_6676699118849.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304302509','','1305180909','1','2','0','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','6','0');
INSERT INTO `qb_fenlei_content` VALUES ('26','˫ָ׳ǹľװһ˦˦˦','0','','1','0','11','ⷿ','0','0','0','0','7','0','1288750587','1288750587','1','admin','','0','http://pic.58.com/p1/big/n_6669667112193.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304302587','','1298518501','1','1','1','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','2','0');
INSERT INTO `qb_fenlei_content` VALUES ('27','԰ ׯ ʿ· ܰʺһ','0','','1','0','11','ⷿ','0','0','0','0','7','0','1288750643','1288750643','1','admin','','0','http://pic.58.com/p1/big/n_6675030029058.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304302643','','1305169596','1','2','0','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','2','0');
INSERT INTO `qb_fenlei_content` VALUES ('28','תûոϷʼǱ,3DϷ','0','','6','0','25','ֱʼǱ','0','0','0','0','2','0','1288750739','1288750739','1','admin','','0','http://pic.58.com/p1/big/n_6734044924418.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304302739','','1288750741','1','1','0','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','4','0');
INSERT INTO `qb_fenlei_content` VALUES ('29','ȫ¿˫Һ,ͻ,걣','0','','6','0','25','ֱʼǱ','0','0','0','0','1','0','1288750820','1288750820','1','admin','','0','http://pic.58.com/p1/big/n_4233931316737.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304302820','','1288750821','1','3','0','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','1','0');
INSERT INTO `qb_fenlei_content` VALUES ('30','199.9250GٻƯCQ40','0','','6','0','25','ֱʼǱ','0','0','0','0','2','0','1288750891','1288750891','1','admin','','0','http://pic.58.com/p1/big/n_6755839858689.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304302891','','1288750892','1','0','0','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','2','0');
INSERT INTO `qb_fenlei_content` VALUES ('31','2GѸ̴28±л999IBMT61P','0','','6','0','25','ֱʼǱ','0','0','0','0','2','0','1288750945','1288750945','1','admin','','0','http://pic.58.com/p1/big/n_6777091359492.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304302945','','1295431796','1','1','6','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','1','0');
INSERT INTO `qb_fenlei_content` VALUES ('32','Ҹ һԷ','0','','5','0','129','','0','0','0','0','1','0','1288762604','1288762604','1','admin','','0','http://pic.58.com/p1/big/n_6777574838529.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304314604','','1288762605','1','0','0','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','1','0');
INSERT INTO `qb_fenlei_content` VALUES ('33','ǼƵнƸԱ','0','','3','0','60','/Ƶ','0','0','0','0','3','0','1288762758','1288762758','1','admin','','0','http://pic.58.com/p1/big/n_6668047451908.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304314758','','1288762823','1','0','0','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','1','0');
INSERT INTO `qb_fenlei_content` VALUES ('34','ȫµĴĻػ˶M10ֻ','0','','6','0','26','ֻ/ͨѶ','0','0','0','0','10','0','1288763234','1288763234','1','admin','','0','http://pic.58.com/p1/big/n_6762676355074.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1289022434','','1298618692','1','1','0','','3','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','1','0');
INSERT INTO `qb_fenlei_content` VALUES ('35','ͼתúƳ995Ԫת','0','','6','0','31','ĸӤ/ͯƷ','0','0','0','0','2','0','1288763344','1288763344','1','admin','','0','http://pic.58.com/p1/big/n_5042078629889.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1289022544','','1298541593','1','1','0','','3','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','1','0');
INSERT INTO `qb_fenlei_content` VALUES ('36','תʽƤѥ,42ŵĻ27 ,10Ԫת','0','','6','0','30','//ղƷ','0','0','0','0','2','0','1288763474','1288763474','1','admin','','0','http://pic.58.com/p1/big/n_6778448960516.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1289022674','','1288763476','1','0','0','','3','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','1','0');
INSERT INTO `qb_fenlei_content` VALUES ('37','תƻMACBOOK','0','','6','0','24','̨ʽ','0','0','0','0','5','0','1288763579','1288763579','1','admin','','0','http://pic.58.com/p1/big/n_6780653510658.jpg','1','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','1304315579','','1298532911','1','0','0','','180','','0','','13399999999','65223@qq.com','888888','','admin','','','','','','1','0');
INSERT INTO `qb_fenlei_content_1` VALUES ('1','1','11','1','ϱͨ͸ңھװޣҺʹҳϣϴּɾڼҵȫ롣סǰ绰ϵɿ<br />\r\nϵʱ˵58ͬǿģлл','88·','վ','һ','900','ˮ//绰//ܵú/','65','װ','89','1');
INSERT INTO `qb_fenlei_content_1` VALUES ('2','2','11','1','н<br />\r\nҺסһ䣬 һԳ⣬ϰ壬Ů£סӵķǳãһ۵˿϶ġӣûиϣסűȽʰƬҽĵġ<br />\r\nλ϶ֶ · 5· ¥Զǹվ,ͨ19,48,53,54,59,72,122,395,377,414,474,626,741,800,939,<br />\r\n<br />\r\nǾװ2е1ӣ䣬ϴ»ˮ΢¯յȫС<br />\r\n2. 15ƽף;<br />\r\n3. ҾһӦȫ˫˴+ľx1+x1+<br />\r\n4. ȫϴ·㡣ã<br />\r\n5. С24Сʱ԰ȫվ࣬<br />\r\n5. һ1900ĩȫ죩<br />\r\n<br />\r\n<br />\r\n1. Ů<br />\r\n2. ȶ,Ը,ɾ<br />\r\n','989·','ƴվ','һ','6000','ˮ//绰//Ҿ','66','ͨװ','21','1');
INSERT INTO `qb_fenlei_content_1` VALUES ('3','3','11','1','ڹׯҾߺͼҵȽȫܱͨＰ䷽㣬ϷӵԾסûκӰ죬ҴƬʵͼҪѸҷϢ벻Ҫ绰һģصģѾˣ','','','һ','3000','ˮ///Ҿ','66','װ','12','1');
INSERT INTO `qb_fenlei_content_1` VALUES ('4','4','11','1','װ޵ķ¥󼴵5ߺ13߽紦ˮųվAڣж·ͨ㡣,ůůм豸,ֻźźã,,ɾ,ͨϴ·⻧˵õĵҡ,LOFT,¥¥¶дס,Լ۱ȼߵķ,Ժͬ»Ѻ','','','һ','500','ˮ///ܵú/','55','ͨװ','14','1');
INSERT INTO `qb_fenlei_content_1` VALUES ('5','5','11','1','Ǵ̨һ䡣ϵĴش涼ǽһΪܸţڻ   ھסĶϰ ľذ.ҵȫˮ ϴ» 䣬ҵȡůг¹ д̨   ˫˴ҪסһŮŮΪӺܸɾϣϧӣദסʱԿ нţ<br />\r\n<br />\r\nӽ5ߵͨԷվͨʮֱŵᳬ10ӣ˵5⣬п417432758ȶ·<br />\r\n','','','һ','5555','ˮ//绰/','44','ͨװ','23','1');
INSERT INTO `qb_fenlei_content_1` VALUES ('6','6','11','1','02Ʒ.¥,,,ͨ͸Լ,67ƽһ.ȫҵ,:ӡ䡢ϴ»ˮ绰ADSL΢¯,ȼҺͿпյ.Ҿȫ.˫̨,,ϴ,ס.<br />\r\nͨ䷽мӼڿɿʽ⡣<br />\r\nⷿ⻧Ҵ绰벻Ҫ˷ѱ˴˵ʱ䣬нСнϣгϵĵ˺Լ۸С긶۸顣顣','','','һ','434','ˮ/','55','װ','34','1');
INSERT INTO `qb_fenlei_content_1` VALUES ('7','7','12','1','Ϊһ20ʹȨװޣһϱͨ͸Ͷʡϡסѡ<br />\r\n','','','һ','11112','ˮ/','32','װ','23','1');
INSERT INTO `qb_fenlei_content_1` VALUES ('8','8','12','1','˷һ԰ġ԰30ƽףɹⲻӰ졣˷ͨ͸Ļͨ͡رáֵĺܸɾ˷Ʒ˰١СУ׶԰С軪ߡеȵȣСšܱʩȫͨ·Сſڣ','','','һ','4343','ˮ/','34','װ','4','1');
INSERT INTO `qb_fenlei_content_1` VALUES ('9','9','12','1','һ׺÷ûϧ׷Ī<br />\r\nһ׺÷ǰҪ˵ȫ<br />\r\nһޣǾǴȨ70꣡','','','һ','5455','ˮ//绰/','55','װ','5','1');
INSERT INTO `qb_fenlei_content_1` VALUES ('10','10','12','1','ϱ¥ַɹ㣬ϱҼԼ73ƽףϲи¥һ䣨ɿռ䣬ɼӶΪ๦ңСλڵ2š4ţ13ֱվ200״6߳ׯվ200״СΪ֯רҹ滮ƵľɳǸʾСС߶ȴΪ㣬ůԭĺԺڴľΪ˾ɫ̬СסլλС룬ʣϱСɫڣλ㣬סšСйůͨйܵȻСάӲʩȺθ¡Сܱ׶԰л·СѧĸСѧ԰Сѧ԰СѧС35Уѵġйͯġ깬Сܱ߹﷽㣬˳츮ھӡ㳡ȴ͹ﳬУС50йСйСУСжǱѧҽԺС򹫽ֱ˴СС⣬ھס˵Ϊ٣ټϺܶʷƣûгƬȽйģСڷḻĹҼĽ̡ԴʹԱСΪס󣻱Сλڶֱڣٹҽڽ飬νУϽ񡢹ҵ̬Ϊѳ̨ڲסլƷĿõءĹ涨ˣҵȥסԣϡȱԴ߼Ͷʼֵ2010ϰͬǨ׼ݱعֵΪ260ԲֵΪ300-400Բϡ⣬ɢڽ70ԶĲʹöƱСΪִ˾ӾסС͹һЩסڱСΣϳֻҪŲǨ׷׹˱СѰҴ۵ķϾйִеĻƶڱȫӢƼ׶ȥΪί߶˽񡢹ҼʩƼڹȥΪ󡱣ǽʼմλ<br />\r\n','','','һ','0','ˮ//绰/','43','װ','4','1');
INSERT INTO `qb_fenlei_content_1` VALUES ('11','11','12','1','ϱͨ͸2ңҵۣʱ<br />\r\n<br />\r\n2.СţͨŶ·ط<br />\r\n<br />\r\n3.ܱߴѧ:ʯʹѧ,Դѧ,ʯͻѧԺ,йũҵѧУ,ҵѧ,쿪վ,йʯʹѧ.<br />\r\n<br />\r\n4.ҵǮŻᳬͼ۳ۡ','','','һ','4355','ˮ//绰','45','װ','4','1');
INSERT INTO `qb_fenlei_content_1` VALUES ('12','12','12','1','С˳̻󣬷ǶŶĴӣȫǳϣԶ̨Ӿװޡ','','','һ','43434','ˮ//绰','43','ͨװ','4','1');
INSERT INTO `qb_fenlei_content_1` VALUES ('13','13','12','1','һ Դƣ 1Ժ¥۳ <br />\r\n2߿  <br />\r\n3װ ס <br />\r\n ͽܣͣ321ϱͨ͸ַʹʳ <br />\r\n1ߡʡǳ <br />\r\n2Ҵĺӱʹʷǳ֮ <br />\r\n3̨ͼ㹻Ŀռչ˽ҳ<br />\r\n4ӿͳ֮ͼζĲɰ¶д<br />\r\n ܣ ˾ס ʸ ҵ <br />\r\n1С2000  <br />\r\n2СǼйů<br />\r\n3СݻʷǳСڵܶ ǳ˾ס <br />\r\n4С̻ʸߣܻ԰һļ<br />\r\nġ ׽ܣȫ һӦȫ ֿɼ <br />\r\n1 С Ӽҹ﷽ <br />\r\n2 λСԶܱУʵͶƷݣ<br />\r\n3 СиѧУϵ101,Сѧѧ㣩 <br />\r\n4 СԶвؾƵ꣬ھ дѲ <br />\r\n塢ͨܣλõ ˽ҳ͹ܷͨУУ ܱ߹448114392333963362<br />\r\n˽ܣԴ*·ԴʱӭѯʵؿλãԺ<br />\r\nַ<br />\r\n','','','һ','434','ˮ//绰/','34','ͨװ','4','1');
INSERT INTO `qb_fenlei_content_1` VALUES ('14','14','12','1','˷ϱͨ͸ңֺãλԽڴ˶Сѵͣס߿ʱϵ<br />\r\n<br />\r\n·968.410.456.631.957.937 5Ӿ룡ɱ','','','һ','434','ˮ//','54','ͨװ','4','1');
INSERT INTO `qb_fenlei_content_1` VALUES ('15','25','11','1','ӭҵϵ̣˷ķԴʵЧףⷿ죡<br />\r\nƼɣ<br />\r\nͺãϱͨ͸ӣͷֺм·<br />\r\nװ޺ãװޣҾ߼ҵ綼ȫҵַǳã⼴סɿһƬ<br />\r\nҵ̬ĳ⣬˼۾ԵͬС3<br />\r\nҵרҼ飺ҵزѩӪĳⷿѾһˣҵϺڷܣӮ˺ܶͻҵΡ<br />\r\nҶһǳϤֻҪзʵķ񽫴ӽ绰ʼ<br />\r\nʱ翴ѩ߳Ϊ<br />\r\nдͬԴҵͷҵĵ̲鿴<br />\r\n','','','һ','543','ˮ//绰','543','װ','54','2');
INSERT INTO `qb_fenlei_content_1` VALUES ('16','26','11','1','λþ зǳֵǱ Ͷʵĺõض <br />\r\n ڼָ ٰ   .... <br />\r\nڶϵ10 ͨǳı <br />\r\nַ· <br />\r\nѧУպѧѧԺֲ<br />\r\n','','','һ','65465','ˮ//绰','65','װ','65','2');
INSERT INTO `qb_fenlei_content_1` VALUES ('17','27','11','1','װ޵úܲг׵ļҾߵʰĸɾʱ룬ʱС滷ҲǺܲģ̻ķǳãܱ߽ͨʩȫⷿĵ绰ϵ','','','һ','543','ˮ//绰','543','װ','54','2');
INSERT INTO `qb_fenlei_content_3` VALUES ('1','33','60','1','涼ι˾ԭӴ¥2006526գйش山42ţԲ԰棩Ӫҵ4000ƽף¥ԹŵΪ30Сȵİ1500λٸͣλǷڡ¥ɽӴֻ磬ȴ;ۻᡣ 꾭ӪҪɽʳΪ澭Ӫɽ㱱ζ桢ˣطٸ˽ˣԼӦʱʡҹ˾ӪмƲˣƷǽ޻СɲΡƽΡƷԧࡢ֭ᡢıɽ亣ζϴͬӡ⡢ζտͬͷڻԴۡ㡭 þ¥ϺƼ޹˾רҵ ܾȫԱδ ָнṫƸλԱ','տԱ','5','ϴ','','3','1');
INSERT INTO `qb_fenlei_content_5` VALUES ('1','32','129','1','Ըã󷽣ϲϣǳˣһܶõδڴԵŶ','23','155','','50','','Ů','1','5');
INSERT INTO `qb_fenlei_content_6` VALUES ('1','15','25','1','˸±ˣתIBM һ̨ ų\r\nCPU2.0 ڴ1G Ӳ120G \r\n14 Կ9000 DVD¼\r\n޻ۣάʷش2Сʱ\r\nƽʱ3DͼϷáΡӰǳ','200','9','600','1');
INSERT INTO `qb_fenlei_content_6` VALUES ('2','16','25','1','CPU600 ڴ128M Ӳ10G 12 8500Ԫ\r\nCPU500 ڴ128M Ӳ10G 14 VCD 9 600Ԫ\r\nCPU400 ڴ128M 12  USBӿ VCD ĥ ۸500Ԫ\r\nIBM  CPU ڴ128M Ӳ10G 12 £άʷĥ𣬼۸500Ԫ\r\n֥ CPU600 ڴ192M Ӳ10G 12 VCD ۸800\r\nNECʼǱ CPU450 ڴ128M Ӳ10G 14 ĥ ų ۸500Ԫ \r\n\r\nIBM T20 CPU900 ڴ256M Ӳ20G 14 غãDVD¼۸1000Ԫ\r\n CPU700 ڴ256M Ӳ20G VCD 14 ųάʷ ۸800Ԫ\r\nʿͨ cpu1000 ڴ256M Ӳ20G 15 VCD ۸800Ԫ\r\n֥ CPU 900 ڴ256M Ӳ20G 14 DVD ۸900Ԫ ĥ,ų,άʷ\r\nDELLѸ1.7 ڴ512M Ӳ40G Կ64M DVD¼ 14 ۸1100Ԫ\r\nTCL CPU1000 ڴ128M Ӳ20G 14 VCD 9 800Ԫ\r\n\r\n֥ CPU2.0 ڴ512M Ӳ40G 15 DVD 9 ɫ 1100Ԫ\r\n CPUѸ1.5 ڴ512M Ӳ40G 13.3  9 ɫ 1200Ԫ\r\nHP CPUѸ2.8 ڴ1G Ӳ80G Կ128M DVD 14άʷ,ų ۸1450Ԫ \r\nIBM CPUѸ2.2 ڴ1G Ӳ40G Կ7500 DVD 14  ۸1400Ԫ\r\nIBM R60 ˫1.66 ڴ1G Ӳ80G Կ DVD¼ 14 95 2000Ԫ\r\nDELL D620 ˫1.73 ڴ1G Ӳ80G 14 DVD¼ Կ256M 9 ۸1850Ԫ\r\n','54','9','545','1');
INSERT INTO `qb_fenlei_content_6` VALUES ('3','17','25','1','ͺţThinkpad E300492-2ZC\r\nɫ죨棩\r\nCPU SU4100(1.30GHz)\r\nڴ棺 2GB\r\nӲ̣320GB\r\nʾоƬIntel GMA 4500MHD\r\nThinkPad BGN ֧802.11b/g/nЭ飩\r\n1000Mbps̫\r\n壺㴥 \r\nָˣTrackpointָ\r\nͷأ 130 \r\nĻ13.3Ӣ 169 1366 x 768\r\nʱ䣺 29Wh 5Сʱ Ӱ3-4Сʱ\r\nԵϿڵļǮ5300ӡ\r\n˰꣬Ʊ޵һӦȫаʱڣ\r\n˱ κĥ װWIN7콢棡\r\n칫 Ϸ ߿Ӱ ڻ£͵ѹCPUǿرᣬ1.64KGӡȽʺŮá\r\nҪĿԸϵǳţлл\r\n','44','9','4343','1');
INSERT INTO `qb_fenlei_content_6` VALUES ('4','28','25','1','תûոϷʼǱ,95ƽʱҲãã14羵Ųʿ˫1.7ٶȺܿ죩1Gڴ棬160GӲ̣256MԿDVD¼һᴥƼHIFI߼죨ܺã\r\n\r\n˱ϷһⶼûУʲôħޣɣʹٻȶܺУ³ǣɣԽߵȸڻ£Ϸ칫ⱾȫʤΣ\r\nû޹ʱĤսµһ','543','9','5435','2');
INSERT INTO `qb_fenlei_content_6` VALUES ('5','29','25','1','绰13126781171 QQ1455597583 ϵˣ ͻţҲҵʵ굱潻ף̼ңйشרۺбϣʵӪҵִͼƬ\r\n\r\nʵַйشȵԳһC1C72\r\n\r\nŵ۲Ʒȫ°걣ޡͻ,충 ͻš֧ƱҪƱļ5%˰㡣\r\n\r\nѿ˵ĵãңѾͼˣ𿳼ۣ\r\n\r\nҺʾ廪Ϲ 15350Ԫ 17600Ԫ 19650 22900Ԫ\r\n\r\n칫ͣرʺϹ˾칫ãȫȫ׹һ׺һ͡\r\n\r\n1: INTEL 2.6G/512Mڴ/Ӣ845/80GӲ/Կ/Դ400W=600Ԫ(ؼۻ\r\n\r\n2INTEL 2.6G/ʿ1Gڴ/Ӣ945/80GӲ/256MԿ/Դ400W/DVD=750Ԫ \r\n\r\n3ӢHT˫2.8G/ʿ1Gڴ/Ӣ945/80GӲ/256MԿ/Դ400W/DVD=850Ԫ\r\n\r\n4ӢHT˫3.0G/ʿ1Gڴ/Ӣ945/160GӲ/256MԿ/Դ400W/DVD=950Ԫ\r\n\r\n5: Xeon˫3.06G/ʿ1Gڴ/ӢG31/160GӲ/256MԿ/Դ400W/DVD=1000Ԫ \r\n\r\n˼ͣϷCF³ǣܿƷɳħޣ\r\n\r\n1AMD2˫ 220 2.8GƵ/ʿ2Gڴ/AM2C68/160GӲ/6150SE 512MԿ/Դ400W/DVD=1300Ԫ \r\n\r\n2Xeon˫3.06G/ʿ2Gڴ/ӢG31/160GӲ/9800GT 1GԿ/Դ400W/DVD=1400Ԫ\r\n\r\n3˫E5500/ʿ2Gڴ/ӢG31/160GӲ/9800GT 1GԿ/Դ400W/DVD=1600Ԫ \r\n\r\n4AMD8600/˶/ʿ2Gڴ/500GӲ/9800GT 1GԿ/Դ400W/DVD=1700Ԫ \r\n\r\n5AMD5000 ĺ/΢770/ʿ2Gڴ/500GӲ/9800GT 1GԿ/Դ400W/DVD=1700Ԫ \r\n\r\n6AMD˫245 2.8GƵ/ʿ2Gڴ/u/500GӲ/9800GT 1GԿ/Դ400W/DVD=1700Ԫ \r\n\r\n7ĺAMD X4 635/˶/ʿ2Gڴ/500GӲ/9800GT 1GԿ/Դ400W/DVD=2200Ԫ \r\n\r\n8ӢĺQ8200/÷G41G/ʿ2Gڴ/500GӲ/9800GT 1GԿ/Դ400W/DVD=2400Ԫ','54','9','5646','2');
INSERT INTO `qb_fenlei_content_6` VALUES ('6','30','25','1','ҵıǻյCQ40ǳƯ˲1£ɫû˵99.9¡\r\nʮֵƯɫĸٻǶһɫĻյı־ܸ߹ܻ\r\nڲɫĻаΧ̣Ưܸ߹󣬺ɫɿˮʼ̣ȥƯദָʾƵѤ˸ޱȡĻ14.1LEDھ͸ȥǳӾЧܺá\r\nǼƯ\r\nԵĴCPU Inter 2˫ 2.0HZ ٶȷǳĿġ\r\nڴ 1G\r\nӲ 250G ٴӲ\r\nԿ ATIĶԿ512MBϷͼӰʲôӾЧǳ\r\nDVD¼ ˵Լ¼̵\r\n3Сʱ ɢȷǳ\r\nøͷ   HDMIֽӿ ๦ܶ \r\nҵĹʽƱ ޿ ԭװ԰   ȶڣû1£Ըǳã2ȫ\r\n','434','9','54354','1');
INSERT INTO `qb_fenlei_content_6` VALUES ('7','31','25','1','ͺIBM T61P߶ʼǱ⼸ûĥ𣬿˵µûʲô999û⡣\r\nʼǱеУָʶȫоƬ512GѸ{ٿϵٶȣͨĵҪһ}1394ӿڣˮ̵ȵȡ\r\nʼǱĿǰΪֹ8ʱ䣬ܹȫ3꣬ڻ24ʱ䡣Ʊ޿ȱȫСȫģԵ顣\r\nʼǱƽʱֻ칫ʹ[ʵǳ˷]۵ԭΪá\r\nҪϲϷͼƵҵĵѡϾôߵѾ൱ˡ\r\nѸ4ļӢؿ2˫T8300ģƵС2.4HZõȽ45׼\r\nļٶȷǳĿ졣ػûãڵγ3Сʱࡣ\r\nڴ棺ԭװ2 2Gڴ棬֧4Gչ Ӳ̣ת320GӲ̡\r\nԿNvidia FX570MרҵԿԿС512MBġϷͼƶû⡣\r\nDVD˫¼DVDܿ¼VCD,CD,DVDȸֹ̡\r\nʼǱĻ15.4169߷ֿĻ180ȽǶɼUֱ1680*1050.\r\nҵıҲЩˣϲС񱾵Ѳ\r\nУԴ꣬Ʊ޿ԭװ˫米{Ҫ200Ԫ}һ͡\r\n','43','9','5435','2');
INSERT INTO `qb_fenlei_content_6` VALUES ('8','34','26','1','ȫµֻл3850Ԫ˴򿪺µƬûв⣬ɼش㡣͵лΪϰWMϵͳԱ˳ۡWM6.5ϵͳĻأǳʱСָкܺáרҵ豸˾GarminƷGarmin-AsusƳĵڶרҵΪĻͣϸѯ\r\n','2500','9','3000','2');
INSERT INTO `qb_fenlei_content_6` VALUES ('9','35','31','1','1,ȫСɡ120Ԫ\r\n2úƳ۵ɰɿ۵ų160Ԫת:ּɴ򿪺Ӥݡ ᣬ۵СЯ㡣ڣ㱦ɰɵĲͬ ǰֿɶ,иӰȫ ۵ в𣬷㹺 ䷶Χ7-36¡ 4.75kg\r\n3úƳ۵795Ԫת\r\n4úƳ۵8120Ԫת\r\n5,úɡ870Ԫת\r\n6úɡ8100Ԫת\r\n7úɡ9140Ԫת\r\n8ȫ±ֱɡ60Ԫת\r\n;ǶӤƷר;ϸַĻС50;\r\n','50','9','60','1');
INSERT INTO `qb_fenlei_content_6` VALUES ('10','36','30','1','˵Ƥѥ42ŵĻ27ףǽ䶦϶һ꣬öеСһŵƤѥˣ˫ЬͲˣûɣ˿ϧתøҪĲ˰ɣ10Ԫתá粻ûǮþֻҲУֻеëеҲɽߵ绰䶼ϵصҲ','2','9','10','2');
INSERT INTO `qb_fenlei_content_6` VALUES ('11','37','24','1','http://www.apple.com/macbook/ ǹҾ մ õ ѧУMACǳ ʹ ҾԲƭӿԸߵ濴ҵVISA ַҵѧ\r\n','1000','9','3000','1');
INSERT INTO `qb_fenlei_content_7` VALUES ('1','18','19','1','ʢʩ걸ѶӯơŵǡIBMд¥ߣΧŨ񣻴̳̫ƽٻ˵װгΪõҵ;ưɽֺͳưĻ㳡ʹɫݡṩжĺȥṩ˸ߵĽ͡ס\r\n˷Դʢؼ۷Դϡȱͣ䳯ãɹãҰǮˣ⣬᲻࣬Īʧٵ绰ϵ~\r\n','543','543','ͨװ','54','','','1');
INSERT INTO `qb_fenlei_content_7` VALUES ('2','19','19','1','E1650ƽ\r\n\r\nóĹ3ڣabcdef6д¥ȫֻⲻۡ\r\n1һĿоб־Եλֱߣ24㣬4㡣еһΪסĿǰһabѾȷȫ⣬ûпշԼ600-1000ƽס\r\n2cdĿǰd14ѾϣcҲѾȷɽ5㣬ҵ칫Լ3200ƽף200810-11½\r\n3efд¥ϷֱΪ15㡢 7㣬4㣬1500ƽסֱ빫԰оõд¥ޡ\r\nܹ滮λ3500һ523ͣλ1200ͣλһڳλ650-750Ԫ/£ڳλѶ800-1300Ԫ/¡˹̶³λ֮⣬㳡ϻмʮʱͣλ','543','543','ͨװ','54','','','1');
INSERT INTO `qb_fenlei_content_7` VALUES ('3','20','19','1','SOHOйţмŹ˾ SOHOйΪйزҵ˰ǰ10ҵSOHOй2005˹ƻѺйĻᡱơSOHOйᡱSOHOй2007108գSOHOйɹУƱ룺41019ԪĵزҵIPO20062009꣬SOHOйѡƸ־İѡġ͵й˾ȫǰ\r\n\r\n\r\nSOHOй²ֳĿ\r\n\r\n\r\nSOHOд¥SOHOԭģС\r\n\r\n809000ƽ ۸3.8Ԫ7Ԫ//죡\r\n\r\n\r\nSOHOشŻƽضΣǶĳۺ壬ӵ㴦ľλ⽻йšйСʯк͡й˱ڶҺҵȼSOHOλණϽǣߵ6ŵ߽㣻110112 11944·ȶͨ׶ʻ·վ·ڶҵţڻۼڴˡ\r\n\r\nSOHO ضϽǣ2ߺ6߽洩Խͨͨ˴37ͥȫĻǽƵĴùռ䣬׿Ȼȣȫ¾װް칫仧ͷ칫ռɣڵվİ칫\r\n\r\nSOHOһģʱȺռ7.65,ܽ50ƽף㼯ʶд¥ǼƵ꣬ʻչģ߼ԢĴ󲿷֡ͬʱд¥滮5ߵ̡ʩȽȫװ޾֮໥Э໥ϣ񣬻չ֣һվʽܡ\r\n\r\n\r\n\r\nSOHOװд¥8800ƽ\r\n\r\nؼۡ 4.5ƽ/죡\r\n\r\n;ƵʽߵԢС\r\n\r\n100300ƽף۸12000Ԫ30000Ԫ/\r\n\r\n\r\nSOHOĿλڱг山·ϲ࣬··ڵڶʹ͹ݣǱ߹ʻպʹͳصĻϢ⡣ƹСӽ5Ĵܷḻ46ƽ׵ĽһŨ˵ĳоۣΪ͵㣬ҵΪһ壬Ϊοͣд¥ȺסߵһȫµѸ塣\r\n\r\n\r\nSOHOʢд¥(·19)ؼС\r\n\r\nʢ1709000ƽ ۸5Ԫ7Ԫ//죡 \r\n\r\n\r\nSOHOʢ(SOHO Nexus Center)λڱڼҵͰ칫ΪһۺԽһʼ׼д¥Ĵ¥150ףۺΰƶأǱߴԵĽ֮һҪҵǼƵ꼰̨°칫¥ʮƽ׵ܽṩİ칫͹ﻷSOHOʢʻȫҰܵ¶ִм׼д¥±׼ \r\nʢĵַ:г·19 \r\n\r\n\r\nSOHOʢĿص\r\n\r\n&#8226; Լ21002500ƽףֻ;߱ˮ \r\n&#8226; ű߽CBD \r\n&#8226; 10Žվ·ֱ \r\n&#8226; ڹóʹ׶40ӳ \r\n&#8226; ǽõпղĻǽܿյذ弰յϵͳԼԴ \r\n&#8226; 16ߵ˿͵ݣICȫϵͳ \r\n&#8226; CBDҹ \r\n&#8226; ٽǼƵ꼰߶д¥ңַ \r\n\r\n\r\n\r\nSOHOйߣ13701394570\r\n','543','54','ͨװ','54','','','1');
INSERT INTO `qb_fenlei_content_7` VALUES ('4','21','19','1','ֻʵ350ƽװ칫д¥ͼ۳⣬ʱҪĸϿж÷Ӳ','5435','54','ͨװ','5','','','1');
INSERT INTO `qb_fenlei_content_7` VALUES ('5','22','19','1','̩ķزĿλʮϡȱ㣬ͨʮֱз㣡ҵŨ\r\n۸ʮֹֻȫ⣬칫õͣȫ⡣\r\n2527526983200ƽ׿ѡ\r\nİ칫ҵãҵܵϸ\r\nṩԱʮԪһݣػˮ\r\n','434','43243','ͨװ','43','','','1');
INSERT INTO `qb_fenlei_content_7` VALUES ('6','23','19','1','һṩС칫ޣߵװޣ칫ҾߣӡӡȰ칫ʩңңǰ̨ӴáΪҵṩעᣬ˰֤߰칫Чʡ\r\nǿƳʺ 2-8˰칫۸1518Ԫ-4660Ԫ͵绰ӿڣйõĻңҵȡůࡢ硢ˮˮȷãͻֻЯİͿʵ칫ͨڳϵվ¥18߹ֱﾩǸԱ°࣬¥гܱͣСʩһӦȫ. \r\nϵַкϵĽһ¥\r\nϵ绰 010-51660061 010-51669561 010-51669761ϵˣ С\r\n˾ַwww.kinghorse.com QQ:870262691\r\nҵMSN: kinghorse_cy@hotmail.com\r\nṩרҵ50¹˾ע,ṩʵעַ,ṩעˡ˰ʷ\r\n','453','5435','ͨװ','4','','','2');
INSERT INTO `qb_fenlei_content_7` VALUES ('7','24','19','1','λҵֻ㣬ھװ䣬Ϊ ʱϵʵԴ֤Ϊи෿Դ','5434','543','ͨװ','4','','','1');
INSERT INTO `qb_fenlei_db` VALUES ('1','11','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('2','11','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('3','11','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('4','11','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('5','11','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('6','11','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('7','12','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('8','12','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('9','12','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('10','12','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('11','12','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('12','12','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('13','12','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('14','12','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('15','25','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('16','25','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('17','25','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('18','19','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('19','19','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('20','19','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('21','19','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('22','19','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('23','19','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('24','19','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('25','11','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('26','11','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('27','11','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('28','25','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('29','25','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('30','25','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('31','25','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('32','129','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('33','60','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('34','26','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('35','31','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('36','30','1','1');
INSERT INTO `qb_fenlei_db` VALUES ('37','24','1','1');
INSERT INTO `qb_fenlei_field` VALUES ('125','6','עϢ','content','mediumtext','0','7','textarea','0','0','','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('124','6','¾ɳ̶','my_hownew','varchar','12','8','select','0','0','9\r\n8\r\n7\r\n6\r\n5\r\n4\r\n3\r\n2\r\n1\r\nȫ','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('122','6','ԭ','my_outprice','int','10','10','text','5','0','','','Ԫ','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('123','6','ּ','my_price','int','7','9','text','5','0','','','Ԫ','','0','1','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('120','5','ҽ','content','mediumtext','0','3','textarea','0','0','','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('121','6','׷ʽ','sortid','varchar','1','11','radio','0','0','1|潻\r\n2|Ͻ','1','','','1','1','1','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('119','5','ѧ','schoo_age','int','1','4','select','0','0','1|Сѧ\r\n2|\r\n3|\r\n4|ר\r\n5|ר\r\n6|\r\n7|о\r\n8|ʿ','5','','','0','1','1','1','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('118','5','Ҫ','sortid','int','1','5','radio','0','0','1|Ư\r\n2|ͻ\r\n3|Ӣ\r\n4|Ͻ\r\n5|ʵ','','','','1','1','1','1','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('117','5','Ȥ','my_interest','varchar','100','6','text','50','0','','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('116','5','ְҵ','my_job','varchar','30','7','text','30','0','','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('115','5','','my_weight','varchar','15','8','text','3','0','','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('114','5','','my_height','varchar','8','9','text','3','0','','','CM','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('113','5','','my_age','varchar','8','10','text','2','0','','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('112','5','Ա','my_sex','varchar','4','11','radio','0','0','\r\nŮ\r\n','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('111','4','ҽ','content','mediumtext','0','0','textarea','0','0','','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('110','4','н','my_wage','varchar','30','4','select','0','0','\r\n1000Ԫ\r\n1000Ԫ-2000Ԫ\r\n2000Ԫ-3000Ԫ\r\n3000Ԫ-4000Ԫ\r\n4000Ԫ-5000Ԫ\r\n5000Ԫ','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('108','4','','sortid','int','1','6','radio','0','0','1|Ӧ\r\n2|һ\r\n3|\r\n4|\r\n','1','','','0','1','1','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('109','4','','my_workplace','varchar','50','5','text','12','0','','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('107','4','Ա','my_sex','varchar','4','7','radio','0','0','\r\nŮ\r\n','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('106','4','','my_age','varchar','8','8','text','2','0','','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('105','4','ѧ','my_schoolage','varchar','30','9','select','0','0','Сѧ\r\n\r\n\r\nר\r\nר\r\n\r\nо\r\nʿ','ר','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('104','4','ְҵ','my_jobs','varchar','30','10','text','30','0','','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('103','3','˾','content','mediumtext','0','0','textarea','0','0','','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('102','3','ְλҪ','my_jobabout','mediumtext','255','5','textarea','0','0','','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('101','3','н','wage','int','1','6','select','0','0','1|\r\n2|1000Ԫ\r\n3|1000Ԫ-2000Ԫ\r\n4|2000Ԫ-3000Ԫ\r\n5|3000Ԫ-4000Ԫ\r\n6|4000Ԫ-5000Ԫ\r\n7|5000Ԫ','1','','','0','1','1','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('100','3','','my_workplace','varchar','30','7','text','12','0','','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('99','3','Ƹ','my_nums','varchar','12','8','text','5','0','','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('98','3','Ƹְλ','my_jobs','varchar','30','9','text','30','0','','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('97','3','Ƹ','sortid','varchar','1','10','radio','0','0','1|ȫְ\r\n2|ְ\r\n3|ʵϰ','1','','','0','1','1','1','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('96','7','עϢ','content','mediumtext','0','0','textarea','0','0','','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('95','7','·','my_bus','varchar','50','4','text','12','0','','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('94','7','վ','my_station','varchar','50','5','text','15','0','','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('93','7','¥','my_floor','varchar','5','6','text','3','0','','','¥','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('92','7','װ','my_fitment','varchar','20','7','select','0','0','ͨװ\r\nװ\r\nװ\r\në','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('90','7','','my_acreage','varchar','12','9','text','5','0','','','ƽ','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('91','7','۸','my_price','int','10','8','text','8','0','','','Ԫ','','0','1','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('89','7','','sortid','int','1','10','radio','0','0','1|\r\n2|н','1','','','1','1','1','1','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('88','2','ϸϢ','content','mediumtext','0','2','textarea','0','0','','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('86','1','עϢ','content','mediumtext','0','1','ieedit','500','300','','','','','0','0','0','0','','','','','31');
INSERT INTO `qb_fenlei_field` VALUES ('87','2','','sortid','int','1','3','radio','0','0','1|\r\n2|\r\n3|ҵ','1','','','0','1','1','1','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('85','1','·','my_bus','varchar','50','2','text','0','0','','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('84','1','վ','my_station','varchar','100','3','text','0','0','','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('83','1','¥','my_floor','varchar','12','4','text','4','0','','','¥','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('81','1','','my_acreage','varchar','12','6','text','5','0','','','ƽ','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('82','1','װ','my_fitment','varchar','15','5','radio','0','0','ͨװ\r\nװ\r\nװ\r\në','ͨװ','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('80','1','ʩ','my_peitao','varchar','150','7','checkbox','0','0','ˮ\r\n\r\n绰\r\n\r\nܵú\r\n\r\nҾ','ˮ/','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('79','1','ڲ','my_rooms','varchar','30','8','select','0','0','һ\r\n\r\nһ\r\n\r\nһһ\r\nһ\r\n\r\n','','','','0','1','1','0','','','','','1');
INSERT INTO `qb_fenlei_field` VALUES ('78','1','۸','my_price','int','8','9','text','12','0','','','Ԫ','','0','1','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('77','1','','sortid','int','1','10','radio','0','0','1|\r\n2|н','1','','','0','1','1','1','','','','','1');
INSERT INTO `qb_fenlei_field` VALUES ('126','13','','content','mediumtext','0','0','textarea','0','0','','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('127','13','˾','sortid','int','3','0','radio','0','0','1|30Ԫ\r\n2|30~50Ԫ\r\n3|50~100Ԫ\r\n4|100~150Ԫ\r\n5|150~200Ԫ\r\n6|200~300Ԫ\r\n7|300Ԫ','1','','','0','0','1','1','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('128','13','','sortid2','int','3','0','radio','0','0','1|ͥۻ\r\n2|Գ\r\n3|Լ\r\n4|Ǣ̸\r\n5|Ѿۻ\r\n6|\r\n7|;ۻ','1','','','0','0','1','1','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('129','13','ͣλ','my_228','int','1','0','radio','0','0','1|\r\n2|շ\r\n3|\r\n4|δ֪','4','','','0','0','1','1','','','','','1');
INSERT INTO `qb_fenlei_field` VALUES ('130','13','·','my_837','varchar','100','0','text','30','0','','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('131','13','վ','my_613','varchar','100','0','text','50','0','','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('132','14','','content','mediumtext','0','0','textarea','0','0','','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('133','14','˾','sortid','int','3','0','radio','0','0','1|30Ԫ\r\n2|30~50Ԫ\r\n3|50~100Ԫ\r\n4|100~150Ԫ\r\n5|150~200Ԫ\r\n6|200~300Ԫ\r\n7|300Ԫ','1','','','0','0','1','1','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('134','14','','sortid2','int','3','0','radio','0','0','1|ͥۻ\r\n2|Գ\r\n3|Լ\r\n4|Ǣ̸\r\n5|Ѿۻ\r\n6|\r\n7|;ۻ','1','','','0','0','1','1','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('135','14','ͣλ','my_382','int','1','0','radio','0','0','1|\r\n2|շ\r\n3|\r\n4|δ֪','4','','','0','0','1','1','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('136','14','·','my_835','varchar','100','0','text','30','0','','','','','0','0','0','0','','','','','0');
INSERT INTO `qb_fenlei_field` VALUES ('137','14','վ','my_491','varchar','100','0','text','30','0','','','','','0','0','0','0','','','','','1');
IINSERT INTO `qb_fenlei_friendlink` VALUES ('29','0','еƼ','http://www.chinaccnet.com/','','еƼ','0','0','0','0','0','0','','1','0','0');
INSERT INTO `qb_fenlei_friendlink` VALUES ('32','0','','http://www.sudu.cn/','','','0','0','0','0','0','0','','1','0','0');
INSERT INTO `qb_fenlei_friendlink` VALUES ('34','0','Դ֮','http://www.mycodes.net/','','Դ֮','26','0','0','0','0','0','','1','0','0');
INSERT INTO `qb_fenlei_friendlink` VALUES ('37','0','Ƹͨ','http://union.tenpay.com/','','Ƹͨ','28','0','0','0','0','0','','1','0','0');
INSERT INTO `qb_fenlei_module` VALUES ('1','0','סլ','10','','a:1:{s:9:\"moduleSet\";a:1:{s:6:\"useMap\";s:1:\"1\";}}','','1','0','a:4:{s:4:\"list\";s:0:\"\";s:4:\"show\";s:0:\"\";s:4:\"post\";s:0:\"\";s:6:\"search\";s:0:\"\";}');
INSERT INTO `qb_fenlei_module` VALUES ('2','0','һϢ','4','','a:1:{s:9:\"moduleSet\";N;}','','1','0','');
INSERT INTO `qb_fenlei_module` VALUES ('7','0','÷','9','','a:1:{s:9:\"moduleSet\";a:1:{s:6:\"useMap\";s:1:\"1\";}}','','0','0','');
INSERT INTO `qb_fenlei_module` VALUES ('3','0','Ƹ','6','','a:1:{s:9:\"moduleSet\";N;}','','0','0','');
INSERT INTO `qb_fenlei_module` VALUES ('4','0','ְ','7','','a:1:{s:9:\"moduleSet\";N;}','','0','0','');
INSERT INTO `qb_fenlei_module` VALUES ('5','0','','5','','a:1:{s:9:\"moduleSet\";N;}','','0','0','');
INSERT INTO `qb_fenlei_module` VALUES ('6','0','','8','','a:1:{s:9:\"moduleSet\";N;}','','0','0','');
INSERT INTO `qb_fenlei_module` VALUES ('13','0','','0','','a:1:{s:9:\"moduleSet\";a:1:{s:6:\"useMap\";s:1:\"1\";}}','a:6:{s:4:\"fen1\";a:2:{s:4:\"name\";s:4:\"\";s:3:\"set\";s:36:\"1=\r\n2=һ\r\n3=\r\n4=ܺ\r\n5=ǳ\";}s:4:\"fen2\";a:2:{s:4:\"name\";s:4:\"\";s:3:\"set\";s:36:\"1=\r\n2=һ\r\n3=\r\n4=ܺ\r\n5=ǳ\";}s:4:\"fen3\";a:2:{s:4:\"name\";s:4:\"\";s:3:\"set\";s:36:\"1=\r\n2=һ\r\n3=\r\n4=ܺ\r\n5=ǳ\";}s:4:\"fen4\";a:2:{s:4:\"name\";s:4:\"λ\";s:3:\"set\";s:28:\"1=\r\n2=\r\n3=\r\n4=ܹ\";}s:4:\"fen5\";a:2:{s:4:\"name\";s:8:\"ϲ̶\";s:3:\"set\";s:36:\"1=ϲ\r\n2=ν\r\n3=ϲ\r\n4=ϲ\";}s:4:\"fen6\";a:2:{s:4:\"name\";s:8:\"Χ\";s:3:\"set\";s:68:\"ͥۻ\r\nԳ\r\nԼ\r\nǢ̸\r\nѾۻ\r\n\r\n;ۻ\";}}','0','1','');
INSERT INTO `qb_fenlei_module` VALUES ('14','0','','0','','a:1:{s:9:\"moduleSet\";a:1:{s:6:\"useMap\";i:1;}}','a:6:{s:4:\"fen1\";a:2:{s:4:\"name\";s:4:\"\";s:3:\"set\";s:36:\"1=\r\n2=һ\r\n3=\r\n4=ܺ\r\n5=ǳ\";}s:4:\"fen2\";a:2:{s:4:\"name\";s:4:\"\";s:3:\"set\";s:36:\"1=\r\n2=һ\r\n3=\r\n4=ܺ\r\n5=ǳ\";}s:4:\"fen3\";a:2:{s:4:\"name\";s:4:\"\";s:3:\"set\";s:36:\"1=\r\n2=һ\r\n3=\r\n4=ܺ\r\n5=ǳ\";}s:4:\"fen4\";a:2:{s:4:\"name\";s:4:\"λ\";s:3:\"set\";s:28:\"1=\r\n2=\r\n3=\r\n4=ܹ\";}s:4:\"fen5\";a:2:{s:4:\"name\";s:8:\"ϲ̶\";s:3:\"set\";s:36:\"1=ϲ\r\n2=ν\r\n3=ϲ\r\n4=ϲ\";}s:4:\"fen6\";a:2:{s:4:\"name\";s:8:\"Χ\";s:3:\"set\";s:48:\"ͥۻ\r\nԼ\r\nǢ̸\r\nѾۻ\r\n;ۻ\";}}','0','1','');
INSERT INTO `qb_fenlei_pic` VALUES ('1','1','11','0','1','0','http://pic.58.com/p1/big/n_6734506480129.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('2','1','11','0','1','0','http://pic.58.com/p1/big/n_6734508713986.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('3','1','11','0','1','0','http://pic.58.com/p1/big/n_6734511689476.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('4','1','11','0','1','0','http://pic.58.com/p1/big/n_6734471650562.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('5','1','11','0','1','0','http://pic.58.com/p1/big/n_6734518066946.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('6','1','11','0','1','0','http://pic.58.com/p1/big/n_6734520442626.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('7','1','11','0','1','0','http://pic.58.com/p1/big/n_6734524643841.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('8','2','11','0','1','0','http://pic.58.com/p1/big/n_6677318701828.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('9','2','11','0','1','0','http://pic.58.com/p1/big/n_6677317915396.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('10','2','11','0','1','0','http://pic.58.com/p1/big/n_6677276803586.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('11','3','11','0','1','0','http://pic.58.com/p1/big/n_6669086810625.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('12','3','11','0','1','0','http://pic.58.com/p1/big/n_6669094643458.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('13','3','11','0','1','0','http://pic.58.com/p1/big/n_6669102120962.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('14','3','11','0','1','0','http://pic.58.com/p1/big/n_6669117145858.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('15','3','11','0','1','0','http://pic.58.com/p1/big/n_6669109559044.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('16','4','11','0','1','0','http://pic.58.com/p1/big/n_6776884899585.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('17','4','11','0','1','0','http://pic.58.com/p1/big/n_6776877710852.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('18','4','11','0','1','0','http://pic.58.com/p1/big/n_6776878775809.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('19','5','11','0','1','0','http://pic.58.com/p1/big/n_6675172719362.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('20','5','11','0','1','0','http://pic.58.com/p1/big/n_6675127980802.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('21','6','11','0','1','0','http://pic.58.com/p1/big/n_6274044757249.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('22','6','11','0','1','0','http://pic.58.com/p1/big/n_6274014898178.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('23','6','11','0','1','0','http://pic.58.com/p1/big/n_6274027778306.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('24','6','11','0','1','0','http://pic.58.com/p1/big/n_6274060408068.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('25','7','12','0','1','0','http://pic.58.com/p1/big/n_6629233098498.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('26','7','12','0','1','0','http://pic.58.com/p1/big/n_6629279272962.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('27','8','12','0','1','0','http://pic.58.com/p1/big/n_6756913455618.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('28','8','12','0','1','0','http://pic.58.com/p1/big/n_6756914729730.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('29','8','12','0','1','0','http://pic.58.com/p1/big/n_6756871945730.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('30','8','12','0','1','0','http://pic.58.com/p1/big/n_6756918049796.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('31','9','12','0','1','0','http://pic.58.com/p1/big/n_6648791474433.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('32','9','12','0','1','0','http://pic.58.com/p1/big/n_6648799507202.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('33','9','12','0','1','0','http://pic.58.com/p1/big/n_6648800388356.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('34','10','12','0','1','0','http://pic.58.com/p1/big/n_5923400835588.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('35','10','12','0','1','0','http://pic.58.com/p1/big/n_5923402491138.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('36','10','12','0','1','0','http://pic.58.com/p1/big/n_5923379162114.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('37','10','12','0','1','0','http://pic.58.com/p1/big/n_5923404312066.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('38','10','12','0','1','0','http://pic.58.com/p1/big/n_5923405158404.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('39','10','12','0','1','0','http://pic.58.com/p1/big/n_5923405762817.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('40','11','12','0','1','0','http://pic.58.com/p1/big/n_6543150205444.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('41','11','12','0','1','0','http://pic.58.com/p1/big/n_6543157596673.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('42','11','12','0','1','0','http://pic.58.com/p1/big/n_6543160072961.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('43','11','12','0','1','0','http://pic.58.com/p1/big/n_6543123519234.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('44','12','12','0','1','0','http://pic.58.com/p1/big/n_6695274413313.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('45','12','12','0','1','0','http://pic.58.com/p1/big/n_6695230392834.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('46','12','12','0','1','0','http://pic.58.com/p1/big/n_6695279130369.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('47','12','12','0','1','0','http://pic.58.com/p1/big/n_6695238440706.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('48','13','12','0','1','0','http://pic.58.com/p1/big/n_6651860091394.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('49','13','12','0','1','0','http://pic.58.com/p1/big/n_6651863946754.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('50','13','12','0','1','0','http://pic.58.com/p1/big/n_6651868582657.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('51','13','12','0','1','0','http://pic.58.com/p1/big/n_6651879048194.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('52','13','12','0','1','0','http://pic.58.com/p1/big/n_6651894885889.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('53','13','12','0','1','0','http://pic.58.com/p1/big/n_6651881218306.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('54','14','12','0','1','0','http://pic.58.com/p1/big/n_6273115439620.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('55','14','12','0','1','0','http://pic.58.com/p1/big/n_6273081732354.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('56','14','12','0','1','0','http://pic.58.com/p1/big/n_6273116459524.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('57','14','12','0','1','0','http://pic.58.com/p1/big/n_6273084650754.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('58','15','25','0','1','0','http://pic.58.com/p1/big/n_6668288325380.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('59','15','25','0','1','0','http://pic.58.com/p1/big/n_6668243447298.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('60','16','25','0','1','0','http://pic.58.com/p1/big/n_5847911041538.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('61','16','25','0','1','0','http://pic.58.com/p1/big/n_5847913764356.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('62','16','25','0','1','0','http://pic.58.com/p1/big/n_5847894684162.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('63','16','25','0','1','0','http://pic.58.com/p1/big/n_5847939890436.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('64','16','25','0','1','0','http://pic.58.com/p1/big/n_5847920633858.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('65','16','25','0','1','0','http://pic.58.com/p1/big/n_5847955339777.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('66','17','25','0','1','0','http://pic.58.com/p1/big/n_6547264688642.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('67','17','25','0','1','0','http://pic.58.com/p1/big/n_6547269359874.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('68','18','19','0','1','0','http://pic.58.com/p1/big/n_6761542190084.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('69','18','19','0','1','0','http://pic.58.com/p1/big/n_6761537635844.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('70','19','19','0','1','0','http://pic.58.com/p1/big/n_6674458128129.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('71','19','19','0','1','0','http://pic.58.com/p1/big/n_6674449699330.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('72','20','19','0','1','0','http://pic.58.com/p1/big/n_6579165722369.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('73','20','19','0','1','0','http://pic.58.com/p1/big/n_6579148441858.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('74','20','19','0','1','0','http://pic.58.com/p1/big/n_6579261257218.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('75','20','19','0','1','0','http://pic.58.com/p1/big/n_6579209917186.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('76','20','19','0','1','0','http://pic.58.com/p1/big/n_6579249465090.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('77','20','19','0','1','0','http://pic.58.com/p1/big/n_6579248914946.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('78','21','19','0','1','0','http://pic.58.com/p1/big/n_6777321068802.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('79','21','19','0','1','0','http://pic.58.com/p1/big/n_6777283788546.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('80','21','19','0','1','0','http://pic.58.com/p1/big/n_6777313677060.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('81','21','19','0','1','0','http://pic.58.com/p1/big/n_6777269783554.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('82','22','19','0','1','0','http://pic.58.com/p1/big/n_5914324988418.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('83','22','19','0','1','0','http://pic.58.com/p1/big/n_5914322499330.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('84','22','19','0','1','0','http://pic.58.com/p1/big/n_5914321671684.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('85','22','19','0','1','0','http://pic.58.com/p1/big/n_5914320547332.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('86','22','19','0','1','0','http://pic.58.com/p1/big/n_5914326906372.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('87','22','19','0','1','0','http://pic.58.com/p1/big/n_5914325925634.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('88','23','19','0','1','0','http://pic.58.com/p1/big/n_6228552039169.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('89','23','19','0','1','0','http://pic.58.com/p1/big/n_6228540864002.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('90','23','19','0','1','0','http://pic.58.com/p1/big/n_6228514492162.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('91','23','19','0','1','0','http://pic.58.com/p1/big/n_6228527664898.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('92','24','19','0','1','0','http://pic.58.com/p1/big/n_2840474831617.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('93','25','11','0','1','0','http://pic.58.com/p1/big/n_6676699118849.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('94','25','11','0','1','0','http://pic.58.com/p1/big/n_6676701816834.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('95','25','11','0','1','0','http://pic.58.com/p1/big/n_6676702116353.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('96','25','11','0','1','0','http://pic.58.com/p1/big/n_6676658765826.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('97','25','11','0','1','0','http://pic.58.com/p1/big/n_6676703413762.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('98','25','11','0','1','0','http://pic.58.com/p1/big/n_6676703170561.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('99','26','11','0','1','0','http://pic.58.com/p1/big/n_6669667112193.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('100','26','11','0','1','0','http://pic.58.com/p1/big/n_6669663453186.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('101','27','11','0','1','0','http://pic.58.com/p1/big/n_6675030029058.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('102','27','11','0','1','0','http://pic.58.com/p1/big/n_6675006245377.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('103','28','25','0','1','0','http://pic.58.com/p1/big/n_6734044924418.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('104','28','25','0','1','0','http://pic.58.com/p1/big/n_6734089378818.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('105','28','25','0','1','0','http://pic.58.com/p1/big/n_6734092457473.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('106','28','25','0','1','0','http://pic.58.com/p1/big/n_6734090518785.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('107','29','25','0','1','0','http://pic.58.com/p1/big/n_4233931316737.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('108','30','25','0','1','0','http://pic.58.com/p1/big/n_6755839858689.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('109','30','25','0','1','0','http://pic.58.com/p1/big/n_6755798215938.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('110','31','25','0','1','0','http://pic.58.com/p1/big/n_6777091359492.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('111','32','129','0','1','0','http://pic.58.com/p1/big/n_6777574838529.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('112','33','60','0','1','0','http://pic.58.com/p1/big/n_6668047451908.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('113','34','26','0','1','0','http://pic.58.com/p1/big/n_6762676355074.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('114','35','31','0','1','0','http://pic.58.com/p1/big/n_5042078629889.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('115','36','30','0','1','0','http://pic.58.com/p1/big/n_6778448960516.jpg','');
INSERT INTO `qb_fenlei_pic` VALUES ('116','37','24','0','1','0','http://pic.58.com/p1/big/n_6780653510658.jpg','');
INSERT INTO `qb_fenlei_sort` VALUES ('1','0','','1','1','0','1','','10','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','104','','FangChan','0');
INSERT INTO `qb_fenlei_sort` VALUES ('2','0','Ʒ','6','1','0','1','','9','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','100','','WuPinJiaoYi','0');
INSERT INTO `qb_fenlei_sort` VALUES ('3','0','ҵƸ','6','1','0','1','','8','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','50','','QiYeZhaoPin','0');
INSERT INTO `qb_fenlei_sort` VALUES ('4','0','ְ','2','1','0','1','','7','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','37','','QiuZhiJianLi','0');
INSERT INTO `qb_fenlei_sort` VALUES ('5','0','ͬǽ','2','1','0','1','','6','0','','','','','','','0','','','','1','','','','','0','','0','1','','TongChengJiaoYou','0');
INSERT INTO `qb_fenlei_sort` VALUES ('6','0','ͬǻ','2','1','0','1','','5','0','','','','','','','0','','','','1','','','','','0','','0','1','','TongChengHuoDong','0');
INSERT INTO `qb_fenlei_sort` VALUES ('7','0','-','2','1','0','1','','4','0','','','','','','','0','','','','1','','','','','0','','0','1','','FuWu_ShengHuoLei','0');
INSERT INTO `qb_fenlei_sort` VALUES ('8','0','-','2','1','0','1','','3','0','','','','','','','0','','','','1','','','','','0','','0','1','','FuWu_ShangWuLei','0');
INSERT INTO `qb_fenlei_sort` VALUES ('9','0','','2','1','0','1','','2','0','','','','','','','0','','','','1','','','','','0','','0','0','','CheLiangMaiMaiYuFuWu','0');
INSERT INTO `qb_fenlei_sort` VALUES ('10','0','ѵ','2','1','0','1','','1','0','','','','','','','0','','','','1','','','','','0','','0','1','','JiaoYuPeiXun','0');
INSERT INTO `qb_fenlei_sort` VALUES ('11','1','ⷿ','1','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','1','1','','ChuZuFang','0');
INSERT INTO `qb_fenlei_sort` VALUES ('12','1','ַ','1','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:11:\"field_value\";N;s:7:\"is_html\";N;}','1','0','','ErShouFangChuShou','1');
INSERT INTO `qb_fenlei_sort` VALUES ('13','1','ⷿ','1','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','HeZuFang','0');
INSERT INTO `qb_fenlei_sort` VALUES ('14','1','ⷿ','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','DuanQiZuFang','0');
INSERT INTO `qb_fenlei_sort` VALUES ('15','1','ⷿ','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','QiuZuFang','0');
INSERT INTO `qb_fenlei_sort` VALUES ('16','1','ַ','1','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','ErShouFangQiuGou','0');
INSERT INTO `qb_fenlei_sort` VALUES ('17','1','̳/','7','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','ShangPuChuZu_QiuZu','0');
INSERT INTO `qb_fenlei_sort` VALUES ('18','1','̳/','7','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','ShangPuChuShou_QiuGou','0');
INSERT INTO `qb_fenlei_sort` VALUES ('19','1','д¥/','7','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','1','0','','XieZiLouChuZu_QiuZu','0');
INSERT INTO `qb_fenlei_sort` VALUES ('20','1','д¥/','7','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','XieZiLouChuShou_QiuGou','0');
INSERT INTO `qb_fenlei_sort` VALUES ('21','2','Ʊ/Ʊ/ȯ/ѿ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','HuoChePiao_MenPiao_GouWuQuan_XiaoFeiKa','0');
INSERT INTO `qb_fenlei_sort` VALUES ('23','2','/Ʒ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','ChongWu_ChongWuYongPin','0');
INSERT INTO `qb_fenlei_sort` VALUES ('24','2','̨ʽ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','ErShouTaiShiDianNao','0');
INSERT INTO `qb_fenlei_sort` VALUES ('25','2','ֱʼǱ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','1','1','','ErShouBiJiBen','0');
INSERT INTO `qb_fenlei_sort` VALUES ('26','2','ֻ/ͨѶ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','ShouJi_TongXunXiangGuan','0');
INSERT INTO `qb_fenlei_sort` VALUES ('27','2','/¼','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','ErShouShuMa_SheLu','0');
INSERT INTO `qb_fenlei_sort` VALUES ('28','2','//Ӱ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','YinXiang_LeQi_YingYin','0');
INSERT INTO `qb_fenlei_sort` VALUES ('29','2','/ͼ/','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','RuanJian_TuShu_YinXiang','0');
INSERT INTO `qb_fenlei_sort` VALUES ('30','2','//ղƷ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','YiShu_GongYi_ShouCangPin','0');
INSERT INTO `qb_fenlei_sort` VALUES ('31','2','ĸӤ/ͯƷ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','MuYing_ErTongYongPin','0');
INSERT INTO `qb_fenlei_sort` VALUES ('32','2','//Ьñ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','FuShi_XiangBao_XieMao','0');
INSERT INTO `qb_fenlei_sort` VALUES ('33','2','ױƷ/Ʒ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','HuaZhuangPin_BaoJianPin','0');
INSERT INTO `qb_fenlei_sort` VALUES ('36','2','칫Ʒ/Ĳ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','BanGongYongPin_HaoCai','0');
INSERT INTO `qb_fenlei_sort` VALUES ('37','2','˶/','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','YunDong_JianShenQiCai','0');
INSERT INTO `qb_fenlei_sort` VALUES ('38','2','Ҿ/ðٻ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','JiaJu_RiYongBaiHuo','0');
INSERT INTO `qb_fenlei_sort` VALUES ('40','2','ּҵ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','ErShouJiaDian','0');
INSERT INTO `qb_fenlei_sort` VALUES ('42','2','/װ/Ʒ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','WangYou_ZhuangBei_XuNiWuPin','0');
INSERT INTO `qb_fenlei_sort` VALUES ('43','2','Ʒ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','QiTaWuPin','0');
INSERT INTO `qb_fenlei_sort` VALUES ('44','9','','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','ErShouQiCheMaiMai','0');
INSERT INTO `qb_fenlei_sort` VALUES ('45','9','⳵/','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','ZuChe_DaiJia','0');
INSERT INTO `qb_fenlei_sort` VALUES ('46','9','ְ','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','DaiCheQiuZhi','0');
INSERT INTO `qb_fenlei_sort` VALUES ('47','9','г','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','ZiXingCheMaiMai','0');
INSERT INTO `qb_fenlei_sort` VALUES ('48','9','Ħг/','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','MoTuoChe_ZhuDongChe','0');
INSERT INTO `qb_fenlei_sort` VALUES ('49','9','ƴ°','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','PinCheShangXiaBan','0');
INSERT INTO `qb_fenlei_sort` VALUES ('50','9','У/','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','JiaXiao_PeiLian','0');
INSERT INTO `qb_fenlei_sort` VALUES ('51','9','޳˾ְ','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','WuCheSiJiQiuZhi','0');
INSERT INTO `qb_fenlei_sort` VALUES ('52','9','/','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','QiXiu_BaoYang','0');
INSERT INTO `qb_fenlei_sort` VALUES ('53','9','','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','CheLiangPeiJian','0');
INSERT INTO `qb_fenlei_sort` VALUES ('54','9','³','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','XinCheMaiMai','0');
INSERT INTO `qb_fenlei_sort` VALUES ('55','3','г/Ӫ','3','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','ShiChang_YingXiao55','0');
INSERT INTO `qb_fenlei_sort` VALUES ('56','3','ְ','3','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','JianZhi','0');
INSERT INTO `qb_fenlei_sort` VALUES ('57','3','/Ա','3','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','WenMi_WenYuan57','0');
INSERT INTO `qb_fenlei_sort` VALUES ('58','3','/һ㹤','3','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','JiGong_YiBanGongRen58','0');
INSERT INTO `qb_fenlei_sort` VALUES ('59','3','/','3','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','DianNao_WangLuoXiangGuan59','0');
INSERT INTO `qb_fenlei_sort` VALUES ('60','3','/Ƶ','3','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','LvYou_JiuDianCanYin60','0');
INSERT INTO `qb_fenlei_sort` VALUES ('61','3','/߻','3','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','SheJi_CeHua61','0');
INSERT INTO `qb_fenlei_sort` VALUES ('62','3','/','3','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','XingZheng_ZhuLi62','0');
INSERT INTO `qb_fenlei_sort` VALUES ('63','3','/ƻ/','3','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','JinRong_CaiHui_ChuNa63','0');
INSERT INTO `qb_fenlei_sort` VALUES ('64','3','Ӫ','3','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','JingYingGuanLi64','0');
INSERT INTO `qb_fenlei_sort` VALUES ('65','3','/','3','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','BaoJian_MeiRongMeiFa65','0');
INSERT INTO `qb_fenlei_sort` VALUES ('66','3','//','3','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','YinLe_BiaoYan_ZhuChi66','0');
INSERT INTO `qb_fenlei_sort` VALUES ('67','3','/е/','3','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','DianZi_JiXie_GongCheng67','0');
INSERT INTO `qb_fenlei_sort` VALUES ('68','3','д/','3','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','XieZuo_FanYi68','0');
INSERT INTO `qb_fenlei_sort` VALUES ('69','3','/ҵλ','3','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','ZhengFu_ShiYeDanWei69','0');
INSERT INTO `qb_fenlei_sort` VALUES ('70','3','ְλ','3','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','QiTaZhiWei70','0');
INSERT INTO `qb_fenlei_sort` VALUES ('71','7','','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','JiaZheng','0');
INSERT INTO `qb_fenlei_sort` VALUES ('72','7','','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','BaoJie','0');
INSERT INTO `qb_fenlei_sort` VALUES ('73','7','','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','BanJia','0');
INSERT INTO `qb_fenlei_sort` VALUES ('74','7','װ/װ','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','ZhuangXiu_ZhuangShi','0');
INSERT INTO `qb_fenlei_sort` VALUES ('75','7','ܵͨ/','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','GuanDaoShuTong_DaKong','0');
INSERT INTO `qb_fenlei_sort` VALUES ('76','7','ά','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','DianNaoWeiXiu','0');
INSERT INTO `qb_fenlei_sort` VALUES ('77','7','ҵά','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','JiaDianWeiXiu','0');
INSERT INTO `qb_fenlei_sort` VALUES ('78','7','칫豸ά','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','BanGongSheBeiWeiXiu','0');
INSERT INTO `qb_fenlei_sort` VALUES ('79','7','ǻ','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','LiYiHunQing','0');
INSERT INTO `qb_fenlei_sort` VALUES ('80','7','д/ɴӰ','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','XieZhen_HunShaSheYing','0');
INSERT INTO `qb_fenlei_sort` VALUES ('81','7','','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','MeiRongMeiTi','0');
INSERT INTO `qb_fenlei_sort` VALUES ('82','7','','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','YangShengBaoJian','0');
INSERT INTO `qb_fenlei_sort` VALUES ('83','7','','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','LvYou','0');
INSERT INTO `qb_fenlei_sort` VALUES ('84','7','Ʊ/ؼۻƱ','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','DingPiao_TeJiaJiPiao','0');
INSERT INTO `qb_fenlei_sort` VALUES ('85','7','ˮ/','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','SongShui_SongQi','0');
INSERT INTO `qb_fenlei_sort` VALUES ('86','7','','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','PeiLian','0');
INSERT INTO `qb_fenlei_sort` VALUES ('87','4','г/Ӫ','4','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','ShiChang_YingXiao','0');
INSERT INTO `qb_fenlei_sort` VALUES ('88','4','ְ','4','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','QiuJianZhi','0');
INSERT INTO `qb_fenlei_sort` VALUES ('89','4','/Ա','4','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','WenMi_WenYuan','0');
INSERT INTO `qb_fenlei_sort` VALUES ('90','4','/һ㹤','4','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','JiGong_YiBanGongRen','0');
INSERT INTO `qb_fenlei_sort` VALUES ('91','4','/','4','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','DianNao_WangLuoXiangGuan','0');
INSERT INTO `qb_fenlei_sort` VALUES ('92','4','/Ƶ','4','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','LvYou_JiuDianCanYin','0');
INSERT INTO `qb_fenlei_sort` VALUES ('93','4','/߻','4','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','SheJi_CeHua','0');
INSERT INTO `qb_fenlei_sort` VALUES ('94','4','/','4','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','XingZheng_ZhuLi','0');
INSERT INTO `qb_fenlei_sort` VALUES ('95','4','/ƻ/','4','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','JinRong_CaiHui_ChuNa','0');
INSERT INTO `qb_fenlei_sort` VALUES ('96','4','Ӫ','4','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','JingYingGuanLi','0');
INSERT INTO `qb_fenlei_sort` VALUES ('97','4','/','4','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','BaoJian_MeiRongMeiFa','0');
INSERT INTO `qb_fenlei_sort` VALUES ('98','4','//','4','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','YinLe_BiaoYan_ZhuChi','0');
INSERT INTO `qb_fenlei_sort` VALUES ('99','4','/е/','4','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','DianZi_JiXie_GongCheng','0');
INSERT INTO `qb_fenlei_sort` VALUES ('100','4','д/','4','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','XieZuo_FanYi','0');
INSERT INTO `qb_fenlei_sort` VALUES ('101','4','/ҵλ','4','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','ZhengFu_ShiYeDanWei','0');
INSERT INTO `qb_fenlei_sort` VALUES ('102','4','ְλ','4','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','QiTaZhiWei','0');
INSERT INTO `qb_fenlei_sort` VALUES ('103','8','','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','KuaiDi','0');
INSERT INTO `qb_fenlei_sort` VALUES ('104','8','/վ','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','SheJi_WangZhanJianShe','0');
INSERT INTO `qb_fenlei_sort` VALUES ('105','8','ӡˢ','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','YinShua','0');
INSERT INTO `qb_fenlei_sort` VALUES ('106','8','','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','PenHuiZhaoPai','0');
INSERT INTO `qb_fenlei_sort` VALUES ('107','8','̼','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','ZhaoShangJiaMeng','0');
INSERT INTO `qb_fenlei_sort` VALUES ('108','8','˾ע/','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','GongSiZhuCe_NianJian','0');
INSERT INTO `qb_fenlei_sort` VALUES ('109','8','//','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','HuiJi_ShenJi_PingGu','0');
INSERT INTO `qb_fenlei_sort` VALUES ('110','8','/','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','JinRong_DanBaoDaiKuan','0');
INSERT INTO `qb_fenlei_sort` VALUES ('111','8','ʦ','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','LvShi','0');
INSERT INTO `qb_fenlei_sort` VALUES ('112','8','Ƿ/','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','QingQian_ShangWuDiaoCha','0');
INSERT INTO `qb_fenlei_sort` VALUES ('113','8','','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','FanYi','0');
INSERT INTO `qb_fenlei_sort` VALUES ('114','8','','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','KuaiCanWaiMai','0');
INSERT INTO `qb_fenlei_sort` VALUES ('116','8','/','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','WuLiu_HuoYun','0');
INSERT INTO `qb_fenlei_sort` VALUES ('117','8','','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','QiTa117','0');
INSERT INTO `qb_fenlei_sort` VALUES ('118','10','ҽ','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','JiaJiao','0');
INSERT INTO `qb_fenlei_sort` VALUES ('119','10','ѵ','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','WaiYuPeiXun','0');
INSERT INTO `qb_fenlei_sort` VALUES ('120','10','ְҵѵ','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','ZhiYePeiXun','0');
INSERT INTO `qb_fenlei_sort` VALUES ('121','10','','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','JiXuJiaoYu','0');
INSERT INTO `qb_fenlei_sort` VALUES ('122','10','/','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','WenYi_TiYu','0');
INSERT INTO `qb_fenlei_sort` VALUES ('123','10','ѧ/','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','LiuXue_YiMin','0');
INSERT INTO `qb_fenlei_sort` VALUES ('124','10','/','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','DianNao_WangLuo','0');
INSERT INTO `qb_fenlei_sort` VALUES ('125','10','Сѧ','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','ZhongXiaoXueJiaoYu','0');
INSERT INTO `qb_fenlei_sort` VALUES ('126','10','/Ա','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','KaoYan_GongWuYuan','0');
INSERT INTO `qb_fenlei_sort` VALUES ('127','10','','2','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','QiTa127','0');
INSERT INTO `qb_fenlei_sort` VALUES ('128','5','Ů','5','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','ZhaoNvYou','0');
INSERT INTO `qb_fenlei_sort` VALUES ('129','5','','5','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','ZhaoNanYou','0');
INSERT INTO `qb_fenlei_sort` VALUES ('130','5','ʿ','5','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','NanShiZhengHun','0');
INSERT INTO `qb_fenlei_sort` VALUES ('131','5','Ůʿ','5','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','NvShiZhengHun','0');
INSERT INTO `qb_fenlei_sort` VALUES ('132','5','ͬ','5','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','TongXiangHui','0');
INSERT INTO `qb_fenlei_sort` VALUES ('133','5','Ȥ','5','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','XingQuJiaoYou','0');
INSERT INTO `qb_fenlei_sort` VALUES ('134','5','/ף','5','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','ZhenQingGaoBai_ZhuFu','0');
INSERT INTO `qb_fenlei_sort` VALUES ('135','5','ѰѰ','5','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','XunRenXunYou','0');
INSERT INTO `qb_fenlei_sort` VALUES ('136','5','ܽ','5','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','JiNengJiaoHuan','0');
INSERT INTO `qb_fenlei_sort` VALUES ('137','5','','5','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','QiTa137','0');
INSERT INTO `qb_fenlei_sort` VALUES ('138','6','ټ','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','HuoDongZhaoJi','0');
INSERT INTO `qb_fenlei_sort` VALUES ('139','6','Ź/','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','TuanGou_DaZhe','0');
INSERT INTO `qb_fenlei_sort` VALUES ('140','6','','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','JieBanChuYou','0');
INSERT INTO `qb_fenlei_sort` VALUES ('141','6','Լ˶','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','XiangYueYunDong','0');
INSERT INTO `qb_fenlei_sort` VALUES ('142','6','/־Ը','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','GongYiHuoDong_ZhiYuanZhe','0');
INSERT INTO `qb_fenlei_sort` VALUES ('143','6','/ֻ/Ƹ','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','JiangZuo_YanTaoHui_ZhaoPinHui','0');
INSERT INTO `qb_fenlei_sort` VALUES ('144','6','ݳ/չ','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','YanChu_ZhanLan','0');
INSERT INTO `qb_fenlei_sort` VALUES ('145','6','','2','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','QiTa','0');
INSERT INTO `qb_fenlei_sort` VALUES ('150','0','ʳ','13','1','0','1','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','CanYinMeiShi','0');
INSERT INTO `qb_fenlei_sort` VALUES ('158','150','ҳ','13','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','JiaChangCai','0');
INSERT INTO `qb_fenlei_sort` VALUES ('159','150','','13','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','ChaGuan','0');
INSERT INTO `qb_fenlei_sort` VALUES ('160','150','ȹ','13','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','KaFeiGuan','0');
INSERT INTO `qb_fenlei_sort` VALUES ('161','150','','13','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','ZiZhuCan','0');
INSERT INTO `qb_fenlei_sort` VALUES ('162','150','','13','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','KuaiCan','0');
INSERT INTO `qb_fenlei_sort` VALUES ('163','150','','13','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','XiangCai','0');
INSERT INTO `qb_fenlei_sort` VALUES ('164','150','պ','13','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','RiHanCai','0');
INSERT INTO `qb_fenlei_sort` VALUES ('165','0','','14','1','0','1','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','XiuXianYuLe','0');
INSERT INTO `qb_fenlei_sort` VALUES ('166','165','ư','14','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','JiuBa','0');
INSERT INTO `qb_fenlei_sort` VALUES ('167','165','KTV','14','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','KTV','0');
INSERT INTO `qb_fenlei_sort` VALUES ('168','165','','14','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','MeiRongMeiFa','0');
INSERT INTO `qb_fenlei_sort` VALUES ('169','165','ϴԡ','14','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','XiYu','0');
INSERT INTO `qb_fenlei_sort` VALUES ('170','165','ӰԺ','14','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','DianYingYuan','0');
INSERT INTO `qb_fenlei_sort` VALUES ('171','165','Ħ','14','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','AnMo','0');
INSERT INTO `qb_fenlei_sort` VALUES ('172','165','','14','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','QiPaiShi','0');
INSERT INTO `qb_fenlei_street` VALUES ('1','1','̫ƽׯ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','BeiTaiPingZhuang');
INSERT INTO `qb_fenlei_street` VALUES ('2','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','DaZhongSi');
INSERT INTO `qb_fenlei_street` VALUES ('3','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','DingHuiSi');
INSERT INTO `qb_fenlei_street` VALUES ('4','1','ʼҿ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','GanJiaKou');
INSERT INTO `qb_fenlei_street` VALUES ('5','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','GongZhuFen');
INSERT INTO `qb_fenlei_street` VALUES ('6','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','HangTianQiao');
INSERT INTO `qb_fenlei_street` VALUES ('7','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','JianXiangQiao');
INSERT INTO `qb_fenlei_street` VALUES ('8','1','峧','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','LanDianChang');
INSERT INTO `qb_fenlei_street` VALUES ('9','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','MaDian');
INSERT INTO `qb_fenlei_street` VALUES ('10','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','QingHe');
INSERT INTO `qb_fenlei_street` VALUES ('11','1','ϵ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','ShangDi');
INSERT INTO `qb_fenlei_street` VALUES ('12','1','ׯ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','ShangZhuang');
INSERT INTO `qb_fenlei_street` VALUES ('13','1','ļ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','SiJiQing');
INSERT INTO `qb_fenlei_street` VALUES ('14','1','κ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','WeiGongCun');
INSERT INTO `qb_fenlei_street` VALUES ('15','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','XiErQi');
INSERT INTO `qb_fenlei_street` VALUES ('16','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','WuDaoKou');
INSERT INTO `qb_fenlei_street` VALUES ('17','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','XiSanQi');
INSERT INTO `qb_fenlei_street` VALUES ('18','1','ֱ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','XiZhiMen');
INSERT INTO `qb_fenlei_street` VALUES ('19','1','ɽ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','WaiXiangShan');
INSERT INTO `qb_fenlei_street` VALUES ('20','1','ѧԺ·','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','XueYuanLu');
INSERT INTO `qb_fenlei_street` VALUES ('21','1','Ȫ·','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','YuQuanLu');
INSERT INTO `qb_fenlei_street` VALUES ('22','1','Բ԰','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','YuanMingYuan');
INSERT INTO `qb_fenlei_street` VALUES ('23','1','йش','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','ZhongGuanCun');
INSERT INTO `qb_fenlei_zone` VALUES ('1','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','HaiDian');
INSERT INTO `qb_fenlei_zone` VALUES ('2','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','ChaoYang');
INSERT INTO `qb_fenlei_zone` VALUES ('3','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','DongCheng');
INSERT INTO `qb_fenlei_zone` VALUES ('4','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','XiCheng');
INSERT INTO `qb_fenlei_zone` VALUES ('5','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','ChongWen');
INSERT INTO `qb_fenlei_zone` VALUES ('6','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','XuanWu');
INSERT INTO `qb_fenlei_zone` VALUES ('7','1','̨','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','FengTai');
INSERT INTO `qb_fenlei_zone` VALUES ('8','1','ʯɽ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','ShiJingShan');
INSERT INTO `qb_fenlei_zone` VALUES ('9','1','ɽ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','FangShan');
INSERT INTO `qb_fenlei_zone` VALUES ('10','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','DaXing');
INSERT INTO `qb_fenlei_zone` VALUES ('11','1','ͨ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','TongZhou');
INSERT INTO `qb_fenlei_zone` VALUES ('12','1','˳','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','ShunYi');
INSERT INTO `qb_fenlei_zone` VALUES ('13','1','ƽ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','ChangPing');
INSERT INTO `qb_fenlei_zone` VALUES ('14','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','MiYun');
INSERT INTO `qb_fenlei_zone` VALUES ('15','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','HuaiRou');
INSERT INTO `qb_fenlei_zone` VALUES ('16','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','YanQing');
INSERT INTO `qb_fenlei_zone` VALUES ('17','1','ƽ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','PingGu');
INSERT INTO `qb_fenlei_zone` VALUES ('18','1','ͷ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','MenTouGou');
