<?php

/**
 * 后台管理功能基础控制器
 *
 * @author jonwang
 *
 */
class Controller_MyQEE__Admin extends Controller
{
    /**
     * 页面标题
     *
     * @var string
     */
    protected $page_title;

    /**
     * 导航目录
     *
     * 数组形式
     *   array(
     *   	'目录1',
     *   	array(
     *   		'innerHTML'=>'目录2',
     *   	),
     *   	array(
     *   		'innerHTML'=>'目录3',
     *   		'href' => 'url2',
     *   	),
     *   	'目录4',
     *   )
     *
     * @var array
     */
    protected $location;

    /**
     * 快速菜单
     *
     * array(
     *     'test/url1' => '测试菜单',
     *     'test/url12' => '测试菜单2',
     * )
     *
     * @var array
     */
    protected $quick_menu;

    /**
     * 检查是否登录
     */
    protected function check_login()
    {
        if ( TIME-1800>$this->session()->last_actived_time() || !$this->session()->member()->id>0 )
        {
            # 未登录或登录超时
            if ( Request::$is_ajax )
            {
                self::message('登录超时或未登录',-1);
            }
            else
            {
                $this->redirect(Core::url('login/?forward='.urlencode($_SERVER['REQUEST_URI'].($_SERVER['QUERY_STRING']?'?'.$_SERVER['QUERY_STRING']:''))));
            }
            exit;
        }
    }

    public function before()
    {
        $this->check_login();
        # 记录访问日志
        if ( Request::$method=='POST' )
        {
            Database::instance(Model_Admin::DATABASE)->insert( Core::config('admin/log.tablename'),
                array(
                    'uri' => $_SERVER["REQUEST_URI"],
                    'ip' => Request::$client_ip,
                	'type' => 'log',
                    'referer' => $_SERVER["HTTP_REFERER"],
                    'post' => serialize($_POST),
                    'admin_id' => $this->session()->member()->id,
                )
            );
        }

        # 不允许非超管跨项目访问
        if ( $this->session()->member()->project!=Core::$project && !$this->session()->member()->perm()->is_super_perm() )
        {
            self::message('通道受限，您不具备此项目的操作权限，请联系管理员',-1);
        }

        ob_start();
    }

    public function after()
    {
        $output = ob_get_clean();

        if ( !Request::$is_ajax )
        {
            $view = new View( 'admin/header' );
            $view->page_title = $this->page_title;
            $view->location = $this->location;
            $view->admin_menu = Core::config('admin/menu/'.$this->session()->member()->get_menu_config(),$this->project?$this->project:null);
            $view->quick_menu = $this->quick_menu;
            $view->render( true );
            echo $output;
            $view = new View( 'admin/bottom' );
            $view->render( true );
        }
        else
        {
            echo $output;
        }
    }

    public function message($msg,$code=0)
    {
        if ( Request::$is_ajax )
        {
            if ( is_array($msg) )
            {
                $data = $msg;
            }
            else
            {
                $data = array(
                    'code' => $code,
                    'msg' => (string)$msg,
                );
            }
            header('Content-Type:application/json');
            echo json_encode($data);
        }
        else
        {
            echo $msg;
        }
        $this->after();
        exit;
    }
}