<?php
/**
 * 登录，退出控制器
 *
 * @author jonwang
 *
 */
class Controller_MyQEE__Login extends Controller
{
    protected $message = '';

    protected $error_input;

    public function action_default()
    {
        $member = array(
            'message' => '',
            'input' => '',
        );
        $view = new View('admin/login');
        if (Request::$method=='POST')
        {
            $member = $this->post($_POST);
            if ( $member )
            {
                $member->last_login_ip = Request::$client_ip;
                $member->last_login_time = TIME;
                $member->value_increment('login_num');
                $member->update();
                # 开启session
                $this->session()->start();
                $this->session()->set_member($member);
                $url = $_POST['forward'] ? $_POST['forward'] : Core::url('/');

                $this->redirect( $url );
            }
            else
            {
                $view->shake = true;
            }
        }
        $view->message = $this->message;
        $view->error_input = $this->error_input;
        if ($_POST)
        {
            $view->username = $_POST['username'];
        }
        $view->render();
    }

    public function action_out()
    {
        $this->session()->start()->destroy();
        $this->redirect(Core::url('login/'));
    }

    /**
     * 处理提交
     *
     * @param array $data
     * @return Member 失败则返回false
     */
    protected function post($data)
    {
        if (!$data['username'])
        {
            $this->message = '用户名不能空';
            $this->error_input = 'username';
            return false;
        }
        if (!$data['password'])
        {
            $this->message = '密码不能空';
            $this->error_input = 'password';
            return false;
        }

        try {
            $member = Auth::instance('admin')->check_user($data['username'], $data['password']);
            $id = (int)$member->id;
            $_POST['password'] = '******';    //日志中隐藏密码项

            if ( $member->project!=Core::$project && !$member->perm()->is_super_perm() )
            {
                throw new Exception('不允许通过此页面登录');
            }

            if ( $member->shielded )
            {
                throw new Exception('您已被屏蔽', -1 );
            }
        }
        catch (Exception $e)
        {
            $this->message = $e->getMessage();
            $this->error_input = 'password';
            $id = 0;
            $member = false;
        }

        # 记录登录日志
        Database::instance(Model_Admin::DATABASE)->insert( Core::config('admin/log.tablename'),
            array(
                'uri' => $_SERVER["REQUEST_URI"],
                'type' => 'login',
                'ip' => Request::$client_ip,
                'referer' => $_SERVER["HTTP_REFERER"],
                'post' => serialize($_POST),
                'admin_id' => $id,
            )
        );
        return $member;
    }
}