<?php

/**
 * URL类
 *
 * @author jonwang(jonwang@myqee.com)
 * @category   MyQEE
 * @package    System
 * @subpackage Core
 * @copyright  Copyright (c) 2008-2011 myqee.com
 * @license    http://www.myqee.com/license.html
 */
class MyQEE_Core_Url
{

    public $url = '';

    public function __construct($url = '')
    {
        $this->url = $url;
    }

    /**
     * 获取站点URL
     */
    public function site($uri = '' , $index = 0 )
    {
        return $this->base($index) . ltrim($uri, '/');
    }

    /**
     * 获取当前页面前缀
     *
     * @param string $index
     * @return string
     */
    public function base( $index = 0 )
    {
        if ( strpos(Core::$project_config['url_admin'],'://') )
        {
            return rtrim(Core::$project_config['url_admin'], '/') . '/';
        }
        else if ( defined('IN_ADMIN') )
        {
            # 构造特殊的URL形式
            $project_url = Core::$project_url.Core::config('core.projects.'.INITIAL_PROJECT_NAME.'.url_admin').'p/'.Core::$project.'/';
            return rtrim($project_url, '/') . '/';
        }
        else
        {
            if ( is_array(Core::$project_config['url']) )
            {
                $project_url = Core::$project_config['url'][$index];
            }
            else
            {
                $project_url = (string)Core::$project_config['url'];
            }
            return rtrim($project_url, '/') . rtrim(Core::$project_config['url_admin'], '/') . '/';
        }
    }

    public function __toString()
    {
        return $this->site($this->url);
    }
}