<?php
/**
 * 超级管理员模块
 *
 * @author jonwang
 *
 */
class Model_MyQEE_Admin_Administrator extends Model_Admin
{
    /**
     * 管理员设置
     *
     * @var string
     */
    protected $config;

    protected $group_tablename;

    public function __construct()
    {
        $this->config = Core::config('admin/administrator');
        parent::__construct();
    }

    /**
     * 获取管理员数目
     */
    public function total_count($project = null , $only_list_my_group_user = false )
    {
        if ($project)
        {
            $this->db()->where('project',Core::$project);
        }
        if ( $only_list_my_group_user )
        {
            $this->db()->and_where_open();
            foreach ( Session::instance()->member()->group_ids as $group_id )
            {
                $this->db()->or_where('group_ids','%,'.$group_id.',%','like');
            }
            $this->db()->and_where_close();
        }
        return $this->db()->count_records( $this->config['tablename'] );
    }


    /**
     * 获取管理员列表数据
     *
     * @param int $offset
     * @param int $limit
     * @return ORM_Admin_Aministrator_Result
     */
    public function get_aministrator_list( $project = null  , $only_list_my_group_user = false , $offset = 0 , $limit = 20 )
    {
        $orm_member = new ORM_Admin_Member_Finder();

        if ( $project )
        {
            $orm_member->driver()->where('project',$project);
        }
        if ( $only_list_my_group_user )
        {
            $this->db()->and_where_open();
            foreach ( Session::instance()->member()->group_ids as $group_id )
            {
                $this->db()->or_where('group_ids','%,'.$group_id.',%','like');
            }
            $this->db()->and_where_close();
        }
        if ( $limit )
        {
            $orm_member->driver()->limit($limit)->offset($offset);
        }
        $orm_member->driver()->from($this->config['tablename'])->order_by('id','DESC');
        return $orm_member->find();
    }

    /**
     * 根据用户ID获取用户数据
     *
     * @param int $member_id
     * @return Member
     */
    public function get_by_id($member_id)
    {
        $orm_member = new ORM_Admin_Member_Finder();
        return $orm_member->get_by_id($member_id);
    }

    /**
     * 根据用户名获取用户对象
     *
     * @param string $username
     * @return Member
     */
    public function get_by_username( $username )
    {
        $orm_member = new ORM_Admin_Member_Finder();
        return $orm_member->where('username',$username)->find()->current();
    }

    /**
     * 获取管理员数目
     */
    public function total_group_count($project=null)
    {
        if ($project)
        {
            $this->db()->where('project',Core::$project);
        }
        return $this->db()->count_records( $this->config['group']['tablename'] );
    }

    /**
     * 获取管理组列表数据
     *
     * @param int $offset
     * @param int $limit
     * @return ORM_Admin_MemberGroup_Result
     */
    public function get_group_list( $project = null , $offset = 0 , $limit = 20)
    {
        $orm_group = new ORM_Admin_MemberGroup_Finder();

        if ($project)
        {
            $orm_group->driver()->where('project',$project);
        }
        if ( $limit )
        {
            $orm_group->driver()
            ->limit($limit)
            ->offset($offset);
        }

        $orm_group->driver()->from($this->config['group']['tablename'])->order_by('order','DESC');

        return $orm_group->find();
    }

}