<?php

/**
 * 超级管理员ORM
 *
 * @author jonwang
 *
 */
class ORM_MyQEE_Admin_Member_Finder extends OOP_ORM_Finder_DB
{
    protected $database = Model_Admin::DATABASE;

    protected $tablename = 'admin_member';
}

/**
 * 超级管理员ORM查询结果集
 *
 * @author jonwang
 *
 */
class ORM_MyQEE_Admin_Member_Result extends OOP_ORM_Result
{

}


/**
 * 超管用户基础类
 *
 * @author	   jonwang(jonwang@myqee.com)
 * @category   MyQEE
 * @package	   System
 * @subpackage Core
 * @copyright  Copyright (c) 2008-2011 myqee.com
 * @license	   http://www.myqee.com/license.html
 */
class ORM_MyQEE_Admin_Member_Data extends OOP_ORM_Data
{
    /**
     * 权限对象
     *
     * @var Permission
     */
    protected $_permission;
    /**
     * 用户ID
     *
     * @var int
     */
    public $id = array(
        'field_name' => 'id',
        'is_id_field' => true,
    );

    /**
     * 用户名
     *
     * @var string
     */
    public $username;

    /**
     * 昵称
     *
     * @var string
     */
    public $nickname;

    /**
     * 当前用户密码（通常都是加密后的内容）
     *
     * @var string
     */
    public $password;

    /**
     * 所属项目
     *
     * @var string
     */
    public $project;

    /**
     * 用户自定义权限
     *
     * 请使用$this->perm()方法获取对象
     *
     * @var array
     */
    public $perm_setting = array(
        'field_name' => 'perm_setting',
        'format' => array(
            'serialize',
        ),
    );

    /**
     * 最后登录时间
     *
     * @var int
     */
    public $last_login_time;

    /**
     * 最后登录IP
     *
     * @var string
     */
    public $last_login_ip;

    /**
     * 登录数
     *
     * @var int
     */
    public $login_num;

    /**
     * 快速便签
     *
     * @var string
     */
    public $notepad;

    /**
     * 是否已被屏蔽
     *
     * @var int
     */
    public $shielded;

    /**
     * 管理组ID
     *
     * @var array
     */
    public $group_ids = array(
        'field_name' => 'group_ids',
        'format' => array(
            array('implode',',',true),
        ),
    );

    /**
     * 管理组ID
     *
     * @var int
     */
    public $default_group_id = 'group_ids[0]';

    /**
     * 管理组
     *
     * @var ORM_Admin_MemberGroup_Data
     */
    public $default_group = array(
        'is_virtual_field' => true,
        'orm' => array(
            'name' => 'Admin_MemberGroup',
            'return' => OOP_ORM::PARAM_RETURN_SINGLE,
            'mapping' => array(
                'id' => 'default_group_id',
            ),
        ),
    );

    /**
     * 所属平台ID
     *
     * @var int
     */
    public $channel_id;

    /**
     * 所属于平台
     *
     * @var ORM_Channel_Data
     */
    public $channel = array(
        'is_virtual_field' => true,
        'orm' => array(
            'name' => 'Channel',
            'return' => OOP_ORM::PARAM_RETURN_SINGLE,
            'mapping' => array(
                'id' => 'channel_id',
            ),
        ),
    );

    /**
     * 返回所有组的对象集
     * @return ORM_Admin_MemberGroup_Result
     */
    public function all_groups()
    {
        $orm_group = new ORM_Admin_MemberGroup_Finder();
        if (!$this->group_ids)
        {
            return $orm_group->create_group_data(array());
        }
        $orm_group->in('id', $this->group_ids);
        return $orm_group->find();
    }

    /**
     * 检查密码是否正确
     *
     * @param string $password
     */
    public function check_password( $password )
    {
        if ( $this->_get_password_hash($password) == $this->password )
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    /**
     * 获取一个新的密码hash值
     *
     * @param string $password
     * @return string
     */
    protected function _get_password_hash( $password )
    {
        return md5($this->username . '|@(3+(#*@Dh_' . $password);
    }

    /**
     * 修改密码
     *
     * @param string $new_password
     * @return array 失败返回false
     */
    public function change_password( $new_password )
    {
        $this->password = $this->_get_password_hash($new_password);
        return $this->update();
    }

    /**
     * 返回用户权限对象
     *
     * @return Permission
     */
    public function perm()
    {
        if ( null===$this->_permission )
        {
            $perm_setting = $this->perm_setting;
            $groups = $this->all_groups();
            if ($groups->count())
            {
                foreach ( $groups as $group )
                {
                    # 合并权限
                    $perm_setting = self::_merge_permission($perm_setting,$group->perm_setting);
                }
            }

            $this->_permission = new Permission($perm_setting);
        }

        return $this->_permission;
    }

    /**
     * 获取当前用户后台菜单配置
     *
     * @return string
     */
    public function get_menu_config()
    {
        $config = $this->default_group->setting['menu_config'];
        return $config?$config:'default';
    }

    /**
     * 合并权限
     *
     * @return array
     */
    protected function _merge_permission( $arr1 , $arr2 )
    {
        if (!is_array($arr1))$arr1 = array();
        if ( !$arr2 || !is_array($arr2) )return $arr1;

        foreach ( $arr2 as $k=>$v )
        {
            if ( is_array($v) )
            {
                $arr1[$k] = self::_merge_permission($arr1[$k],$v);
            }
            else
            {
                $arr1[$k] = $v?true:false;
            }
        }

        return $arr1;
    }
}