<?php

/**
 * 超级管理员ORM
 *
 * @author jonwang
 *
 */
class ORM_MyQEE_Admin_MemberGroup_Finder extends OOP_ORM_Finder_DB
{
    protected $database = Model_Admin::DATABASE;

    protected $tablename = 'admin_member_group';

}

/**
 * 超级管理员ORM查询结果集
 *
 * @author jonwang
 *
 */
class ORM_MyQEE_Admin_MemberGroup_Result extends OOP_ORM_Result
{

}

/**
 * 超级管理员ORM数据
 *
 * @author jonwang
 *
 */
class ORM_MyQEE_Admin_MemberGroup_Data extends OOP_ORM_Data
{
    /**
     * 权限对象
     *
     * @var Permission
     */
    protected $_permission;

    public $id = array(
        'is_id_field' => true,
    );

    /**
     * 组名称
     *
     * @var string
     */
    public $group_name;

    /**
     * 组说明
     *
     * @var string
     */
    public $group_desc;

    /**
     * 排序
     *
     * @var int
     */
    public $order;

    /**
     * 所属项目
     *
     * @var string
     */
    public $project = array(
        'field_name' => 'project',
        'is_readonly' => true,
    );

    /**
     * 权限对象
     *
     * @var Permission
     */
    public $perm_setting = array(
        'field_name' => 'perm_setting',
        'format' => array(
            'serialize',
        ),
    );

    /**
     * 组设置
     *
     * @var array
     */
    public $setting = array(
        'format' => array(
            'serialize',
        ),
    );

    /**
     * 创建时间
     *
     * @var string
     */
    public $created_time;

    /**
     * 返回用户权限对象
     *
     * @return Permission
     */
    public function perm()
    {
        if ( null===$this->_permission )
        {

            $this->_permission = new Permission($this->perm_setting);
        }

        return $this->_permission;
    }

    /**
     * 返回该群组所有用户对象
     *
     * @return ORM_Member_Result
     */
    public function members()
    {
        $orm_member = new ORM_Admin_Member_Finder();
        $orm_member->driver()->like('group_ids','%,'.$this->id.',%');
        return $orm_member->find();
    }
}
