<?php
/*
思维网络PHP分页类。
版本:1.3 for utf-8
Code By 陶之11
OICQ:14779023
Email:vip@samxy.com
WebSite:http://www.Samxy.com
本程序属本人原创,如果您要使用或在此基础上进行修改,请保留原创信息
谢谢您的使用.欢迎您有任何好的建议或意见请随时聊系我.

使用方法-->
require_once SWCMS_ROOT.'./include/page.class.php';
$sql = "SELECT * FROM table  ORDER BY id DESC"; //SQL查询语句.
$px = new Pagex();
$px->total = $db->num_rows($db->query($sql));
$query = $db->query($sql." LIMIT {$px->thispage},{$px->pagesize}");

echo $px->pageshow('default');
*/
class Pagex{
        public $total;    //记录总数
        public $pagename; //分页URL参数名称default:p;
        public $pagesize; //每页记录数default:10        
        public $pagelist; //显示数字页数default:0
        public $pageurl;  //链接URL
        public $pagetext; //显示分页相关信息
        public $thispage;
        
        //初始化函数
        function __construct($pagesize=10,$pagelist=0,$pagetext=true,$pagename='p'){
          $this->total = intval($total);
          $this->pagesize = $pagesize;
          $this->pagename = $pagename;          
          $this->pagelist = $pagelist;          
          $this->pagetext = $pagetext;     
          $this->thispage = ($this->currpage()-1)*$this->pagesize;
         //URL处理===================================
           if(!$this->pageurl){$this->pageurl=$_SERVER["REQUEST_URI"];}
           $parse_url=parse_url($this->pageurl);
           $url_query=$parse_url["query"]; 
             if($url_query){
             $url_query=ereg_replace("(^|&){$this->pagename}={$this->currpage()}","",$url_query);
             $this->pageurl=str_replace($parse_url["query"],$url_query,$this->pageurl);
               if($url_query) $this->pageurl.="&amp;".$this->pagename; else $this->pageurl.=$this->pagename;
             }else {
               $this->pageurl.="?".$this->pagename;
             }
         //URL处理结束=================================    
        }
        

       
        //获取当前页码
        function currpage(){
         $getpage = (@$_REQUEST[$this->pagename] + 0 <= 0)? 1: (@$_REQUEST[$this->pagename] + 0);
          if (!is_int($getpage)) {
              $getpage = 1;           
          }    
          return $getpage;       
        }
        //获取当前页码
        
        
        
        /*计算页数================================*/
        //最后一页
        function lastpage(){
             
            return intval((floor($this->total/$this->pagesize) == ceil($this->total/$this->pagesize))?floor($this->total/$this->pagesize):ceil($this->total/$this->pagesize));
          //return ceil($this->total/$this->pagesize); 
        }        
        //上一页
        function prevpage(){
          return $this->currpage()-1;
        }
        //下一页
        function nextpage(){
          return ($this->currpage()==$this->lastpage() || $this->lastpage()<1 ? 0 :$this->currpage()+1);
          //if ($this->currpage()==$this->lastpage())
        }
        /*计算结束================================*/
        
        //数字分页按扭
        function numberhtml($page){
           if($this->currpage()==$page){
            return "<span>[".$page."]</span>";
           }else{
            return "<span>"."<a class=\"pnum\" title=\"".$page."\" href=\"".$this->pageurl."=".$page."\">[".$page."]</a>"."</span>";
           }
        }
        
        
        //计算生成数字分页导航条
        function pagelist(){
              if($this->pagelist>0){
                  $listhtml.= '';
                      if ($this->pagelist >= $this->lastpage()) {            
                          for ($i = 1; $i <= $this->lastpage(); $i++) {
                              $listhtml .= $this->numberhtml($i);
                          }
                      } else {
                          $ceilpage = ceil($this->pagelist/2);                       
                          if ($this->currPage() <= $ceilpage) {                
                              for ($i = 1; $i <= $this->pagelist; $i++) {
                                  $listhtml .= $this->numberhtml($i);
                              }
                          } else {
                              if ($this->currPage()+$ceilpage <= $this->lastpage()) {
                                  for($i=$this->currPage()-$ceilpage+1;$i<=$this->currPage()+$ceilpage;$i++){
                                      $listhtml .= $this->numberhtml($i);
                                  }
                              } else {
                                  for ($i = $this->lastpage()-$this->pagelist+1; $i <=$this->lastpage(); $i++) {
                                      $listhtml .= $this->numberhtml($i);
                                  }
                              }
                          }
                      }
                  $listhtml.= "";
                
                 return $listhtml;
                 
              }else{              
                return "&nbsp;";
              }
        }
        
        
        
//显示分页模块        
        function pageshow($pagetype){
          $pagehtml = '';
          
          $homelink = $this->pageurl."=1";
          $prevlink = $this->pageurl."=".$this->prevpage();
          $nextlink = $this->pageurl."=".$this->nextpage();
          $lastlink = $this->pageurl."=".$this->lastpage();

           switch($pagetype){              
                case "wap"://WAP分页系统。
                   if($this->prevpage()) {
                    $pagehtml.="<a href=\"".$homelink."\">首页</a>";
                    $pagehtml.="<a href=\"".$prevlink."\">上页</a>";                   
                   }                                 
                   if($this->nextpage()) {
                    $pagehtml.="<a href=\"".$nextlink."\">下页</a>";
                    $pagehtml.="<a href=\"".$lastlink."\">尾页</a>";
                   }
                   
                   if($this->total>=$this->pagesize){                   
                   $pagehtml.= "<br/>[第".$this->currpage()."/".$this->lastpage()."页|总".$this->total."条]<br/>";
                   $pagehtml.="<input name=\"p\" type=\"text\" maxlength=\"5\" size=\"1\" value=\"1\" emptyok=\"true\" />";
                   $pagehtml.="<anchor title=\"跳到\">跳到该页<go href=\"".$this->pageurl."=$(p)\" method=\"post\">";
                   $pagehtml.="<postfield name=\"p\" value=\"$(p)\" />";
                   $pagehtml.="</go></anchor>";
                   }
                break;
                
                case "style": //带样式化分页
                    $pagehtml.="<div class=\"px\">";
                  if($this->pagetext){
                    $pagehtml.="<span class=\"total\">总共".$this->total."记录</span>";
                   }
                   if($this->prevpage()) {
                    $pagehtml.="<span class=\"link\"><a href=\"".$homelink."\">首页</a></span>";
                    $pagehtml.="<span class=\"link\"><a href=\"".$prevlink."\">上一页</a></span>";
                   }else{
                    $pagehtml.="<span class=\"text\">首页</span>";
                    $pagehtml.="<span class=\"text\">上一页</span>";
                   }
                    
                    $pagehtml.=$this->pagelist();//数字分页导航条
                            
                   if($this->nextpage()) {
                    $pagehtml.="<span class=\"link\"><a href=\"".$nextlink."\">下一页</a></span>";
                    $pagehtml.="<span class=\"link\"><a href=\"".$lastlink."\">尾页</a></span>";
                   }else{
                    $pagehtml.="<span class=\"text\">下一页</span>";
                    $pagehtml.="<span class=\"text\">尾页</span>";
                   }
                  if($this->pagetext){
                    $pagehtml.="<span class=\"pages\">当前".$this->currpage()."/".$this->lastpage()."分页</span>";
                   }  
                    $pagehtml.="</div>";
                break;
         
                default://默认分页形式。
                  if($this->pagetext){
                    $pagehtml.="总共".$this->total."记录";
                   }
                    $pagehtml.= "&nbsp;";
                   if($this->prevpage()) {
                    $pagehtml.="<a href=\"".$homelink."\">首页</a>";
                    $pagehtml.= "&nbsp;";
                    $pagehtml.="<a href=\"".$prevlink."\">上一页</a>";
                   }else{
                    $pagehtml.="首页";
                    $pagehtml.= "&nbsp;";
                    $pagehtml.="上一页";
                   }
                    
                    $pagehtml.=$this->pagelist();//数字分页导航条
                            
                   if($this->nextpage()) {
                    $pagehtml.="<a href=\"".$nextlink."\">下一页</a>";
                    $pagehtml.= "&nbsp;";
                    $pagehtml.="<a href=\"".$lastlink."\">尾页</a>";
                   }else{
                    $pagehtml.="下一页";
                    $pagehtml.= "&nbsp;";
                    $pagehtml.="尾页";
                   }
                  if($this->pagetext){
                    $pagehtml.= "&nbsp;";
                    $pagehtml.="当前".$this->currpage()."/".$this->lastpage()."总页";
                   }                   
           }                   
         return $pagehtml;     
        }
//显示页面结束              
}
?>