$(function() {
	var O_Type = $("#O_Type");
	var mainlist = $("#mainlist");
	var O_TopFont = $("#topFont");
	var O_AreaDrop = O_TopFont.find("#areaDrop");
	var O_HotelDrop = O_TopFont.find("#hotelDrop");
	var O_SimpleSearchBtn = $("#O_SimpleSearchBtn");
	var O_Flush = $("#O_Flush");
	O_Flush.hide();
	mainlist.find(".page").click(function() {
		mainlist.find("#loading").show();
		pageClick(this);
	});
	//点击区域筛选下拉列
	O_AreaDrop.change(function() {
		O_Flush.show();
		var areaId = O_AreaDrop.val();
		if(areaId == ""){
			O_Type.val("list");
			$.post("?m=admin/ktv.getList", { pageSize:0, json:true }, function(data) {//alert(data);
				O_HotelDrop.empty();
				O_HotelDrop.append("<option value=\"\">==酒店==</option>");
				$.each(data, function(id, item) {
					O_HotelDrop.append("<option value=\"" + item.id + "\">" + item.name + "</option>");
				});
			}, "json");
			$.post("?m=admin/ktv_room.getList", { pageSize:0 }, function(data) {
				mainlist.html(data);
				mainlist.find(".page").click(function() {
					mainlist.find("#loading").show();
					pageClick(this);
				});
				O_Flush.hide();
			});
		} else {
			O_Type.val("byarea");
			$.post("?m=admin/ktv.getListByArea", { areaId:areaId, pageSize:0, json:true }, function(data) {//alert(data);
				O_HotelDrop.empty();
				O_HotelDrop.append("<option value=\"\">==酒店==</option>");
				$.each(data, function(id, item) {
					O_HotelDrop.append("<option value=\"" + item.id + "\">" + item.name + "</option>");
				});
			}, "json");
			$.post("?m=admin/ktv_room.getListByArea", { areaId:areaId, pageSize:0 }, function(data) {
				mainlist.html(data);
				mainlist.find(".page").click(function() {
					mainlist.find("#loading").show();
					pageClick(this);
				});
				O_Flush.hide();
			});
		}
	});
	//点击酒店筛选下拉列
	O_HotelDrop.change(function() {
		O_Flush.show();
		var hotelId = O_HotelDrop.val();
		if(hotelId == ""){
			O_Type.val("list");
			$.post("?m=admin/ktv_room.getList", { pageSize:0 }, function(data) {
				mainlist.html(data);
				mainlist.find(".page").click(function() {
					mainlist.find("#loading").show();
					pageClick(this);
				});
				O_Flush.hide();
			});
		} else {
			O_Type.val("byhotel");
			$.post("?m=admin/ktv_room.getListByHotel", { hotelId:hotelId, pageSize:0 }, function(data) {
				mainlist.html(data);
				mainlist.find(".page").click(function() {
					mainlist.find("#loading").show();
					pageClick(this);
				});
				O_Flush.hide();
			});
		}
	});
	//点击快捷搜索按钮
	O_SimpleSearchBtn.click(function() {
		var v_field = $("#simpleSearch").val();
		var O_Key = $("#simpleSearchKey");
		var v_key = O_Key.val().replace(/ /g, '').replace(/'/g, '');
		//设置列表类型
		if(v_key == ""){ O_Type.val("list"); }
		else { O_Type.val("simplesearch"); }
		O_Flush.show();
		$.post("?m=admin/ktv_room.simpleSearch", { field:v_field, key:v_key }, function(data) {
			mainlist.html(data);
			mainlist.find(".page").click(function() {
				mainlist.find("#loading").show();
				pageClick(this);
			});
			O_Flush.hide();
		});
	});
	getCount();
});
//点击状态按钮
function statusClick(v_status) {
	var mainlist = $("#mainlist");
	var O_Flush = $("#O_Flush");
	//设置列表类型
	$("#O_Type").val("bystatus");
	$("#currentStatus").val(v_status);
	O_Flush.show();
	$.post("?m=admin/ktv_room.getListByStatus", { status:v_status }, function(data) {
		mainlist.html(data);
		mainlist.find(".page").click(function() {
			mainlist.find("#loading").show();
			pageClick(this);
		});
		O_Flush.hide();
	});
}
//加载列表
function loadList(page, linehighId) {
	var mainlist = $("#mainlist");
	var v_type = $("#O_Type").val();
	var O_Flush = $("#O_Flush");
	O_Flush.show();
	if(v_type == "list"){
		$.post("?m=admin/ktv_room.getList", { page:page }, function(data) {
			mainlist.html(data);
			mainlist.find(".page").click(function() {
				mainlist.find("#loading").show();
				pageClick(this);
			});
			if(linehighId) {
				mainlist.find("#O_Row_" + linehighId).addClass("on");//高亮行
			}
			O_Flush.hide();
		});
	} else if(v_type == "simplesearch") {
		var v_field = $("#simpleSearch").val();
		var O_Key = $("#simpleSearchKey");
		var v_key = O_Key.val().replace(/ /g, '').replace(/'/g, '');
		$.post("?m=admin/ktv_room.simpleSearch", { field:v_field, key:v_key, page:page }, function(data) {
			mainlist.html(data);
			mainlist.find(".page").click(function() {
				mainlist.find("#loading").show();
				pageClick(this);
			});
			if(linehighId) {
				mainlist.find("#O_Row_" + linehighId).addClass("on");//高亮行
			}
			O_Flush.hide();
		});
	} else if(v_type == "bystatus") {
		var v_status = $("#currentStatus").val();
		$.post("?m=admin/ktv_room.getListByStatus", { status:v_status, page:page }, function(data) {
			mainlist.html(data);
			mainlist.find(".page").click(function() {
				mainlist.find("#loading").show();
				pageClick(this);
			});
			if(linehighId) {
				mainlist.find("#O_Row_" + linehighId).addClass("on");//高亮行
			}
			O_Flush.hide();
		});
	} else if(v_type == "byarea") {
		var areaId = $("#topFont").find("#areaDrop").val();
		$.post("?m=admin/ktv_room.getListByArea", { areaId:areaId, page:page }, function(data) {
			mainlist.html(data);
			mainlist.find(".page").click(function() {
				mainlist.find("#loading").show();
				pageClick(this);
			});
			if(linehighId) {
				mainlist.find("#O_Row_" + linehighId).addClass("on");//高亮行
			}
			O_Flush.hide();
		});
	} else if(v_type == "byhotel") {
		var hotelId = $("#topFont").find("#hotelDrop").val();
		$.post("?m=admin/ktv_room.getListByHotel", { hotelId:hotelId, page:page }, function(data) {
			mainlist.html(data);
			mainlist.find(".page").click(function() {
				mainlist.find("#loading").show();
				pageClick(this);
			});
			if(linehighId) {
				mainlist.find("#O_Row_" + linehighId).addClass("on");//高亮行
			}
			O_Flush.hide();
		});
	}
}
//分页点击
function pageClick(t) {
	loadList(t.id);
}
//首页
function firstPage() {
	var O_FirstPage = document.createElement("span");
	O_FirstPage.id = "1";
	$("#loading").show();
	pageClick(O_FirstPage);
}
//上一页
function prevPage() {
	var prevPage = parseInt($("#O_CurrentPage").val()) - 1;
	var O_PrevPage = $("#" + prevPage.toString());
	O_PrevPage.triggerHandler("click");
}
//下一页
function nextPage() {
	var nextPage = parseInt($("#O_CurrentPage").val()) + 1;
	var O_NextPage = $("#" + nextPage.toString());
	O_NextPage.triggerHandler("click");
}
//尾页
function lastPage() {
	var pageCount = parseInt($("#O_PageCount").val());
	var O_LastPage = document.createElement("span");
	O_LastPage.id = pageCount.toString();
	$("#loading").show();
	pageClick(O_LastPage);
}
//跳转到下拉列
function goPage() {
	var O_Page = $("#O_Page");
	var O_Go = $("#O_Go");
	var O_GoPage  = document.createElement("span");
	O_GoPage.id = O_Page.val();
	$("#loading").show();
	pageClick(O_GoPage);
}
//浏览
function viewClick(t) {
	$("#divView h1 span").html("客房信息浏览");
	var O_Content = $("#contentView");
	O_Content.html('<div style="width:580px;height:200px;_height:300px;font-size:14px;text-align:center;"><span style="margin-top:120px;margin-bottom:15px;">正在加载...</span><img src="theme/admin/images/loading.gif"></div>');
	setView();
	var id = t.id.replace(/o_/g, '');
	highLightRow(id);//高亮行
	$.post("?m=admin/ktv_room.info", { id:id }, function(data) {//alert(data);
		O_Content.html(data);
		setView();
	});
	//启动浏览模式
	openView();
}
//状态更新
function updateStatusClick(t) {
	var page = $("#O_CurrentPage").val();
	var id = t.id.replace(/o_/g, '');
	highLightRow(id);//高亮行
	$.post("?m=admin/ktv_room.updateStatusHandle", { id:id }, function(data) {//alert(data);
		if(data[0] == "success") {
			//刷新列表
			loadList(page, id);
			//刷新统计
			getCount();
		} else {
			alert(data[1]);
		}
	}, "json");
}
//信息更新
function updateClick(t) {

	
	$("#divUpdate h1 span").html("服务设施添加");
	var O_Content = $("#contentUpdate");
	O_Content.html('<div style="width:580px;height:200px;_height:300px;font-size:14px;text-align:center;"><div style="margin-top:120px;margin-bottom:15px;">正在加载...</div><img src="theme/admin/images/loading.gif"></div>');
	setUpdate();
	var id = t.id.replace(/o_/g, '');
	highLightRow(id);//高亮行
	
	
	$.post("?m=admin/ktv.update_server", { id:id }, function(data) {//alert(data);
		O_Content.html(data);
		setUpdate();
		$("#O_SumbitUpdate").attr("disabled", false).unbind("click").click(function() { update(); });
	});
	//启动浏览模式
	openUpdate();
}

//信息添加
function addClick() {

	
	$("#divUpdate h1 span").html("服务设施添加");
	var O_Content = $("#contentUpdate");
	O_Content.html('<div style="width:580px;height:200px;_height:300px;font-size:14px;text-align:center;"><div style="margin-top:120px;margin-bottom:15px;">正在加载...</div><img src="theme/admin/images/loading.gif"></div>');
	setUpdate();
	/*var id = t.id.replace(/o_/g, '');
	highLightRow(id);//高亮行*/
	$.post("?m=admin/ktv.update_server", {}, function(data) {//alert(data);
		O_Content.html(data);
		setUpdate();
		$("#O_SumbitUpdate").attr("disabled", false).unbind("click").click(function() { add_server(); });
	});
	//启动浏览模式
	openUpdate();
}
//删除
function delClick(t) {
	

	if(confirm("删除所选设施，确认？")) { 
		
		var arrChk = $(":input[class='delAll']:checked");  
        var v_ids = "";  
        for(var i = 0; i < arrChk.length; i++){ 
            v_ids += arrChk[i].value;
            if(i < arrChk.length - 1) { v_ids += ","; }
        }
		
		

		$.post("?m=admin/ktv.del_ktv_server", { id:v_ids , array : true }, function(data) {
		
			location.reload() ;
			return;
		
		}, "json");
		return true;
	}
	return false;
}
//全选删除
function checkDelAll() {
	$(".delAll").attr("checked", $("#o_delall").attr("checked"));
}
//批量删除
function delSelectClick() {
	if(confirm("删除所选时段，确认？")) { 
		//遍历得到每个checkbox的value值
        var arrChk = $(":input[class='delAll']:checked");  
        var v_ids = "";  
        for(var i = 0; i < arrChk.length; i++){ 
            v_ids += arrChk[i].value;
            if(i < arrChk.length - 1) { v_ids += ","; }
        }
		$.post("?m=admin/ktv_room.deltimes_SelectHandle", { ids:v_ids }, function(data) {
			//刷新列表
			
			location.reload() ;
			/*
			var page = $("#O_CurrentPage").val();
			loadList(page);
			//刷新统计
			getCount();*/
		});
		return true;
	}
	return false;
}
//获取统计
function getCount() {
	$.post("?m=admin/ktv.getServiceCount", {}, function(data) {
		var str = "共 <span class=\"f_14b_f00\">" + data.all + "</span> 个, 已审核 <span class=\"f_14b_f00\">" + data.check + "</span> 个, 待审核 <span class=\"f_14b_f00\">" + data.wait + "</span> 个, 已停用 <span class=\"f_14b_f00\">" + data.stop + "</span> 个";
		$("#O_Count").html(str);
		$("#O_Flush").hide();
	}, "json");
}
//高亮行
function highLightRow(id) {
	$(".row").removeClass("on");
	$("#O_Row_" + id).addClass("on");
}
//获取窗体区域
function getRange() {//得到屏幕的大小
    var top = document.body.scrollTop;
    var left = document.body.scrollLeft;
    var height = document.body.clientHeight;
    var width = document.body.clientWidth;
    if (top == 0 && left == 0 && height == 0 && width == 0) {
        top = document.documentElement.scrollTop;
        left = document.documentElement.scrollLeft;
        height = document.documentElement.clientHeight;
        width = document.documentElement.clientWidth;
    }
    return { top: top, left: left, height: height, width: width };
}
//处理
function update() {
	
	var O_Name = $("#O_Name");
	var O_Status = $("#O_Status");
	var O_ID = $("#O_ID");
	
	var v_name = O_Name.val();
	var v_id = O_ID.val();

	
	if(v_name == "") {
		alert("请填写服务设施名称");
		O_Name.focus();
		return;
	}
	
	var v_status = '已审核';
	
	if(O_Status.attr('checked') == 'checked')
	{
		v_status = '待审核';	
	}
	
$.post("?m=admin/ktv.update_ktv_server", { name:v_name ,status:v_status, id:v_id}, function(data) {
				location.reload();
	
		});
	

}


function add_server() {
	
	var O_Name = $("#O_Name");
	var O_Status = $("#O_Status");
	
	var v_name = O_Name.val();

	

	
	if(v_name == "") {
		alert("请填写服务设施名称");
		O_Name.focus();
		return;
	}
	
	var v_status = '已审核';
	
	if(O_Status.attr('checked') == 'checked')
	{
		v_status = '待审核';	
	}
	
	
	$.post("?m=admin/ktv.add_server", { name:v_name , status:v_status}, function(data) {
		location.reload();
	});
	

}