$(function() {
	var basePath = $($("body")[0]).attr("base");
	var O_Account = $("#O_Account");//帐号
	var O_Account_Status = $("#O_Account_Status");//帐号是否可注状态(辅助用)
	var O_AccountValue = $("#O_AccountValue");//帐号值(辅助用)
	var $closeBtn = $("#closeReg");//关闭按钮
	//获取所有具有required的textbox控件
	var $requiredTexts = $("#regform input.required");
	O_Account.focus();
	
	//清空所有内容
	$requiredTexts.each(function() {
		clearText($(this));
	});
	
	$("#regform input").blur(function() {//添加失焦点事件
		var $thisNode = $(this);
		var $oldAccountStatus = $("#O_Account_Span").html();
		var $parent = $thisNode.parent();
		//检验用户名
		if($thisNode.is("#O_Account")) {
			var v_account = this.value.replace(/ /g, '').replace(/'/g, '');
			$thisNode.val(v_account);
			
			if(v_account == "" || v_account.length < 5) {
				//更新帐号值
				O_AccountValue.val(v_account);
				updateSpan($parent, "onError", "请输入至少5位的用户名");
				O_Account_Status.val("Error");
			} else {
				if(O_AccountValue.val() != v_account) {
					//更新帐号值
					O_AccountValue.val(v_account);
					//判断是否需提交远程
					$.post(basePath + "?m=login.checkAccount", { account:v_account }, function(data) {//alert(data);
						if(data[0] == "success") {
							updateSpan($parent, "onSuccess", data[1]);
							O_Account_Status.val("Success");
						} else {
							updateSpan($parent, "onError", data[1]);
							O_Account_Status.val("Error");
						}
					}, "json");
				} else {
					updateSpan($parent, $("O_Account_Status").val(), $oldAccountStatus);
				}
			}
		}
		//检验登录密码
		if($thisNode.is("#O_Psd")) {
			var v_psd = this.value.replace(/ /g, '').replace(/'/g, '');
			$thisNode.val(v_psd);
			if(v_psd == "") {
				updateSpan($parent, "onError", "密码不能为空");
			} else {
				updateSpan($parent, "onSuccess", "输入正确");
			}
		}
		//重复登录密码
		if($thisNode.is("#O_RePsd")) {
			var v_psd = $("#O_Psd").val().replace(/ /g, '').replace(/'/g, '');
			var v_repsd = this.value;
			if(v_repsd == "") {
				updateSpan($parent, "onError", "重复密码不能为空");
			} else if(v_psd != v_repsd) {
				updateSpan($parent, "onError", "两次输入密码不一致");
			} else {
				updateSpan($parent, "onSuccess", "输入正确");
			}
		}
		//检验姓名
		if($thisNode.is("#O_Name")) {
			var v_name = this.value.replace(/ /g, '').replace(/'/g, '');
			$thisNode.val(v_name);
			if(v_name == "") {
				updateSpan($parent, "onError", "请输入您的姓名，方便我们与您联系");
			} else {
				updateSpan($parent, "onSuccess", "输入正确");
			}
		}
		//检验手机
		if($thisNode.is("#O_Phone")) {
			var v_phone = this.value.replace(/ /g, '').replace(/'/g, '');
			$thisNode.val(v_phone);
			if(v_phone == "") {
				updateSpan($parent, "onError", "请输入您的手机号，方便我们与您联系");
			} else {
				if(v_phone != "" && !/^(13|15|18)\d{9}$/.test(v_phone)){
					updateSpan($parent, "onError", "请输入正确的手机号码！");
				} else {
					updateSpan($parent, "onSuccess", "输入正确");
				}
			}
		}
		//检验邮箱
		if($thisNode.is("#O_Email")) {
			var v_email = this.value.replace(/ /g, '').replace(/'/g, '');
			$thisNode.val(v_email);
			if(v_email == "") {
				updateSpan($parent, "onSuccess", "");
			} else { 
				if(v_email != "" && !/.+@.+\.[a-zA-Z]{2,4}$/.test(v_email)) {
					updateSpan($parent, "onError", "请输入正确的Email地址");
				} else {
					updateSpan($parent, "onSuccess", "输入正确");
				}
			}
		}
	}).keyup(function() {//键盘输入更改
		$(this).triggerHandler("blur");
	}).focus(function() {//获得焦点事件
		$(this).triggerHandler("blur");
	});
	var regBtn = $("#reg_submit");
	regBtn.click(function() {
		//触发所有需验证控件的检验事件
		$requiredTexts.trigger("blur");
		//将报错打印
		var $errSpan = $("#regform .onError");
		var numError = $errSpan.length;
		//获取焦点
		if(O_Account_Status.val() == "Error") {
			O_Account.focus();
		} else {
			var i = 1;
			$errSpan.each(function(){
				if(i == 1) { $(this).parent().find("input").focus(); }
				i++;
			});
		}
		if(numError) {
			return false;
		} else {
			var v_account = $("#O_Account").val().replace(/ /g, '').replace(/'/g, '');
			var v_psd = $("#O_Psd").val().replace(/ /g, '').replace(/'/g, '');
			var v_name = $("#O_Name").val().replace(/ /g, '').replace(/'/g, '');
			var v_phone = $("#O_Phone").val().replace(/ /g, '').replace(/'/g, '');
			var v_email = $("#O_Email").val().replace(/ /g, '').replace(/'/g, '');
			$.post(basePath + "?m=login.register", { account:v_account, password:v_psd, name:v_name, mobile:v_phone, email:v_email }, function(data) {//alert(data);
				if(data[0] == "success") {
					$.post(basePath + "?m=login.check", { account:v_account, password:v_psd }, function(data) {//alert(data);
						if(data[0] == "success") {
							var url = document.getElementById("O_LoginSuccessUrl") != null ? document.getElementById("O_LoginSuccessUrl").value : "";
							if(url.length > 0) { window.location = url; }
							else { window.location.reload(); }
						} else{ window.location.reload(); }
					});
				} else {
					O_Account.focus();
					if(data[2] == "account is exists") {
						updateSpan(O_Account.parent(), "onError", data[1]);
						O_Account_Status.val("Error");
					}
				}
			}, "json");
		}
		return false;
	});
	
	//关闭窗口
	$closeBtn.click(function(){
		//清空所有内容
		$requiredTexts.each(function(){
			clearText($(this));
		});
		$("#doing").hide();
		$("#divReg").hide();
		$("#divRegF").hide();
	});
	
	$divReg=$("#divReg");
	$divRegF=$("#divRegF");
	var windowObj = $(window);//获取window对象
	var browserWidth = windowObj.width();//获取当前浏览器长度
	var browserHeight = windowObj.height();//获取当前浏览器宽度
	var scrollLeft = windowObj.scrollLeft();
	var scrollTop = windowObj.scrollTop();
	var cwinWidth = $divReg.width();
	var cwinHeight = $divReg.height();
	var left = scrollLeft + (browserWidth - cwinWidth) / 2;
	var top = scrollTop + (browserHeight -cwinHeight) / 2;
	$divReg.css("top",top).css("left",left);
	$divRegF.css("top",top).css("left",left);
	$(window).scroll(function(){
		var windowObj = $(window);//获取window对象
		var browserWidth = windowObj.width();//获取当前浏览器长度
		var browserHeight = windowObj.height();//获取当前浏览器宽度
		var scrollLeft = windowObj.scrollLeft();
		var scrollTop = windowObj.scrollTop();
		var cwinWidth = $divReg.width();
		var cwinHeight = $divReg.height();
		var left = scrollLeft + (browserWidth - cwinWidth) / 2;
		var top = scrollTop + (browserHeight -cwinHeight) / 2;
		$divReg.css("top",top).css("left",left);
		$divRegF.css("top",top).css("left",left);
	});
}); 
//清空所有内容
function clearText($thisNode){
	var $parent = $thisNode.parent();
	if($thisNode.is("#O_Account")) { $thisNode.val("");$parent.find("span.formtips").removeClass("Normal").removeClass("onSuccess").removeClass("onError").addClass("Normal").html("用户ID不能为空！"); }
	if($thisNode.is("#O_Psd")) { $thisNode.val("");$parent.find("span.formtips").removeClass("Normal").removeClass("onSuccess").removeClass("onError").addClass("Normal").html("设置登录密码"); }
	if($thisNode.is("#O_RePsd")) { $thisNode.val("");$parent.find("span.formtips").removeClass("Normal").removeClass("onSuccess").removeClass("onError").addClass("Normal").html("确认登录密码"); }
	if($thisNode.is("#O_Phone")) { $thisNode.val("");$parent.find("span.formtips").removeClass("Normal").removeClass("onSuccess").removeClass("onError").addClass("Normal").html("输入常用手机号码"); }
	if($thisNode.is("#O_Email")) { $thisNode.val("");$parent.find("span.formtips").removeClass("Normal").removeClass("onSuccess").removeClass("onError").addClass("Normal").html("输入常用Email"); }
}
//更新span显示
function updateSpan($parent, $cusClass, $msg) {
	$parent.find(".formtips").removeClass("Normal").removeClass("onSuccess").removeClass("onError").addClass($cusClass).html($msg);
}